/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.formatting;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.preferences.PreferenceKey;
import org.eclipse.xtext.xbase.formatting.BlankLineKey;
import org.eclipse.xtext.xbase.formatting.CommentInfo;
import org.eclipse.xtext.xbase.formatting.FormattableDocument;
import org.eclipse.xtext.xbase.formatting.FormattingData;
import org.eclipse.xtext.xbase.formatting.FormattingDataInit;
import org.eclipse.xtext.xbase.formatting.FormattingPreferenceValues;
import org.eclipse.xtext.xbase.formatting.HiddenLeafAccess;
import org.eclipse.xtext.xbase.formatting.HiddenLeafs;
import org.eclipse.xtext.xbase.formatting.LeafInfo;
import org.eclipse.xtext.xbase.formatting.NewLineData;
import org.eclipse.xtext.xbase.formatting.NewLineKey;
import org.eclipse.xtext.xbase.formatting.NewLineOrPreserveKey;
import org.eclipse.xtext.xbase.formatting.WhitespaceData;
import org.eclipse.xtext.xbase.formatting.WhitespaceInfo;
import org.eclipse.xtext.xbase.formatting.WhitespaceKey;
import org.eclipse.xtext.xbase.formatting.XbaseFormatterPreferenceKeys;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormattingDataFactory {
    @Inject
    @Extension
    private HiddenLeafAccess _hiddenLeafAccess;

    protected Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> newFormattingData(HiddenLeafs leafs, Procedures.Procedure1<? super FormattingDataInit> init) {
        Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _xblockexpression = null;
        FormattingDataInit data = new FormattingDataInit();
        init.apply((Object)data);
        _xblockexpression = this.newFormattingData(leafs, data.key, data);
        return _xblockexpression;
    }

    protected Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _newFormattingData(final HiddenLeafs leafs, Void key, final FormattingDataInit it) {
        Functions.Function1<FormattableDocument, Iterable<FormattingData>> _function = new Functions.Function1<FormattableDocument, Iterable<FormattingData>>(){

            public Iterable<FormattingData> apply(FormattableDocument doc) {
                boolean _equals_1;
                Integer _elvis = null;
                _elvis = it.newLines != null ? it.newLines : Integer.valueOf(0);
                int newLines2 = _elvis;
                boolean _or = false;
                boolean _and = false;
                boolean _equals = Objects.equal((Object)it.space, null);
                _and = !_equals ? false : (_equals_1 = Objects.equal((Object)it.newLines, null));
                if (_and) {
                    _or = true;
                } else {
                    boolean _equals_2;
                    boolean _and_1 = false;
                    int _newLinesInComments = leafs.getNewLinesInComments();
                    boolean bl = _equals_2 = _newLinesInComments == 0;
                    if (!_equals_2) {
                        _and_1 = false;
                    } else {
                        boolean _equals_3;
                        boolean _or_1 = false;
                        _or_1 = newLines2 == 0 ? true : (_equals_3 = Objects.equal((Object)it.space, (Object)""));
                        _and_1 = _or_1;
                    }
                    _or = _and_1;
                }
                if (_or) {
                    boolean _isDebugConflicts = doc.isDebugConflicts();
                    return FormattingDataFactory.this.newWhitespaceData(leafs, it.space, it.increaseIndentationChange, it.decreaseIndentationChange, _isDebugConflicts);
                }
                boolean _isDebugConflicts_1 = doc.isDebugConflicts();
                return FormattingDataFactory.this.newNewLineData(leafs, newLines2, newLines2, it.increaseIndentationChange, it.decreaseIndentationChange, _isDebugConflicts_1);
            }
        };
        return _function;
    }

    protected Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _newFormattingData(final HiddenLeafs leafs, final BlankLineKey key, final FormattingDataInit it) {
        Functions.Function1<FormattableDocument, Iterable<FormattingData>> _function = new Functions.Function1<FormattableDocument, Iterable<FormattingData>>(){

            public Iterable<FormattingData> apply(FormattableDocument doc) {
                Iterable<FormattingData> _xblockexpression = null;
                FormattingPreferenceValues _cfg = doc.getCfg();
                int blankline = _cfg.get(key);
                FormattingPreferenceValues _cfg_1 = doc.getCfg();
                int preserve = _cfg_1.get(XbaseFormatterPreferenceKeys.preserveBlankLines);
                int min = blankline + 1;
                int max = Math.max(preserve + 1, min);
                boolean _isDebugConflicts = doc.isDebugConflicts();
                _xblockexpression = FormattingDataFactory.this.newNewLineData(leafs, min, max, it.increaseIndentationChange, it.decreaseIndentationChange, _isDebugConflicts);
                return _xblockexpression;
            }
        };
        return _function;
    }

    protected Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _newFormattingData(final HiddenLeafs leafs, final NewLineOrPreserveKey key, final FormattingDataInit it) {
        Functions.Function1<FormattableDocument, Iterable<FormattingData>> _function = new Functions.Function1<FormattableDocument, Iterable<FormattingData>>(){

            public Iterable<FormattingData> apply(FormattableDocument doc) {
                Iterable<FormattingData> _xblockexpression = null;
                FormattingPreferenceValues _cfg = doc.getCfg();
                boolean newLine = _cfg.get(key);
                FormattingPreferenceValues _cfg_1 = doc.getCfg();
                boolean preserve = _cfg_1.get(XbaseFormatterPreferenceKeys.preserveNewLines);
                int _xifexpression = 0;
                _xifexpression = newLine ? 1 : 0;
                int _xifexpression_1 = 0;
                boolean _or = false;
                _or = preserve ? true : newLine;
                _xifexpression_1 = _or ? 1 : 0;
                boolean _isDebugConflicts = doc.isDebugConflicts();
                _xblockexpression = FormattingDataFactory.this.newNewLineData(leafs, _xifexpression, _xifexpression_1, it.increaseIndentationChange, it.decreaseIndentationChange, _isDebugConflicts);
                return _xblockexpression;
            }
        };
        return _function;
    }

    protected Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _newFormattingData(final HiddenLeafs leafs, final NewLineKey key, final FormattingDataInit it) {
        Functions.Function1<FormattableDocument, Iterable<FormattingData>> _function = new Functions.Function1<FormattableDocument, Iterable<FormattingData>>(){

            public Iterable<FormattingData> apply(FormattableDocument doc) {
                Iterable<FormattingData> _xblockexpression = null;
                FormattingPreferenceValues _cfg = doc.getCfg();
                boolean newLine = _cfg.get(key);
                int _xifexpression = 0;
                _xifexpression = newLine ? 1 : 0;
                int minmax = _xifexpression;
                boolean _isDebugConflicts = doc.isDebugConflicts();
                _xblockexpression = FormattingDataFactory.this.newNewLineData(leafs, minmax, minmax, it.increaseIndentationChange, it.decreaseIndentationChange, _isDebugConflicts);
                return _xblockexpression;
            }
        };
        return _function;
    }

    protected Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _newFormattingData(HiddenLeafs leafs, PreferenceKey key, FormattingDataInit it) {
        Class<?> _class = key.getClass();
        String _plus = "Unknown configuration key kind: " + _class;
        throw new RuntimeException(_plus);
    }

    protected Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _newFormattingData(final HiddenLeafs leafs, final WhitespaceKey key, final FormattingDataInit it) {
        Functions.Function1<FormattableDocument, Iterable<FormattingData>> _function = new Functions.Function1<FormattableDocument, Iterable<FormattingData>>(){

            public Iterable<FormattingData> apply(FormattableDocument doc) {
                Iterable<FormattingData> _xblockexpression = null;
                FormattingPreferenceValues _cfg = doc.getCfg();
                boolean space = _cfg.get(key);
                String _xifexpression = null;
                _xifexpression = space ? " " : "";
                boolean _isDebugConflicts = doc.isDebugConflicts();
                _xblockexpression = FormattingDataFactory.this.newWhitespaceData(leafs, _xifexpression, it.increaseIndentationChange, it.decreaseIndentationChange, _isDebugConflicts);
                return _xblockexpression;
            }
        };
        return _function;
    }

    protected Iterable<FormattingData> newWhitespaceData(HiddenLeafs leafs, String space, int increaseIndentationChange, int decreaseIndentationChange, boolean trace) {
        ArrayList _xblockexpression = null;
        ArrayList result = CollectionLiterals.newArrayList((Object[])new FormattingData[0]);
        boolean isFirst = true;
        List<LeafInfo> _leafs = leafs.getLeafs();
        for (LeafInfo leaf : _leafs) {
            boolean _matched = false;
            if (!_matched && leaf instanceof WhitespaceInfo) {
                _matched = true;
                int _offset = ((WhitespaceInfo)leaf).getOffset();
                int _length = ((WhitespaceInfo)leaf).getLength();
                int _xifexpression = 0;
                _xifexpression = isFirst ? increaseIndentationChange : 0;
                int _xifexpression_1 = 0;
                _xifexpression_1 = isFirst ? decreaseIndentationChange : 0;
                RuntimeException _xifexpression_2 = null;
                if (trace) {
                    _xifexpression_2 = new RuntimeException();
                }
                WhitespaceData _whitespaceData = new WhitespaceData(_offset, _length, _xifexpression, _xifexpression_1, _xifexpression_2, space);
                result.add(_whitespaceData);
                isFirst = false;
            }
            if (_matched || !(leaf instanceof CommentInfo)) continue;
            _matched = true;
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    protected Iterable<FormattingData> newNewLineData(HiddenLeafs leafs, int minNewLines, int maxNewLines, int increaseIndentationChange, int decreaseIndentationChange, boolean trace) {
        ArrayList _xblockexpression = null;
        ArrayList result = CollectionLiterals.newArrayList((Object[])new FormattingData[0]);
        boolean applied = false;
        List<LeafInfo> _leafs = leafs.getLeafs();
        for (LeafInfo leaf : _leafs) {
            boolean _matched = false;
            if (!_matched && leaf instanceof WhitespaceInfo) {
                _matched = true;
                boolean equalIndentationChange = increaseIndentationChange == decreaseIndentationChange * -1;
                boolean _and = false;
                CommentInfo _trailingComment = ((WhitespaceInfo)leaf).trailingComment();
                boolean _isTrailing = false;
                if (_trailingComment != null) {
                    _isTrailing = _trailingComment.isTrailing();
                }
                if (!_isTrailing) {
                    _and = false;
                } else {
                    boolean _not;
                    CommentInfo _trailingComment_1 = ((WhitespaceInfo)leaf).trailingComment();
                    boolean _isMultiline = false;
                    if (_trailingComment_1 != null) {
                        _isMultiline = _trailingComment_1.isMultiline();
                    }
                    _and = _not = !_isMultiline;
                }
                if (_and) {
                    boolean _equals;
                    String _xifexpression = null;
                    int _offset = ((WhitespaceInfo)leaf).getOffset();
                    boolean bl = _equals = _offset == 0;
                    if (_equals) {
                        _xifexpression = "";
                    } else {
                        String _xifexpression_1 = null;
                        _xifexpression_1 = maxNewLines == 0 ? null : " ";
                        _xifexpression = _xifexpression_1;
                    }
                    String space = _xifexpression;
                    int _offset_1 = ((WhitespaceInfo)leaf).getOffset();
                    int _length = ((WhitespaceInfo)leaf).getLength();
                    RuntimeException _xifexpression_2 = null;
                    if (trace) {
                        _xifexpression_2 = new RuntimeException();
                    }
                    WhitespaceData _whitespaceData = new WhitespaceData(_offset_1, _length, 0, 0, _xifexpression_2, space);
                    result.add(_whitespaceData);
                } else if (!applied) {
                    boolean _not_1;
                    int _offset_2;
                    boolean _greaterThan;
                    int _newLines = leafs.getNewLines();
                    int _max = Math.max(_newLines, minNewLines);
                    int newLines = Math.min(_max, maxNewLines);
                    boolean _and_1 = false;
                    boolean _and_2 = false;
                    _and_2 = newLines >= 1 ? false : (_greaterThan = (_offset_2 = ((WhitespaceInfo)leaf).getOffset()) > 0);
                    if (!_and_2) {
                        _and_1 = false;
                    } else {
                        boolean _or = false;
                        CommentInfo _leadingComment = ((WhitespaceInfo)leaf).leadingComment();
                        boolean _isMultiline_1 = false;
                        if (_leadingComment != null) {
                            _isMultiline_1 = _leadingComment.isMultiline();
                        }
                        if (_isMultiline_1) {
                            _or = true;
                        } else {
                            CommentInfo _trailingComment_2 = ((WhitespaceInfo)leaf).trailingComment();
                            boolean _isMultiline_2 = false;
                            if (_trailingComment_2 != null) {
                                _isMultiline_2 = _trailingComment_2.isMultiline();
                            }
                            _or = _isMultiline_2;
                        }
                        _and_1 = _or;
                    }
                    if (_and_1) {
                        newLines = 1;
                    }
                    CommentInfo _leadingComment_1 = ((WhitespaceInfo)leaf).leadingComment();
                    boolean _endsWithNewLine = false;
                    if (_leadingComment_1 != null) {
                        _endsWithNewLine = _leadingComment_1.endsWithNewLine();
                    }
                    if (_endsWithNewLine) {
                        --newLines;
                    }
                    boolean _and_3 = false;
                    CommentInfo _leadingComment_2 = ((WhitespaceInfo)leaf).leadingComment();
                    boolean _endsWithNewLine_1 = false;
                    if (_leadingComment_2 != null) {
                        _endsWithNewLine_1 = _leadingComment_2.endsWithNewLine();
                    }
                    boolean bl = _not_1 = !_endsWithNewLine_1;
                    if (!_not_1) {
                        _and_3 = false;
                    } else {
                        boolean bl2 = _and_3 = newLines == 0;
                    }
                    if (_and_3) {
                        boolean _equals_1;
                        int _offset_3 = ((WhitespaceInfo)leaf).getOffset();
                        int _length_1 = ((WhitespaceInfo)leaf).getLength();
                        RuntimeException _xifexpression_3 = null;
                        if (trace) {
                            _xifexpression_3 = new RuntimeException();
                        }
                        String _xifexpression_4 = null;
                        int _offset_4 = ((WhitespaceInfo)leaf).getOffset();
                        boolean bl3 = _equals_1 = _offset_4 == 0;
                        if (_equals_1) {
                            _xifexpression_4 = "";
                        } else {
                            String _xifexpression_5 = null;
                            boolean _containsComment = leafs.containsComment();
                            _xifexpression_5 = _containsComment ? null : " ";
                            _xifexpression_4 = _xifexpression_5;
                        }
                        WhitespaceData _whitespaceData_1 = new WhitespaceData(_offset_3, _length_1, increaseIndentationChange, decreaseIndentationChange, _xifexpression_3, _xifexpression_4);
                        result.add(_whitespaceData_1);
                    } else {
                        List<LeafInfo> _leafs_1;
                        LeafInfo _last;
                        boolean _notEquals;
                        boolean _and_4 = false;
                        _and_4 = !equalIndentationChange ? false : (_notEquals = !Objects.equal((Object)(_last = (LeafInfo)IterableExtensions.last(_leafs_1 = leafs.getLeafs())), (Object)leaf));
                        if (_and_4) {
                            int _offset_5 = ((WhitespaceInfo)leaf).getOffset();
                            int _length_2 = ((WhitespaceInfo)leaf).getLength();
                            RuntimeException _xifexpression_6 = null;
                            if (trace) {
                                _xifexpression_6 = new RuntimeException();
                            }
                            NewLineData _newLineData = new NewLineData(_offset_5, _length_2, increaseIndentationChange, decreaseIndentationChange, _xifexpression_6, newLines);
                            result.add(_newLineData);
                        } else {
                            int _offset_6 = ((WhitespaceInfo)leaf).getOffset();
                            int _length_3 = ((WhitespaceInfo)leaf).getLength();
                            int _xifexpression_7 = 0;
                            _xifexpression_7 = equalIndentationChange ? 0 : increaseIndentationChange;
                            int _xifexpression_8 = 0;
                            _xifexpression_8 = equalIndentationChange ? 0 : decreaseIndentationChange;
                            RuntimeException _xifexpression_9 = null;
                            if (trace) {
                                _xifexpression_9 = new RuntimeException();
                            }
                            NewLineData _newLineData_1 = new NewLineData(_offset_6, _length_3, _xifexpression_7, _xifexpression_8, _xifexpression_9, newLines);
                            result.add(_newLineData_1);
                        }
                    }
                    applied = true;
                } else {
                    List<LeafInfo> _leafs_2;
                    LeafInfo _last_1;
                    boolean _notEquals_1;
                    int newLines_1 = 1;
                    CommentInfo _leadingComment_3 = ((WhitespaceInfo)leaf).leadingComment();
                    boolean _endsWithNewLine_2 = false;
                    if (_leadingComment_3 != null) {
                        _endsWithNewLine_2 = _leadingComment_3.endsWithNewLine();
                    }
                    if (_endsWithNewLine_2) {
                        --newLines_1;
                    }
                    boolean _and_5 = false;
                    _and_5 = !equalIndentationChange ? false : (_notEquals_1 = !Objects.equal((Object)(_last_1 = (LeafInfo)IterableExtensions.last(_leafs_2 = leafs.getLeafs())), (Object)leaf));
                    if (_and_5) {
                        int _offset_7 = ((WhitespaceInfo)leaf).getOffset();
                        int _length_4 = ((WhitespaceInfo)leaf).getLength();
                        RuntimeException _xifexpression_10 = null;
                        if (trace) {
                            _xifexpression_10 = new RuntimeException();
                        }
                        NewLineData _newLineData_2 = new NewLineData(_offset_7, _length_4, increaseIndentationChange, decreaseIndentationChange, _xifexpression_10, newLines_1);
                        result.add(_newLineData_2);
                    } else {
                        int _offset_8 = ((WhitespaceInfo)leaf).getOffset();
                        int _length_5 = ((WhitespaceInfo)leaf).getLength();
                        RuntimeException _xifexpression_11 = null;
                        if (trace) {
                            _xifexpression_11 = new RuntimeException();
                        }
                        NewLineData _newLineData_3 = new NewLineData(_offset_8, _length_5, 0, 0, _xifexpression_11, newLines_1);
                        result.add(_newLineData_3);
                    }
                }
            }
            if (_matched || !(leaf instanceof CommentInfo)) continue;
            _matched = true;
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> append(INode node, Procedures.Procedure1<? super FormattingDataInit> init) {
        boolean _notEquals;
        Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)node, null);
        if (_notEquals) {
            HiddenLeafs _hiddenLeafsAfter = this._hiddenLeafAccess.getHiddenLeafsAfter(node);
            _xifexpression = this.newFormattingData(_hiddenLeafsAfter, init);
        }
        return _xifexpression;
    }

    public Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> prepend(INode node, Procedures.Procedure1<? super FormattingDataInit> init) {
        boolean _notEquals;
        Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)node, null);
        if (_notEquals) {
            HiddenLeafs _hiddenLeafsBefore = this._hiddenLeafAccess.getHiddenLeafsBefore(node);
            _xifexpression = this.newFormattingData(_hiddenLeafsBefore, init);
        }
        return _xifexpression;
    }

    public Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> surround(final INode node, final Procedures.Procedure1<? super FormattingDataInit> init) {
        Functions.Function1<FormattableDocument, Iterable<FormattingData>> _function = new Functions.Function1<FormattableDocument, Iterable<FormattingData>>(){

            public Iterable<FormattingData> apply(FormattableDocument doc) {
                boolean _notEquals;
                ArrayList _xblockexpression = null;
                ArrayList result = CollectionLiterals.newArrayList((Object[])new FormattingData[0]);
                boolean bl = _notEquals = !Objects.equal((Object)node, null);
                if (_notEquals) {
                    Iterable _elvis = null;
                    HiddenLeafs _hiddenLeafsBefore = FormattingDataFactory.this._hiddenLeafAccess.getHiddenLeafsBefore(node);
                    Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _newFormattingData = FormattingDataFactory.this.newFormattingData(_hiddenLeafsBefore, (Procedures.Procedure1<? super FormattingDataInit>)init);
                    Iterable _apply = null;
                    if (_newFormattingData != null) {
                        _apply = (Iterable)_newFormattingData.apply((Object)doc);
                    }
                    if (_apply != null) {
                        _elvis = _apply;
                    } else {
                        List _emptyList = CollectionLiterals.emptyList();
                        _elvis = _emptyList;
                    }
                    Iterables.addAll((Collection)result, (Iterable)_elvis);
                    Iterable _elvis_1 = null;
                    HiddenLeafs _hiddenLeafsAfter = FormattingDataFactory.this._hiddenLeafAccess.getHiddenLeafsAfter(node);
                    Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _newFormattingData_1 = FormattingDataFactory.this.newFormattingData(_hiddenLeafsAfter, (Procedures.Procedure1<? super FormattingDataInit>)init);
                    Iterable _apply_1 = null;
                    if (_newFormattingData_1 != null) {
                        _apply_1 = (Iterable)_newFormattingData_1.apply((Object)doc);
                    }
                    if (_apply_1 != null) {
                        _elvis_1 = _apply_1;
                    } else {
                        List _emptyList_1 = CollectionLiterals.emptyList();
                        _elvis_1 = _emptyList_1;
                    }
                    Iterables.addAll((Collection)result, (Iterable)_elvis_1);
                }
                _xblockexpression = result;
                return _xblockexpression;
            }
        };
        return _function;
    }

    public Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> surround(final INode node, final Procedures.Procedure1<? super FormattingDataInit> before, final Procedures.Procedure1<? super FormattingDataInit> after) {
        Functions.Function1<FormattableDocument, Iterable<FormattingData>> _function = new Functions.Function1<FormattableDocument, Iterable<FormattingData>>(){

            public Iterable<FormattingData> apply(FormattableDocument doc) {
                boolean _notEquals;
                ArrayList _xblockexpression = null;
                ArrayList result = CollectionLiterals.newArrayList((Object[])new FormattingData[0]);
                boolean bl = _notEquals = !Objects.equal((Object)node, null);
                if (_notEquals) {
                    Iterable _elvis = null;
                    HiddenLeafs _hiddenLeafsBefore = FormattingDataFactory.this._hiddenLeafAccess.getHiddenLeafsBefore(node);
                    Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _newFormattingData = FormattingDataFactory.this.newFormattingData(_hiddenLeafsBefore, (Procedures.Procedure1<? super FormattingDataInit>)before);
                    Iterable _apply = null;
                    if (_newFormattingData != null) {
                        _apply = (Iterable)_newFormattingData.apply((Object)doc);
                    }
                    if (_apply != null) {
                        _elvis = _apply;
                    } else {
                        List _emptyList = CollectionLiterals.emptyList();
                        _elvis = _emptyList;
                    }
                    Iterables.addAll((Collection)result, (Iterable)_elvis);
                    Iterable _elvis_1 = null;
                    HiddenLeafs _hiddenLeafsAfter = FormattingDataFactory.this._hiddenLeafAccess.getHiddenLeafsAfter(node);
                    Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> _newFormattingData_1 = FormattingDataFactory.this.newFormattingData(_hiddenLeafsAfter, (Procedures.Procedure1<? super FormattingDataInit>)after);
                    Iterable _apply_1 = null;
                    if (_newFormattingData_1 != null) {
                        _apply_1 = (Iterable)_newFormattingData_1.apply((Object)doc);
                    }
                    if (_apply_1 != null) {
                        _elvis_1 = _apply_1;
                    } else {
                        List _emptyList_1 = CollectionLiterals.emptyList();
                        _elvis_1 = _emptyList_1;
                    }
                    Iterables.addAll((Collection)result, (Iterable)_elvis_1);
                }
                _xblockexpression = result;
                return _xblockexpression;
            }
        };
        return _function;
    }

    protected Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> newFormattingData(HiddenLeafs leafs, PreferenceKey key, FormattingDataInit it) {
        if (key instanceof BlankLineKey) {
            return this._newFormattingData(leafs, (BlankLineKey)key, it);
        }
        if (key instanceof NewLineKey) {
            return this._newFormattingData(leafs, (NewLineKey)key, it);
        }
        if (key instanceof NewLineOrPreserveKey) {
            return this._newFormattingData(leafs, (NewLineOrPreserveKey)key, it);
        }
        if (key instanceof WhitespaceKey) {
            return this._newFormattingData(leafs, (WhitespaceKey)key, it);
        }
        if (key == null) {
            return this._newFormattingData(leafs, (Void)null, it);
        }
        if (key != null) {
            return this._newFormattingData(leafs, key, it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(leafs, key, it).toString());
    }
}

