/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb;

import com.google.gerrit.reviewdb.ApprovalCategory;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.ShortKey;

public final class ApprovalCategoryValue {
    @Column(id=1, name="--NONE--")
    protected Id key;
    @Column(id=2, length=50)
    protected String name;

    protected ApprovalCategoryValue() {
    }

    public ApprovalCategoryValue(Id id, String name) {
        this.key = id;
        this.name = name;
    }

    public Id getId() {
        return this.key;
    }

    public ApprovalCategory.Id getCategoryId() {
        return this.key.categoryId;
    }

    public short getValue() {
        return this.key.value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String formatValue() {
        if (this.getValue() < 0) {
            return Short.toString(this.getValue());
        }
        if (this.getValue() == 0) {
            return " 0";
        }
        return "+" + Short.toString(this.getValue());
    }

    public String format() {
        StringBuilder m = new StringBuilder();
        m.append(this.formatValue());
        m.append(' ');
        m.append(this.getName());
        return m.toString();
    }

    public static class Id
    extends ShortKey<ApprovalCategory.Id> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected ApprovalCategory.Id categoryId;
        @Column(id=2)
        protected short value;

        protected Id() {
            this.categoryId = new ApprovalCategory.Id();
        }

        public Id(ApprovalCategory.Id cat, short v) {
            this.categoryId = cat;
            this.value = v;
        }

        public ApprovalCategory.Id getParentKey() {
            return this.categoryId;
        }

        public short get() {
            return this.value;
        }

        protected void set(short newValue) {
            this.value = newValue;
        }
    }
}

