/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.scanner;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.ISequenceRule;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.KeywordRule;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.SequenceBlockRule;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.SequenceRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;

public class AcceleoPartitionScanner
extends RuleBasedPartitionScanner {
    public static final String ACCELEO_COMMENT = "__ACCELEO_comment";
    public static final String ACCELEO_TEMPLATE = "__ACCELEO_template";
    public static final String ACCELEO_QUERY = "__ACCELEO_query";
    public static final String ACCELEO_MACRO = "__ACCELEO_macro";
    public static final String ACCELEO_PROTECTED_AREA = "__ACCELEO_protected_area";
    public static final String ACCELEO_IF = "__ACCELEO_if";
    public static final String ACCELEO_LET = "__ACCELEO_let";
    public static final String ACCELEO_FOR = "__ACCELEO_for";
    public static final String ACCELEO_BLOCK = "__ACCELEO_block";
    public static final String ACCELEO_DOCUMENTATION = "__ACCELEO_documentation";
    public static final String[] LEGAL_CONTENT_TYPES = new String[]{"__ACCELEO_comment", "__ACCELEO_template", "__ACCELEO_query", "__ACCELEO_macro", "__ACCELEO_protected_area", "__ACCELEO_if", "__ACCELEO_let", "__ACCELEO_for", "__ACCELEO_block", "__ACCELEO_documentation"};

    public AcceleoPartitionScanner() {
        ArrayList<IRule> rules = new ArrayList<IRule>();
        SequenceBlockRule literal = new SequenceBlockRule((ISequenceRule)new KeywordRule("'"), (ISequenceRule)new KeywordRule("'"), new KeywordRule("\\'"), (IToken)new Token((Object)"__dftl_partition_content_type"));
        this.computeCommentRules(rules);
        this.computeDocumentationRules(rules);
        this.computeBehavioralFeatureRules(rules, literal);
        this.computeProtectedAreaRules(rules, literal);
        this.computeIfRules(rules, literal);
        this.computeLetRules(rules, literal);
        this.computeForRules(rules, literal);
        this.computeBlockRules(rules, literal);
        this.setPredicateRules(rules.toArray(new IPredicateRule[rules.size()]));
    }

    private void computeDocumentationRules(List<IRule> rules) {
        rules.add((IRule)new SequenceBlockRule((ISequenceRule)this.beginSequence("**"), (ISequenceRule)new KeywordRule("]"), new SequenceBlockRule[0], (IToken)new Token((Object)ACCELEO_DOCUMENTATION)));
    }

    private void computeCommentRules(List<IRule> rules) {
        SequenceRule beginComment = new SequenceRule(new String[]{"[", "comment", "]"});
        SequenceRule endComment = new SequenceRule(new String[]{"[", "/", "comment", "]"});
        rules.add((IRule)new SequenceBlockRule((ISequenceRule)beginComment, (ISequenceRule)endComment, new SequenceBlockRule[0], (IToken)new Token((Object)ACCELEO_COMMENT)));
        rules.add((IRule)new SequenceBlockRule((ISequenceRule)this.beginSequence("comment"), (ISequenceRule)new KeywordRule("]"), new SequenceBlockRule[0], (IToken)new Token((Object)ACCELEO_COMMENT)));
    }

    private void computeBehavioralFeatureRules(List<IRule> rules, SequenceBlockRule literal) {
        rules.add((IRule)new SequenceBlockRule((ISequenceRule)this.beginSequence("template"), (ISequenceRule)new KeywordRule("]"), new SequenceBlockRule[]{literal}, (IToken)new Token((Object)ACCELEO_TEMPLATE)));
        rules.add((IRule)new SequenceRule(new String[]{"[", "/", "template", "]"}, (IToken)new Token((Object)ACCELEO_TEMPLATE)));
        rules.add((IRule)new SequenceBlockRule((ISequenceRule)this.beginSequence("query"), (ISequenceRule)new KeywordRule("]"), new SequenceBlockRule[]{literal}, (IToken)new Token((Object)ACCELEO_QUERY)));
        rules.add((IRule)new SequenceRule(new String[]{"[", "/", "query", "]"}, (IToken)new Token((Object)ACCELEO_QUERY)));
        rules.add((IRule)new SequenceBlockRule((ISequenceRule)this.beginSequence("macro"), (ISequenceRule)new KeywordRule("]"), new SequenceBlockRule[]{literal}, (IToken)new Token((Object)ACCELEO_MACRO)));
        rules.add((IRule)new SequenceRule(new String[]{"[", "/", "macro", "]"}, (IToken)new Token((Object)ACCELEO_MACRO)));
    }

    private void computeProtectedAreaRules(List<IRule> rules, SequenceBlockRule literal) {
        rules.add((IRule)new SequenceBlockRule((ISequenceRule)this.beginSequence("protected"), (ISequenceRule)new KeywordRule("]"), new SequenceBlockRule[]{literal}, (IToken)new Token((Object)ACCELEO_PROTECTED_AREA)));
        rules.add((IRule)new SequenceBlockRule((ISequenceRule)new SequenceRule(new String[]{"[", "/", "protected"}), (ISequenceRule)new KeywordRule("]"), new SequenceBlockRule[]{literal}, (IToken)new Token((Object)ACCELEO_PROTECTED_AREA)));
    }

    private void computeIfRules(List<IRule> rules, SequenceBlockRule literal) {
        rules.add((IRule)new SequenceBlockRule((ISequenceRule)this.beginSequence("if"), (ISequenceRule)new KeywordRule("]"), new SequenceBlockRule[]{literal}, (IToken)new Token((Object)ACCELEO_IF)));
        rules.add((IRule)new SequenceBlockRule((ISequenceRule)this.beginSequence("elseif"), (ISequenceRule)new KeywordRule("]"), new SequenceBlockRule[]{literal}, (IToken)new Token((Object)ACCELEO_IF)));
        rules.add((IRule)new SequenceRule(new String[]{"[", "else", "]"}, (IToken)new Token((Object)ACCELEO_IF)));
        rules.add((IRule)new SequenceRule(new String[]{"[", "/", "if", "]"}, (IToken)new Token((Object)ACCELEO_IF)));
    }

    private void computeLetRules(List<IRule> rules, SequenceBlockRule literal) {
        rules.add((IRule)new SequenceBlockRule((ISequenceRule)this.beginSequence("let"), (ISequenceRule)new KeywordRule("]"), new SequenceBlockRule[]{literal}, (IToken)new Token((Object)ACCELEO_LET)));
        rules.add((IRule)new SequenceBlockRule((ISequenceRule)this.beginSequence("elselet"), (ISequenceRule)new KeywordRule("]"), new SequenceBlockRule[]{literal}, (IToken)new Token((Object)ACCELEO_LET)));
        rules.add((IRule)new SequenceRule(new String[]{"[", "else", "]"}, (IToken)new Token((Object)ACCELEO_LET)));
        rules.add((IRule)new SequenceRule(new String[]{"[", "/", "let", "]"}, (IToken)new Token((Object)ACCELEO_LET)));
    }

    private void computeForRules(List<IRule> rules, SequenceBlockRule literal) {
        rules.add((IRule)new SequenceBlockRule((ISequenceRule)this.beginSequence("for"), (ISequenceRule)new KeywordRule("]"), new SequenceBlockRule[]{literal}, (IToken)new Token((Object)ACCELEO_FOR)));
        rules.add((IRule)new SequenceRule(new String[]{"[", "/", "for", "]"}, (IToken)new Token((Object)ACCELEO_FOR)));
    }

    private void computeBlockRules(List<IRule> rules, SequenceBlockRule literal) {
        rules.add((IRule)new SequenceBlockRule((ISequenceRule)new KeywordRule("["), (ISequenceRule)new KeywordRule("]"), new SequenceBlockRule[]{literal}, (IToken)new Token((Object)ACCELEO_BLOCK)));
    }

    private SequenceRule beginSequence(String keyword) {
        return new SequenceRule(new String[]{"[", keyword});
    }
}

