/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.chart.aggregate.IAggregateFunction;
import org.eclipse.birt.chart.api.ChartEngine;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.attribute.GroupingUnitType;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.chart.util.ChartExpressionUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.emf.common.util.EList;

public abstract class AbstractChartBaseQueryGenerator {
    protected ReportItemHandle fReportItemHandle;
    protected Chart fChartModel;
    protected Set<String> fNameSet = new HashSet<String>();
    protected final boolean bCreateBindingForExpression;
    protected final ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();
    protected final IModelAdapter modelAdapter;
    protected String innerGroupName = null;

    public AbstractChartBaseQueryGenerator(ReportItemHandle handle, Chart cm, IModelAdapter modelAdapter) {
        this(handle, cm, false, modelAdapter);
    }

    public AbstractChartBaseQueryGenerator(ReportItemHandle handle, Chart cm, boolean bCreateBindingForExpression, IModelAdapter modelAdapter) {
        this.fChartModel = cm;
        this.fReportItemHandle = handle;
        this.bCreateBindingForExpression = bCreateBindingForExpression;
        this.modelAdapter = modelAdapter;
    }

    public abstract IDataQueryDefinition createBaseQuery(IDataQueryDefinition var1) throws ChartException;

    public abstract IDataQueryDefinition createBaseQuery(List<String> var1) throws ChartException;

    /*
     * Unable to fully structure code
     */
    protected void addValueSeriesAggregateBindingForGrouping(BaseQueryDefinition query, EList<SeriesDefinition> seriesDefinitions, GroupDefinition innerMostGroupDef, Map<String, String[]> valueExprMap, SeriesDefinition baseSD) throws ChartException {
        for (SeriesDefinition orthSD : seriesDefinitions) {
            series = orthSD.getDesignTimeSeries();
            qlist = ChartEngine.instance().getDataSetProcessor(series.getClass()).getDataDefinitionsForGrouping(series);
            for (Query qry : series.getDataDefinition()) {
                expr = qry.getDefinition();
                if (expr == null || "".equals(expr) || this.isDataBinding(expr) || (aggName = ChartUtil.getAggregateFuncExpr((SeriesDefinition)orthSD, (SeriesDefinition)baseSD, (Query)qry)) == null && (!this.bCreateBindingForExpression || this.exprCodec.isRowBinding(expr, false)) || this.fNameSet.contains(name = ChartUtil.generateBindingNameOfValueSeries((Query)qry, (SeriesDefinition)orthSD, (SeriesDefinition)baseSD))) continue;
                this.fNameSet.add(name);
                colBinding = new Binding(name);
                colBinding.setDataType(0);
                if (qlist.contains(qry)) {
                    try {
                        colBinding.setExportable(false);
                        if (aggName != null) {
                            this.setBindingExpressionDueToAggregation(colBinding, expr, aggName);
                            if (innerMostGroupDef != null) {
                                colBinding.addAggregateOn(this.innerGroupName);
                            }
                            colBinding.setAggrFunction(ChartReportItemUtil.convertToDtEAggFunction(aggName));
                            aFunc = PluginSettings.instance().getAggregateFunction(aggName);
                            if (aFunc.getParametersCount() <= 0) ** GOTO lbl36
                            parameters = ChartUtil.getAggFunParameters((SeriesDefinition)orthSD, (SeriesDefinition)baseSD, (Query)qry);
                            i = 0;
                            while (i < parameters.length && i < aFunc.getParametersCount()) {
                                param = parameters[i];
                                colBinding.addArgument((IBaseExpression)new ScriptExpression(param));
                                ++i;
                            }
                        }
                        this.exprCodec.decode(expr);
                        colBinding.setExpression((IBaseExpression)ChartReportItemUtil.adaptExpression(this.exprCodec, this.modelAdapter, false));
                    }
                    catch (DataException e1) {
                        throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)e1);
                    }
                } else {
                    this.exprCodec.decode(expr);
                    colBinding.setExpression((IBaseExpression)ChartReportItemUtil.adaptExpression(this.exprCodec, this.modelAdapter, false));
                }
lbl36:
                // 4 sources

                newExpr = this.getExpressionForEvaluator(name);
                try {
                    if (!query.getBindings().containsKey(colBinding.getBindingName())) {
                        query.addBinding((IBinding)colBinding);
                        if (ChartUtil.compareVersion((String)this.fChartModel.getVersion(), (String)"2.6.1") < 0) {
                            bindingName = ChartUtil.generateBindingNameOfValueSeries((Query)qry, (SeriesDefinition)orthSD, (SeriesDefinition)baseSD, (boolean)true);
                            if (!query.getBindings().containsKey(bindingName) && !this.fNameSet.contains(bindingName)) {
                                newBinding = new Binding(bindingName, colBinding.getExpression());
                                newBinding.setAggrFunction(colBinding.getAggrFunction());
                                newBinding.setDataType(colBinding.getDataType());
                                newBinding.setDisplayName(colBinding.getDisplayName());
                                newBinding.setExportable(colBinding.exportable());
                                newBinding.setFilter(colBinding.getFilter());
                                newBinding.setTimeFunction(colBinding.getTimeFunction());
                                for (E o : colBinding.getAggregatOns()) {
                                    newBinding.getAggregatOns().add(o);
                                }
                                for (E o : colBinding.getArguments()) {
                                    newBinding.addArgument((IBaseExpression)o);
                                }
                                query.addBinding((IBinding)newBinding);
                            }
                        }
                    }
                }
                catch (DataException e) {
                    throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)e);
                }
                valueExprMap.put(expr, new String[]{name, newExpr});
            }
        }
    }

    protected boolean isDataBinding(String expr) {
        ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();
        exprCodec.decode(expr);
        String returnExpr = exprCodec.getExpression();
        return exprCodec.isCubeBinding(returnExpr, true);
    }

    protected String generateUniqueBindingName(String expr) {
        String name = StructureFactory.newComputedColumn((DesignElementHandle)this.fReportItemHandle, (String)ChartUtil.escapeSpecialCharacters((String)expr)).getName();
        if (this.fNameSet.contains(name)) {
            name = String.valueOf(name) + this.fNameSet.size();
            return this.generateUniqueBindingName(name);
        }
        this.fNameSet.add(name);
        return name;
    }

    protected void generateExtraBindings(BaseQueryDefinition query) throws ChartException {
        SeriesDefinition categorySD = null;
        SeriesDefinition orthSD = null;
        Object[] orthAxisArray = null;
        if (this.fChartModel instanceof ChartWithAxes) {
            ChartWithAxes cwa = (ChartWithAxes)this.fChartModel;
            categorySD = (SeriesDefinition)cwa.getBaseAxes()[0].getSeriesDefinitions().get(0);
            orthAxisArray = cwa.getOrthogonalAxes(cwa.getBaseAxes()[0], true);
            orthSD = (SeriesDefinition)orthAxisArray[0].getSeriesDefinitions().get(0);
        } else if (this.fChartModel instanceof ChartWithoutAxes) {
            ChartWithoutAxes cwoa = (ChartWithoutAxes)this.fChartModel;
            categorySD = (SeriesDefinition)cwoa.getSeriesDefinitions().get(0);
            orthSD = (SeriesDefinition)categorySD.getSeriesDefinitions().get(0);
        }
        GroupDefinition optionalYGroupDefinition = this.createYGrouping(query, orthSD);
        if (optionalYGroupDefinition != null && orthSD.isSetSorting()) {
            this.bindSortOnOptionalY(optionalYGroupDefinition, orthSD, (Axis[])orthAxisArray, categorySD, query);
        }
        GroupDefinition categoryGroupDefinition = this.createCategoryGrouping(query, categorySD);
        Map<String, String[]> valueExprMap = this.addAggregateBindings(query, categorySD, orthAxisArray);
        if (this.bCreateBindingForExpression) {
            String exprCategory = ((Query)categorySD.getDesignTimeSeries().getDataDefinition().get(0)).getDefinition();
            String exprYGroup = orthSD.getQuery().getDefinition();
            try {
                this.exprCodec.decode(exprCategory);
                if (!this.exprCodec.isRowBinding(false)) {
                    this.addExtraBinding(query, this.exprCodec);
                }
                this.exprCodec.decode(exprYGroup);
                if (!this.exprCodec.isRowBinding(false)) {
                    this.addExtraBinding(query, this.exprCodec);
                }
                if (query instanceof ISubqueryDefinition) {
                    ChartReportItemUtil.copyAndInsertBindingFromContainer((ISubqueryDefinition)query, exprCategory);
                    ChartReportItemUtil.copyAndInsertBindingFromContainer((ISubqueryDefinition)query, exprYGroup);
                    if (!categorySD.getGrouping().isEnabled()) {
                        for (SeriesDefinition sd : ChartUtil.getAllOrthogonalSeriesDefinitions((Chart)this.fChartModel)) {
                            EList queries = sd.getDesignTimeSeries().getDataDefinition();
                            for (Query queryExpr : queries) {
                                ChartReportItemUtil.copyAndInsertBindingFromContainer((ISubqueryDefinition)query, queryExpr.getDefinition());
                            }
                        }
                    }
                }
            }
            catch (DataException e) {
                throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)e);
            }
        }
        if (categorySD != null) {
            this.bindSortOnCategorySeries(query, categorySD, categoryGroupDefinition, valueExprMap, (Axis[])orthAxisArray);
        }
    }

    protected void addExtraBinding(BaseQueryDefinition query, ChartExpressionUtil.ExpressionCodec exprCodec) throws ChartException {
        String bindingName = exprCodec.getExpression();
        if (bindingName == null || bindingName.trim().length() == 0) {
            return;
        }
        try {
            if (!query.getBindings().containsKey(bindingName)) {
                Binding colBinding = new Binding(ChartUtil.escapeSpecialCharacters((String)bindingName));
                colBinding.setDataType(0);
                colBinding.setExportable(false);
                colBinding.setExpression((IBaseExpression)ChartReportItemUtil.adaptExpression(exprCodec, this.modelAdapter, false));
                query.addBinding((IBinding)colBinding);
            }
        }
        catch (DataException e) {
            throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)e);
        }
    }

    protected void bindSortOnCategorySeries(BaseQueryDefinition query, SeriesDefinition categorySD, GroupDefinition categoryGroupDefinition, Map<String, String[]> valueExprMap, Axis[] orthAxisArray) throws ChartException {
        String baseSortExpr = this.getValidSortExpr(categorySD);
        if (!categorySD.isSetSorting() || baseSortExpr == null || categoryGroupDefinition == null) {
            return;
        }
        SortDefinition sd = new SortDefinition();
        if (categorySD.getSortLocale() != null) {
            sd.setSortLocale(new ULocale(categorySD.getSortLocale()));
        }
        if (!categorySD.isSetSortStrength()) {
            sd.setSortStrength(2);
        } else {
            sd.setSortStrength(categorySD.getSortStrength());
        }
        sd.setSortDirection(ChartReportItemUtil.convertToDtESortDirection(categorySD.getSorting()));
        String sortExpr = baseSortExpr;
        if (ChartReportItemUtil.isBaseGroupingDefined(categorySD)) {
            String aggFunc;
            categoryGroupDefinition.addSort(sd);
            String baseExpr = ((Query)categorySD.getDesignTimeSeries().getDataDefinition().get(0)).getDefinition();
            if (baseExpr.equals(this.getValidSortExpr(categorySD))) {
                sd.setExpression(categoryGroupDefinition.getKeyExpression());
                return;
            }
            String[] nameNewExprArray = valueExprMap.get(baseSortExpr);
            if (nameNewExprArray != null && nameNewExprArray.length == 2) {
                sortExpr = nameNewExprArray[1];
                this.exprCodec.decode(sortExpr);
                sd.setExpression(ChartReportItemUtil.adaptExpression(this.exprCodec, this.modelAdapter, false));
                return;
            }
            sortExpr = baseSortExpr;
            this.exprCodec.decode(sortExpr);
            String name = this.generateUniqueBindingName(this.exprCodec.getExpression());
            Binding binding = new Binding(name);
            try {
                query.addBinding((IBinding)binding);
                binding.setExpression((IBaseExpression)ChartReportItemUtil.adaptExpression(this.exprCodec, this.modelAdapter, false));
                binding.setDataType(0);
                binding.setExportable(false);
            }
            catch (DataException e) {
                throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)e);
            }
            if (this.isYSeriesExpression(sortExpr) && (aggFunc = this.getAggFunExpr(sortExpr, categorySD, orthAxisArray)) != null) {
                try {
                    binding.addAggregateOn(categoryGroupDefinition.getName());
                }
                catch (DataException e) {
                    throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)e);
                }
                binding.setAggrFunction(ChartReportItemUtil.convertToDtEAggFunction(aggFunc));
                IAggregateFunction aFunc = PluginSettings.instance().getAggregateFunction(aggFunc);
                if (aFunc.getParametersCount() > 0) {
                    String[] parameters = (String[])categorySD.getGrouping().getAggregateParameters().toArray((Object[])new String[1]);
                    int i = 0;
                    while (i < parameters.length && i < aFunc.getParametersCount()) {
                        String param = parameters[i];
                        binding.addArgument((IBaseExpression)new ScriptExpression(param));
                        ++i;
                    }
                }
            }
            sd.setExpression(ExpressionUtil.createRowExpression((String)binding.getBindingName()));
        } else {
            sortExpr = baseSortExpr;
            query.addSort(sd);
            this.exprCodec.decode(sortExpr);
            sd.setExpression(ChartReportItemUtil.adaptExpression(this.exprCodec, this.modelAdapter, false));
        }
    }

    private Map<String, String[]> addAggregateBindings(BaseQueryDefinition query, SeriesDefinition categorySD, Object[] orthAxisArray) throws ChartException {
        GroupDefinition innerMostGroupDef = null;
        if (query.getGroups() != null && query.getGroups().size() > 0) {
            innerMostGroupDef = (GroupDefinition)query.getGroups().get(query.getGroups().size() - 1);
        }
        HashMap<String, String[]> valueExprMap = new HashMap<String, String[]>();
        if (this.fChartModel instanceof ChartWithAxes) {
            int i = 0;
            while (i < orthAxisArray.length) {
                this.addValueSeriesAggregateBindingForGrouping(query, (EList<SeriesDefinition>)((Axis)orthAxisArray[i]).getSeriesDefinitions(), innerMostGroupDef, valueExprMap, categorySD);
                ++i;
            }
        } else if (this.fChartModel instanceof ChartWithoutAxes) {
            this.addValueSeriesAggregateBindingForGrouping(query, (EList<SeriesDefinition>)categorySD.getSeriesDefinitions(), innerMostGroupDef, valueExprMap, categorySD);
        }
        return valueExprMap;
    }

    protected void bindSortOnOptionalY(GroupDefinition yGroupingDefinition, SeriesDefinition orthSD, Axis[] orthAxisArray, SeriesDefinition categorySD, BaseQueryDefinition query) throws ChartException {
        SortDefinition sortDefinition = new SortDefinition();
        if (categorySD.getSortLocale() != null) {
            sortDefinition.setSortLocale(new ULocale(categorySD.getSortLocale()));
        }
        if (!categorySD.isSetSortStrength()) {
            sortDefinition.setSortStrength(2);
        } else {
            sortDefinition.setSortStrength(categorySD.getSortStrength());
        }
        sortDefinition.setSortDirection(ChartReportItemUtil.convertToDtESortDirection(orthSD.getSorting()));
        String sortKey = null;
        if (orthSD.getSortKey() != null && orthSD.getSortKey().getDefinition() != null) {
            sortKey = orthSD.getSortKey().getDefinition();
        }
        if (sortKey == null || orthSD.getQuery() != null && sortKey.equals(orthSD.getQuery().getDefinition()) || yGroupingDefinition.getKeyExpression().equals(sortKey)) {
            sortDefinition.setExpression(yGroupingDefinition.getKeyExpression());
        } else {
            String aggFunc;
            this.exprCodec.decode(sortKey);
            String name = this.generateUniqueBindingName(this.exprCodec.getExpression());
            Binding binding = new Binding(name);
            try {
                query.addBinding((IBinding)binding);
                binding.setExpression((IBaseExpression)ChartReportItemUtil.adaptExpression(this.exprCodec, this.modelAdapter, false));
                binding.setDataType(0);
                binding.setExportable(false);
            }
            catch (DataException e) {
                throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)e);
            }
            if (this.isYSeriesExpression(sortKey) && (aggFunc = this.getAggFunExpr(sortKey, categorySD, orthAxisArray)) != null) {
                try {
                    binding.addAggregateOn(yGroupingDefinition.getName());
                }
                catch (DataException e) {
                    throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)e);
                }
                binding.setAggrFunction(ChartReportItemUtil.convertToDtEAggFunction(aggFunc));
                IAggregateFunction aFunc = PluginSettings.instance().getAggregateFunction(aggFunc);
                if (aFunc.getParametersCount() > 0) {
                    String[] parameters = ChartUtil.getAggFunParameters((SeriesDefinition)orthSD, (SeriesDefinition)categorySD, null);
                    int i = 0;
                    while (i < parameters.length && i < aFunc.getParametersCount()) {
                        String param = parameters[i];
                        binding.addArgument((IBaseExpression)new ScriptExpression(param));
                        ++i;
                    }
                }
            }
            sortDefinition.setExpression(ExpressionUtil.createRowExpression((String)binding.getBindingName()));
        }
        yGroupingDefinition.addSort(sortDefinition);
    }

    private boolean isYSeriesExpression(String expression) {
        String[] vsExprs = ChartUtil.getValueSeriesExpressions((Chart)this.fChartModel);
        int i = 0;
        while (i < vsExprs.length) {
            if (vsExprs[i].equals(expression)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected GroupDefinition createYGrouping(BaseQueryDefinition query, SeriesDefinition orthSD) {
        if (ChartReportItemUtil.isYGroupingDefined(orthSD)) {
            String name;
            DataType dataType = null;
            GroupingUnitType groupUnit = null;
            double groupIntervalRange = 0.0;
            String yGroupExpr = orthSD.getQuery().getDefinition();
            SeriesGrouping yGroupingInterval = orthSD.getQuery().getGrouping();
            if (yGroupingInterval != null) {
                dataType = yGroupingInterval.getGroupType();
                groupUnit = yGroupingInterval.getGroupingUnit();
                groupIntervalRange = yGroupingInterval.getGroupingInterval();
            }
            this.exprCodec.decode(yGroupExpr);
            this.innerGroupName = name = this.generateUniqueBindingName(this.exprCodec.getExpression());
            GroupDefinition yGroupDefinition = new GroupDefinition(name);
            yGroupDefinition.setKeyExpression(ChartReportItemUtil.adaptExpression(this.exprCodec, this.modelAdapter, false));
            yGroupDefinition.setInterval(ChartReportItemUtil.convertToDtEGroupUnit(dataType, groupUnit, groupIntervalRange));
            yGroupDefinition.setIntervalRange(ChartReportItemUtil.convertToDtEIntervalRange(dataType, groupUnit, groupIntervalRange));
            if (yGroupDefinition != null) {
                query.addGroup(yGroupDefinition);
            }
            return yGroupDefinition;
        }
        return null;
    }

    protected GroupDefinition createCategoryGrouping(BaseQueryDefinition query, SeriesDefinition baseSD) {
        if (ChartReportItemUtil.isBaseGroupingDefined(baseSD)) {
            String name;
            DataType dataType = baseSD.getGrouping().getGroupType();
            GroupingUnitType groupUnit = baseSD.getGrouping().getGroupingUnit();
            double groupIntervalRange = baseSD.getGrouping().getGroupingInterval();
            if (groupIntervalRange < 0.0) {
                groupIntervalRange = 0.0;
            }
            String baseExpr = ((Query)baseSD.getDesignTimeSeries().getDataDefinition().get(0)).getDefinition();
            this.exprCodec.decode(baseExpr);
            this.innerGroupName = name = this.generateUniqueBindingName(this.exprCodec.getExpression());
            GroupDefinition baseGroupDefinition = new GroupDefinition(name);
            baseGroupDefinition.setKeyExpression(ChartReportItemUtil.adaptExpression(this.exprCodec, this.modelAdapter, false));
            baseGroupDefinition.setInterval(ChartReportItemUtil.convertToDtEGroupUnit(dataType, groupUnit, groupIntervalRange));
            baseGroupDefinition.setIntervalRange(ChartReportItemUtil.convertToDtEIntervalRange(dataType, groupUnit, groupIntervalRange));
            if (baseGroupDefinition != null) {
                query.addGroup(baseGroupDefinition);
            }
            return baseGroupDefinition;
        }
        return null;
    }

    protected String getAggFunExpr(String sortKey, SeriesDefinition baseSD, Axis[] orthAxisArray) throws ChartException {
        String baseAggFunExpr = null;
        if (baseSD.getGrouping() != null && baseSD.getGrouping().isEnabled()) {
            baseAggFunExpr = baseSD.getGrouping().getAggregateExpression();
        }
        String aggFunction = null;
        if (this.fChartModel instanceof ChartWithAxes) {
            int i = 0;
            while (i < orthAxisArray.length) {
                EList sds = orthAxisArray[i].getSeriesDefinitions();
                for (SeriesDefinition sd : sds) {
                    Query q;
                    if (sd.getDesignTimeSeries().getDataDefinition() == null || sd.getDesignTimeSeries().getDataDefinition().get(0) == null || !sortKey.equals((q = (Query)sd.getDesignTimeSeries().getDataDefinition().get(0)).getDefinition())) continue;
                    aggFunction = ChartUtil.getAggregateFunctionExpr((SeriesDefinition)sd, (String)baseAggFunExpr, (Query)q);
                    break;
                }
                ++i;
            }
        } else if (this.fChartModel instanceof ChartWithoutAxes) {
            for (SeriesDefinition sd : baseSD.getSeriesDefinitions()) {
                Query q;
                if (sd.getDesignTimeSeries().getDataDefinition() == null || sd.getDesignTimeSeries().getDataDefinition().get(0) == null || !sortKey.equals((q = (Query)sd.getDesignTimeSeries().getDataDefinition().get(0)).getDefinition())) continue;
                aggFunction = ChartUtil.getAggregateFunctionExpr((SeriesDefinition)sd, (String)baseAggFunExpr, (Query)q);
                break;
            }
        }
        if (aggFunction == null || "".equals(aggFunction)) {
            return baseAggFunExpr;
        }
        return aggFunction;
    }

    protected String getValidSortExpr(SeriesDefinition sd) {
        if (!sd.isSetSorting()) {
            return null;
        }
        String sortExpr = null;
        sortExpr = sd.getSortKey() != null && sd.getSortKey().getDefinition() != null ? sd.getSortKey().getDefinition() : ((Query)sd.getDesignTimeSeries().getDataDefinition().get(0)).getDefinition();
        if ("".equals(sortExpr)) {
            sortExpr = null;
        }
        return sortExpr;
    }

    protected String getExpressionForEvaluator(String expression) {
        return ExpressionUtil.createJSRowExpression((String)expression);
    }

    protected void setBindingExpressionDueToAggregation(Binding binding, String expression, String chartAggFunName) throws DataException {
        IAggrFunction dteAggFunc = AggregationManager.getInstance().getAggregation(ChartReportItemUtil.convertToDtEAggFunction(chartAggFunName));
        IParameterDefn[] parameters = dteAggFunc.getParameterDefn();
        this.exprCodec.decode(expression);
        if (parameters != null && parameters.length > 0) {
            binding.setExpression((IBaseExpression)ChartReportItemUtil.adaptExpression(this.exprCodec, this.modelAdapter, false));
        }
    }
}

