/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache.disk;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.core.security.FileSecurity;
import org.eclipse.birt.data.engine.executor.cache.ResultObjectUtil;
import org.eclipse.birt.data.engine.odi.IResultObject;

class DataFileWriter {
    private File file;
    private boolean isOpen;
    private FileOutputStream fos;
    private BufferedOutputStream bos;
    private ResultObjectUtil resultObjectUtil;

    static DataFileWriter newInstance(File file, ResultObjectUtil resultObjectUtil) {
        return new DataFileWriter(file, resultObjectUtil);
    }

    private DataFileWriter(File file, ResultObjectUtil resultObjectUtil) {
        this.resultObjectUtil = resultObjectUtil;
        this.setWriteFile(file);
    }

    void setWriteFile(File file) {
        if (this.isOpen) {
            this.close();
        }
        this.file = file;
        this.isOpen = false;
    }

    void write(IResultObject[] resultObjects, int count) throws IOException, DataException {
        if (!this.isOpen) {
            try {
                this.fos = FileSecurity.createFileOutputStream(this.file);
            }
            catch (Exception exception) {}
            this.bos = new BufferedOutputStream(this.fos);
            this.isOpen = true;
        }
        this.resultObjectUtil.writeData(this.bos, resultObjects, count);
    }

    void close() {
        if (this.isOpen) {
            try {
                this.bos.close();
                this.fos.close();
                this.isOpen = false;
            }
            catch (IOException iOException) {}
        }
    }
}

