/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.model.schematic;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.DesignElementHandleAdapter;
import org.eclipse.birt.report.designer.core.model.IModelAdapterHelper;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.TableHandleAdapter;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.MetricUtility;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.DimensionUtil;

public class RowHandleAdapter
extends DesignElementHandleAdapter {
    private static final String TABLE_GROUPFOOTER = Messages.getString("RowHandleAdapter.table.groupFooter");
    private static final String TABLE_GROUPHEADER = Messages.getString("RowHandleAdapter.table.groupHeader");
    private static final String TABLE_DETAIL = Messages.getString("RowHandleAdapter.table.detail");
    private static final String TABLE_FOOTER = Messages.getString("RowHandleAdapter.table.footer");
    private static final String TABLE_HEADER = Messages.getString("RowHandleAdapter.table.header");
    static final int DEFAULT_HEIGHT = 23;
    public static final int DEFAULT_MINHEIGHT = 23;

    public RowHandleAdapter(RowHandle row) {
        this(row, null);
    }

    public RowHandleAdapter(RowHandle row, IModelAdapterHelper mark) {
        super((DesignElementHandle)row, mark);
    }

    public int getHeight() {
        DimensionHandle handle = this.getRowHandle().getHeight();
        int px = (int)DEUtil.convertoToPixel(handle);
        if (px <= 0) {
            px = 23;
        }
        return px;
    }

    public boolean isCustomHeight() {
        DimensionHandle handle = this.getRowHandle().getHeight();
        return handle.getMeasure() > 0.0;
    }

    public int getRowNumber() {
        TableHandleAdapter adapter = HandleAdapterFactory.getInstance().getTableHandleAdapter(this.getTableParent());
        return adapter.getRows().indexOf(this.getRowHandle()) + 1;
    }

    public int getMinHeight() {
        return 23;
    }

    private RowHandle getRowHandle() {
        return (RowHandle)this.getHandle();
    }

    @Override
    public List getChildren() {
        return this.getRowHandle().getCells().getContents();
    }

    @Override
    public String getDisplayName() {
        TableHandleAdapter adapt = HandleAdapterFactory.getInstance().getTableHandleAdapter(this.getTableParent());
        TableHandleAdapter.RowUIInfomation info = adapt.getRowInfo(this.getHandle());
        return info.getRowDisplayName();
    }

    public String getType() {
        TableHandleAdapter adapt = HandleAdapterFactory.getInstance().getTableHandleAdapter(this.getTableParent());
        TableHandleAdapter.RowUIInfomation info = adapt.getRowInfo(this.getHandle());
        return info.getType();
    }

    public String getTypeString() {
        TableHandleAdapter adapt = HandleAdapterFactory.getInstance().getTableHandleAdapter(this.getTableParent());
        TableHandleAdapter.RowUIInfomation info = adapt.getRowInfo(this.getHandle());
        String tp = info.getType();
        if ("H".equals(tp)) {
            return TABLE_HEADER;
        }
        if ("F".equals(tp)) {
            return TABLE_FOOTER;
        }
        if ("D".equals(tp)) {
            return TABLE_DETAIL;
        }
        if ("gh".equals(tp)) {
            return TABLE_GROUPHEADER;
        }
        if ("gf".equals(tp)) {
            return TABLE_GROUPFOOTER;
        }
        return null;
    }

    public int getParentSlotId() {
        return -1;
    }

    public Object copy() throws SemanticException {
        SlotHandle slotHandle = this.getRowHandle().getContainerSlotHandle();
        RowHandle retValue = slotHandle.getElementHandle().getElementFactory().newTableRow();
        Iterator iter = this.getRowHandle().getPropertyIterator();
        while (iter.hasNext()) {
            PropertyHandle handle = (PropertyHandle)iter.next();
            String key = handle.getDefn().getName();
            if (!handle.isLocal()) continue;
            this.getRowHandle().copyPropertyTo(key, (DesignElementHandle)retValue);
        }
        return retValue;
    }

    public Object getTableParent() {
        DesignElementHandle element = this.getRowHandle().getContainer();
        if (element instanceof TableGroupHandle) {
            element = element.getContainer();
        }
        return element;
    }

    public void setHeight(int rowHeight, String units) throws SemanticException {
        double value = MetricUtility.pixelToPixelInch(rowHeight);
        DimensionValue dimensionValue = DimensionUtil.convertTo((double)value, (String)"in", (String)units);
        this.getRowHandle().getHeight().setValue((Object)dimensionValue);
    }

    public void setHeight(int rowHeight) throws SemanticException {
        this.setHeight(rowHeight, "in");
    }
}

