/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.DescriptorToolkit;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.TextPropertyDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TextAndTwoButtonSection
extends Section {
    private int width = -1;
    private boolean fillText = false;
    protected TextPropertyDescriptor textField;
    private List secondSelectList = new ArrayList();
    protected Button secondButton;
    private String secondButtonText;
    IDescriptorProvider provider;
    protected List firstSelectList = new ArrayList();
    private int secondButtonWidth = 60;
    private boolean isComputeSize = false;
    private String oldValue;
    private String secondButtonTooltipText;

    public TextAndTwoButtonSection(String labelText, Composite parent, boolean isFormStyle) {
        super(labelText, parent, isFormStyle);
    }

    @Override
    public void createSection() {
        if (this.firstSelectList == null) {
            this.firstSelectList = new ArrayList();
        }
        if (this.secondSelectList == null) {
            this.secondSelectList = new ArrayList();
        }
        this.getLabelControl(this.parent);
        this.getTextControl(this.parent);
        this.getSecondButtonControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    @Override
    public void layout() {
        GridData gd = (GridData)this.textField.getControl().getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - 3 - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - 3 - this.placeholder;
        if (this.width > -1) {
            gd.widthHint = this.width;
            gd.grabExcessHorizontalSpace = false;
        } else {
            gd.grabExcessHorizontalSpace = this.fillText;
        }
        gd = (GridData)this.secondButton.getLayoutData();
        if (this.secondButtonWidth > -1) {
            gd.widthHint = !this.isComputeSize ? Math.max(this.secondButton.computeSize((int)-1, (int)-1).x, this.secondButtonWidth) : this.secondButton.computeSize((int)-1, (int)-1).x;
        }
    }

    public TextPropertyDescriptor getTextControl() {
        return this.textField;
    }

    protected TextPropertyDescriptor getTextControl(Composite parent) {
        if (this.textField == null) {
            this.textField = DescriptorToolkit.createTextPropertyDescriptor(true);
            if (this.getProvider() != null) {
                this.textField.setDescriptorProvider(this.getProvider());
            }
            this.textField.createControl(parent);
            this.textField.getControl().setLayoutData((Object)new GridData());
            this.textField.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    TextAndTwoButtonSection.this.textField = null;
                }
            });
        } else {
            this.checkParent(this.textField.getControl(), parent);
        }
        return this.textField;
    }

    protected Button getSecondButtonControl(Composite parent) {
        if (this.secondButton == null) {
            this.secondButton = FormWidgetFactory.getInstance().createButton(parent, 8, this.isFormStyle);
            this.secondButton.setFont(parent.getFont());
            this.secondButton.setLayoutData((Object)new GridData());
            String text = this.getSecondButtonText();
            if (text != null) {
                this.secondButton.setText(text);
            }
            if ((text = this.getSecondButtonTooltipText()) != null) {
                this.secondButton.setToolTipText(text);
            }
            this.secondButton.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    TextAndTwoButtonSection.this.secondButton = null;
                }
            });
            if (!this.secondSelectList.isEmpty()) {
                this.secondButton.addSelectionListener((SelectionListener)this.secondSelectList.get(0));
            } else {
                SelectionAdapter listener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TextAndTwoButtonSection.this.onClickSecondButton();
                    }
                };
                this.secondSelectList.add(listener);
            }
        } else {
            this.checkParent((Control)this.secondButton, parent);
        }
        return this.secondButton;
    }

    private String getSecondButtonTooltipText() {
        return this.secondButtonTooltipText;
    }

    private String getSecondButtonText() {
        return this.secondButtonText;
    }

    public IDescriptorProvider getProvider() {
        return this.provider;
    }

    public void setProvider(IDescriptorProvider provider) {
        this.provider = provider;
        if (this.textField != null) {
            this.textField.setDescriptorProvider(provider);
        }
    }

    public void addSecondSelectionListener(SelectionListener listener) {
        if (!this.secondSelectList.contains(listener)) {
            if (!this.secondSelectList.isEmpty()) {
                this.removeSecondSelectionListener((SelectionListener)this.secondSelectList.get(0));
            }
            this.secondSelectList.add(listener);
            if (this.secondButton != null) {
                this.secondButton.addSelectionListener(listener);
            }
        }
    }

    public void removeSecondSelectionListener(SelectionListener listener) {
        if (this.secondSelectList.contains(listener)) {
            this.secondSelectList.remove(listener);
            if (this.secondButton != null) {
                this.secondButton.removeSelectionListener(listener);
            }
        }
    }

    protected void onClickSecondButton() {
    }

    public void forceFocus() {
        this.textField.getControl().forceFocus();
    }

    @Override
    public void setInput(Object input) {
        this.textField.setInput(input);
    }

    @Override
    public void load() {
        if (this.textField != null && !this.textField.getControl().isDisposed()) {
            this.textField.load();
        }
    }

    public void setSecondButtonWidth(int buttonWidth) {
        this.secondButtonWidth = buttonWidth;
        if (this.secondButton != null) {
            GridData data = new GridData();
            data.widthHint = Math.max(this.secondButton.computeSize((int)-1, (int)-1).x, buttonWidth);
            data.grabExcessHorizontalSpace = false;
            this.secondButton.setLayoutData((Object)data);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setStringValue(String value) {
        if (this.textField != null) {
            if (value == null) {
                value = "";
            }
            this.oldValue = this.textField.getText();
            if (!this.oldValue.equals(value)) {
                this.textField.setText(value);
            }
        }
    }

    public boolean isFillText() {
        return this.fillText;
    }

    public void setFillText(boolean fillText) {
        this.fillText = fillText;
    }

    @Override
    public void setHidden(boolean isHidden) {
        if (this.displayLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.displayLabel, (boolean)isHidden);
        }
        if (this.textField != null && this.placeholderLabel != null) {
            WidgetUtil.setExcludeGridData((Control)this.placeholderLabel, (boolean)isHidden);
        }
    }

    @Override
    public void setVisible(boolean isVisible) {
        if (this.displayLabel != null) {
            this.displayLabel.setVisible(isVisible);
        }
        if (this.textField != null) {
            this.textField.setVisible(isVisible);
        }
        if (this.placeholderLabel != null) {
            this.placeholderLabel.setVisible(isVisible);
        }
    }

    public void setSecondButtonTooltipText(String string) {
        this.secondButtonTooltipText = string;
        if (this.secondButton != null) {
            this.secondButton.setToolTipText(this.secondButtonTooltipText);
        }
    }

    public void setSecondButtonText(String buttonText) {
        this.secondButtonText = buttonText;
        if (this.secondButton != null) {
            this.secondButton.setText(buttonText);
        }
    }

    public boolean buttonIsComputeSize() {
        return this.isComputeSize;
    }

    public void setButtonIsComputeSize(boolean isComputeSize) {
        this.isComputeSize = isComputeSize;
    }
}

