/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pptx.writer;

import java.awt.Color;
import java.io.IOException;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.pptx.PPTXCanvas;
import org.eclipse.birt.report.engine.emitter.pptx.writer.Component;
import org.eclipse.birt.report.engine.emitter.pptx.writer.Presentation;
import org.eclipse.birt.report.engine.emitter.pptx.writer.SlideLayout;
import org.eclipse.birt.report.engine.nLayout.area.impl.PageArea;
import org.eclipse.birt.report.engine.ooxml.IPartContainer;

public class SlideMaster
extends Component {
    private final Presentation presentation;
    private final SlideLayout slideLayout;
    private final PageArea masterarea;

    public SlideMaster(Presentation presentation, PageArea area) throws IOException {
        this.presentation = presentation;
        String type = "application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml";
        String relationshipType = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/slideMaster";
        String uri = "slideMasters/slideMaster" + presentation.getNextSlideMasterId() + ".xml";
        this.initialize((IPartContainer)presentation.getPart(), uri, type, relationshipType);
        this.masterarea = area;
        this.writePage(area);
        this.slideLayout = new SlideLayout(presentation, this);
    }

    public Presentation getPresentation() {
        return this.presentation;
    }

    public void close() throws IOException {
        this.writer.closeTag("p:spTree");
        this.writer.closeTag("p:cSld");
        this.writer.openTag("p:clrMap");
        this.writer.attribute("bg1", "lt1");
        this.writer.attribute("tx1", "dk1");
        this.writer.attribute("bg2", "lt2");
        this.writer.attribute("tx2", "dk2");
        this.writer.attribute("accent1", "accent1");
        this.writer.attribute("accent2", "accent2");
        this.writer.attribute("accent3", "accent3");
        this.writer.attribute("accent4", "accent4");
        this.writer.attribute("accent5", "accent5");
        this.writer.attribute("accent6", "accent6");
        this.writer.attribute("hlink", "hlink");
        this.writer.attribute("folHlink", "folHlink");
        this.writer.closeTag("p:clrMap");
        this.outputSlideLayouts();
        this.writer.openTag("p:txStyles");
        this.writer.openTag("p:titleStyle");
        this.writer.closeTag("p:titleStyle");
        this.writer.openTag("p:bodyStyle");
        this.writer.closeTag("p:bodyStyle");
        this.writer.openTag("p:otherStyle");
        this.writer.openTag("a:lvl1pPr");
        this.writer.closeTag("a:lvl1pPr");
        this.writer.closeTag("p:otherStyle");
        this.writer.closeTag("p:txStyles");
        this.writer.closeTag("p:sldMaster");
        this.writer.endWriter();
        this.writer.close();
        this.writer = null;
    }

    private void outputSlideLayouts() {
        this.writer.openTag("p:sldLayoutIdLst");
        long id = this.presentation.getNextGlobalId();
        String relationshipId = this.referTo(this.slideLayout).getRelationshipId();
        this.writer.openTag("p:sldLayoutId");
        this.writer.attribute("id", String.valueOf(id));
        this.writer.attribute("r:id", relationshipId);
        this.writer.closeTag("p:sldLayoutId");
        this.writer.closeTag("p:sldLayoutIdLst");
    }

    private void drawSlideBackgroundColor(Color color) {
        this.writer.openTag("p:bg");
        this.writer.openTag("p:bgPr");
        this.setColor(color);
        this.writer.openTag("a:effectLst");
        this.writer.closeTag("a:effectLst");
        this.writer.closeTag("p:bgPr");
        this.writer.closeTag("p:bg");
    }

    private void setColor(Color color) {
        if (color != null) {
            this.writer.openTag("a:solidFill");
            this.writer.openTag("a:srgbClr");
            this.writer.attribute("val", EmitterUtil.getColorString((Color)color));
            this.writer.closeTag("a:srgbClr");
            this.writer.closeTag("a:solidFill");
        }
    }

    public void writePage(PageArea pageArea) {
        this.writer.startWriter();
        this.writer.openTag("p:sldMaster");
        this.writer.nameSpace("a", "http://schemas.openxmlformats.org/drawingml/2006/main");
        this.writer.nameSpace("r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
        this.writer.nameSpace("p", "http://schemas.openxmlformats.org/presentationml/2006/main");
        this.writer.openTag("p:cSld");
        Color color = pageArea.getBoxStyle().getBackgroundColor();
        if (color != null) {
            this.drawSlideBackgroundColor(color);
        } else {
            this.writer.openTag("p:bg");
            this.writer.openTag("p:bgRef");
            this.writer.attribute("idx", "1001");
            this.writer.openTag("a:schemeClr");
            this.writer.attribute("val", "bg1");
            this.writer.closeTag("a:schemeClr");
            this.writer.closeTag("p:bgRef");
            this.writer.closeTag("p:bg");
        }
        this.writer.openTag("p:spTree");
        this.writer.openTag("p:nvGrpSpPr");
        this.writer.openTag("p:cNvPr");
        this.writer.attribute("id", "1");
        this.writer.attribute("name", "");
        this.writer.closeTag("p:cNvPr");
        this.writer.openTag("p:cNvGrpSpPr");
        this.writer.closeTag("p:cNvGrpSpPr");
        this.writer.openTag("p:nvPr");
        this.writer.closeTag("p:nvPr");
        this.writer.closeTag("p:nvGrpSpPr");
        this.writer.openTag("p:grpSpPr");
        this.writer.openTag("a:xfrm");
        this.writer.openTag("a:off");
        this.writer.attribute("x", "0");
        this.writer.attribute("y", "0");
        this.writer.closeTag("a:off");
        this.writer.openTag("a:ext");
        this.writer.attribute("cx", "0");
        this.writer.attribute("cy", "0");
        this.writer.closeTag("a:ext");
        this.writer.openTag("a:chOff");
        this.writer.attribute("x", "0");
        this.writer.attribute("y", "0");
        this.writer.closeTag("a:chOff");
        this.writer.openTag("a:chExt");
        this.writer.attribute("cx", "0");
        this.writer.attribute("cy", "0");
        this.writer.closeTag("a:chExt");
        this.writer.closeTag("a:xfrm");
        this.writer.closeTag("p:grpSpPr");
    }

    public SlideLayout getSlideLayout() {
        return this.slideLayout;
    }

    public PPTXCanvas getCanvas() {
        return new PPTXCanvas(this.presentation, this.part, this.writer);
    }

    public PageArea getPageArea() {
        return this.masterarea;
    }
}

