/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.impl.PageContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.PageVariable;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.IAreaVisitor;
import org.eclipse.birt.report.engine.nLayout.area.IContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.IImageArea;
import org.eclipse.birt.report.engine.nLayout.area.ITemplateArea;
import org.eclipse.birt.report.engine.nLayout.area.ITextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.script.internal.OnPageBreakScriptVisitor;
import org.eclipse.birt.report.engine.script.internal.ReportScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;

public class OnPageBreakLayoutPageHandle
implements ILayoutPageHandler {
    private static final int CONTENTS_CONVERTION_THRESHOLD = 16;
    protected ExecutionContext executionContext;
    protected IContentEmitter emitter;
    protected PageContent pageContent;
    protected boolean bufferAllContents;
    private Collection<IContent> contents;
    protected boolean existPageScript = false;

    public OnPageBreakLayoutPageHandle(ExecutionContext executionContext) {
        this.executionContext = executionContext;
        this.emitter = new PageContentBuilder();
        this.contents = new ArrayList<IContent>();
        Report report = executionContext.getReport();
        if (report != null) {
            this.existPageScript = ReportScriptExecutor.existPageScript(report, executionContext) || report.getOnPageStart() != null || report.getOnPageEnd() != null;
        }
    }

    public IContentEmitter getEmitter() {
        return this.emitter;
    }

    private void initPageBuffer(PageContent pageContent) {
        MasterPageDesign pageDesign = (MasterPageDesign)pageContent.getGenerateBy();
        pageContent.getReportContent().getDesign();
        this.bufferAllContents = pageDesign.getOnPageStart() != null || pageDesign.getOnPageEnd() != null || this.existPageScript;
        this.contents.clear();
        this.pageContent = pageContent;
    }

    private ReportItemDesign getGenerateDesign(IContent content) {
        Object design = content.getGenerateBy();
        if (design instanceof ReportItemDesign) {
            return (ReportItemDesign)design;
        }
        if (design instanceof ReportItemHandle) {
            IReportContent reportContent = content.getReportContent();
            Report reportDesign = reportContent.getDesign();
            return reportDesign.findDesign((ReportElementHandle)((ReportItemHandle)design));
        }
        return null;
    }

    private void addContent(IContent content) {
        if (!this.bufferAllContents) {
            ReportItemDesign design = this.getGenerateDesign(content);
            if (design != null && ScriptExecutor.needOnPageBreak(design, this.executionContext) && !this.contents.contains(content)) {
                this.doAddContent(content);
            }
        } else if (!this.contents.contains(content)) {
            this.doAddContent(content);
        }
    }

    private void doAddContent(IContent content) {
        if (this.contents.size() == 16) {
            this.contents = new TreeSet<IContent>(this.contents);
        }
        this.contents.add(content);
    }

    @Override
    public void onPage(long page, Object context) {
        if (this.executionContext == null || this.pageContent == null) {
            return;
        }
        Report report = this.executionContext.getReport();
        OnPageBreakScriptVisitor onPageBreakVisitor = new OnPageBreakScriptVisitor(this.executionContext);
        Collection<PageVariable> pageVariables = this.executionContext.getPageVariables();
        for (PageVariable pageVar : pageVariables) {
            if (!"page".equals(pageVar.getScope())) continue;
            Object value = pageVar.getDefaultValue();
            pageVar.setValue(value);
        }
        onPageBreakVisitor.onPageStart(report, this.pageContent, this.contents);
        onPageBreakVisitor.onPageStart(this.pageContent, this.contents);
        for (IContent content : this.contents) {
            onPageBreakVisitor.onPageBreak(content);
        }
        onPageBreakVisitor.onPageEnd(this.pageContent, this.contents);
        onPageBreakVisitor.onPageEnd(report, this.pageContent, this.contents);
        this.contents.clear();
        this.pageContent = null;
    }

    private class PageBreakContentCollector
    implements IAreaVisitor {
        private PageBreakContentCollector() {
        }

        @Override
        public void visitText(ITextArea textArea) {
        }

        @Override
        public void visitAutoText(ITemplateArea templateArea) {
        }

        @Override
        public void visitImage(IImageArea imageArea) {
        }

        @Override
        public void visitContainer(IContainerArea container) {
            IContent content = ((ContainerArea)container).getContent();
            if (content != null) {
                OnPageBreakLayoutPageHandle.this.addContent(content);
            }
            Iterator<IArea> iter = container.getChildren();
            while (iter.hasNext()) {
                IArea child = iter.next();
                child.accept(this);
            }
        }
    }

    private class PageContentBuilder
    extends ContentEmitterAdapter {
        private PageContentBuilder() {
        }

        @Override
        public void startPage(IPageContent pageContent) throws BirtException {
            OnPageBreakLayoutPageHandle.this.initPageBuffer((PageContent)pageContent);
            IArea pageArea = (IArea)pageContent.getExtension(1);
            if (pageArea != null) {
                pageArea.accept(new PageBreakContentCollector());
            }
        }

        @Override
        public void startContent(IContent content) throws BirtException {
            OnPageBreakLayoutPageHandle.this.addContent(content);
        }
    }
}

