/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.report.data.adapter.api.CubeQueryUtil;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IDimensionLevel;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.data.adapter.api.LinkedDataSetUtil;
import org.eclipse.birt.report.item.crosstab.core.CrosstabException;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.de.AbstractCrosstabItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.internal.CrosstabModelUtil;
import org.eclipse.birt.report.item.crosstab.core.de.internal.ICrosstabModelListener;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabExtendedItemFactory;
import org.eclipse.birt.report.item.crosstab.core.util.ICrosstabUpdateListener;
import org.eclipse.birt.report.model.api.AggregationArgumentHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.util.CubeUtil;

public final class CrosstabUtil
implements ICrosstabConstants {
    public static final String BRS_DATASET_ROW_INDICATOR = "DATASET";
    private static String labelDisplayNameKey;

    private CrosstabUtil() {
    }

    public static void setCrosstabUpdateListener(ICrosstabUpdateListener listener) {
        CrosstabModelUtil.setCrosstabModelListener(listener);
    }

    public static ICrosstabUpdateListener getCrosstabUpdateListener() {
        ICrosstabModelListener listener = CrosstabModelUtil.getCrosstabModelListener();
        if (listener instanceof ICrosstabUpdateListener) {
            return (ICrosstabUpdateListener)listener;
        }
        return null;
    }

    public static int getOppositeAxisType(int axisType) {
        switch (axisType) {
            case 1: {
                return 0;
            }
            case 0: {
                return 1;
            }
        }
        return -1;
    }

    public static IReportItem getReportItem(DesignElementHandle element) {
        if (!(element instanceof ExtendedItemHandle)) {
            return null;
        }
        ExtendedItemHandle extendedItem = (ExtendedItemHandle)element;
        try {
            return extendedItem.getReportItem();
        }
        catch (ExtendedElementException extendedElementException) {
            return null;
        }
    }

    public static IReportItem getReportItem(DesignElementHandle element, String extensionName) {
        if (!(element instanceof ExtendedItemHandle)) {
            return null;
        }
        if (extensionName == null) {
            throw new IllegalArgumentException("extension name can not be null");
        }
        ExtendedItemHandle extendedItem = (ExtendedItemHandle)element;
        if (extensionName.equals(extendedItem.getExtensionName())) {
            try {
                return extendedItem.getReportItem();
            }
            catch (ExtendedElementException extendedElementException) {
                return null;
            }
        }
        return null;
    }

    public static boolean canContain(CrosstabReportItemHandle crosstab, DimensionHandle dimension) {
        if (crosstab != null && crosstab.getModelHandle().getExtends() != null) {
            return false;
        }
        if (crosstab != null && dimension != null) {
            CubeHandle currentCube = crosstab.getCube();
            if (currentCube == null) {
                return true;
            }
            if (CrosstabUtil.isBoundToLinkedDataSet(crosstab)) {
                String cubeName;
                DesignElementHandle deh = dimension.getContainer();
                if (deh != null && deh instanceof CubeHandle && (cubeName = ((CubeHandle)deh).getName()) != null && cubeName.equals(currentCube.getName())) {
                    DimensionHandle dh;
                    DimensionViewHandle dv;
                    int i = 0;
                    while (i < crosstab.getDimensionCount(0)) {
                        dv = crosstab.getDimension(0, i);
                        dh = dv.getCubeDimension();
                        if (dh != null && dh.getName() != null && dh.getName().equals(dimension.getName())) {
                            return false;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < crosstab.getDimensionCount(1)) {
                        dv = crosstab.getDimension(1, i);
                        dh = dv.getCubeDimension();
                        if (dh != null && dh.getName() != null && dh.getName().equals(dimension.getName())) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            } else if (dimension.getElement().isContentOf(currentCube.getElement())) {
                DimensionViewHandle dv;
                int i = 0;
                while (i < crosstab.getDimensionCount(0)) {
                    dv = crosstab.getDimension(0, i);
                    if (dv.getCubeDimension() == dimension) {
                        return false;
                    }
                    ++i;
                }
                i = 0;
                while (i < crosstab.getDimensionCount(1)) {
                    dv = crosstab.getDimension(1, i);
                    if (dv.getCubeDimension() == dimension) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean canContain(CrosstabReportItemHandle crosstab, MeasureHandle measure) {
        if (crosstab != null && crosstab.getModelHandle().getExtends() != null) {
            return false;
        }
        if (crosstab != null && measure != null) {
            CubeHandle currentCube = crosstab.getCube();
            if (currentCube == null) {
                return true;
            }
            if (CrosstabUtil.isBoundToLinkedDataSet(crosstab) && measure.getContainer() != null) {
                String cubeName;
                DesignElementHandle deh = measure.getContainer().getContainer();
                if (deh != null && deh instanceof CubeHandle && (cubeName = ((CubeHandle)deh).getName()) != null && cubeName.equals(currentCube.getName())) {
                    int i = 0;
                    while (i < crosstab.getMeasureCount()) {
                        MeasureViewHandle mv = crosstab.getMeasure(i);
                        MeasureHandle mh = mv.getCubeMeasure();
                        if (mh != null && mh.getName() != null && mh.getName().equals(measure.getName())) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            } else if (measure.getElement().isContentOf(currentCube.getElement())) {
                int i = 0;
                while (i < crosstab.getMeasureCount()) {
                    MeasureViewHandle mv = crosstab.getMeasure(i);
                    if (mv.getCubeMeasure() == measure) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean canContain(CrosstabReportItemHandle crosstab, MeasureGroupHandle obj) {
        return crosstab.getModelHandle().getExtends() == null;
    }

    public static boolean isAggregationAffectAllMeasures(CrosstabReportItemHandle crosstabItem, int axisType) {
        String measureDirection = crosstabItem.getMeasureDirection();
        return "horizontal".equals(measureDirection) && axisType == 0 || "vertical".equals(measureDirection) && axisType == 1;
    }

    public static String getDefaultMeasureAggregationFunction(MeasureViewHandle mv) {
        return CrosstabModelUtil.getDefaultMeasureAggregationFunction(mv);
    }

    public static void addDataItem(CrosstabReportItemHandle crosstab, AggregationCellHandle cell, MeasureViewHandle measureView, String function, String rowDimension, String rowLevel, String colDimension, String colLevel) throws SemanticException {
        CrosstabModelUtil.addDataItem(crosstab, cell, measureView, function, rowDimension, rowLevel, colDimension, colLevel);
    }

    public static List<IDimensionLevel> getReferencedLevels(LevelViewHandle level, String bindingExpr) {
        DesignElementHandle dimensionHandle;
        LevelHandle levelHandle = level.getCubeLevel();
        if (level.getCubeLevel() == null) {
            return Collections.EMPTY_LIST;
        }
        DesignElementHandle hierarchyHandle = levelHandle.getContainer();
        DesignElementHandle designElementHandle = dimensionHandle = hierarchyHandle == null ? null : hierarchyHandle.getContainer();
        if (dimensionHandle == null) {
            return Collections.EMPTY_LIST;
        }
        CrosstabReportItemHandle crosstab = level.getCrosstab();
        boolean isLinkedDataModel = CrosstabUtil.isBoundToLinkedDataSet(crosstab);
        try {
            List<IBinding> bindings = CrosstabUtil.getQueryBindings(crosstab);
            if (isLinkedDataModel) {
                String targetLevel = CubeUtil.getFullLevelName((String)dimensionHandle.getName(), (String)levelHandle.getName());
                List<String> rowLevelList = CrosstabUtil.getLevelBindingNameList(crosstab, 0);
                List<String> colLevelList = CrosstabUtil.getLevelBindingNameList(crosstab, 1);
                return CubeQueryUtil.getReferencedLevelsForLinkedCube((String)targetLevel, (String)bindingExpr, bindings, rowLevelList, colLevelList);
            }
            String targetLevel = ExpressionUtil.createJSDimensionExpression((String)dimensionHandle.getName(), (String)levelHandle.getName());
            List<String> rowExpList = CrosstabUtil.getLevelExpressionList(crosstab, 0);
            List<String> colExpList = CrosstabUtil.getLevelExpressionList(crosstab, 1);
            return CubeQueryUtil.getReferencedLevels((String)targetLevel, (String)bindingExpr, bindings, rowExpList, colExpList);
        }
        catch (Exception exception) {
            return Collections.EMPTY_LIST;
        }
    }

    public static boolean isBoundToLinkedDataSet(AbstractCrosstabItemHandle crosstabItem) {
        boolean isBoundToLinkedDataSet = false;
        try {
            if (crosstabItem != null) {
                isBoundToLinkedDataSet = LinkedDataSetUtil.bindToLinkedDataSet((ReportItemHandle)((ReportItemHandle)crosstabItem.getCrosstabHandle()));
            }
        }
        catch (Exception exception) {}
        return isBoundToLinkedDataSet;
    }

    private static List<IBinding> getQueryBindings(CrosstabReportItemHandle crosstabItem) throws BirtException {
        LevelViewHandle lv;
        int j;
        DimensionViewHandle dv;
        int i;
        ArrayList<String> rowLevelNameList = new ArrayList<String>();
        ArrayList<String> columnLevelNameList = new ArrayList<String>();
        if (crosstabItem.getDimensionCount(0) > 0) {
            i = 0;
            while (i < crosstabItem.getDimensionCount(0)) {
                dv = crosstabItem.getDimension(0, i);
                if (dv.getCubeDimension() == null) {
                    throw new CrosstabException(dv.getModelHandle().getElement(), Messages.getString("CrosstabQueryHelper.error.invalid.dimension.row", dv.getCubeDimensionName()));
                }
                j = 0;
                while (j < dv.getLevelCount()) {
                    lv = dv.getLevel(j);
                    if (lv.getCubeLevel() == null) {
                        throw new CrosstabException(lv.getModelHandle().getElement(), Messages.getString("CrosstabQueryHelper.error.invalid.level.row", lv.getCubeLevelName()));
                    }
                    rowLevelNameList.add(lv.getCubeLevel().getFullName());
                    ++j;
                }
                ++i;
            }
        }
        if (crosstabItem.getDimensionCount(1) > 0) {
            i = 0;
            while (i < crosstabItem.getDimensionCount(1)) {
                dv = crosstabItem.getDimension(1, i);
                if (dv.getCubeDimension() == null) {
                    throw new CrosstabException(dv.getModelHandle().getElement(), Messages.getString("CrosstabQueryHelper.error.invalid.dimension.column", dv.getCubeDimensionName()));
                }
                j = 0;
                while (j < dv.getLevelCount()) {
                    lv = dv.getLevel(j);
                    if (lv.getCubeLevel() == null) {
                        throw new CrosstabException(lv.getModelHandle().getElement(), Messages.getString("CrosstabQueryHelper.error.invalid.level.column", lv.getCubeLevelName()));
                    }
                    columnLevelNameList.add(lv.getCubeLevel().getFullName());
                    ++j;
                }
                ++i;
            }
        }
        ArrayList<IBinding> bindingList = new ArrayList<IBinding>();
        Iterator bindingItr = ((ExtendedItemHandle)crosstabItem.getModelHandle()).columnBindingsIterator();
        if (bindingItr != null) {
            HashMap<String, String> cache = new HashMap<String, String>();
            DataRequestSession session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3));
            try {
                IModelAdapter modelAdapter = session.getModelAdaptor();
                while (bindingItr.hasNext()) {
                    ComputedColumnHandle column = (ComputedColumnHandle)bindingItr.next();
                    IBinding binding = modelAdapter.adaptBinding(column, IModelAdapter.ExpressionLocation.CUBE);
                    List aggrList = column.getAggregateOnList();
                    if (aggrList != null) {
                        for (String baseLevel : aggrList) {
                            CrosstabUtil.addHierachyAggregateOn(crosstabItem, binding, baseLevel, rowLevelNameList, columnLevelNameList, cache);
                        }
                    }
                    bindingList.add(binding);
                }
            }
            finally {
                session.shutdown();
            }
        }
        return bindingList;
    }

    public static void addHierachyAggregateOn(CrosstabReportItemHandle crosstabItem, IBinding binding, String baseLevel, List<String> rowLevelList, List<String> columnLevelList, Map<String, String> cache) throws BirtException {
        if (binding == null || baseLevel == null || crosstabItem == null) {
            return;
        }
        int sindex = rowLevelList.indexOf(baseLevel);
        if (sindex != -1) {
            int i = 0;
            while (i <= sindex) {
                String levelName = rowLevelList.get(i);
                String cachedExpression = cache.get(levelName);
                if (cachedExpression == null) {
                    cachedExpression = CrosstabUtil.createAggregateLevelExpression(crosstabItem, levelName);
                    cache.put(levelName, cachedExpression);
                }
                if (cachedExpression != null) {
                    binding.addAggregateOn(cachedExpression);
                }
                ++i;
            }
            return;
        }
        sindex = columnLevelList.indexOf(baseLevel);
        if (sindex != -1) {
            int i = 0;
            while (i <= sindex) {
                String levelName = columnLevelList.get(i);
                String cachedExpression = cache.get(levelName);
                if (cachedExpression == null) {
                    cachedExpression = CrosstabUtil.createAggregateLevelExpression(crosstabItem, levelName);
                    cache.put(levelName, cachedExpression);
                }
                if (cachedExpression != null) {
                    binding.addAggregateOn(cachedExpression);
                }
                ++i;
            }
            return;
        }
        String cachedExpression = cache.get(baseLevel);
        if (cachedExpression == null) {
            cachedExpression = CrosstabUtil.createAggregateLevelExpression(crosstabItem, baseLevel);
            cache.put(baseLevel, cachedExpression);
        }
        if (cachedExpression != null) {
            binding.addAggregateOn(cachedExpression);
        }
    }

    private static String createAggregateLevelExpression(CrosstabReportItemHandle crosstabItem, String levelFullName) {
        String[] names = CubeUtil.splitLevelName((String)levelFullName);
        if (CrosstabUtil.isBoundToLinkedDataSet(crosstabItem)) {
            return CrosstabUtil.getLevelBindingName(crosstabItem, crosstabItem.getLevel(levelFullName), names[0], names[1]);
        }
        return ExpressionUtil.createJSDimensionExpression((String)names[0], (String)names[1]);
    }

    private static List<String> getLevelBindingNameList(CrosstabReportItemHandle crosstab, int axis) throws CrosstabException {
        ArrayList<String> lvList = new ArrayList<String>();
        int count = crosstab.getDimensionCount(axis);
        int i = 0;
        while (i < count) {
            DimensionViewHandle dv = crosstab.getDimension(axis, i);
            if (dv.getCubeDimension() == null) {
                throw new CrosstabException(dv.getModelHandle().getElement(), Messages.getString("CrosstabQueryHelper.error.invalid.dimension.row", dv.getCubeDimensionName()));
            }
            int j = 0;
            while (j < dv.getLevelCount()) {
                LevelViewHandle lv = dv.getLevel(j);
                if (lv.getCubeLevel() == null) {
                    throw new CrosstabException(lv.getModelHandle().getElement(), Messages.getString("CrosstabQueryHelper.error.invalid.level.row", lv.getCubeLevelName()));
                }
                lvList.add(CrosstabUtil.getLevelBindingName(crosstab, lv, null, null));
                ++j;
            }
            ++i;
        }
        return lvList;
    }

    private static List<String> getLevelExpressionList(CrosstabReportItemHandle crosstab, int axis) throws CrosstabException {
        ArrayList<String> expList = new ArrayList<String>();
        int count = crosstab.getDimensionCount(axis);
        int i = 0;
        while (i < count) {
            DimensionViewHandle dv = crosstab.getDimension(axis, i);
            if (dv.getCubeDimension() == null) {
                throw new CrosstabException(dv.getModelHandle().getElement(), Messages.getString("CrosstabQueryHelper.error.invalid.dimension.row", dv.getCubeDimensionName()));
            }
            int j = 0;
            while (j < dv.getLevelCount()) {
                LevelViewHandle lv = dv.getLevel(j);
                if (lv.getCubeLevel() == null) {
                    throw new CrosstabException(lv.getModelHandle().getElement(), Messages.getString("CrosstabQueryHelper.error.invalid.level.row", lv.getCubeLevelName()));
                }
                String expression = ExpressionUtil.createJSDimensionExpression((String)dv.getCubeDimension().getName(), (String)lv.getCubeLevel().getName());
                expList.add(expression);
                ++j;
            }
            ++i;
        }
        return expList;
    }

    public static DimensionViewHandle getDimensionViewHandle(CrosstabReportItemHandle crosstab, String dimensionShortName) {
        DimensionViewHandle dimension = null;
        int[] nArray = new int[2];
        nArray[1] = 1;
        int[] type = nArray;
        int i = 0;
        while (i < type.length) {
            int count = crosstab.getDimensionCount(type[i]);
            int j = 0;
            while (j < count) {
                DimensionViewHandle tmpDimension = crosstab.getDimension(type[i], j);
                if (tmpDimension != null && tmpDimension.getCubeDimension().getName().equals(dimensionShortName)) {
                    dimension = tmpDimension;
                    return dimension;
                }
                ++j;
            }
            ++i;
        }
        return dimension;
    }

    public static boolean canMergeCrosstabHeaderCell(CrosstabReportItemHandle crosstab) {
        return crosstab.getHeaderCount() > 1;
    }

    public static boolean canSplitCrosstabHeaderCell(CrosstabReportItemHandle crosstab) {
        int[] numbers = CrosstabModelUtil.getHeaderRowAndColumnCount(crosstab);
        return crosstab.getHeaderCount() == 1 && numbers[0] * numbers[1] > 1;
    }

    public static void mergeCrosstabHeaderCell(CrosstabReportItemHandle crosstab) {
        int count = crosstab.getHeaderCount();
        if (count <= 1) {
            return;
        }
        PropertyHandle headerHandle = crosstab.getModelHandle().getPropertyHandle("header");
        int i = 1;
        while (i < count) {
            try {
                headerHandle.removeItem(1);
            }
            catch (PropertyValueException propertyValueException) {}
            ++i;
        }
    }

    public static void splitCrosstabHeaderCell(CrosstabReportItemHandle crosstab) {
        int[] numbers = CrosstabModelUtil.getHeaderRowAndColumnCount(crosstab);
        int total = numbers[0] * numbers[1];
        PropertyHandle headerHandle = crosstab.getModelHandle().getPropertyHandle("header");
        int i = 1;
        while (i < total) {
            ExtendedItemHandle cellHandle = CrosstabExtendedItemFactory.createCrosstabCell(crosstab.getModuleHandle());
            try {
                headerHandle.add((DesignElementHandle)cellHandle);
            }
            catch (SemanticException semanticException) {}
            ++i;
        }
    }

    public static int[] getCrosstabHeaderRowAndColumnCount(CrosstabReportItemHandle crosstab) {
        return CrosstabModelUtil.getHeaderRowAndColumnCount(crosstab);
    }

    public static int findPriorLevelCount(DimensionViewHandle viewHandle) {
        return CrosstabModelUtil.findPriorLevelCount(viewHandle);
    }

    public static List<LevelViewHandle> getLevelList(CrosstabReportItemHandle crosstab, int axisType) {
        return CrosstabModelUtil.getLevelList(crosstab, axisType);
    }

    public static void addAllHeaderLabel(CrosstabReportItemHandle reportHandle) {
        int j;
        DimensionViewHandle viewHandle;
        int i = 0;
        while (i < reportHandle.getDimensionCount(0)) {
            viewHandle = reportHandle.getDimension(0, i);
            j = 0;
            while (j < viewHandle.getLevelCount()) {
                CrosstabUtil.addLabelToHeader(viewHandle.getLevel(j));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < reportHandle.getDimensionCount(1)) {
            viewHandle = reportHandle.getDimension(1, i);
            j = 0;
            while (j < viewHandle.getLevelCount()) {
                CrosstabUtil.addLabelToHeader(viewHandle.getLevel(j));
                ++j;
            }
            ++i;
        }
    }

    private static boolean isShowColumnMeasureHeader(CrosstabReportItemHandle crosstab) {
        return !crosstab.isHideMeasureHeader() && crosstab.getMeasureCount() != 0 && "horizontal".equals(crosstab.getMeasureDirection());
    }

    public static void addLabelToHeader(LevelViewHandle levelHandle) {
        int type = levelHandle.getAxisType();
        DimensionViewHandle viewHandle = (DimensionViewHandle)levelHandle.getContainer();
        int count = CrosstabUtil.findPriorLevelCount(viewHandle) + levelHandle.getIndex();
        CrosstabReportItemHandle crosstab = levelHandle.getCrosstab();
        boolean addForce = false;
        int[] numbers = CrosstabUtil.getCrosstabHeaderRowAndColumnCount(crosstab);
        if (1 == type && !CrosstabUtil.isShowColumnMeasureHeader(crosstab) && count == numbers[0] - 1) {
            if (CrosstabUtil.findPreLeveHandle(levelHandle) != null) {
                CrosstabUtil.addLabelToHeader(CrosstabUtil.findPreLeveHandle(levelHandle));
            }
            if (CrosstabUtil.getLevelList(crosstab, 0).size() != 0) {
                if (!"vertical".equals(crosstab.getMeasureDirection()) || crosstab.getMeasureCount() == 0 || crosstab.isHideMeasureHeader()) {
                    return;
                }
                addForce = true;
            }
        } else if (type == 0 && numbers[0] * numbers[1] == 1) {
            addForce = true;
        }
        count = 1 == type ? (count + 1) * numbers[1] - 1 : (numbers[0] - 1) * numbers[1] + count;
        try {
            if (crosstab.getHeader(count) != null && crosstab.getHeader(count).getContents().size() == 0) {
                LabelHandle labelHandle = crosstab.getModuleHandle().getElementFactory().newLabel(null);
                if (levelHandle.getDisplayField() == null && levelHandle.getCubeLevel() == null) {
                    labelHandle.setText("");
                } else {
                    labelHandle.setText(levelHandle.getDisplayField() == null ? levelHandle.getCubeLevel().getName() : levelHandle.getDisplayField());
                }
                if (labelDisplayNameKey != null) {
                    labelHandle.setTextKey(labelDisplayNameKey);
                }
                crosstab.getHeader(count).addContent((DesignElementHandle)labelHandle);
            } else if (crosstab.getHeader(count) != null && addForce && crosstab.getHeader(count).getContents().get(0) instanceof LabelHandle) {
                LabelHandle labelHandle = (LabelHandle)crosstab.getHeader(count).getContents().get(0);
                labelHandle.setText(levelHandle.getDisplayField() == null ? levelHandle.getCubeLevel().getName() : levelHandle.getDisplayField());
                if (labelDisplayNameKey != null) {
                    labelHandle.setTextKey(labelDisplayNameKey);
                }
            }
        }
        catch (SemanticException semanticException) {}
    }

    private static LevelViewHandle findPreLeveHandle(LevelViewHandle handle) {
        DimensionViewHandle viewHandle = (DimensionViewHandle)handle.getContainer();
        if (handle.getIndex() != 0) {
            return viewHandle.getLevel(handle.getIndex() - 1);
        }
        if (viewHandle.getIndex() == 0) {
            return null;
        }
        viewHandle = handle.getCrosstab().getDimension(viewHandle.getAxisType(), viewHandle.getIndex() - 1);
        return viewHandle.getLevel(viewHandle.getLevelCount() - 1);
    }

    public static ComputedColumnHandle getColumnHandle(CrosstabReportItemHandle crosstabItem, String bindingName) {
        if (crosstabItem == null || bindingName == null) {
            return null;
        }
        Iterator it = ((ExtendedItemHandle)crosstabItem.getModelHandle()).columnBindingsIterator();
        while (it.hasNext()) {
            ComputedColumnHandle column = (ComputedColumnHandle)it.next();
            if (!bindingName.equals(column.getName())) continue;
            return column;
        }
        return null;
    }

    public static Map<String, String> getBindingExpressMap(CrosstabReportItemHandle crosstabItem) {
        HashMap<String, String> exprMap = new HashMap<String, String>();
        if (crosstabItem != null) {
            Iterator it = ((ExtendedItemHandle)crosstabItem.getModelHandle()).columnBindingsIterator();
            while (it.hasNext()) {
                ComputedColumnHandle column = (ComputedColumnHandle)it.next();
                String bindingName = column.getName();
                String expression = column.getExpression();
                if (expression == null) {
                    Iterator argIt = column.argumentsIterator();
                    while (argIt.hasNext()) {
                        AggregationArgumentHandle arg;
                        String name;
                        Object obj = argIt.next();
                        if (!(obj instanceof AggregationArgumentHandle) || !"expression".equalsIgnoreCase(name = (arg = (AggregationArgumentHandle)obj).getName())) continue;
                        expression = arg.getValue();
                        break;
                    }
                }
                exprMap.put(bindingName, expression);
            }
        }
        return exprMap;
    }

    public static boolean validateBinding(ComputedColumnHandle column, String columnName) {
        ExpressionHandle expr;
        String expression;
        if (column == null) {
            return false;
        }
        if (columnName == null || columnName.isEmpty()) {
            columnName = "[^\\]]+";
        }
        if ((expression = (expr = column.getExpressionProperty("expression")).getStringExpression()) != null) {
            if ("javascript".equalsIgnoreCase(expr.getType())) {
                Pattern p = Pattern.compile("\\[\\s*\\\"" + columnName + "\\\"\\s*\\]");
                return p.matcher(expression).find();
            }
            Pattern p = Pattern.compile("\\[\\s*" + columnName + "\\s*\\]");
            return p.matcher(expression).find();
        }
        return false;
    }

    public static boolean validateLevelBinding(ComputedColumnHandle column, String dimensionName, String levelName) {
        if (column == null || dimensionName == null || levelName == null) {
            return false;
        }
        if (column.getAggregateFunction() != null || column.getCalculationType() != null || column.argumentsIterator().hasNext()) {
            return false;
        }
        ExpressionHandle expr = column.getExpressionProperty("expression");
        String expression = expr.getStringExpression();
        if (expression != null) {
            if ("javascript".equalsIgnoreCase(expr.getType())) {
                Pattern p = Pattern.compile("\\[\\s*\\\"" + dimensionName + "\\\"\\s*\\]");
                if (!dimensionName.equals(levelName)) {
                    p = Pattern.compile("\\[\\s*\\\"" + dimensionName + "\\\"\\s*\\]\\[\\s*\\\"" + levelName + "\\\"\\s*\\]");
                }
                return p.matcher(expression).find();
            }
            Pattern p = Pattern.compile("\\[\\s*" + dimensionName + "\\s*\\]");
            if (!dimensionName.equals(levelName)) {
                p = Pattern.compile("\\[\\s*" + dimensionName + "\\s*\\]\\[\\s*" + levelName + "\\s*\\]");
            }
            return p.matcher(expression).find();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getLevelBindingName(CrosstabReportItemHandle crosstabItem, LevelViewHandle lv, String dimensionName, String levelName) {
        if (crosstabItem == null) {
            return null;
        }
        String levelBindingName = null;
        if (lv != null) {
            CrosstabCellHandle cell = lv.getCell();
            if (cell == null) return levelBindingName;
            List contents = cell.getContents();
            for (Object obj : contents) {
                ComputedColumnHandle column;
                if (obj != null && obj instanceof DataItemHandle && CrosstabUtil.validateBinding(column = CrosstabUtil.getColumnHandle(crosstabItem, levelBindingName = ((DataItemHandle)obj).getResultSetColumn()), levelName)) return levelBindingName;
            }
            return levelBindingName;
        } else {
            if (dimensionName == null) return levelBindingName;
            if (levelName == null) return levelBindingName;
            Iterator it = ((ExtendedItemHandle)crosstabItem.getModelHandle()).columnBindingsIterator();
            while (it.hasNext()) {
                ComputedColumnHandle column = (ComputedColumnHandle)it.next();
                if (!CrosstabUtil.validateLevelBinding(column, dimensionName, levelName)) continue;
                return column.getName();
            }
        }
        return levelBindingName;
    }

    public static ComputedColumnHandle getMeasureBindingColumnHandle(MeasureViewHandle mv) {
        if (mv == null) {
            return null;
        }
        CrosstabReportItemHandle crosstabItem = mv.getCrosstab();
        String measureName = mv instanceof ComputedMeasureViewHandle ? null : mv.getCubeMeasureName();
        AggregationCellHandle cell = mv.getCell();
        ComputedColumnHandle columnHandle = null;
        if (cell != null) {
            List contents = cell.getContents();
            for (Object obj : contents) {
                String columnName;
                if (obj != null && obj instanceof DataItemHandle && CrosstabUtil.validateBinding(columnHandle = CrosstabUtil.getColumnHandle(crosstabItem, columnName = ((DataItemHandle)obj).getResultSetColumn()), measureName)) break;
            }
        }
        return columnHandle;
    }

    public static boolean isLinkedDataModelMeasureView(MeasureViewHandle mv) {
        String refColumn = CrosstabUtil.getRefLinkedDataModelColumnName(mv, true);
        return refColumn != null && !refColumn.isEmpty();
    }

    public static String getRefLinkedDataModelColumnName(MeasureViewHandle mv) {
        return CrosstabUtil.getRefLinkedDataModelColumnName(mv, false);
    }

    public static String getRefLinkedDataModelColumnName(MeasureViewHandle mv, boolean ignoreRTP) {
        if (mv == null) {
            return null;
        }
        if (!CrosstabUtil.isBoundToLinkedDataSet(mv.getCrosstab())) {
            return null;
        }
        String refColumnName = null;
        if (mv instanceof ComputedMeasureViewHandle) {
            ComputedColumnHandle ch = CrosstabUtil.getMeasureBindingColumnHandle(mv);
            if (ch != null && ch.getAggregateFunction() != null && !ch.getAggregateFunction().isEmpty()) {
                String expression;
                if (ignoreRTP && ch.getCalculationType() != null) {
                    return null;
                }
                ExpressionHandle expr = ch.getExpressionProperty("expression");
                String string = expression = expr != null ? expr.getStringExpression() : null;
                if (expression == null) {
                    Iterator it = ch.argumentsIterator();
                    while (it.hasNext()) {
                        AggregationArgumentHandle arg;
                        Object obj = it.next();
                        if (!(obj instanceof AggregationArgumentHandle) || !"expression".equalsIgnoreCase((arg = (AggregationArgumentHandle)obj).getName()) || (expr = arg.getExpressionProperty("value")) == null) continue;
                        expression = arg.getValue();
                        break;
                    }
                }
                if (expression != null) {
                    Pattern p = null;
                    p = "javascript".equalsIgnoreCase(expr.getType()) ? Pattern.compile("dataSetRow\\[\\s*\\\"([^\\]]+)\\\"\\s*\\]") : Pattern.compile("\\[DATASET\\]\\.\\[\\s*([^\\]]+)\\s*\\]");
                    Matcher m = p.matcher(expression);
                    if (m.find()) {
                        return m.group(1);
                    }
                }
            }
        } else {
            refColumnName = mv.getCubeMeasureName();
        }
        return refColumnName;
    }

    public static void setLabelDisplayNameKey(String key) {
        labelDisplayNameKey = key;
    }

    public static void clearLabelDisplayNameKey() {
        labelDisplayNameKey = null;
    }
}

