/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.dnd;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.dnd.DNDLocation;
import org.eclipse.birt.report.designer.internal.ui.dnd.IDropAdapter;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedDataModelUIAdapterHelper;
import org.eclipse.birt.report.designer.internal.ui.extension.IExtendedDataModelUIAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.DataUtil;
import org.eclipse.birt.report.designer.util.IVirtualValidator;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.AggregationCellProviderWrapper;
import org.eclipse.birt.report.item.crosstab.internal.ui.dialogs.LevelViewDialog;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabCellAdapter;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.VirtualCrosstabCellAdapter;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;

public class ExtendedDataColumnXtabDropAdapter
implements IDropAdapter {
    private IExtendedDataModelUIAdapter adapter = ExtendedDataModelUIAdapterHelper.getInstance().getAdapter();

    public int canDrop(Object transfer, Object target, int operation, DNDLocation location) {
        EditPart editPart;
        if (!(transfer instanceof ReportElementHandle) || this.adapter == null || !this.adapter.isExtendedDataItem((ReportElementHandle)transfer)) {
            return 0;
        }
        if (target instanceof EditPart && (editPart = (EditPart)target).getModel() instanceof IVirtualValidator) {
            if (this.handleValidate(editPart, transfer).size() > 0) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public boolean performDrop(Object transfer, Object target, int operation, DNDLocation location) {
        if (target instanceof EditPart) {
            EditPart targetPart = (EditPart)target;
            CrosstabReportItemHandle crosstab = this.getCrosstab(targetPart);
            if (crosstab == null) {
                return false;
            }
            CommandStack cmdStack = crosstab.getModuleHandle().getCommandStack();
            cmdStack.startTrans(Messages.getFormattedString("ExtendedDataColumnXtabDropAdapter.trans.add", new String[]{((ReportElementHandle)transfer).getName()}));
            ReportElementHandle extendedData = this.adapter.getBoundExtendedData((ReportItemHandle)crosstab.getModelHandle());
            if (!(extendedData != null && extendedData.equals(this.adapter.resolveExtendedData((DesignElementHandle)((ReportElementHandle)transfer))) || this.adapter.setExtendedData((ReportItemHandle)crosstab.getModelHandle(), this.adapter.resolveExtendedData((DesignElementHandle)((ReportElementHandle)transfer))))) {
                cmdStack.rollback();
                return false;
            }
            List validElements = this.handleValidate(targetPart, transfer);
            MeasureHandle measure = null;
            Object[] tabularDimension = null;
            Object[] timeDimension = null;
            ResultSetColumnHandle resultSetColumn = this.adapter.getResultSetColumn((ReportElementHandle)transfer);
            DataSetHandle dataSetHandle = (DataSetHandle)resultSetColumn.getElementHandle();
            List columnHints = DataUtil.getColumnHints((DataSetHandle)dataSetHandle);
            ColumnHintHandle chh = null;
            for (ColumnHintHandle columnHintHandle : columnHints) {
                if (!resultSetColumn.getColumnName().equals(columnHintHandle.getAlias()) && !resultSetColumn.getColumnName().equals(columnHintHandle.getColumnName())) continue;
                chh = columnHintHandle;
                break;
            }
            String contentKeyForLabel = null;
            if (chh != null) {
                contentKeyForLabel = chh.getDisplayNameKey();
            }
            for (Object obj : validElements) {
                if (obj instanceof MeasureHandle) {
                    measure = (MeasureHandle)obj;
                    continue;
                }
                if (!(obj instanceof DimensionHandle)) continue;
                Object[] dim = (Object[])obj;
                if (dim.isTimeType()) {
                    timeDimension = dim;
                    continue;
                }
                tabularDimension = dim;
            }
            if (measure != null) {
                CreateRequest request = new CreateRequest();
                request.getExtendedData().put("newObject", measure);
                request.setLocation(location.getPoint());
                Command command = targetPart.getCommand((Request)request);
                if (command != null && command.canExecute()) {
                    CrosstabCellHandle crosstabCellHandle;
                    List contentList;
                    IReportItem model;
                    Object headerCell;
                    targetPart.getViewer().getEditDomain().getCommandStack().execute(command);
                    MeasureViewHandle measureViewHandle = crosstab.getMeasure(measure.getName());
                    PropertyHandle headHandle = measureViewHandle.getHeaderProperty();
                    Object object = headHandle.getValue();
                    if (object instanceof List && !((List)object).isEmpty() && (headerCell = ((List)object).get(0)) instanceof ExtendedItemHandle && (model = CrosstabUtil.getReportItem((DesignElementHandle)((ExtendedItemHandle)headerCell))) instanceof CrosstabCellHandle && !(contentList = (crosstabCellHandle = (CrosstabCellHandle)model).getContents()).isEmpty() && contentList.get(0) instanceof LabelHandle) {
                        LabelHandle labelHandle = (LabelHandle)contentList.get(0);
                        try {
                            labelHandle.setTextKey(contentKeyForLabel);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    AggregationCellProviderWrapper providerWrapper = new AggregationCellProviderWrapper(crosstab);
                    providerWrapper.updateAllAggregationCells(0);
                    if (crosstab.getDimensionCount(1) != 0) {
                        DimensionViewHandle viewHnadle = crosstab.getDimension(1, crosstab.getDimensionCount(1) - 1);
                        CrosstabUtil.addLabelToHeader((LevelViewHandle)viewHnadle.getLevel(viewHnadle.getLevelCount() - 1));
                    }
                    cmdStack.commit();
                    return true;
                }
            } else if (tabularDimension != null || timeDimension != null) {
                Object[] element = null;
                if (timeDimension != null) {
                    LevelViewDialog dialog = new LevelViewDialog(false);
                    dialog.setInput((DimensionHandle)timeDimension, this.adapter.getLevelHints((DimensionHandle)timeDimension));
                    if (dialog.open() != 0) {
                        cmdStack.rollback();
                        return false;
                    }
                    element = ((List)dialog.getResult()).size() > 0 ? ((List)dialog.getResult()).toArray() : tabularDimension;
                } else if (tabularDimension != null) {
                    element = tabularDimension;
                }
                if (element == null) {
                    return false;
                }
                ReportElementHandle reportElementHandle = null;
                if (element instanceof Object[] && ((Object[])element).length != 0) {
                    reportElementHandle = (ReportElementHandle)((Object[])element)[0];
                } else if (element instanceof DimensionHandle) {
                    reportElementHandle = (ReportElementHandle)element;
                }
                try {
                    String displayNameKey = reportElementHandle.getDisplayNameKey();
                    if (displayNameKey == null) {
                        reportElementHandle.setDisplayNameKey(contentKeyForLabel);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                CreateRequest request = new CreateRequest();
                request.getExtendedData().put("newObject", element);
                request.setLocation(location.getPoint());
                Command command = targetPart.getCommand((Request)request);
                if (command != null && command.canExecute()) {
                    targetPart.getViewer().getEditDomain().getCommandStack().execute(command);
                    AggregationCellProviderWrapper providerWrapper = new AggregationCellProviderWrapper(crosstab);
                    providerWrapper.updateAllAggregationCells(0);
                    cmdStack.commit();
                    return true;
                }
            }
        }
        return false;
    }

    private CrosstabReportItemHandle getCrosstab(EditPart editPart) {
        CrosstabReportItemHandle crosstab = null;
        Object tmp = editPart.getModel();
        if (!(tmp instanceof CrosstabCellAdapter)) {
            return null;
        }
        if (tmp instanceof VirtualCrosstabCellAdapter) {
            return ((VirtualCrosstabCellAdapter)tmp).getCrosstabReportItemHandle();
        }
        CrosstabCellHandle handle = ((CrosstabCellAdapter)tmp).getCrosstabCellHandle();
        if (handle != null) {
            crosstab = handle.getCrosstab();
        }
        return crosstab;
    }

    private List handleValidate(EditPart editPart, Object transfer) {
        if (!(transfer instanceof ReportElementHandle)) {
            return null;
        }
        ReportElementHandle[] supportedTypes = this.adapter.getSupportedTypes((ReportElementHandle)transfer, (ReportElementHandle)this.getCrosstab(editPart).getCube());
        ArrayList<ReportElementHandle> list = new ArrayList<ReportElementHandle>();
        ReportElementHandle[] reportElementHandleArray = supportedTypes;
        int n = supportedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ReportElementHandle type = reportElementHandleArray[n2];
            if (((IVirtualValidator)editPart.getModel()).handleValidate((Object)type)) {
                list.add(type);
            }
            ++n2;
        }
        return list;
    }
}

