/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editors.xpath;

import java.util.ResourceBundle;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.contentassist.ExpressionContentAssistProcessor;
import org.eclipse.bpel.ui.editors.TextEditor;
import org.eclipse.bpel.ui.editors.xpath.ColorManager;
import org.eclipse.bpel.ui.editors.xpath.VariablePickerAction;
import org.eclipse.bpel.ui.editors.xpath.XPathCharPairMatcher;
import org.eclipse.bpel.ui.editors.xpath.XPathEditorMessages;
import org.eclipse.bpel.ui.editors.xpath.XPathSourceViewerConfiguration;
import org.eclipse.bpel.ui.editors.xpath.XPathWhitespaceDetector;
import org.eclipse.bpel.ui.preferences.PreferenceConstants;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class XPathTextEditor
extends TextEditor {
    public static final String XPATH_EDITOR_ID = XPathTextEditor.class.getName();
    protected static final char[] BRACKETS = new char[]{'(', ')', '[', ']'};
    protected XPathCharPairMatcher fBracketMatcher = new XPathCharPairMatcher(BRACKETS);
    BracketInserter fBracketInserter = new BracketInserter();
    private final ColorManager fColorManager;
    IWhitespaceDetector fWhitespaceDetector = new XPathWhitespaceDetector();
    VariablePickerAction fVariablePickerAction;
    private ControlDecoration decoration;

    public XPathTextEditor() {
        this.fColorManager = new ColorManager();
        this.setSourceViewerConfiguration(new XPathSourceViewerConfiguration(this.fColorManager));
    }

    @Override
    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = ResourceBundle.getBundle("bpelexpression");
        ContentAssistAction action = new ContentAssistAction(bundle, "ContentAssistProposal.", (ITextEditor)this);
        String id = "org.eclipse.ui.edit.text.contentAssist.proposals";
        action.setActionDefinitionId(id);
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
        this.fVariablePickerAction = new VariablePickerAction(XPathEditorMessages.getBundleForConstructedKeys(), "Editor.VariablePicker.", (ITextEditor)this);
        this.fVariablePickerAction.setActionDefinitionId("org.eclipse.bpel.ui.editors.xpath.VariablePicker");
        this.setAction("VariablePicker", (IAction)this.fVariablePickerAction);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        String expressionContext;
        super.doSetInput(input);
        ExpressionContentAssistProcessor caproc = (ExpressionContentAssistProcessor)this.getSourceViewerConfiguration().getContentAssistant(this.getSourceViewer()).getContentAssistProcessor("__dftl_partition_content_type");
        EObject eObj = (EObject)input.getAdapter(EObject.class);
        if (eObj != null) {
            caproc.setModelObject(eObj);
        }
        if ((expressionContext = (String)input.getAdapter(Integer.class)) != null) {
            caproc.setExpressionContext(expressionContext);
            if (this.fVariablePickerAction != null) {
                this.fVariablePickerAction.setEnabled(expressionContext.indexOf("joinCondition/boolean") < 0);
            }
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        boolean closeBrackets = preferenceStore.getBoolean("closeBrackets");
        boolean closeStrings = preferenceStore.getBoolean("closeString");
        this.fBracketInserter.setCloseBracketsEnabled(closeBrackets);
        this.fBracketInserter.setCloseStringsEnabled(closeStrings);
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).prependVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        IAction variablePicker = this.getAction("VariablePicker");
        menu.add((IContributionItem)new Separator());
        menu.add(variablePicker);
    }

    public void dispose() {
        this.fColorManager.dispose();
        this.fBracketMatcher.dispose();
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).removeVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
        super.dispose();
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.fBracketMatcher);
        support.setMatchingCharacterPainterPreferenceKeys("org.eclipse.bpel.ui.xpath.editor.MatchingBrackets", "org.eclipse.bpel.ui.xpath.editor.MatchingBracketsColor");
        super.configureSourceViewerDecorationSupport(support);
    }

    protected void setPreferenceStore(IPreferenceStore store) {
        if (store != null) {
            PreferenceConstants.initializeDefaultValues(store);
        }
        super.setPreferenceStore(store);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        String p = event.getProperty();
        if ("closeBrackets".equals(p)) {
            this.fBracketInserter.setCloseBracketsEnabled(this.getPreferenceStore().getBoolean(p));
            return;
        }
        if ("closeString".equals(p)) {
            this.fBracketInserter.setCloseStringsEnabled(this.getPreferenceStore().getBoolean(p));
            return;
        }
        super.handlePreferenceStoreChanged(event);
    }

    public void setDecoration(boolean enabled) {
        if (enabled) {
            this.decoration = new ControlDecoration((Control)this.getSourceViewer().getTextWidget(), 16512);
            this.decoration.setMarginWidth(25);
            this.decoration.setDescriptionText("Content Assist Available (Ctrl+Space)");
            this.decoration.setShowOnlyOnFocus(true);
            FieldDecoration dec = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
            this.decoration.setImage(dec.getImage());
        } else {
            this.decoration.dispose();
        }
    }

    static char getEscapeCharacter(char character) {
        switch (character) {
            case '\"': 
            case '\'': {
                return '\\';
            }
        }
        return '\u0000';
    }

    static char getPeerCharacter(char character) {
        switch (character) {
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '[': {
                return ']';
            }
            case '\"': {
                return character;
            }
            case '\'': {
                return character;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        this.getSourceViewer().getTextWidget().addFocusListener(focusListener);
    }

    public class BracketInserter
    implements VerifyKeyListener {
        private boolean fCloseBrackets = true;
        private boolean fCloseStrings = true;

        public void setCloseBracketsEnabled(boolean enabled) {
            this.fCloseBrackets = enabled;
        }

        public void setCloseStringsEnabled(boolean enabled) {
            this.fCloseStrings = enabled;
        }

        private boolean hasIdentifierToTheRight(IDocument document, int offset) {
            try {
                int end = offset;
                IRegion endLine = document.getLineInformationOfOffset(end);
                int maxEnd = endLine.getOffset() + endLine.getLength();
                while (end != maxEnd && XPathTextEditor.this.fWhitespaceDetector.isWhitespace(document.getChar(end))) {
                    ++end;
                }
                return end != maxEnd && Character.isJavaIdentifierPart(document.getChar(end));
            }
            catch (BadLocationException badLocationException) {
                return true;
            }
        }

        private boolean hasIdentifierToTheLeft(IDocument document, int offset) {
            try {
                int start = offset;
                IRegion startLine = document.getLineInformationOfOffset(start);
                int minStart = startLine.getOffset();
                while (start != minStart && XPathTextEditor.this.fWhitespaceDetector.isWhitespace(document.getChar(start - 1))) {
                    --start;
                }
                return start != minStart && Character.isJavaIdentifierPart(document.getChar(start - 1));
            }
            catch (BadLocationException badLocationException) {
                return true;
            }
        }

        private boolean hasCharacterToTheRight(IDocument document, int offset, char character) {
            try {
                int end = offset;
                IRegion endLine = document.getLineInformationOfOffset(end);
                int maxEnd = endLine.getOffset() + endLine.getLength();
                while (end != maxEnd && XPathTextEditor.this.fWhitespaceDetector.isWhitespace(document.getChar(end))) {
                    ++end;
                }
                return end != maxEnd && document.getChar(end) == character;
            }
            catch (BadLocationException badLocationException) {
                return true;
            }
        }

        private boolean hasCharacterAtOffset(IDocument document, int offset, char character) {
            try {
                return document.getChar(offset) == character;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }

        public void verifyKey(VerifyEvent event) {
            if (!event.doit || XPathTextEditor.this.getInsertMode() != SMART_INSERT) {
                return;
            }
            ISourceViewer sourceViewer = XPathTextEditor.this.getSourceViewer();
            IDocument document = sourceViewer.getDocument();
            Point selection = sourceViewer.getSelectedRange();
            int offset = selection.x;
            int length = selection.y;
            switch (event.character) {
                case ']': {
                    if (!this.fCloseBrackets) {
                        return;
                    }
                }
                case ')': {
                    if (!this.hasCharacterAtOffset(document, offset + length, event.character)) break;
                    sourceViewer.setSelectedRange(offset + length + 1, 0);
                    event.doit = false;
                    return;
                }
                case '(': {
                    if (this.hasCharacterToTheRight(document, offset + length, '(')) {
                        return;
                    }
                }
                case '[': {
                    if (!this.fCloseBrackets) {
                        return;
                    }
                    if (this.hasIdentifierToTheRight(document, offset + length)) {
                        return;
                    }
                }
                case '\'': {
                    if (event.character == '\'') {
                        if (!this.fCloseStrings) {
                            return;
                        }
                        if (this.hasCharacterAtOffset(document, offset - 1, '\\')) {
                            return;
                        }
                        if (this.hasCharacterAtOffset(document, offset + length, '\'')) {
                            sourceViewer.setSelectedRange(offset + length + 1, 0);
                            event.doit = false;
                            return;
                        }
                        if (this.hasIdentifierToTheLeft(document, offset) || this.hasIdentifierToTheRight(document, offset + length)) {
                            return;
                        }
                    }
                }
                case '\"': {
                    if (event.character == '\"') {
                        if (!this.fCloseStrings) {
                            return;
                        }
                        if (this.hasCharacterAtOffset(document, offset - 1, '\\')) {
                            return;
                        }
                        if (this.hasCharacterAtOffset(document, offset + length, '\"')) {
                            sourceViewer.setSelectedRange(offset + length + 1, 0);
                            event.doit = false;
                            return;
                        }
                        if (this.hasIdentifierToTheLeft(document, offset) || this.hasIdentifierToTheRight(document, offset + length)) {
                            return;
                        }
                    }
                    try {
                        if (!XPathTextEditor.this.validateEditorInputState()) {
                            return;
                        }
                        StringBuffer buffer = new StringBuffer();
                        buffer.append(event.character);
                        buffer.append(XPathTextEditor.getPeerCharacter(event.character));
                        document.replace(offset, length, buffer.toString());
                        sourceViewer.setSelectedRange(offset + 1, 0);
                        event.doit = false;
                        break;
                    }
                    catch (BadLocationException e) {
                        BPELUIPlugin.log(e);
                    }
                }
            }
        }
    }
}

