/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import org.eclipse.bpmn2.modeler.core.features.IConnectionRouter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public abstract class AbstractConnectionRouter
implements IConnectionRouter {
    protected static final IPeService peService = Graphiti.getPeService();
    protected static final IGaService gaService = Graphiti.getGaService();
    protected IFeatureProvider fp;

    public AbstractConnectionRouter(IFeatureProvider fp) {
        this.fp = fp;
    }

    protected abstract void initialize(Connection var1);

    @Override
    public abstract boolean route(Connection var1);

    @Override
    public abstract void dispose();

    public static String addRoutingInfo(Connection connection, String info) {
        Assert.isTrue((info != null && !info.isEmpty() ? 1 : 0) != 0);
        String newInfo = AbstractConnectionRouter.getRoutingInfo(connection);
        if (!newInfo.isEmpty()) {
            newInfo = String.valueOf(newInfo) + ",";
        }
        newInfo = String.valueOf(newInfo) + info;
        peService.setPropertyValue((PropertyContainer)connection, "routing.info", newInfo);
        return newInfo;
    }

    public static void removeRoutingInfo(Connection connection) {
        AbstractConnectionRouter.removeRoutingInfo(connection, AbstractConnectionRouter.getRoutingInfo(connection));
    }

    public static String removeRoutingInfo(Connection connection, String info) {
        String newInfo = null;
        if (info != null && !info.isEmpty() && (newInfo = AbstractConnectionRouter.getRoutingInfo(connection)) != null && !newInfo.isEmpty()) {
            String[] a = newInfo.split(",");
            String[] b = info.split(",");
            int i = 0;
            while (i < a.length) {
                String[] stringArray = b;
                int n = b.length;
                int n2 = 0;
                while (n2 < n) {
                    String sb = stringArray[n2];
                    if (a[i].startsWith(sb)) {
                        a[i] = null;
                        break;
                    }
                    ++n2;
                }
                ++i;
            }
            newInfo = "";
            i = 0;
            while (i < a.length) {
                if (a[i] != null && !a[i].isEmpty()) {
                    if (!newInfo.isEmpty()) {
                        newInfo = String.valueOf(newInfo) + ",";
                    }
                    newInfo = String.valueOf(newInfo) + a[i];
                }
                ++i;
            }
        }
        if (newInfo == null || newInfo.isEmpty()) {
            peService.removeProperty((PropertyContainer)connection, "routing.info");
        } else {
            peService.setPropertyValue((PropertyContainer)connection, "routing.info", newInfo);
        }
        return newInfo;
    }

    public static String getRoutingInfo(Connection connection) {
        String info = peService.getPropertyValue((PropertyContainer)connection, "routing.info");
        if (info == null || info.isEmpty()) {
            return "";
        }
        return info;
    }

    public static String setRoutingInfoInt(Connection connection, String info, int value) {
        AbstractConnectionRouter.removeRoutingInfo(connection, String.valueOf(info) + "=");
        return AbstractConnectionRouter.addRoutingInfo(connection, String.valueOf(info) + "=" + value);
    }

    public static String setRoutingInfo(Connection connection, String info, String value) {
        AbstractConnectionRouter.removeRoutingInfo(connection, String.valueOf(info) + "=");
        return AbstractConnectionRouter.addRoutingInfo(connection, String.valueOf(info) + "=" + value);
    }

    public static int getRoutingInfoInt(Connection connection, String info) {
        String[] a;
        String oldInfo = AbstractConnectionRouter.getRoutingInfo(connection);
        String[] stringArray = a = oldInfo.split(",");
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith(String.valueOf(info) + "=")) {
                try {
                    String[] b = s.split("=");
                    return Integer.parseInt(b[1]);
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
        return -1;
    }

    public static String getRoutingInfo(Connection connection, String info) {
        String[] a;
        String oldInfo = AbstractConnectionRouter.getRoutingInfo(connection);
        String[] stringArray = a = oldInfo.split(",");
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith(String.valueOf(info) + "=")) {
                try {
                    String[] b = s.split("=");
                    return b[1];
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
        return null;
    }

    public static void setForceRouting(Connection connection, boolean force) {
        if (force) {
            AbstractConnectionRouter.addRoutingInfo(connection, "force");
        } else {
            AbstractConnectionRouter.removeRoutingInfo(connection, "force");
        }
    }

    public static boolean forceRouting(Connection connection) {
        return AbstractConnectionRouter.getRoutingInfo(connection).contains("force");
    }
}

