/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.modeler.core.features.CompoundCreateFeaturePart;
import org.eclipse.bpmn2.modeler.core.features.IBpmn2CreateFeature;
import org.eclipse.bpmn2.modeler.core.runtime.CustomTaskImageProvider;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.runtime.ToolPaletteDescriptor;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.graphiti.IExecutionInfo;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.impl.AbstractCreateFeature;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditor;

public class CompoundCreateFeature<CONTEXT extends IContext>
extends AbstractCreateFeature
implements IBpmn2CreateFeature<BaseElement, CONTEXT>,
ICreateConnectionFeature {
    protected List<CompoundCreateFeaturePart<CONTEXT>> children = new ArrayList<CompoundCreateFeaturePart<CONTEXT>>();
    protected ToolPaletteDescriptor.ToolDescriptor tool;

    public CompoundCreateFeature(IFeatureProvider fp, ToolPaletteDescriptor.ToolDescriptor tool) {
        super(fp, tool.getName(), tool.getDescription());
        this.tool = tool;
    }

    public CompoundCreateFeature(IFeatureProvider fp) {
        super(fp, null, null);
    }

    public CompoundCreateFeaturePart<CONTEXT> addChild(IFeature feature) {
        CompoundCreateFeaturePart node = new CompoundCreateFeaturePart(feature);
        this.children.add(node);
        return node;
    }

    public boolean canExecute(IContext context) {
        boolean ret = false;
        if (context instanceof ICreateContext) {
            ret = this.canCreate((ICreateContext)context);
        } else if (context instanceof ICreateConnectionContext) {
            ret = this.canCreate((ICreateConnectionContext)context);
        }
        return ret;
    }

    public void execute(IContext context) {
        ArrayList pes = new ArrayList();
        context.putProperty((Object)"pictogram.elements", pes);
        if (context instanceof ICreateContext) {
            this.create((ICreateContext)context);
        } else if (context instanceof ICreateConnectionContext) {
            this.create((ICreateConnectionContext)context);
        }
        this.getDiagramEditor().selectPictogramElements(pes.toArray(new PictogramElement[pes.size()]));
    }

    public boolean canCreate(ICreateContext context) {
        for (CompoundCreateFeaturePart<CONTEXT> ft : this.children) {
            if (ft.canCreate((IContext)context)) continue;
            return false;
        }
        return true;
    }

    public boolean canCreate(ICreateConnectionContext context) {
        for (CompoundCreateFeaturePart<CONTEXT> ft : this.children) {
            if (ft.canCreate((IContext)context)) continue;
            return false;
        }
        return true;
    }

    public Object[] create(ICreateContext context) {
        ArrayList<Object> businessObjects = new ArrayList<Object>();
        ArrayList<PictogramElement> pictogramElements = new ArrayList<PictogramElement>();
        ContainerShape targetContainer = context.getTargetContainer();
        if (targetContainer == null) {
            targetContainer = this.getDiagram();
        }
        PictogramElement[] selection = this.getDiagramBehavior().getDiagramContainer().getSelectedPictogramElements();
        int index = 0;
        for (CompoundCreateFeaturePart<CONTEXT> fp : this.children) {
            String optional = fp.getProperty("ToolPartOptional");
            if ("true".equals(optional) && index < selection.length) {
                PictogramElement pe;
                boolean replace = true;
                if ((pe = selection[index++]) instanceof Diagram) {
                    replace = false;
                } else if (fp.feature instanceof ICreateFeature) {
                    if (!(pe instanceof ContainerShape)) {
                        replace = false;
                    }
                } else if (fp.feature instanceof ICreateConnectionFeature && !(pe instanceof Connection)) {
                    replace = false;
                }
                if (replace) {
                    BaseElement bo = BusinessObjectUtil.getFirstBaseElement(pe);
                    pictogramElements.add(pe);
                    businessObjects.add(bo);
                    String id = fp.getProperty("ToolPartID");
                    if (id == null) continue;
                    Graphiti.getPeService().setPropertyValue((PropertyContainer)pe, "ToolPartID", id);
                    continue;
                }
            }
            fp.create((IContext)context, targetContainer, pictogramElements, businessObjects);
        }
        return businessObjects.toArray();
    }

    public Connection create(ICreateConnectionContext context) {
        Object o;
        ArrayList<Object> businessObjects = new ArrayList<Object>();
        ArrayList<PictogramElement> pictogramElements = new ArrayList<PictogramElement>();
        Diagram targetContainer = this.getDiagram();
        for (CompoundCreateFeaturePart<CONTEXT> ft : this.children) {
            ft.create((IContext)context, (ContainerShape)targetContainer, pictogramElements, businessObjects);
        }
        if (businessObjects.size() > 0 && (o = businessObjects.get(0)) instanceof Connection) {
            return (Connection)o;
        }
        return null;
    }

    public String getCreateImageId() {
        String icon = this.tool.getIcon();
        if (icon != null) {
            TargetRuntime rt = this.tool.getParent().getParent().getRuntime();
            return CustomTaskImageProvider.getImageId(rt, icon, CustomTaskImageProvider.IconSize.SMALL);
        }
        IFeature feature = this.getChildren().get(0).getFeature();
        if (feature instanceof ICreateFeature) {
            return ((ICreateFeature)feature).getCreateImageId();
        }
        if (feature instanceof ICreateConnectionFeature) {
            return ((ICreateConnectionFeature)feature).getCreateImageId();
        }
        return null;
    }

    public String getCreateLargeImageId() {
        String icon = this.tool.getIcon();
        if (icon != null) {
            TargetRuntime rt = this.tool.getParent().getParent().getRuntime();
            return CustomTaskImageProvider.getImageId(rt, icon, CustomTaskImageProvider.IconSize.LARGE);
        }
        IFeature feature = this.getChildren().get(0).getFeature();
        if (feature instanceof ICreateFeature) {
            return ((ICreateFeature)feature).getCreateLargeImageId();
        }
        if (feature instanceof ICreateConnectionFeature) {
            return ((ICreateConnectionFeature)feature).getCreateLargeImageId();
        }
        return null;
    }

    public boolean isAvailable(IContext context) {
        for (CompoundCreateFeaturePart<CONTEXT> ft : this.children) {
            if (ft.isAvailable(context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public BaseElement createBusinessObject(CONTEXT context) {
        for (CompoundCreateFeaturePart<CONTEXT> ft : this.children) {
            IBpmn2CreateFeature f;
            BaseElement be;
            if (!(ft.getFeature() instanceof IBpmn2CreateFeature) || (be = (BaseElement)(f = (IBpmn2CreateFeature)ft.getFeature()).createBusinessObject(context)) == null) continue;
            return be;
        }
        return null;
    }

    @Override
    public BaseElement getBusinessObject(CONTEXT context) {
        for (CompoundCreateFeaturePart<CONTEXT> ft : this.children) {
            IBpmn2CreateFeature f;
            BaseElement be;
            if (!(ft.getFeature() instanceof IBpmn2CreateFeature) || (be = (BaseElement)(f = (IBpmn2CreateFeature)ft.getFeature()).getBusinessObject(context)) == null) continue;
            return be;
        }
        return null;
    }

    @Override
    public void putBusinessObject(CONTEXT context, BaseElement businessObject) {
        for (CompoundCreateFeaturePart<CONTEXT> ft : this.children) {
            if (!(ft.getFeature() instanceof IBpmn2CreateFeature)) continue;
            IBpmn2CreateFeature f = (IBpmn2CreateFeature)ft.getFeature();
            f.putBusinessObject(context, businessObject);
        }
    }

    @Override
    public EClass getBusinessObjectClass() {
        if (this.children.size() == 1) {
            return this.children.get(0).getBusinessObjectClass();
        }
        return null;
    }

    @Override
    public void postExecute(IExecutionInfo executionInfo) {
        for (CompoundCreateFeaturePart<CONTEXT> ft : this.children) {
            if (!(ft.getFeature() instanceof IBpmn2CreateFeature)) continue;
            IBpmn2CreateFeature f = (IBpmn2CreateFeature)ft.getFeature();
            f.postExecute(executionInfo);
        }
    }

    public List<CompoundCreateFeaturePart<CONTEXT>> getChildren() {
        return this.children;
    }

    public boolean canStartConnection(ICreateConnectionContext context) {
        for (CompoundCreateFeaturePart<CONTEXT> ft : this.children) {
            ICreateConnectionFeature f;
            if (!(ft.getFeature() instanceof ICreateConnectionFeature) || (f = (ICreateConnectionFeature)ft.getFeature()).canStartConnection(context)) continue;
            return false;
        }
        return true;
    }

    public void startConnecting() {
        for (CompoundCreateFeaturePart<CONTEXT> ft : this.children) {
            if (!(ft.getFeature() instanceof ICreateConnectionFeature)) continue;
            ICreateConnectionFeature f = (ICreateConnectionFeature)ft.getFeature();
            f.startConnecting();
        }
    }

    public void endConnecting() {
        for (CompoundCreateFeaturePart<CONTEXT> ft : this.children) {
            if (!(ft.getFeature() instanceof ICreateConnectionFeature)) continue;
            ICreateConnectionFeature f = (ICreateConnectionFeature)ft.getFeature();
            f.endConnecting();
        }
    }

    public void attachedToSource(ICreateConnectionContext context) {
        for (CompoundCreateFeaturePart<CONTEXT> ft : this.children) {
            if (!(ft.getFeature() instanceof ICreateConnectionFeature)) continue;
            ICreateConnectionFeature f = (ICreateConnectionFeature)ft.getFeature();
            f.attachedToSource(context);
        }
    }

    public void canceledAttaching(ICreateConnectionContext context) {
        for (CompoundCreateFeaturePart<CONTEXT> ft : this.children) {
            if (!(ft.getFeature() instanceof ICreateConnectionFeature)) continue;
            ICreateConnectionFeature f = (ICreateConnectionFeature)ft.getFeature();
            f.canceledAttaching(context);
        }
    }

    @Override
    public EClass getFeatureClass() {
        return null;
    }

    protected DiagramEditor getDiagramEditor() {
        return (DiagramEditor)this.getFeatureProvider().getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer();
    }
}

