/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import java.util.List;
import org.eclipse.bpmn2.Bpmn2Factory;
import org.eclipse.bpmn2.Documentation;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2CustomFeature;
import org.eclipse.bpmn2.modeler.core.features.Messages;
import org.eclipse.bpmn2.modeler.core.preferences.ModelEnablements;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ShowDocumentationFeature
extends AbstractBpmn2CustomFeature {
    protected boolean changesDone = false;
    ICustomContext context;

    public ShowDocumentationFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getName() {
        return Messages.ShowDocumentationFeature_Documentation_Title;
    }

    public String getDescription() {
        String text;
        EStructuralFeature feature;
        PictogramElement[] pes;
        EObject businessObject;
        List docList;
        if (this.context != null && (docList = (List)(businessObject = BusinessObjectUtil.getBusinessObjectForPictogramElement((pes = this.context.getPictogramElements())[0])).eGet(feature = businessObject.eClass().getEStructuralFeature("documentation"))).size() > 0 && (text = ((Documentation)docList.get(0)).getText()) != null) {
            return text;
        }
        return "";
    }

    public boolean canExecute(ICustomContext context) {
        ModelEnablements me;
        EStructuralFeature feature;
        PictogramElement[] pes = context.getPictogramElements();
        EObject businessObject = BusinessObjectUtil.getBusinessObjectForPictogramElement(pes[0]);
        if (businessObject != null && pes.length == 1 && (feature = businessObject.eClass().getEStructuralFeature("documentation")) != null && (me = this.getModelEnablements()) != null && me.isEnabled(businessObject.eClass().getName(), feature.getName())) {
            this.context = context;
            return true;
        }
        this.context = null;
        return false;
    }

    public boolean isAvailable(IContext context) {
        return true;
    }

    public void execute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        EObject businessObject = BusinessObjectUtil.getBusinessObjectForPictogramElement(pes[0]);
        EStructuralFeature feature = businessObject.eClass().getEStructuralFeature("documentation");
        List docList = (List)businessObject.eGet(feature);
        Documentation documentation = null;
        String text = "";
        if (docList.size() > 0) {
            documentation = (Documentation)docList.get(0);
            text = documentation.getText();
        }
        DocumentationDialog dialog = new DocumentationDialog(Display.getDefault().getActiveShell());
        dialog.setValue(text);
        if (dialog.open() == 0) {
            text = dialog.getValue();
            if (documentation == null) {
                if (text.isEmpty()) {
                    return;
                }
                documentation = Bpmn2Factory.eINSTANCE.createDocumentation();
                docList.add(documentation);
            }
            documentation.setText(text);
        }
    }

    public boolean hasDoneChanges() {
        return this.changesDone;
    }

    public String getImageId() {
        return "org.eclipse.bpmn2.modeler.icons.info.16";
    }

    protected ModelEnablements getModelEnablements() {
        DiagramEditor editor = this.getDiagramEditor();
        return (ModelEnablements)editor.getAdapter(ModelEnablements.class);
    }

    public class DocumentationDialog
    extends Dialog {
        String value;
        StyledText text;
        Font descriptionFont;
        Display display;

        protected DocumentationDialog(Shell parentShell) {
            super(parentShell);
            this.display = Display.getDefault();
        }

        public Font getDescriptionFont() {
            if (this.descriptionFont == null) {
                FontData data = this.display.getSystemFont().getFontData()[0];
                this.descriptionFont = new Font((Device)this.display, data.getName(), data.getHeight() + 1, 0);
            }
            return this.descriptionFont;
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            container.setLayout((Layout)new GridLayout(2, true));
            this.text = new StyledText(container, 2626);
            this.text.setText(this.value);
            this.text.setFont(this.getDescriptionFont());
            GridData d = new GridData(4, 4, true, true, 2, 1);
            d.horizontalIndent = 0;
            d.verticalIndent = 0;
            d.heightHint = (int)(5.5 * (double)this.getDescriptionFont().getFontData()[0].getHeight());
            d.widthHint = 100;
            this.text.setLayoutData((Object)d);
            return container;
        }

        protected void okPressed() {
            this.value = this.text.getText();
            super.okPressed();
        }

        protected void configureShell(Shell newShell) {
            newShell.setText(Messages.ShowDocumentationFeature_Documentation_Title);
            super.configureShell(newShell);
        }

        protected int getShellStyle() {
            return super.getShellStyle();
        }

        protected Point getInitialSize() {
            return new Point(450, 300);
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

