/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.preferences;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.di.BPMNLabelStyle;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.InsertionAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.ObjectPropertyProvider;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.model.ModelDecorator;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.preferences.Messages;
import org.eclipse.bpmn2.modeler.core.runtime.BaseRuntimeExtensionDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.ModelExtensionDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.dd.dc.DcFactory;
import org.eclipse.dd.dc.Font;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.graphiti.mm.algorithms.styles.StylesFactory;
import org.eclipse.graphiti.mm.algorithms.styles.StylesPackage;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.ColorUtil;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class ShapeStyle
extends BaseRuntimeExtensionDescriptor {
    public static final String EXTENSION_NAME = "style";
    public static IColorConstant DEFAULT_COLOR = new ColorConstant(212, 231, 248);
    public static String DEFAULT_FONT_STRING = "arial,9,-,-";
    public static final int SS_SHAPE_BACKGROUND = 1;
    public static final int SS_SHAPE_FOREGROUND = 2;
    public static final int SS_SHAPE_PRIMARY_SELECTION = 4;
    public static final int SS_SHAPE_SECONDARY_SELECTION = 8;
    public static final int SS_LABEL_FONT = 16;
    public static final int SS_LABEL_FOREGROUND = 32;
    public static final int SS_LABEL_BACKGROUND = 64;
    public static final int SS_LABEL_POSITION = 2048;
    public static final int SS_ROUTING_STYLE = 128;
    public static final int SS_USE_DEFAULT_SIZE = 256;
    public static final int SS_DEFAULT_WIDTH = 512;
    public static final int SS_DEFAULT_HEIGHT = 1024;
    public static final int SS_ALL = -1;
    public static final String STYLE_OBJECT = "style";
    public static final String STYLE_ECLASS = "ShapeStyle";
    public static final String STYLE_SHAPE_FOREGROUND = "shapeForeground";
    public static final String STYLE_SHAPE_BACKGROUND = "shapeBackground";
    public static final String STYLE_LABEL_FONT = "labelFont";
    public static final String STYLE_LABEL_FOREGROUND = "labelForeground";
    public static final String STYLE_LABEL_BACKGROUND = "labelBackground";
    public static final String STYLE_LABEL_POSITION = "labelPosition";
    public static final String STYLE_ROUTING_STYLE = "routingStyle";
    public static final String STYLE_USE_DEFAULT_SIZE = "useDefaultSize";
    public static final String STYLE_DEFAULT_WIDTH = "defaultWidth";
    public static final String STYLE_DEFAULT_HEIGHT = "defaultHeight";
    private static final String DEFAULT_BACKGROUND = "FFFFFF";
    private static final String DEFAULT_FOREGROUND = "000000";
    String object;
    IColorConstant shapeBackground;
    IColorConstant shapePrimarySelectedColor;
    IColorConstant shapeSecondarySelectedColor;
    IColorConstant shapeForeground;
    org.eclipse.graphiti.mm.algorithms.styles.Font labelFont;
    IColorConstant labelForeground;
    IColorConstant labelBackground;
    RoutingStyle routingStyle = RoutingStyle.MANHATTAN;
    boolean useDefaultSize;
    int defaultWidth = 110;
    int defaultHeight = 50;
    LabelPosition labelPosition = LabelPosition.SOUTH;
    int changeMask;

    public ShapeStyle() {
        this.setDefaultColors(DEFAULT_COLOR);
        this.labelFont = ShapeStyle.stringToFont(DEFAULT_FONT_STRING);
    }

    public ShapeStyle(IConfigurationElement e) {
        super(e);
        this.object = e.getAttribute("object");
        String shapeForeground = e.getAttribute(STYLE_SHAPE_FOREGROUND);
        String shapeBackground = e.getAttribute(STYLE_SHAPE_BACKGROUND);
        String labelFont = e.getAttribute(STYLE_LABEL_FONT);
        String labelForeground = e.getAttribute(STYLE_LABEL_FOREGROUND);
        String labelBackground = e.getAttribute(STYLE_LABEL_BACKGROUND);
        String labelPosition = e.getAttribute(STYLE_LABEL_POSITION);
        String routingStyle = e.getAttribute(STYLE_ROUTING_STYLE);
        String useDefaultSize = e.getAttribute(STYLE_USE_DEFAULT_SIZE);
        String defaultHeight = e.getAttribute(STYLE_DEFAULT_HEIGHT);
        String defaultWidth = e.getAttribute(STYLE_DEFAULT_WIDTH);
        if (shapeBackground == null || shapeBackground.isEmpty()) {
            shapeBackground = DEFAULT_BACKGROUND;
        }
        this.shapeBackground = ShapeStyle.stringToColor(shapeBackground);
        this.setDefaultColors(this.shapeBackground);
        if (shapeForeground != null && !shapeForeground.isEmpty()) {
            this.shapeForeground = ShapeStyle.stringToColor(shapeForeground);
        }
        if (labelFont == null || labelFont.isEmpty()) {
            labelFont = DEFAULT_FONT_STRING;
        }
        this.labelFont = ShapeStyle.stringToFont(labelFont);
        if (labelForeground != null && !labelForeground.isEmpty()) {
            this.labelForeground = ShapeStyle.stringToColor(labelForeground);
        }
        if (labelBackground != null && !labelBackground.isEmpty()) {
            this.labelBackground = ShapeStyle.stringToColor(labelBackground);
        }
        this.labelPosition = labelPosition != null && !labelPosition.isEmpty() ? LabelPosition.valueOf(labelPosition) : LabelPosition.SOUTH;
        this.routingStyle = routingStyle != null && !routingStyle.isEmpty() ? RoutingStyle.valueOf(labelPosition) : RoutingStyle.MANHATTAN;
        this.useDefaultSize = Boolean.parseBoolean(useDefaultSize);
        try {
            this.defaultHeight = Integer.parseInt(defaultHeight);
        }
        catch (Exception exception) {}
        try {
            this.defaultWidth = Integer.parseInt(defaultWidth);
        }
        catch (Exception exception) {}
    }

    public ShapeStyle(ShapeStyle other) {
        this(ShapeStyle.encode(other));
        this.object = other.object;
        this.targetRuntime = other.targetRuntime;
    }

    private ShapeStyle(String s) {
        String[] a = s.trim().split(";");
        if (a.length > 0) {
            this.shapeBackground = ShapeStyle.stringToColor(a[0]);
        }
        if (a.length > 1) {
            this.shapePrimarySelectedColor = ShapeStyle.stringToColor(a[1]);
        }
        if (a.length > 2) {
            this.shapeSecondarySelectedColor = ShapeStyle.stringToColor(a[2]);
        }
        if (a.length > 3) {
            this.shapeForeground = ShapeStyle.stringToColor(a[3]);
        }
        if (a.length > 4) {
            this.labelFont = ShapeStyle.stringToFont(a[4]);
        }
        if (a.length > 5) {
            this.labelForeground = ShapeStyle.stringToColor(a[5]);
        }
        if (a.length > 6) {
            this.labelBackground = ShapeStyle.stringToColor(a[6]);
        }
        if (a.length > 7) {
            try {
                this.routingStyle = RoutingStyle.values()[Integer.parseInt(a[7])];
            }
            catch (Exception exception) {
                this.routingStyle = RoutingStyle.MANUAL;
            }
        } else {
            this.routingStyle = RoutingStyle.MANUAL;
        }
        this.useDefaultSize = a.length > 8 ? ShapeStyle.stringToBoolean(a[8]) : false;
        this.defaultWidth = a.length > 9 ? Integer.parseInt(a[9]) : 110;
        this.defaultHeight = a.length > 10 ? Integer.parseInt(a[10]) : 50;
        this.labelPosition = a.length > 11 ? LabelPosition.values()[Integer.parseInt(a[11])] : LabelPosition.SOUTH;
    }

    @Override
    public void setConfigFile(IFile configFile) {
        super.setConfigFile(configFile);
        if (configFile != null) {
            Bpmn2Preferences prefs = Bpmn2Preferences.getInstance(configFile.getProject());
            prefs.setShapeStyle(this.getObject(), this);
        }
    }

    @Override
    public void dispose() {
        if (this.configFile != null) {
            Bpmn2Preferences prefs = Bpmn2Preferences.getInstance(this.configFile.getProject());
            prefs.setShapeStyle(this.getObject(), null);
        }
        super.dispose();
    }

    @Override
    public String getExtensionName() {
        return "style";
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public void setDefaultColors(IColorConstant defaultColor) {
        this.setShapeBackground(defaultColor);
        this.setShapePrimarySelectedColor(StyleUtil.shiftColor(defaultColor, 32));
        this.setShapeSecondarySelectedColor(StyleUtil.shiftColor(defaultColor, -32));
        this.setShapeForeground(StyleUtil.shiftColor(defaultColor, -128));
        this.setLabelForeground(StyleUtil.shiftColor(defaultColor, -128));
        this.setLabelBackground(ShapeStyle.stringToColor(DEFAULT_BACKGROUND));
    }

    public boolean isDirty() {
        return this.changeMask != 0;
    }

    public void setDirty(boolean dirty) {
        this.changeMask = -1;
    }

    public IColorConstant getShapeBackground() {
        return this.shapeBackground;
    }

    public void setShapeBackground(IColorConstant shapeDefaultColor) {
        if (!ShapeStyle.equals(this.shapeBackground, shapeDefaultColor)) {
            this.shapeBackground = shapeDefaultColor;
            this.changeMask |= 1;
        }
    }

    public IColorConstant getShapePrimarySelectedColor() {
        return this.shapePrimarySelectedColor;
    }

    public void setShapePrimarySelectedColor(IColorConstant shapePrimarySelectedColor) {
        if (!ShapeStyle.equals(this.shapePrimarySelectedColor, shapePrimarySelectedColor)) {
            this.shapePrimarySelectedColor = shapePrimarySelectedColor;
            this.changeMask |= 4;
        }
    }

    public IColorConstant getShapeSecondarySelectedColor() {
        return this.shapeSecondarySelectedColor;
    }

    public void setShapeSecondarySelectedColor(IColorConstant shapeSecondarySelectedColor) {
        if (!ShapeStyle.equals(this.shapeSecondarySelectedColor, shapeSecondarySelectedColor)) {
            this.shapeSecondarySelectedColor = shapeSecondarySelectedColor;
            this.changeMask |= 8;
        }
    }

    public IColorConstant getShapeForeground() {
        return this.shapeForeground;
    }

    public void setShapeForeground(IColorConstant shapeBorderColor) {
        if (!ShapeStyle.equals(this.shapeForeground, shapeBorderColor)) {
            this.shapeForeground = shapeBorderColor;
            this.changeMask |= 2;
        }
    }

    public org.eclipse.graphiti.mm.algorithms.styles.Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(org.eclipse.graphiti.mm.algorithms.styles.Font labelFont) {
        if (!ShapeStyle.equals(this.labelFont, labelFont)) {
            this.labelFont = labelFont;
            this.changeMask |= 0x10;
        }
    }

    public IColorConstant getLabelForeground() {
        return this.labelForeground;
    }

    public void setLabelForeground(IColorConstant labelForeground) {
        if (!ShapeStyle.equals(this.labelForeground, labelForeground)) {
            this.labelForeground = labelForeground;
            this.changeMask |= 0x20;
        }
    }

    public IColorConstant getLabelBackground() {
        if (this.labelBackground == null) {
            return ShapeStyle.stringToColor(DEFAULT_BACKGROUND);
        }
        return this.labelBackground;
    }

    public void setLabelBackground(IColorConstant labelBackground) {
        if (!ShapeStyle.equals(this.labelBackground, labelBackground)) {
            this.labelBackground = labelBackground;
            this.changeMask |= 0x40;
        }
    }

    public RoutingStyle getRoutingStyle() {
        return this.routingStyle;
    }

    public void setRoutingStyle(RoutingStyle routingStyle) {
        if (this.routingStyle != routingStyle) {
            this.routingStyle = routingStyle;
            this.changeMask |= 0x80;
        }
    }

    public int getDefaultWidth() {
        if (this.defaultWidth <= 0) {
            if (this.object.toLowerCase().contains("gateway")) {
                return 50;
            }
            if (this.object.toLowerCase().contains("event")) {
                return 36;
            }
            if (this.object.toLowerCase().contains("choreography")) {
                return 150;
            }
            if (this.object.toLowerCase().contains("data")) {
                return 36;
            }
            return 110;
        }
        return this.defaultWidth;
    }

    public void setDefaultWidth(int defaultWidth) {
        if (this.defaultWidth != defaultWidth) {
            this.defaultWidth = defaultWidth;
            this.changeMask |= 0x200;
        }
    }

    public int getDefaultHeight() {
        if (this.defaultHeight <= 0) {
            if (this.object.toLowerCase().contains("gateway")) {
                return 50;
            }
            if (this.object.toLowerCase().contains("event")) {
                return 36;
            }
            if (this.object.toLowerCase().contains("choreography")) {
                return 150;
            }
            if (this.object.toLowerCase().contains("data")) {
                return 50;
            }
            return 50;
        }
        return this.defaultHeight;
    }

    public void setDefaultHeight(int defaultHeight) {
        if (this.defaultHeight != defaultHeight) {
            this.defaultHeight = defaultHeight;
            this.changeMask |= 0x400;
        }
    }

    public LabelPosition getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(LabelPosition labelPosition) {
        if (this.labelPosition != labelPosition) {
            this.labelPosition = labelPosition;
            this.changeMask |= 0x800;
        }
    }

    public boolean getUseDefaultSize() {
        return this.useDefaultSize;
    }

    public void setUseDefaultSize(boolean b) {
        if (this.useDefaultSize != b) {
            this.useDefaultSize = b;
            this.changeMask |= 0x100;
        }
    }

    public boolean getSnapToGrid() {
        return this.getUseDefaultSize();
    }

    public void setSnapToGrid(boolean value) {
        this.setUseDefaultSize(value);
    }

    public static String colorToString(IColorConstant c) {
        return new String(String.valueOf(String.format("%02X", c.getRed())) + String.format("%02X", c.getGreen()) + String.format("%02X", c.getBlue()));
    }

    public static IColorConstant stringToColor(String s) {
        if (s.contains(",")) {
            String[] a = s.split(",");
            int r = Integer.parseInt(a[0]);
            int g = Integer.parseInt(a[1]);
            int b = Integer.parseInt(a[2]);
            return new ColorConstant(r, g, b);
        }
        if (s.length() < 6) {
            return new ColorConstant(0, 0, 0);
        }
        return new ColorConstant(ColorUtil.getRedFromHex((String)s), ColorUtil.getGreenFromHex((String)s), ColorUtil.getBlueFromHex((String)s));
    }

    public static String booleanToString(boolean b) {
        return b ? "1" : "0";
    }

    public static boolean stringToBoolean(String s) {
        return "1".equals(s);
    }

    public static RGB colorToRGB(IColorConstant c) {
        return new RGB(c.getRed(), c.getGreen(), c.getBlue());
    }

    public static IColorConstant RGBToColor(RGB rgb) {
        return new ColorConstant(rgb.red, rgb.green, rgb.blue);
    }

    public static String fontToString(org.eclipse.graphiti.mm.algorithms.styles.Font f) {
        if (f != null) {
            return new String(String.valueOf(f.getName()) + "," + f.getSize() + "," + (f.isItalic() ? "I" : "-") + "," + (f.isBold() ? "B" : "-"));
        }
        return "";
    }

    public static org.eclipse.graphiti.mm.algorithms.styles.Font stringToFont(String s) {
        String[] a = s.split(",");
        org.eclipse.graphiti.mm.algorithms.styles.Font f = StylesFactory.eINSTANCE.createFont();
        f.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getFont_Name(), (Object)a[0]);
        f.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getFont_Size(), (Object)Integer.valueOf(a[1]));
        f.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getFont_Italic(), (Object)a[2].equals("I"));
        f.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getFont_Bold(), (Object)a[3].equals("B"));
        return f;
    }

    public static FontData fontToFontData(org.eclipse.graphiti.mm.algorithms.styles.Font f) {
        int style = 0;
        if (f.isItalic()) {
            style |= 2;
        }
        if (f.isBold()) {
            style |= 1;
        }
        return new FontData(f.getName(), f.getSize(), style);
    }

    public static org.eclipse.graphiti.mm.algorithms.styles.Font fontDataToFont(FontData fd) {
        org.eclipse.graphiti.mm.algorithms.styles.Font f = StylesFactory.eINSTANCE.createFont();
        f.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getFont_Name(), (Object)fd.getName());
        f.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getFont_Size(), (Object)fd.getHeight());
        f.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getFont_Italic(), (Object)((fd.getStyle() & 2) != 0 ? 1 : 0));
        f.eSet((EStructuralFeature)StylesPackage.eINSTANCE.getFont_Bold(), (Object)((fd.getStyle() & 1) != 0 ? 1 : 0));
        return f;
    }

    public static org.eclipse.graphiti.mm.algorithms.styles.Font toGraphitiFont(Diagram diagram, FontData fontData) {
        if (fontData == null) {
            return null;
        }
        org.eclipse.graphiti.mm.algorithms.styles.Font ret = null;
        try {
            String name = fontData.getName();
            int height = fontData.getHeight();
            boolean italic = (fontData.getStyle() & 2) != 0;
            boolean bold = (fontData.getStyle() & 1) != 0;
            ret = Graphiti.getGaService().manageFont(diagram, name, height, italic, bold);
        }
        catch (Exception exception) {}
        return ret;
    }

    public static org.eclipse.graphiti.mm.algorithms.styles.Font toGraphitiFont(Diagram diagram, Font bpmnFont) {
        if (bpmnFont == null) {
            return null;
        }
        org.eclipse.graphiti.mm.algorithms.styles.Font ret = null;
        try {
            String name = bpmnFont.getName();
            int height = Math.round(bpmnFont.getSize());
            boolean italic = bpmnFont.isIsItalic();
            boolean bold = bpmnFont.isIsBold();
            ret = Graphiti.getGaService().manageFont(diagram, name, height, italic, bold);
        }
        catch (Exception exception) {}
        return ret;
    }

    public static Font toBPMNFont(org.eclipse.graphiti.mm.algorithms.styles.Font font) {
        Font bpmnFont = DcFactory.eINSTANCE.createFont();
        bpmnFont.setName(font.getName());
        bpmnFont.setSize((float)font.getSize());
        bpmnFont.setIsBold(font.isBold());
        bpmnFont.setIsItalic(font.isItalic());
        return bpmnFont;
    }

    public static FontData toFontData(org.eclipse.graphiti.mm.algorithms.styles.Font pictogramFont) {
        FontData fontData;
        if (pictogramFont != null) {
            int style = 0;
            if (pictogramFont.isItalic()) {
                style |= 2;
            }
            if (pictogramFont.isBold()) {
                style |= 1;
            }
            int size = pictogramFont.getSize();
            String name = pictogramFont.getName();
            fontData = new FontData(name, size, style);
        } else {
            fontData = new FontData();
        }
        return fontData;
    }

    public static String encode(ShapeStyle sp) {
        if (sp == null) {
            return ShapeStyle.encode(new ShapeStyle());
        }
        return new String(String.valueOf(ShapeStyle.colorToString(sp.shapeBackground)) + ";" + ShapeStyle.colorToString(sp.shapePrimarySelectedColor) + ";" + ShapeStyle.colorToString(sp.shapeSecondarySelectedColor) + ";" + ShapeStyle.colorToString(sp.shapeForeground) + ";" + ShapeStyle.fontToString(sp.labelFont) + ";" + ShapeStyle.colorToString(sp.labelForeground) + ";" + ShapeStyle.booleanToString(sp.useDefaultSize) + ";" + sp.routingStyle.ordinal() + ";" + ShapeStyle.booleanToString(sp.useDefaultSize) + ";" + sp.defaultWidth + ";" + sp.defaultHeight + ";" + sp.labelPosition.ordinal());
    }

    public static ShapeStyle decode(String s) {
        if (s == null || s.trim().split(";").length < 11) {
            return new ShapeStyle();
        }
        return new ShapeStyle(s);
    }

    public void applyChanges(ShapeStyle other) {
        int m = other.changeMask;
        if ((m & 1) != 0) {
            this.setShapeBackground(other.getShapeBackground());
        }
        if ((m & 2) != 0) {
            this.setShapeForeground(other.getShapeForeground());
        }
        if ((m & 4) != 0) {
            this.setShapePrimarySelectedColor(other.getShapePrimarySelectedColor());
        }
        if ((m & 8) != 0) {
            this.setShapeSecondarySelectedColor(other.getShapeSecondarySelectedColor());
        }
        if ((m & 0x10) != 0) {
            this.setLabelFont(other.getLabelFont());
        }
        if ((m & 0x20) != 0) {
            this.setLabelForeground(other.getLabelForeground());
        }
        if ((m & 0x80) != 0) {
            this.setRoutingStyle(other.getRoutingStyle());
        }
        if ((m & 0x100) != 0) {
            this.setSnapToGrid(other.getSnapToGrid());
        }
        if ((m & 0x200) != 0) {
            this.setDefaultWidth(other.getDefaultWidth());
        }
        if ((m & 0x400) != 0) {
            this.setDefaultHeight(other.getDefaultHeight());
        }
        if ((m & 0x800) != 0) {
            this.setLabelPosition(other.getLabelPosition());
        }
    }

    public void setValue(int m, Object value) {
        if (m == 1) {
            this.setShapeBackground((IColorConstant)value);
        }
        if (m == 2) {
            this.setShapeForeground((IColorConstant)value);
        }
        if (m == 4) {
            this.setShapePrimarySelectedColor((IColorConstant)value);
        }
        if (m == 8) {
            this.setShapeSecondarySelectedColor((IColorConstant)value);
        }
        if (m == 16) {
            this.setLabelFont((org.eclipse.graphiti.mm.algorithms.styles.Font)value);
        }
        if (m == 32) {
            this.setLabelForeground((IColorConstant)value);
        }
        if (m == 128) {
            this.setRoutingStyle((RoutingStyle)((Object)value));
        }
        if (m == 256) {
            this.setSnapToGrid((Boolean)value);
        }
        if (m == 512) {
            this.setDefaultWidth((Integer)value);
        }
        if (m == 1024) {
            this.setDefaultHeight((Integer)value);
        }
        if (m == 2048) {
            this.setLabelPosition((LabelPosition)((Object)value));
        }
    }

    private static boolean equals(IColorConstant c1, IColorConstant c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.getRed() == c2.getRed() && c1.getGreen() == c2.getGreen() && c1.getBlue() == c2.getBlue();
    }

    private static boolean equals(org.eclipse.graphiti.mm.algorithms.styles.Font f1, org.eclipse.graphiti.mm.algorithms.styles.Font f2) {
        String s1 = ShapeStyle.fontToString(f1);
        String s2 = ShapeStyle.fontToString(f2);
        return s1.equals(s2);
    }

    public static IColorConstant lighter(IColorConstant c) {
        int r = c.getRed() + 8;
        int g = c.getGreen() + 8;
        int b = c.getBlue() + 8;
        if (r > 255) {
            r = 255;
        }
        if (g > 255) {
            g = 255;
        }
        if (b > 255) {
            b = 255;
        }
        return new ColorConstant(r, g, b);
    }

    public static IColorConstant darker(IColorConstant c) {
        int r = c.getRed() - 8;
        int g = c.getGreen() - 8;
        int b = c.getBlue() - 8;
        if (r < 0) {
            r = 0;
        }
        if (g < 0) {
            g = 0;
        }
        if (b < 0) {
            b = 0;
        }
        return new ColorConstant(r, g, b);
    }

    public String toString() {
        return ShapeStyle.encode(this);
    }

    public static boolean hasStyle(BaseElement businessObject) {
        ModelDecorator md;
        EStructuralFeature styleFeature;
        ModelExtensionDescriptor med = TargetRuntime.getDefaultRuntime().getModelExtensionDescriptor((EObject)businessObject);
        return med != null && (styleFeature = (md = med.getModelDecorator()).getEStructuralFeature((EObject)businessObject, "style")) != null;
    }

    public static EObject createStyleObject(BaseElement element) {
        EObject style = null;
        try {
            ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(element);
            ModelExtensionDescriptor med = TargetRuntime.getDefaultRuntime().getModelExtensionDescriptor((EObject)element);
            ModelDecorator md = med.getModelDecorator();
            EStructuralFeature styleFeature = md.getEStructuralFeature((EObject)element, "style");
            if (styleFeature != null) {
                ShapeStyle ss = ShapeStyle.getShapeStyle(element);
                style = (EObject)adapter.getFeatureDescriptor(styleFeature).getValue();
                if (style == null) {
                    EClass eClass = (EClass)styleFeature.getEType();
                    if (!element.eClass().getEPackage().equals(eClass.getEPackage())) {
                        ObjectPropertyProvider.adapt((EObject)eClass.getEPackage().getEFactoryInstance(), element.eResource());
                    }
                    style = med.createObject(eClass);
                    ShapeStyle.setShapeStyle(element, style, ss);
                    InsertionAdapter.add((EObject)element, styleFeature, style);
                } else {
                    ShapeStyle.setShapeStyle(element, style, ss);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return style;
    }

    public static EObject getStyleObject(BaseElement element) {
        EObject style = null;
        try {
            ExtendedPropertiesAdapter adapter;
            ModelExtensionDescriptor med = TargetRuntime.getDefaultRuntime().getModelExtensionDescriptor((EObject)element);
            ModelDecorator md = med.getModelDecorator();
            EStructuralFeature styleFeature = md.getEStructuralFeature((EObject)element, "style");
            if (styleFeature != null && (adapter = ExtendedPropertiesAdapter.adapt(element)) != null) {
                style = (EObject)adapter.getFeatureDescriptor(styleFeature).getValue();
            }
        }
        catch (Exception exception) {}
        return style;
    }

    public static Object getStyleValue(EObject style, String feature) {
        EStructuralFeature f = style.eClass().getEStructuralFeature(feature);
        if (f != null && style.eIsSet(f)) {
            return style.eGet(f);
        }
        return null;
    }

    private static void setStyleValue(EObject style, String feature, Object value) {
        try {
            EStructuralFeature f = style.eClass().getEStructuralFeature(feature);
            Object oldValue = style.eGet(f);
            if (value != null && !value.equals(oldValue)) {
                style.eSet(f, value);
            }
        }
        catch (Exception exception) {}
    }

    public Object getStyleValue(BaseElement element, String feature) {
        if (STYLE_SHAPE_FOREGROUND.equals(feature)) {
            return ShapeStyle.colorToRGB(this.getShapeForeground());
        }
        if (STYLE_SHAPE_BACKGROUND.equals(feature)) {
            return ShapeStyle.colorToRGB(this.getShapeBackground());
        }
        if (STYLE_LABEL_FOREGROUND.equals(feature)) {
            return ShapeStyle.colorToRGB(this.getLabelForeground());
        }
        if (STYLE_LABEL_BACKGROUND.equals(feature)) {
            return null;
        }
        if (STYLE_LABEL_FONT.equals(feature)) {
            return ShapeStyle.toFontData(this.getLabelFont());
        }
        if (STYLE_LABEL_POSITION.equals(feature)) {
            return ShapeStyle.toEENumLiteral((EObject)element, this.getLabelPosition());
        }
        if (STYLE_ROUTING_STYLE.equals(feature)) {
            return ShapeStyle.toEENumLiteral((EObject)element, this.getRoutingStyle());
        }
        return null;
    }

    public static boolean isStyleObject(Object object) {
        if (object instanceof AnyType) {
            AnyType at = (AnyType)object;
            EClass ec = at.eClass();
            String name = ec.getName();
            return STYLE_ECLASS.equals(name);
        }
        return false;
    }

    public static boolean isStyleFeature(EStructuralFeature feature) {
        return feature.getName().equals("style") && feature.getEType().getName().equals(STYLE_ECLASS);
    }

    public static ShapeStyle getShapeStyle(BaseElement element) {
        Bpmn2Preferences preferences = Bpmn2Preferences.getInstance((EObject)element);
        ShapeStyle ss = preferences.getShapeStyle((EObject)element);
        ss = new ShapeStyle(ss);
        EObject style = ShapeStyle.getStyleObject(element);
        if (style != null) {
            style.eSetDeliver(false);
            RGB shapeForeground = (RGB)ShapeStyle.getStyleValue(style, STYLE_SHAPE_FOREGROUND);
            RGB shapeBackground = (RGB)ShapeStyle.getStyleValue(style, STYLE_SHAPE_BACKGROUND);
            RGB labelForeground = (RGB)ShapeStyle.getStyleValue(style, STYLE_LABEL_FOREGROUND);
            FontData labelFont = (FontData)ShapeStyle.getStyleValue(style, STYLE_LABEL_FONT);
            EEnumLiteral labelPosition = (EEnumLiteral)ShapeStyle.getStyleValue(style, STYLE_LABEL_POSITION);
            EEnumLiteral routingStyle = (EEnumLiteral)ShapeStyle.getStyleValue(style, STYLE_ROUTING_STYLE);
            if (shapeBackground != null) {
                IColorConstant cc = ShapeStyle.RGBToColor(shapeBackground);
                ss.setShapeBackground(cc);
                ss.setShapePrimarySelectedColor(StyleUtil.shiftColor(cc, 32));
                ss.setShapeSecondarySelectedColor(StyleUtil.shiftColor(cc, -32));
            } else {
                ShapeStyle.setStyleValue(style, STYLE_SHAPE_BACKGROUND, ShapeStyle.colorToRGB(ss.getShapeBackground()));
            }
            if (shapeForeground != null) {
                ss.setShapeForeground(ShapeStyle.RGBToColor(shapeForeground));
            } else {
                ShapeStyle.setStyleValue(style, STYLE_SHAPE_FOREGROUND, ShapeStyle.colorToRGB(ss.getShapeForeground()));
            }
            if (labelForeground != null) {
                ss.setLabelForeground(ShapeStyle.RGBToColor(labelForeground));
            } else {
                ShapeStyle.setStyleValue(style, STYLE_LABEL_FOREGROUND, ShapeStyle.colorToRGB(ss.getLabelForeground()));
            }
            if (labelFont != null) {
                Diagram diagram = DIUtils.getDiagram(element);
                if (diagram != null) {
                    ss.setLabelFont(ShapeStyle.toGraphitiFont(diagram, labelFont));
                }
            } else {
                ShapeStyle.setStyleValue(style, STYLE_LABEL_FONT, ShapeStyle.toFontData(ss.getLabelFont()));
            }
            if (labelPosition != null) {
                ss.setLabelPosition((LabelPosition)ShapeStyle.fromEENumLiteral((EObject)element, labelPosition));
            } else {
                ShapeStyle.setStyleValue(style, STYLE_LABEL_POSITION, ShapeStyle.toEENumLiteral((EObject)element, ss.getLabelPosition()));
            }
            if (routingStyle != null) {
                ss.setRoutingStyle((RoutingStyle)ShapeStyle.fromEENumLiteral((EObject)element, routingStyle));
            } else {
                ShapeStyle.setStyleValue(style, STYLE_ROUTING_STYLE, ShapeStyle.toEENumLiteral((EObject)element, ss.getRoutingStyle()));
            }
            style.eSetDeliver(true);
        } else {
            Diagram diagram;
            BPMNLabelStyle bpmnStyle = DIUtils.getDILabelStyle(element);
            if (bpmnStyle != null && bpmnStyle.getFont() != null && (diagram = DIUtils.getDiagram(element)) != null) {
                org.eclipse.graphiti.mm.algorithms.styles.Font f = ShapeStyle.toGraphitiFont(diagram, bpmnStyle.getFont());
                ss.setLabelFont(f);
            }
        }
        return ss;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ShapeStyle) {
            return ShapeStyle.encode(this).equals(ShapeStyle.encode((ShapeStyle)obj));
        }
        if (obj instanceof BPMNLabelStyle) {
            BPMNLabelStyle ls = (BPMNLabelStyle)obj;
            ShapeStyle ss = this;
            Font f1 = ls.getFont();
            org.eclipse.graphiti.mm.algorithms.styles.Font f2 = ss.getLabelFont();
            if (f1 == null && f2 == null) {
                return false;
            }
            if (f2 == null) {
                return false;
            }
            return f1.getName().equals(f1.getName()) && f1.getSize() == (float)f2.getSize() && f1.isIsBold() == f2.isBold() && f1.isIsItalic() == f2.isItalic();
        }
        return super.equals(obj);
    }

    private static Enum fromEENumLiteral(EObject element, EEnumLiteral el) {
        try {
            LabelPosition.values();
            Class<?> c = Class.forName(String.valueOf(ShapeStyle.class.getName()) + "$" + el.getEEnum().getName());
            Enum[] enumArray = (Enum[])c.getEnumConstants();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enum en = enumArray[n2];
                if (en.ordinal() == el.getValue()) {
                    return en;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static EEnumLiteral toEENumLiteral(EObject element, Enum en) {
        ModelExtensionDescriptor med = TargetRuntime.getDefaultRuntime().getModelExtensionDescriptor(element);
        ModelDecorator md = med.getModelDecorator();
        EEnum lp = (EEnum)md.getEDataType(en.getClass().getSimpleName());
        EEnumLiteral el = lp.getEEnumLiteral(en.ordinal());
        ShapeStyle.fromEENumLiteral(element, el);
        return el;
    }

    public static void setShapeStyle(BaseElement element, EObject style, ShapeStyle ss) {
        if (ShapeStyle.hasStyle(element)) {
            if (style == null) {
                style = ShapeStyle.getStyleObject(element);
            }
            ShapeStyle.setStyleValue(style, STYLE_SHAPE_FOREGROUND, ShapeStyle.colorToRGB(ss.getShapeForeground()));
            ShapeStyle.setStyleValue(style, STYLE_SHAPE_BACKGROUND, ShapeStyle.colorToRGB(ss.getShapeBackground()));
            ShapeStyle.setStyleValue(style, STYLE_LABEL_FOREGROUND, ShapeStyle.colorToRGB(ss.getLabelForeground()));
            ShapeStyle.setStyleValue(style, STYLE_LABEL_FONT, ShapeStyle.toFontData(ss.getLabelFont()));
            ShapeStyle.setStyleValue(style, STYLE_LABEL_POSITION, ShapeStyle.toEENumLiteral((EObject)element, ss.getLabelPosition()));
            ShapeStyle.setStyleValue(style, STYLE_ROUTING_STYLE, ShapeStyle.toEENumLiteral((EObject)element, ss.getRoutingStyle()));
        } else {
            Bpmn2Preferences preferences = Bpmn2Preferences.getInstance((EObject)element);
            preferences.setShapeStyle((EObject)element, ss);
        }
    }

    public static enum Category {
        CONNECTIONS(Messages.ShapeStyle_Category_Connections),
        SHAPES(Messages.ShapeStyle_Category_Shapes),
        EVENTS(Messages.ShapeStyle_Category_Events),
        GATEWAYS(Messages.ShapeStyle_Category_Gateways),
        TASKS(Messages.ShapeStyle_Category_Tasks),
        GLOBAL_TASKS(Messages.ShapeStyle_Category_GlobalTasks),
        SUBPROCESS(Messages.ShapeStyle_Category_SubProcess),
        CHOREOGRAPHY(Messages.ShapeStyle_Category_Choreography),
        CONVERSATION(Messages.ShapeStyle_Category_Conversation),
        SWIMLANES(Messages.ShapeStyle_Category_SwimLanes),
        DATA(Messages.ShapeStyle_Category_Data),
        ARTIFACTS(Messages.ShapeStyle_Category_Other),
        CANVAS(Messages.ShapeStyle_Category_Canvas),
        GRID(Messages.ShapeStyle_Category_Grid),
        NONE("");

        private String string;

        private Category(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }
    }

    public static enum LabelPosition {
        SOUTH(Messages.ShapeStyle_LabelPosition_South),
        NORTH(Messages.ShapeStyle_LabelPosition_North),
        WEST(Messages.ShapeStyle_LabelPosition_West),
        EAST(Messages.ShapeStyle_LabelPosition_East),
        TOP(Messages.ShapeStyle_LabelPosition_Top),
        CENTER(Messages.ShapeStyle_LabelPosition_Center),
        BOTTOM(Messages.ShapeStyle_LabelPosition_Bottom),
        LEFT(Messages.ShapeStyle_LabelPosition_Left),
        RIGHT(Messages.ShapeStyle_LabelPosition_Right),
        MOVABLE(Messages.ShapeStyle_LabelPosition_Movable);

        private String string;

        private LabelPosition(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }
    }

    public static enum RoutingStyle {
        MANUAL(Messages.ShapeStyle_RoutingStyle_Manual),
        AUTOMATIC(Messages.ShapeStyle_RoutingStyle_Automatic),
        MANHATTAN(Messages.ShapeStyle_RoutingStyle_Manhattan);

        private String string;

        private RoutingStyle(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }
    }
}

