/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.utils;

import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.DataAssociation;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.Error;
import org.eclipse.bpmn2.ErrorEventDefinition;
import org.eclipse.bpmn2.EscalationEventDefinition;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.InputSet;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.OutputSet;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.utils.Tuple;
import org.eclipse.emf.ecore.resource.Resource;

public class EventDefinitionsUtil {
    private EventDefinitionsUtil() {
    }

    public static Tuple<ItemAwareElement, DataAssociation> getIOParameter(Event event, EventDefinition eventDefinition) {
        Resource resource = event.eResource();
        ItemAwareElement element = null;
        DataAssociation association = null;
        InputSet ioSet = null;
        List eventDefinitions = null;
        List parameters = null;
        List associations = null;
        ThrowEvent throwEvent = null;
        CatchEvent catchEvent = null;
        boolean isInput = false;
        if (event instanceof ThrowEvent) {
            throwEvent = (ThrowEvent)event;
            eventDefinitions = throwEvent.getEventDefinitions();
            parameters = throwEvent.getDataInputs();
            associations = throwEvent.getDataInputAssociation();
            ioSet = throwEvent.getInputSet();
            isInput = true;
        } else {
            catchEvent = (CatchEvent)event;
            eventDefinitions = catchEvent.getEventDefinitions();
            parameters = catchEvent.getDataOutputs();
            associations = catchEvent.getDataOutputAssociation();
            ioSet = catchEvent.getOutputSet();
        }
        int index = -1;
        for (EventDefinition ed : eventDefinitions) {
            element = null;
            association = null;
            if (EventDefinitionsUtil.hasItemDefinition(ed)) {
                ItemDefinition itemDefinition = EventDefinitionsUtil.getItemDefinition(ed);
                if (parameters.size() <= ++index) {
                    String name = ed.getId().replace("EventDefinition", "");
                    if (isInput) {
                        element = (ItemAwareElement)Bpmn2ModelerFactory.create(resource, DataInput.class);
                        ((DataInput)element).setName(String.valueOf(name) + "_Input");
                    } else {
                        element = (ItemAwareElement)Bpmn2ModelerFactory.create(resource, DataOutput.class);
                        ((DataOutput)element).setName(String.valueOf(name) + "_Output");
                    }
                    if (itemDefinition != null) {
                        element.setItemSubjectRef(itemDefinition);
                    }
                    parameters.add(element);
                } else {
                    element = (ItemAwareElement)parameters.get(index);
                }
                if (isInput) {
                    for (DataAssociation a : associations) {
                        if (a.getTargetRef() != element) continue;
                        association = a;
                        break;
                    }
                    if (association == null) {
                        association = (DataAssociation)Bpmn2ModelerFactory.create(resource, DataInputAssociation.class);
                        association.setTargetRef(element);
                        associations.add(association);
                    }
                } else {
                    for (DataAssociation a : associations) {
                        if (!a.getSourceRef().contains(element)) continue;
                        association = a;
                        break;
                    }
                    if (association == null) {
                        association = (DataAssociation)Bpmn2ModelerFactory.create(resource, DataOutputAssociation.class);
                        if (element != null) {
                            association.getSourceRef().add(element);
                        }
                        associations.add(association);
                    }
                }
                if (ioSet == null) {
                    if (isInput) {
                        ioSet = (BaseElement)Bpmn2ModelerFactory.create(resource, InputSet.class);
                        throwEvent.setInputSet(ioSet);
                    } else {
                        ioSet = (BaseElement)Bpmn2ModelerFactory.create(resource, OutputSet.class);
                        catchEvent.setOutputSet((OutputSet)ioSet);
                    }
                }
                if (isInput) {
                    if (!ioSet.getDataInputRefs().contains(element)) {
                        ioSet.getDataInputRefs().add((DataInput)element);
                    }
                } else if (!((OutputSet)ioSet).getDataOutputRefs().contains(element)) {
                    ((OutputSet)ioSet).getDataOutputRefs().add((DataOutput)element);
                }
            }
            if (ed == eventDefinition) break;
        }
        return new Tuple<Object, Object>(element, association);
    }

    public static boolean hasItemDefinition(EventDefinition eventDefinition) {
        return eventDefinition instanceof ErrorEventDefinition || eventDefinition instanceof EscalationEventDefinition || eventDefinition instanceof SignalEventDefinition || eventDefinition instanceof MessageEventDefinition;
    }

    public static ItemDefinition getItemDefinition(EventDefinition eventDefinition) {
        Error payloadContainer;
        ItemDefinition itemDefinition = null;
        if (eventDefinition instanceof ErrorEventDefinition) {
            payloadContainer = ((ErrorEventDefinition)eventDefinition).getErrorRef();
            ItemDefinition itemDefinition2 = itemDefinition = payloadContainer == null ? null : payloadContainer.getStructureRef();
        }
        if (eventDefinition instanceof EscalationEventDefinition) {
            payloadContainer = ((EscalationEventDefinition)eventDefinition).getEscalationRef();
            ItemDefinition itemDefinition3 = itemDefinition = payloadContainer == null ? null : payloadContainer.getStructureRef();
        }
        if (eventDefinition instanceof SignalEventDefinition) {
            payloadContainer = ((SignalEventDefinition)eventDefinition).getSignalRef();
            ItemDefinition itemDefinition4 = itemDefinition = payloadContainer == null ? null : payloadContainer.getStructureRef();
        }
        if (eventDefinition instanceof MessageEventDefinition) {
            payloadContainer = ((MessageEventDefinition)eventDefinition).getMessageRef();
            itemDefinition = payloadContainer == null ? null : payloadContainer.getItemRef();
        }
        return itemDefinition;
    }

    public static void setItemDefinition(EventDefinition eventDefinition, ItemDefinition itemDefinition) {
        Error payloadContainer;
        if (eventDefinition instanceof ErrorEventDefinition) {
            payloadContainer = ((ErrorEventDefinition)eventDefinition).getErrorRef();
            payloadContainer.setStructureRef(itemDefinition);
        }
        if (eventDefinition instanceof EscalationEventDefinition) {
            payloadContainer = ((EscalationEventDefinition)eventDefinition).getEscalationRef();
            payloadContainer.setStructureRef(itemDefinition);
        }
        if (eventDefinition instanceof SignalEventDefinition) {
            payloadContainer = ((SignalEventDefinition)eventDefinition).getSignalRef();
            payloadContainer.setStructureRef(itemDefinition);
        }
        if (eventDefinition instanceof MessageEventDefinition) {
            payloadContainer = ((MessageEventDefinition)eventDefinition).getMessageRef();
            payloadContainer.setItemRef(itemDefinition);
        }
    }

    public static EventDefinition getEventDefinition(ItemAwareElement element) {
        Event event = null;
        List eventDefinitions = null;
        if (element.eContainer() instanceof CatchEvent) {
            event = (Event)element.eContainer();
            eventDefinitions = ((CatchEvent)event).getEventDefinitions();
        } else if (element.eContainer() instanceof ThrowEvent) {
            event = (Event)element.eContainer();
            eventDefinitions = ((ThrowEvent)event).getEventDefinitions();
        }
        if (eventDefinitions != null) {
            for (EventDefinition ed : eventDefinitions) {
                Tuple<ItemAwareElement, DataAssociation> param = EventDefinitionsUtil.getIOParameter(event, ed);
                if (param.getFirst() != element) continue;
                return ed;
            }
        }
        return null;
    }

    public static RootElement getEventDefinitionTarget(EventDefinition eventDefinition) {
        if (eventDefinition instanceof ErrorEventDefinition) {
            return ((ErrorEventDefinition)eventDefinition).getErrorRef();
        }
        if (eventDefinition instanceof EscalationEventDefinition) {
            return ((EscalationEventDefinition)eventDefinition).getEscalationRef();
        }
        if (eventDefinition instanceof SignalEventDefinition) {
            return ((SignalEventDefinition)eventDefinition).getSignalRef();
        }
        if (eventDefinition instanceof MessageEventDefinition) {
            return ((MessageEventDefinition)eventDefinition).getMessageRef();
        }
        return null;
    }
}

