/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.customeditor;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.customeditor.EditBeanDialog;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.drools.process.core.ParameterDefinition;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.drools.process.core.Work;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.drools.process.core.WorkDefinition;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.drools.process.core.WorkEditor;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.drools.process.core.datatype.DataType;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.drools.process.core.impl.WorkImpl;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SampleCustomEditor
extends EditBeanDialog<Work>
implements WorkEditor {
    private WorkDefinition workDefinition;
    private Map<String, Text> texts = new HashMap<String, Text>();

    public SampleCustomEditor(Shell parentShell) {
        super(parentShell, "Custom Work Editor");
        this.setBlockOnOpen(true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Work work = (Work)this.getValue();
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("Name: ");
        nameLabel.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        Text nameText = new Text(composite, 0);
        nameText.setEditable(false);
        nameText.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        String name = work.getName();
        nameText.setText(name == null ? "" : name);
        Set<ParameterDefinition> parameters = this.workDefinition.getParameters();
        for (ParameterDefinition param : parameters) {
            Label label = new Label(composite, 0);
            label.setText(String.valueOf(param.getName()) + ": ");
            label.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
            Text text = new Text(composite, 2048);
            text.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
            this.texts.put(param.getName(), text);
            Object value = work.getParameter(param.getName());
            text.setText(value == null ? "" : value.toString());
        }
        return composite;
    }

    @Override
    protected Work updateValue(Work value) {
        WorkImpl work = new WorkImpl();
        work.setName(value.getName());
        for (Map.Entry<String, Text> entry : this.texts.entrySet()) {
            String text = entry.getValue().getText();
            ParameterDefinition pd = value.getParameterDefinition(entry.getKey());
            DataType type = pd.getType();
            try {
                type.readValue(text);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("The value \"" + text + "\" " + "for parameter \"" + entry.getKey() + "\" " + "does not conform to the " + pd.getType().getStringType() + " " + "data type.");
            }
            work.setParameter(entry.getKey(), "".equals(text) ? null : text);
        }
        work.setParameterDefinitions(value.getParameterDefinitions());
        return work;
    }

    @Override
    public Work getWork() {
        return (Work)this.getValue();
    }

    @Override
    public void setWork(Work work) {
        this.setValue(work);
    }

    @Override
    public void setWorkDefinition(WorkDefinition workDefinition) {
        this.workDefinition = workDefinition;
    }

    @Override
    public boolean show() {
        int result = this.open();
        return result == 0;
    }
}

