/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.extensions;

import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractListComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.DefaultDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.DefaultListComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.ListCompositeColumnProvider;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.ListCompositeContentProvider;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.TableColumn;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.TextAndButtonObjectEditor;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.TextObjectEditor;
import org.eclipse.bpmn2.modeler.core.validation.SyntaxCheckerUtils;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.extensions.Messages;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.extensions.NotificationType;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.extensions.TaskExtensionsFactory;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.extensions.TaskNotification;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.extensions.TaskNotificationList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

public class TaskNotificationsListComposite
extends DefaultListComposite {
    protected TaskNotificationList mylist;
    protected boolean updateList;
    protected Task task;

    public TaskNotificationsListComposite(Composite parent, Task task) {
        super(parent, 28835840);
        this.task = task;
    }

    public EClass getListItemClass(EObject object, EStructuralFeature feature) {
        return TaskExtensionsFactory.eINSTANCE.getTaskNotification();
    }

    protected int createColumnProvider(EObject object, EStructuralFeature feature) {
        if (this.columnProvider == null) {
            this.columnProvider = new ListCompositeColumnProvider((AbstractListComposite)this);
            this.columnProvider.addRaw((TableColumn)new NotificationTypeTableColumn(object));
            this.columnProvider.addRaw((TableColumn)new NotificationFromTableColumn(object));
            this.columnProvider.addRaw((TableColumn)new NotificationUsersTableColumn(object));
            this.columnProvider.addRaw((TableColumn)new NotificationGroupsTableColumn(object));
            this.columnProvider.addRaw((TableColumn)new NotificationReplyToTableColumn(object));
            this.columnProvider.addRaw((TableColumn)new NotificationSubjectTableColumn(object));
            this.columnProvider.addRaw((TableColumn)new NotificationBodyTableColumn(object));
            this.columnProvider.addRaw((TableColumn)new NotificationExpiresAtTableColumn(object));
        }
        return this.columnProvider.getColumns().size();
    }

    public ListCompositeContentProvider getContentProvider(EObject object, EStructuralFeature feature, EList<EObject> list) {
        if (this.contentProvider == null) {
            this.contentProvider = new ListCompositeContentProvider((AbstractListComposite)this, object, feature, list){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                    if (oldInput != newInput || TaskNotificationsListComposite.this.updateList) {
                        TaskNotificationsListComposite.this.getItemList();
                        Task task = (Task)this.object;
                        TaskNotificationList newlist = new TaskNotificationList();
                        newlist.setTask(task);
                        for (DataInputAssociation dia : task.getDataInputAssociations()) {
                            DataInput di = (DataInput)dia.getTargetRef();
                            String type = di.getName();
                            if (NotificationType.get(type) == null) continue;
                            FormalExpression exp = (FormalExpression)((Assignment)dia.getAssignment().get(0)).getFrom();
                            newlist.add(type, exp.getBody());
                        }
                        int index = 0;
                        while (index < newlist.size()) {
                            TaskNotification tn = newlist.get(index);
                            TaskNotificationsListComposite.this.mylist.replace(index, tn.getType().getLiteral(), tn.toString());
                            ++index;
                        }
                        this.object = this.listComposite.getBusinessObject();
                        TaskNotificationsListComposite.this.updateList = false;
                    }
                }

                public Object[] getElements(Object inputElement) {
                    return TaskNotificationsListComposite.this.getItemList().toArray();
                }
            };
        }
        return this.contentProvider;
    }

    public AbstractDetailComposite createDetailComposite(Class eClass, Composite parent, int style) {
        DefaultDetailComposite composite = new DefaultDetailComposite(parent, style){

            protected Composite bindFeature(EObject be, EStructuralFeature feature, EClass eItemClass) {
                final TaskNotification tn = (TaskNotification)be;
                if ("tousers".equals(feature.getName())) {
                    TextAndButtonObjectEditor editor = new TextAndButtonObjectEditor((AbstractDetailComposite)this, be, feature){

                        protected void buttonClicked(int buttonId) {
                            IInputValidator validator = new IInputValidator(){

                                public String isValid(String newText) {
                                    if (newText == null || newText.isEmpty()) {
                                        return null;
                                    }
                                    String[] stringArray = newText.split(",");
                                    int n = stringArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String s = stringArray[n2];
                                        if (!(s = s.trim()).isEmpty() && !SyntaxCheckerUtils.isNCName((String)s)) {
                                            return NLS.bind((String)Messages.TaskNotificationsListComposite_UserName_Error, (Object)s);
                                        }
                                        ++n2;
                                    }
                                    return null;
                                }
                            };
                            String initialValue = tn.getToUsersAsString();
                            InputDialog dialog = new InputDialog(this.getShell(), Messages.TaskNotificationsListComposite_EditUsers_Title, Messages.TaskNotificationsListComposite_EditUsers_Message, initialValue, validator);
                            if (dialog.open() == 0) {
                                this.setValue(dialog.getValue());
                            }
                        }

                        public Object getValue() {
                            return tn.getToUsersAsString();
                        }

                        protected String getText() {
                            return tn.getToUsersAsString();
                        }

                        public boolean setValue(final Object result) {
                            TransactionalEditingDomain domain = this.getDiagramEditor().getEditingDomain();
                            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                                protected void doExecute() {
                                    tn.setToUsers((String)result);
                                }
                            });
                            this.updateText();
                            return true;
                        }
                    };
                    editor.createControl((Composite)this, Messages.TaskNotificationsListComposite_ToUsers_Label);
                    editor.setEditable(false);
                    return null;
                }
                if ("togroups".equals(feature.getName())) {
                    TextAndButtonObjectEditor editor = new TextAndButtonObjectEditor((AbstractDetailComposite)this, be, feature){

                        protected void buttonClicked(int buttonId) {
                            IInputValidator validator = new IInputValidator(){

                                public String isValid(String newText) {
                                    if (newText == null || newText.isEmpty()) {
                                        return null;
                                    }
                                    String[] stringArray = newText.split(",");
                                    int n = stringArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String s = stringArray[n2];
                                        if (!(s = s.trim()).isEmpty() && !SyntaxCheckerUtils.isNCName((String)s)) {
                                            return NLS.bind((String)Messages.TaskNotificationsListComposite_GroupName_Error, (Object)s);
                                        }
                                        ++n2;
                                    }
                                    return null;
                                }
                            };
                            String initialValue = tn.getToGroupsAsString();
                            InputDialog dialog = new InputDialog(this.getShell(), Messages.TaskNotificationsListComposite_EditGroups_Title, Messages.TaskNotificationsListComposite_EditGroups_Message, initialValue, validator);
                            if (dialog.open() == 0) {
                                this.setValue(dialog.getValue());
                            }
                        }

                        public Object getValue() {
                            return tn.getToGroupsAsString();
                        }

                        protected String getText() {
                            return tn.getToGroupsAsString();
                        }

                        public boolean setValue(final Object result) {
                            TransactionalEditingDomain domain = this.getDiagramEditor().getEditingDomain();
                            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                                protected void doExecute() {
                                    tn.setToGroups((String)result);
                                }
                            });
                            this.updateText();
                            return true;
                        }
                    };
                    editor.createControl((Composite)this, Messages.TaskNotificationsListComposite_ToGroups_Label);
                    editor.setEditable(false);
                    return null;
                }
                if ("body".equals(feature.getName())) {
                    TextObjectEditor editor = new TextObjectEditor((AbstractDetailComposite)this, be, feature){

                        protected boolean isMultiLineText() {
                            return true;
                        }
                    };
                    editor.setMultiLine(true);
                    editor.createControl((Composite)this, Messages.TaskNotificationsListComposite_Body_Label);
                    return null;
                }
                return super.bindFeature(be, feature, eItemClass);
            }

            protected boolean isModelObjectEnabled(EClass eclass, EStructuralFeature feature) {
                return true;
            }
        };
        return composite;
    }

    protected EList<EObject> getItemList() {
        if (this.mylist == null) {
            this.mylist = new TaskNotificationList();
            this.mylist.setTask(this.task);
        }
        return this.mylist;
    }

    protected EObject addListItem(EObject object, EStructuralFeature feature) {
        TaskNotification newItem = TaskExtensionsFactory.eINSTANCE.createTaskNotification();
        this.getItemList().add((Object)newItem);
        this.mylist.updateTask();
        return newItem;
    }

    protected Object removeListItem(EObject object, EStructuralFeature feature, int index) {
        this.updateList = true;
        Object result = super.removeListItem(object, feature, index);
        this.mylist.updateTask();
        return result;
    }

    protected Object moveListItemUp(EObject object, EStructuralFeature feature, int index) {
        this.updateList = true;
        Object result = super.moveListItemUp(object, feature, index);
        this.mylist.updateTask();
        return result;
    }

    protected Object moveListItemDown(EObject object, EStructuralFeature feature, int index) {
        this.updateList = true;
        Object result = super.moveListItemDown(object, feature, index);
        this.mylist.updateTask();
        return result;
    }

    class NotificationBodyTableColumn
    extends TableColumn {
        public NotificationBodyTableColumn(EObject object) {
            super(object, TaskExtensionsFactory.eINSTANCE.getTaskNotification_Body());
            this.setHeaderText(Messages.TaskNotificationsListComposite_Body_Header);
            this.setEditable(true);
        }
    }

    class NotificationExpiresAtTableColumn
    extends TableColumn {
        public NotificationExpiresAtTableColumn(EObject object) {
            super(object, TaskExtensionsFactory.eINSTANCE.getTaskNotification_ExpiresAt());
            this.setHeaderText(Messages.TaskNotificationsListComposite_ExpiresAt_Header);
            this.setEditable(true);
        }
    }

    class NotificationFromTableColumn
    extends TableColumn {
        public NotificationFromTableColumn(EObject object) {
            super(object, TaskExtensionsFactory.eINSTANCE.getTaskNotification_From());
            this.setHeaderText(Messages.TaskNotificationsListComposite_From_Header);
            this.setEditable(true);
        }
    }

    class NotificationGroupsTableColumn
    extends TableColumn {
        public NotificationGroupsTableColumn(EObject object) {
            super(object, TaskExtensionsFactory.eINSTANCE.getTaskNotification_ToGroups());
            this.setHeaderText(Messages.TaskNotificationsListComposite_ToGroups_Header);
            this.setEditable(false);
        }

        public String getText(Object element) {
            return ((TaskNotification)((Object)element)).getToGroupsAsString();
        }
    }

    class NotificationReplyToTableColumn
    extends TableColumn {
        public NotificationReplyToTableColumn(EObject object) {
            super(object, TaskExtensionsFactory.eINSTANCE.getTaskNotification_ReplyTo());
            this.setHeaderText(Messages.TaskNotificationsListComposite_ReplyTo_Header);
            this.setEditable(true);
        }
    }

    class NotificationSubjectTableColumn
    extends TableColumn {
        public NotificationSubjectTableColumn(EObject object) {
            super(object, TaskExtensionsFactory.eINSTANCE.getTaskNotification_Subject());
            this.setHeaderText(Messages.TaskNotificationsListComposite_Subject_Header);
            this.setEditable(true);
        }
    }

    class NotificationTypeTableColumn
    extends TableColumn {
        public NotificationTypeTableColumn(EObject object) {
            super(object, TaskExtensionsFactory.eINSTANCE.getTaskNotification_Type());
            this.setHeaderText(Messages.TaskNotificationsListComposite_Type_Header);
            this.setEditable(true);
        }
    }

    class NotificationUsersTableColumn
    extends TableColumn {
        public NotificationUsersTableColumn(EObject object) {
            super(object, TaskExtensionsFactory.eINSTANCE.getTaskNotification_ToUsers());
            this.setHeaderText(Messages.TaskNotificationsListComposite_ToUsers_Header);
            this.setEditable(false);
        }

        public String getText(Object element) {
            return ((TaskNotification)((Object)element)).getToUsersAsString();
        }
    }
}

