/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.extensions;

import java.util.Collection;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.modeler.core.utils.ExtendedStringTokenizer;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.extensions.ReassignmentType;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.extensions.TaskExtensionsFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.xml.type.impl.AnyTypeImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;

public class TaskReassignment
extends AnyTypeImpl
implements IEditingDomainProvider {
    Task task;
    ReassignmentType type = ReassignmentType.NOT_STARTED_REASSIGN;
    EList<String> users = new BasicEList();
    EList<String> groups = new BasicEList();
    String expiresAt = "";
    static EStructuralFeature typeFeature;
    static EStructuralFeature usersFeature;
    static EStructuralFeature groupsFeature;
    static EStructuralFeature expiresAtFeature;

    public TaskReassignment() {
        typeFeature = TaskExtensionsFactory.eINSTANCE.getTaskReassignment_Type();
        usersFeature = TaskExtensionsFactory.eINSTANCE.getTaskReassignment_Users();
        groupsFeature = TaskExtensionsFactory.eINSTANCE.getTaskReassignment_Groups();
        expiresAtFeature = TaskExtensionsFactory.eINSTANCE.getTaskReassignment_ExpiresAt();
    }

    public EClass eClass() {
        return TaskExtensionsFactory.eINSTANCE.getTaskReassignment();
    }

    public Object eGet(EStructuralFeature eFeature) {
        if (eFeature == typeFeature) {
            return this.getType();
        }
        if (eFeature == usersFeature) {
            return this.getUsers();
        }
        if (eFeature == groupsFeature) {
            return this.getGroups();
        }
        if (eFeature == expiresAtFeature) {
            return this.getExpiresAt();
        }
        return super.eGet(eFeature);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        if (eFeature == typeFeature) {
            this.setType((ReassignmentType)((Object)newValue));
        } else if (eFeature == usersFeature) {
            this.getUsers().clear();
            this.getUsers().addAll((Collection)newValue);
        } else if (eFeature == groupsFeature) {
            this.getGroups().clear();
            this.getGroups().addAll((Collection)newValue);
        } else if (eFeature == expiresAtFeature) {
            this.setExpiresAt((String)newValue);
        } else {
            super.eSet(eFeature, newValue);
        }
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public Task getTask() {
        return this.task;
    }

    public ReassignmentType getType() {
        return this.type;
    }

    public void setType(ReassignmentType type) {
        ReassignmentType oldType = this.type;
        this.type = type;
        if (this.eNotificationRequired() && oldType != type) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, typeFeature.getFeatureID(), (Object)oldType, (Object)type));
        }
    }

    public EList<String> getUsers() {
        return this.users;
    }

    public String getUsersAsString() {
        String text = "";
        int i = 0;
        while (i < this.getUsers().size()) {
            text = String.valueOf(text) + (String)this.getUsers().get(i);
            if (i + 1 < this.getUsers().size()) {
                text = String.valueOf(text) + ",";
            }
            ++i;
        }
        return text;
    }

    public void setUsers(String users) {
        BasicEList oldUsers = new BasicEList();
        oldUsers.addAll(this.users);
        this.users.clear();
        if (users != null && !users.isEmpty()) {
            String[] stringArray = users.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (!(s = s.trim()).isEmpty()) {
                    this.users.add((Object)s);
                }
                ++n2;
            }
        }
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, usersFeature.getFeatureID(), (Object)oldUsers, this.users));
        }
    }

    public EList<String> getGroups() {
        return this.groups;
    }

    public String getGroupsAsString() {
        String text = "";
        int i = 0;
        while (i < this.getGroups().size()) {
            text = String.valueOf(text) + (String)this.getGroups().get(i);
            if (i + 1 < this.getGroups().size()) {
                text = String.valueOf(text) + ",";
            }
            ++i;
        }
        return text;
    }

    public void setGroups(String groups) {
        BasicEList oldGroups = new BasicEList();
        oldGroups.addAll(this.groups);
        this.groups.clear();
        if (groups != null && !groups.isEmpty()) {
            String[] stringArray = groups.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (!(s = s.trim()).isEmpty()) {
                    this.groups.add((Object)s);
                }
                ++n2;
            }
        }
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, groupsFeature.getFeatureID(), (Object)oldGroups, this.groups));
        }
    }

    public String getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(String expiresAt) {
        String oldExpiresAt = this.expiresAt;
        this.expiresAt = expiresAt;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, expiresAtFeature.getFeatureID(), (Object)oldExpiresAt, (Object)this.expiresAt));
        }
    }

    public String toString() {
        String result = "[users:";
        int i = 0;
        while (i < this.users.size()) {
            result = String.valueOf(result) + (String)this.users.get(i);
            if (i + 1 < this.users.size()) {
                result = String.valueOf(result) + ",";
            }
            ++i;
        }
        result = String.valueOf(result) + "|groups:";
        i = 0;
        while (i < this.groups.size()) {
            result = String.valueOf(result) + (String)this.groups.get(i);
            if (i + 1 < this.groups.size()) {
                result = String.valueOf(result) + ",";
            }
            ++i;
        }
        result = String.valueOf(result) + "]@[" + this.expiresAt + "]";
        return result;
    }

    public String fromString(String string) {
        String tail = null;
        this.users.clear();
        this.groups.clear();
        this.expiresAt = "";
        EStructuralFeature currentFeature = null;
        ExtendedStringTokenizer st = new ExtendedStringTokenizer(String.valueOf(string) + "\n", "[:,|]@^", true);
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if ("|".equals(t)) {
                currentFeature = null;
                continue;
            }
            if ("]".equals(t)) {
                String t2 = st.nextToken();
                if ("@".equals(t2)) {
                    String t3 = st.nextToken();
                    if ("[".equals(t3)) {
                        currentFeature = expiresAtFeature;
                        continue;
                    }
                    st.pushToken(t3);
                    st.pushToken(t2);
                    continue;
                }
                st.pushToken(t2);
                continue;
            }
            if ("^".equals(t)) {
                tail = st.nextToken("\n");
                break;
            }
            if (currentFeature != null) {
                if (currentFeature == usersFeature) {
                    if (",".equals(t)) continue;
                    this.getUsers().add((Object)t.trim());
                    continue;
                }
                if (currentFeature == groupsFeature) {
                    if (",".equals(t)) continue;
                    this.getGroups().add((Object)t.trim());
                    continue;
                }
                if (currentFeature != expiresAtFeature) continue;
                this.expiresAt = String.valueOf(this.expiresAt) + t;
                continue;
            }
            if ("users".equals(t)) {
                currentFeature = usersFeature;
                Assert.isTrue((boolean)":".equals(st.nextToken()));
                continue;
            }
            if (!"groups".equals(t)) continue;
            currentFeature = groupsFeature;
            Assert.isTrue((boolean)":".equals(st.nextToken()));
        }
        return tail;
    }

    public EditingDomain getEditingDomain() {
        EditingDomain result = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.task);
        return result;
    }
}

