/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.extensions;

import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractListComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.DefaultDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.DefaultListComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.ListCompositeColumnProvider;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.ListCompositeContentProvider;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.TableColumn;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.TextAndButtonObjectEditor;
import org.eclipse.bpmn2.modeler.core.validation.SyntaxCheckerUtils;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.extensions.Messages;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.extensions.ReassignmentType;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.extensions.TaskExtensionsFactory;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.extensions.TaskReassignment;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.property.extensions.TaskReassignmentList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

public class TaskReassignmentsListComposite
extends DefaultListComposite {
    protected TaskReassignmentList mylist;
    protected boolean updateList;
    protected Task task;

    public TaskReassignmentsListComposite(Composite parent, Task task) {
        super(parent, 28835840);
        this.task = task;
    }

    public EClass getListItemClass(EObject object, EStructuralFeature feature) {
        return TaskExtensionsFactory.eINSTANCE.getTaskReassignment();
    }

    protected int createColumnProvider(EObject object, EStructuralFeature feature) {
        if (this.columnProvider == null) {
            this.columnProvider = new ListCompositeColumnProvider((AbstractListComposite)this);
            this.columnProvider.addRaw((TableColumn)new ReassignmentTypeTableColumn(object));
            this.columnProvider.addRaw((TableColumn)new ReassignmentUsersTableColumn(object));
            this.columnProvider.addRaw((TableColumn)new ReassignmentGroupsTableColumn(object));
            this.columnProvider.addRaw((TableColumn)new ReassignmentExpiresAtTableColumn(object));
        }
        return this.columnProvider.getColumns().size();
    }

    public ListCompositeContentProvider getContentProvider(EObject object, EStructuralFeature feature, EList<EObject> list) {
        if (this.contentProvider == null) {
            this.contentProvider = new ListCompositeContentProvider((AbstractListComposite)this, object, feature, list){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                    if (oldInput != newInput || TaskReassignmentsListComposite.this.updateList) {
                        TaskReassignmentsListComposite.this.getItemList();
                        Task task = (Task)this.object;
                        TaskReassignmentList newlist = new TaskReassignmentList();
                        newlist.setTask(task);
                        for (DataInputAssociation dia : task.getDataInputAssociations()) {
                            DataInput di = (DataInput)dia.getTargetRef();
                            String type = di.getName();
                            if (ReassignmentType.get(type) == null) continue;
                            FormalExpression exp = (FormalExpression)((Assignment)dia.getAssignment().get(0)).getFrom();
                            newlist.add(type, exp.getBody());
                        }
                        int index = 0;
                        while (index < newlist.size()) {
                            TaskReassignment tr = newlist.get(index);
                            TaskReassignmentsListComposite.this.mylist.replace(index, tr.getType().getLiteral(), tr.toString());
                            ++index;
                        }
                        this.object = this.listComposite.getBusinessObject();
                        TaskReassignmentsListComposite.this.updateList = false;
                    }
                }

                public Object[] getElements(Object inputElement) {
                    return TaskReassignmentsListComposite.this.getItemList().toArray();
                }
            };
        }
        return this.contentProvider;
    }

    public AbstractDetailComposite createDetailComposite(Class eClass, Composite parent, int style) {
        DefaultDetailComposite composite = new DefaultDetailComposite(parent, style){

            protected Composite bindFeature(EObject be, EStructuralFeature feature, EClass eItemClass) {
                final TaskReassignment tr = (TaskReassignment)be;
                if ("users".equals(feature.getName())) {
                    TextAndButtonObjectEditor editor = new TextAndButtonObjectEditor((AbstractDetailComposite)this, be, feature){

                        protected void buttonClicked(int buttonId) {
                            IInputValidator validator = new IInputValidator(){

                                public String isValid(String newText) {
                                    if (newText == null || newText.isEmpty()) {
                                        return null;
                                    }
                                    String[] stringArray = newText.split(",");
                                    int n = stringArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String s = stringArray[n2];
                                        if (!(s = s.trim()).isEmpty() && !SyntaxCheckerUtils.isNCName((String)s)) {
                                            return NLS.bind((String)Messages.TaskReassignmentsListComposite_InvalidUserName, (Object)s);
                                        }
                                        ++n2;
                                    }
                                    return null;
                                }
                            };
                            String initialValue = tr.getUsersAsString();
                            InputDialog dialog = new InputDialog(this.getShell(), Messages.TaskReassignmentsListComposite_EditUsers_Title, Messages.TaskReassignmentsListComposite_EditUsers_Message, initialValue, validator);
                            if (dialog.open() == 0) {
                                this.setValue(dialog.getValue());
                            }
                        }

                        public Object getValue() {
                            return tr.getUsersAsString();
                        }

                        protected String getText() {
                            return tr.getUsersAsString();
                        }

                        public boolean setValue(final Object result) {
                            TransactionalEditingDomain domain = this.getDiagramEditor().getEditingDomain();
                            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                                protected void doExecute() {
                                    tr.setUsers((String)result);
                                }
                            });
                            this.updateText();
                            return true;
                        }
                    };
                    editor.createControl((Composite)this, Messages.TaskReassignmentsListComposite_Users_Label);
                    editor.setEditable(false);
                    return null;
                }
                if ("groups".equals(feature.getName())) {
                    TextAndButtonObjectEditor editor = new TextAndButtonObjectEditor((AbstractDetailComposite)this, be, feature){

                        protected void buttonClicked(int buttonId) {
                            IInputValidator validator = new IInputValidator(){

                                public String isValid(String newText) {
                                    if (newText == null || newText.isEmpty()) {
                                        return null;
                                    }
                                    String[] stringArray = newText.split(",");
                                    int n = stringArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String s = stringArray[n2];
                                        if (!(s = s.trim()).isEmpty() && !SyntaxCheckerUtils.isNCName((String)s)) {
                                            return NLS.bind((String)Messages.TaskReassignmentsListComposite_InvalidGroupName, (Object)s);
                                        }
                                        ++n2;
                                    }
                                    return null;
                                }
                            };
                            String initialValue = tr.getGroupsAsString();
                            InputDialog dialog = new InputDialog(this.getShell(), Messages.TaskReassignmentsListComposite_EditGroups_Title, Messages.TaskReassignmentsListComposite_EditGroups_Message, initialValue, validator);
                            if (dialog.open() == 0) {
                                this.setValue(dialog.getValue());
                            }
                        }

                        public Object getValue() {
                            return tr.getGroupsAsString();
                        }

                        protected String getText() {
                            return tr.getGroupsAsString();
                        }

                        public boolean setValue(final Object result) {
                            TransactionalEditingDomain domain = this.getDiagramEditor().getEditingDomain();
                            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                                protected void doExecute() {
                                    tr.setGroups((String)result);
                                }
                            });
                            this.updateText();
                            return true;
                        }
                    };
                    editor.createControl((Composite)this, Messages.TaskReassignmentsListComposite_Groups_Label);
                    editor.setEditable(false);
                    return null;
                }
                return super.bindFeature(be, feature, eItemClass);
            }

            protected boolean isModelObjectEnabled(EClass eclass, EStructuralFeature feature) {
                return true;
            }
        };
        return composite;
    }

    protected EList<EObject> getItemList() {
        if (this.mylist == null) {
            this.mylist = new TaskReassignmentList();
            this.mylist.setTask(this.task);
        }
        return this.mylist;
    }

    protected EObject addListItem(EObject object, EStructuralFeature feature) {
        TaskReassignment newItem = TaskExtensionsFactory.eINSTANCE.createTaskReassignment();
        this.getItemList().add((Object)newItem);
        this.mylist.updateTask();
        return newItem;
    }

    protected Object removeListItem(EObject object, EStructuralFeature feature, int index) {
        this.updateList = true;
        Object result = super.removeListItem(object, feature, index);
        this.mylist.updateTask();
        return result;
    }

    protected Object moveListItemUp(EObject object, EStructuralFeature feature, int index) {
        this.updateList = true;
        Object result = super.moveListItemUp(object, feature, index);
        this.mylist.updateTask();
        return result;
    }

    protected Object moveListItemDown(EObject object, EStructuralFeature feature, int index) {
        this.updateList = true;
        Object result = super.moveListItemDown(object, feature, index);
        this.mylist.updateTask();
        return result;
    }

    class ReassignmentExpiresAtTableColumn
    extends TableColumn {
        public ReassignmentExpiresAtTableColumn(EObject object) {
            super(object, TaskExtensionsFactory.eINSTANCE.getTaskReassignment_ExpiresAt());
            this.setHeaderText(Messages.TaskReassignmentsListComposite_ExpiresAt_Header);
            this.setEditable(true);
        }

        public String getText(Object element) {
            return ((TaskReassignment)((Object)element)).getExpiresAt();
        }
    }

    class ReassignmentGroupsTableColumn
    extends TableColumn {
        public ReassignmentGroupsTableColumn(EObject object) {
            super(object, TaskExtensionsFactory.eINSTANCE.getTaskReassignment_Groups());
            this.setHeaderText(Messages.TaskReassignmentsListComposite_Groups_Header);
            this.setEditable(false);
        }

        public String getText(Object element) {
            return ((TaskReassignment)((Object)element)).getGroupsAsString();
        }
    }

    class ReassignmentTypeTableColumn
    extends TableColumn {
        public ReassignmentTypeTableColumn(EObject object) {
            super(object, TaskExtensionsFactory.eINSTANCE.getTaskReassignment_Type());
            this.setHeaderText(Messages.TaskReassignmentsListComposite_Type_Header);
            this.setEditable(true);
        }

        public String getText(Object element) {
            return ((TaskReassignment)((Object)element)).getType().getLiteral();
        }
    }

    class ReassignmentUsersTableColumn
    extends TableColumn {
        public ReassignmentUsersTableColumn(EObject object) {
            super(object, TaskExtensionsFactory.eINSTANCE.getTaskReassignment_Users());
            this.setHeaderText(Messages.TaskReassignmentsListComposite_Users_Header);
            this.setEditable(false);
        }

        public String getText(Object element) {
            return ((TaskReassignment)((Object)element)).getUsersAsString();
        }
    }
}

