/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.validation.validators;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.validation.SyntaxCheckerUtils;
import org.eclipse.bpmn2.modeler.core.validation.validators.AbstractBpmn2ElementValidator;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.ProcessVariableNameChangeAdapter;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.drools.ExternalProcess;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.model.drools.GlobalType;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.validation.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;

public class ProcessVariableNameValidator
extends AbstractBpmn2ElementValidator<BaseElement> {
    public ProcessVariableNameValidator(IValidationContext ctx) {
        super(ctx);
    }

    public ProcessVariableNameValidator(AbstractBpmn2ElementValidator<?> other) {
        super(other);
    }

    public IStatus validate(BaseElement object) {
        String id = null;
        String featureName = null;
        if (object instanceof GlobalType) {
            id = ((GlobalType)object).getIdentifier();
            featureName = "identifier";
        } else if (object instanceof BaseElement) {
            id = object.getId();
            featureName = "id";
        }
        if (ProcessVariableNameValidator.isEmpty((Object)id)) {
            this.addStatus((EObject)object, featureName, 4, Messages.ProcessVariableNameValidator_ID_Empty, new Object[]{object.eClass().getName()});
        } else if (object instanceof Process || object instanceof ExternalProcess) {
            if (!SyntaxCheckerUtils.isJavaPackageName((String)id)) {
                this.addStatus((EObject)object, featureName, 4, Messages.ProcessVariableNameValidator_ID_Invalid, new Object[]{object.eClass().getName(), id});
            }
        } else if (ProcessVariableNameChangeAdapter.appliesTo((EObject)object)) {
            if (!SyntaxCheckerUtils.isJavaIdentifier((String)id)) {
                this.addStatus((EObject)object, featureName, 4, Messages.ProcessVariableNameValidator_ID_Invalid, new Object[]{object.eClass().getName(), id});
            }
        } else if (!SyntaxCheckerUtils.isNCName((String)id)) {
            this.addStatus((EObject)object, featureName, 4, Messages.ProcessVariableNameValidator_ID_Invalid, new Object[]{object.eClass().getName(), id});
        }
        Definitions definitions = ModelUtil.getDefinitions((Object)object);
        TreeIterator iter = definitions.eAllContents();
        while (iter.hasNext()) {
            EObject o2 = (EObject)iter.next();
            if (!(o2 instanceof BaseElement) || object == o2) continue;
            String id2 = o2 instanceof GlobalType ? ((GlobalType)o2).getIdentifier() : ((BaseElement)o2).getId();
            if (id == null || id2 == null || !id.equals(id2)) continue;
            this.addStatus((EObject)object, featureName, 4, Messages.ProcessVariableNameConstraint_Duplicate_ID, new Object[]{String.valueOf(this.getLabel((EObject)object)) + " " + this.getName((EObject)object), String.valueOf(this.getLabel(o2)) + " " + this.getName(o2)});
        }
        return this.getResult();
    }
}

