/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.wizards;

import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.validation.SyntaxCheckerUtils;
import org.eclipse.bpmn2.modeler.runtime.jboss.jbpm5.wizards.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class NewJbpmProcessWizardPage1
extends WizardPage {
    private Text containerText;
    private Text fileText;
    private Text nameText;
    private Text processIdText;
    private Text packageText;
    private Button isJbpmRuntimeCheckbox;
    private ISelection selection;

    public NewJbpmProcessWizardPage1(ISelection selection) {
        super("wizardPage");
        this.setTitle(Messages.NewJbpmProcessWizardPage1_Title);
        this.setDescription(Messages.NewJbpmProcessWizardPage1_Description);
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText(Messages.NewJbpmProcessWizardPage1_Process_Name);
        this.nameText = new Text(container, 2052);
        GridData gridData = new GridData(4, 2, true, false, 2, 1);
        this.nameText.setLayoutData((Object)gridData);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewJbpmProcessWizardPage1.this.fileText.setText(String.valueOf(NewJbpmProcessWizardPage1.this.nameText.getText()) + ".bpmn2");
                String processid = String.valueOf(NewJbpmProcessWizardPage1.this.packageText.getText()) + "." + NewJbpmProcessWizardPage1.this.nameText.getText();
                processid = SyntaxCheckerUtils.toNCName((String)processid.replaceAll(" ", "_"));
                NewJbpmProcessWizardPage1.this.processIdText.setText(processid);
                NewJbpmProcessWizardPage1.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.NewJbpmProcessWizardPage1_Package);
        this.packageText = new Text(container, 2052);
        gridData = new GridData(4, 2, true, false, 2, 1);
        this.packageText.setLayoutData((Object)gridData);
        this.packageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String processid = String.valueOf(NewJbpmProcessWizardPage1.this.packageText.getText()) + "." + NewJbpmProcessWizardPage1.this.nameText.getText();
                processid = SyntaxCheckerUtils.toNCName((String)processid.replaceAll(" ", "_"));
                NewJbpmProcessWizardPage1.this.processIdText.setText(processid);
                NewJbpmProcessWizardPage1.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.NewJbpmProcessWizardPage1_Process_ID);
        this.processIdText = new Text(container, 2052);
        gridData = new GridData(4, 2, true, false, 2, 1);
        this.processIdText.setLayoutData((Object)gridData);
        this.processIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewJbpmProcessWizardPage1.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.NewJbpmProcessWizardPage1_Container);
        this.containerText = new Text(container, 2052);
        gridData = new GridData(768);
        this.containerText.setLayoutData((Object)gridData);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewJbpmProcessWizardPage1.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText(Messages.NewJbpmProcessWizardPage1_Browse);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewJbpmProcessWizardPage1.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.NewJbpmProcessWizardPage1_File_Name);
        this.fileText = new Text(container, 2052);
        gridData = new GridData(4, 2, true, false, 2, 1);
        this.fileText.setLayoutData((Object)gridData);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewJbpmProcessWizardPage1.this.dialogChanged();
            }
        });
        this.isJbpmRuntimeCheckbox = new Button(container, 32);
        this.isJbpmRuntimeCheckbox.setText(Messages.NewJbpmProcessWizardPage1_Set_JBPM_Default);
        this.isJbpmRuntimeCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewJbpmProcessWizardPage1.this.dialogChanged();
            }
        });
        gridData = new GridData(4, 2, true, false, 3, 1);
        this.isJbpmRuntimeCheckbox.setLayoutData((Object)gridData);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        IContainer container = null;
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (!(obj instanceof IResource) && obj instanceof IAdaptable) {
                obj = ((IAdaptable)obj).getAdapter(IResource.class);
            }
            if (obj instanceof IResource) {
                container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.containerText.setText(container.getFullPath().toString());
            }
        }
        String basename = Messages.NewJbpmProcessWizardPage1_Default_File_Name;
        String filename = String.valueOf(basename) + Messages.NewJbpmProcessWizardPage1_BPMN_File_Extension;
        if (container != null) {
            int i = 1;
            while (container.findMember(filename) != null) {
                filename = String.valueOf(basename) + "_" + i + Messages.NewJbpmProcessWizardPage1_BPMN_File_Extension;
                ++i;
            }
        }
        this.fileText.setText(filename);
        this.nameText.setText(Messages.NewJbpmProcessWizardPage1_Default_Process_Name);
        this.processIdText.setText(Messages.NewJbpmProcessWizardPage1_Default_Process_ID);
        this.packageText.setText(Messages.NewJbpmProcessWizardPage1_Default_Package);
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.NewJbpmProcessWizardPage1_Browse_Title);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    private void dialogChanged() {
        Bpmn2Preferences prefs;
        String packageName;
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String fileName = this.getFileName();
        if (this.getContainerName().length() == 0) {
            this.updateStatus(Messages.NewJbpmProcessWizardPage1_Error_No_Container);
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus(Messages.NewJbpmProcessWizardPage1_Error_Invalid_Container);
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus(Messages.NewJbpmProcessWizardPage1_Error_Project_Readonly);
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus(Messages.NewJbpmProcessWizardPage1_Error_No_File_Name);
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus(Messages.NewJbpmProcessWizardPage1_Error_Invalid_File_Name);
            return;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1) {
            String ext = fileName.substring(dotLoc + 1);
            if (!ext.equalsIgnoreCase("bpmn") && !ext.equalsIgnoreCase("bpmn2")) {
                this.updateStatus(Messages.NewJbpmProcessWizardPage1_Error_Invalid_File_Extension);
                return;
            }
            if (((IContainer)container).findMember(fileName) != null) {
                this.updateStatus(NLS.bind((String)Messages.NewJbpmProcessWizardPage1_Error_File_Exists, (Object)fileName));
                return;
            }
        }
        if (!SyntaxCheckerUtils.isJavaPackageName((String)(packageName = this.packageText.getText()))) {
            this.updateStatus(Messages.NewJbpmProcessWizardPage1_Error_Package_Invalid);
            return;
        }
        String processId = this.processIdText.getText();
        if (!SyntaxCheckerUtils.isJavaPackageName((String)processId)) {
            this.updateStatus(Messages.NewJbpmProcessWizardPage1_Error_Process_ID_Invalid);
            return;
        }
        String runtimeId = null;
        if (container instanceof IProject && (prefs = Bpmn2Preferences.getInstance((IProject)((IProject)container))) != null) {
            TargetRuntime rt = prefs.getRuntime();
            runtimeId = rt.getId();
        }
        if ("org.jboss.runtime.jbpm5".equals(runtimeId)) {
            this.isJbpmRuntimeCheckbox.setSelection(true);
            this.isJbpmRuntimeCheckbox.setEnabled(false);
        } else {
            this.isJbpmRuntimeCheckbox.setSelection(true);
            this.isJbpmRuntimeCheckbox.setEnabled(true);
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public IProject getProject() {
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        if (container instanceof IProject) {
            return (IProject)container;
        }
        return null;
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public String getProcessName() {
        return this.nameText.getText();
    }

    public String getProcessId() {
        return this.processIdText.getText();
    }

    public String getPackageName() {
        return this.packageText.getText();
    }

    public boolean isSetJbpmRuntime() {
        return this.isJbpmRuntimeCheckbox.getSelection();
    }
}

