/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.wsil.ui.preferences;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.bpel.wsil.model.inspection.Inspection;
import org.eclipse.bpel.wsil.model.inspection.InspectionFactory;
import org.eclipse.bpel.wsil.model.inspection.Link;
import org.eclipse.bpel.wsil.model.inspection.TypeOfAbstract;
import org.eclipse.bpel.wsil.model.inspection.WSILDocument;
import org.eclipse.bpmn2.modeler.core.merrimac.providers.ColumnTableProvider;
import org.eclipse.bpmn2.modeler.core.merrimac.providers.TableCursor;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerResourceSetImpl;
import org.eclipse.bpmn2.modeler.ui.Activator;
import org.eclipse.bpmn2.modeler.wsil.Messages;
import org.eclipse.bpmn2.modeler.wsil.ui.providers.WSILContentProvider;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class WSILPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PREF_WSIL_URL = "wsil.url";
    Bpmn2ModelerResourceSetImpl resourceSet = new Bpmn2ModelerResourceSetImpl();
    Text wsilURL;
    Table linkTable;
    ColumnTableProvider tableProvider;
    TableViewer linkTableViewer;
    TableCursor tableCursor;
    Link fLinkSelection;
    WSILDocument fWsilDocument;
    Button addButton;
    Button removeButton;
    Button moveUpButton;
    Button moveDownButton;
    Button openInBrowserButton;
    private static String WSIL = "wsil";
    EContentAdapter fContentAdapter = new EContentAdapter(){

        public void notifyChanged(Notification arg0) {
            super.notifyChanged(arg0);
            int eventId = arg0.getEventType();
            if (eventId == 3 || eventId == 1 || eventId == 7 || eventId == 4) {
                WSILPreferencePage.this.linkTableViewer.refresh();
                WSILPreferencePage.this.updateButtons();
            }
        }
    };

    protected Control createContents(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 15;
        layout.makeColumnsEqualWidth = false;
        result.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        Label wsilLabel = new Label(result, 0);
        wsilLabel.setText(Messages.WSILPreferencePage_WSIL_Document_URL);
        wsilLabel.setLayoutData((Object)new GridData(32));
        this.wsilURL = new Text(result, 2048);
        this.wsilURL.setLayoutData((Object)new GridData(768));
        this.wsilURL.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                WSILPreferencePage.this.wsilURL.setData("lastValue", (Object)WSILPreferencePage.this.wsilURL.getText());
            }

            public void focusLost(FocusEvent e) {
                String url = WSILPreferencePage.this.wsilURL.getText();
                if (url.equals(WSILPreferencePage.this.wsilURL.getData("lastValue"))) {
                    return;
                }
                WSILPreferencePage.this.attemptLoad(url);
            }
        });
        Button browse = new Button(result, 0);
        browse.setText(Messages.WSILPreferencePage_WSIL_Browse_Button);
        data = new GridData(131072);
        data.widthHint = 100;
        browse.setLayoutData((Object)data);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(WSILPreferencePage.this.getShell(), 4096);
                fd.setFilterExtensions(new String[]{"*." + WSIL});
                String fileName = fd.open();
                if (fileName != null && fileName.length() > 0) {
                    File file = new File(fileName);
                    String uri = file.toURI().toString();
                    WSILPreferencePage.this.wsilURL.setText(uri);
                    WSILPreferencePage.this.attemptLoad(uri);
                }
            }
        });
        Label txt = new Label(result, 262208);
        txt.setText(Messages.WSILPreferencePage_WSIL_Description);
        data = new GridData(512);
        data.horizontalSpan = 3;
        txt.setLayoutData((Object)data);
        this.linkTable = new Table(result, 68096);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        this.linkTable.setLayoutData((Object)data);
        this.linkTable.setLinesVisible(true);
        this.linkTable.setHeaderVisible(true);
        this.tableProvider = new ColumnTableProvider();
        this.tableProvider.add((ColumnTableProvider.Column)new IndexColumn());
        this.tableProvider.add((ColumnTableProvider.Column)new AbstractColumn());
        this.tableProvider.add((ColumnTableProvider.Column)new LocationColumn());
        this.linkTableViewer = new TableViewer(this.linkTable);
        this.tableProvider.createTableLayout(this.linkTable);
        this.linkTableViewer.setLabelProvider((IBaseLabelProvider)this.tableProvider);
        this.linkTableViewer.setCellModifier((ICellModifier)this.tableProvider);
        WSILContentProvider wsilContentProvider = new WSILContentProvider();
        wsilContentProvider.setMode(1);
        this.linkTableViewer.setContentProvider((IContentProvider)wsilContentProvider);
        this.linkTableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof Link;
            }
        });
        this.linkTableViewer.setColumnProperties(this.tableProvider.getColumnProperties());
        this.linkTableViewer.setCellEditors(this.tableProvider.createCellEditors((Composite)this.linkTable));
        this.tableCursor = TableCursor.create((Table)this.linkTable, (TableViewer)this.linkTableViewer);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 5;
        Composite buttonList = new Composite(result, 0);
        buttonList.setLayout((Layout)layout);
        data = new GridData(66);
        buttonList.setLayoutData((Object)data);
        this.addButton = new Button(buttonList, 0);
        this.addButton.setText(Messages.WSILPreferencePage_WSIL_Add);
        data = new GridData(768);
        this.addButton.setLayoutData((Object)data);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Link link = InspectionFactory.eINSTANCE.createLink();
                link.setLocation(Messages.WSILPreferencePage_WSIL_EnterLocation);
                link.setReferencedNamespace("http://schemas.xmlsoap.org/ws/2001/10/inspection/");
                TypeOfAbstract toa = InspectionFactory.eINSTANCE.createTypeOfAbstract();
                toa.setValue(Messages.WSILPreferencePage_WSIL_EnterDescription);
                link.getAbstract().add((Object)toa);
                EList links = WSILPreferencePage.this.fWsilDocument.getInspection().getLinks();
                links.add((Object)link);
            }
        });
        this.removeButton = new Button(buttonList, 0);
        this.removeButton.setText(Messages.WSILPreferencePage_WSIL_Remove);
        data = new GridData(768);
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WSILPreferencePage.this.fLinkSelection == null) {
                    return;
                }
                EList links = WSILPreferencePage.this.fWsilDocument.getInspection().getLinks();
                links.remove((Object)WSILPreferencePage.this.fLinkSelection);
            }
        });
        this.moveUpButton = new Button(buttonList, 0);
        this.moveUpButton.setText(Messages.WSILPreferencePage_WSIL_MoveUp);
        data = new GridData(768);
        this.moveUpButton.setLayoutData((Object)data);
        this.moveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WSILPreferencePage.this.fLinkSelection == null) {
                    return;
                }
                EList links = WSILPreferencePage.this.fWsilDocument.getInspection().getLinks();
                int idx = links.indexOf((Object)WSILPreferencePage.this.fLinkSelection);
                if (idx < 0) {
                    return;
                }
                links.move(idx, idx - 1);
            }
        });
        this.moveDownButton = new Button(buttonList, 0);
        this.moveDownButton.setText(Messages.WSILPreferencePage_WSIL_MoveDown);
        data = new GridData(768);
        this.moveDownButton.setLayoutData((Object)data);
        this.moveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WSILPreferencePage.this.fLinkSelection == null) {
                    return;
                }
                EList links = WSILPreferencePage.this.fWsilDocument.getInspection().getLinks();
                int idx = links.indexOf((Object)WSILPreferencePage.this.fLinkSelection);
                if (idx < 0) {
                    return;
                }
                links.move(idx, idx + 1);
            }
        });
        this.openInBrowserButton = new Button(buttonList, 0);
        this.openInBrowserButton.setText(Messages.WSILPreferencePage_WSIL_OpenInBrowser);
        data = new GridData(768);
        this.openInBrowserButton.setLayoutData((Object)data);
        this.openInBrowserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WSILPreferencePage.this.fLinkSelection == null) {
                    return;
                }
            }
        });
        this.linkTableViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)selection;
                    Object obj = ss.getFirstElement();
                    WSILPreferencePage.this.fLinkSelection = obj instanceof Link ? (Link)obj : null;
                }
                WSILPreferencePage.this.updateButtons();
            }
        });
        this.updateButtons();
        this.initializeValues();
        return result;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        return true;
    }

    protected void performApply() {
        this.performOk();
    }

    private void initializeDefaults() {
    }

    private void initializeValues() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.wsilURL.setText(store.getString(PREF_WSIL_URL));
        this.attemptLoad(this.wsilURL.getText());
    }

    private void storeValues() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        store.setValue(PREF_WSIL_URL, this.wsilURL.getText());
        if (this.fWsilDocument != null) {
            Resource resource = this.fWsilDocument.eResource();
            try {
                resource.save(null);
            }
            catch (IOException e) {
                Activator.logError((Exception)e);
            }
        }
    }

    void updateButtons() {
        List linkList = this.fWsilDocument == null ? Collections.EMPTY_LIST : this.fWsilDocument.getInspection().getLinks();
        int idx = linkList.indexOf(this.fLinkSelection);
        this.moveUpButton.setEnabled(idx > 0);
        this.moveDownButton.setEnabled(idx >= 0 && idx < linkList.size() - 1);
        this.removeButton.setEnabled(this.fLinkSelection != null);
        this.openInBrowserButton.setEnabled(this.fLinkSelection != null);
        this.addButton.setEnabled(this.fWsilDocument != null);
    }

    public void dispose() {
        for (Resource r : this.resourceSet.getResources()) {
            r.eAdapters().clear();
        }
        super.dispose();
    }

    void attemptLoad(String url) {
        if ((url = url.trim()).length() < 1) {
            return;
        }
        if (!url.endsWith(WSIL)) {
            this.setMessage(Messages.WSILPreferencePage_WSIL_NameLimit, 3);
            return;
        }
        if (this.fWsilDocument != null) {
            this.fWsilDocument.eResource().eAdapters().remove((Object)this.fContentAdapter);
            this.fWsilDocument = null;
        }
        URI uri = URI.createURI((String)url);
        Resource resource = null;
        try {
            resource = this.resourceSet.getResource(uri, true, WSIL);
            EList contents = resource.getContents();
            if (contents.size() > 0 && contents.get(0) instanceof WSILDocument) {
                this.fWsilDocument = (WSILDocument)contents.get(0);
            }
            this.setMessage(null);
        }
        catch (Exception e) {
            this.setMessage(Messages.WSILPreferencePage_WSIL_DocumentNotLoaded, 3);
            Activator.logError((Exception)e);
        }
        this.linkTableViewer.setInput((Object)this.fWsilDocument);
        if (this.fWsilDocument != null) {
            this.fWsilDocument.eResource().eAdapters().add((Object)this.fContentAdapter);
        }
        this.updateButtons();
    }

    public class AbstractColumn
    extends ColumnTableProvider.Column
    implements ILabelProvider,
    ICellModifier {
        public String getHeaderText() {
            return Messages.WSILPreferencePage_WSIL_Abstract;
        }

        public String getProperty() {
            return "abstract";
        }

        public int getInitialWeight() {
            return 50;
        }

        public String getText(Object element) {
            Link link;
            EList abs;
            if (element instanceof Link && (abs = (link = (Link)element).getAbstract()).size() > 0) {
                TypeOfAbstract absType = (TypeOfAbstract)abs.get(0);
                return absType.getValue();
            }
            return "";
        }

        public CellEditor createCellEditor(Composite parent) {
            return new TextCellEditor(parent, 262144);
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            return this.getText(element);
        }

        public void modify(Object element, String property, Object value) {
            Link link;
            EList abs;
            if (element instanceof Link && (abs = (link = (Link)element).getAbstract()).size() > 0) {
                TypeOfAbstract absType = (TypeOfAbstract)abs.get(0);
                if (value.equals(absType.getValue())) {
                    return;
                }
                absType.setValue((String)value);
            }
        }
    }

    public class IndexColumn
    extends ColumnTableProvider.Column
    implements ILabelProvider {
        public String getHeaderText() {
            return Messages.WSILPreferencePage_WSIL_Index;
        }

        public String getProperty() {
            return "index";
        }

        public int getInitialWeight() {
            return 5;
        }

        public String getText(Object element) {
            if (element instanceof Link) {
                Link link = (Link)element;
                Inspection insp = (Inspection)link.eContainer();
                return Integer.toString(insp.getLinks().indexOf((Object)link) + 1);
            }
            return "";
        }
    }

    public class LocationColumn
    extends ColumnTableProvider.Column
    implements ILabelProvider,
    ICellModifier {
        public String getHeaderText() {
            return Messages.WSILPreferencePage_WSIL_Location;
        }

        public String getProperty() {
            return "location";
        }

        public int getInitialWeight() {
            return 50;
        }

        public String getText(Object element) {
            if (element instanceof Link) {
                Link link = (Link)element;
                return link.getLocation();
            }
            return "";
        }

        public CellEditor createCellEditor(Composite parent) {
            return new TextCellEditor(parent, 262144);
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            return this.getText(element);
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof Link) {
                Link link = (Link)element;
                if (value.equals(link.getLocation())) {
                    return;
                }
                URI linkURI = null;
                try {
                    linkURI = URI.createURI((String)((String)value));
                    if (linkURI.isRelative()) {
                        URI parentURI = link.eResource().getURI();
                        linkURI = linkURI.resolve(parentURI);
                    }
                    link.setLocation((String)value);
                    WSILPreferencePage.this.setMessage(null);
                }
                catch (IllegalArgumentException ex) {
                    WSILPreferencePage.this.setMessage(ex.getLocalizedMessage(), 3);
                }
            }
        }
    }

    public class NamespaceColumn
    extends ColumnTableProvider.Column
    implements ILabelProvider {
        public String getHeaderText() {
            return Messages.WSILPreferencePage_WSIL_Namespace;
        }

        public String getProperty() {
            return "namespace";
        }

        public int getInitialWeight() {
            return 30;
        }

        public String getText(Object element) {
            if (element instanceof Link) {
                Link link = (Link)element;
                return link.getReferencedNamespace();
            }
            return "";
        }
    }
}

