/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.util.progress;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.buildship.core.AggregateException;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.util.progress.ToolingApiCommand;
import org.eclipse.buildship.core.util.string.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.gradle.tooling.BuildCancelledException;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.GradleConnectionException;

public final class ToolingApiInvoker {
    private final String workName;
    private final boolean notifyUserAboutBuildFailures;

    public ToolingApiInvoker(String workName, boolean notifyUserAboutBuildFailures) {
        this.workName = (String)Preconditions.checkNotNull((Object)workName);
        this.notifyUserAboutBuildFailures = notifyUserAboutBuildFailures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus invoke(ToolingApiCommand command, IProgressMonitor progressMonitor) {
        try {
            command.run();
            IStatus iStatus = this.handleSuccess();
            return iStatus;
        }
        catch (BuildCancelledException e) {
            IStatus iStatus = this.handleBuildCancelled(e);
            return iStatus;
        }
        catch (BuildException e) {
            IStatus iStatus = this.handleBuildFailed(e);
            return iStatus;
        }
        catch (GradleConnectionException e) {
            IStatus iStatus = this.handleGradleConnectionFailed(e);
            return iStatus;
        }
        catch (GradlePluginsRuntimeException e) {
            IStatus iStatus = this.handlePluginFailed(e);
            return iStatus;
        }
        catch (AggregateException e) {
            IStatus iStatus = this.handleMultiException(e);
            return iStatus;
        }
        catch (Throwable t) {
            IStatus iStatus = this.handleUnknownFailed(t);
            return iStatus;
        }
        finally {
            progressMonitor.done();
        }
    }

    private IStatus handleSuccess() {
        String message = String.format("%s succeeded.", this.workName);
        CorePlugin.logger().info(message);
        return Status.OK_STATUS;
    }

    private IStatus handleBuildCancelled(BuildCancelledException e) {
        String message = String.format("%s cancelled.", this.workName);
        CorePlugin.logger().info(message, e);
        return ToolingApiInvoker.createCancelStatus(message, e);
    }

    private IStatus handleBuildFailed(BuildException e) {
        String message = String.format("%s failed due to an error in the referenced Gradle build.", this.workName);
        CorePlugin.logger().warn(message, e);
        if (this.shouldSendUserNotification(e)) {
            CorePlugin.userNotification().errorOccurred(String.format("%s failed", this.workName), message, this.collectErrorMessages(e), 2, e);
        }
        return ToolingApiInvoker.createInfoStatus(message, e);
    }

    private IStatus handleGradleConnectionFailed(GradleConnectionException e) {
        String message = String.format("%s failed due to an error connecting to the Gradle build.", this.workName);
        CorePlugin.logger().warn(message, e);
        if (this.shouldSendUserNotification(e)) {
            CorePlugin.userNotification().errorOccurred(String.format("%s failed", this.workName), message, this.collectErrorMessages(e), 2, e);
        }
        return ToolingApiInvoker.createInfoStatus(message, e);
    }

    private IStatus handlePluginFailed(GradlePluginsRuntimeException e) {
        String message = String.format("%s failed due to an error configuring Eclipse.", this.workName);
        CorePlugin.logger().error(message, e);
        if (this.shouldSendUserNotification(e)) {
            CorePlugin.userNotification().errorOccurred(String.format("%s failed", this.workName), message, this.collectErrorMessages(e), 4, e);
        }
        return ToolingApiInvoker.createInfoStatus(message, e);
    }

    private IStatus handleUnknownFailed(Throwable t) {
        String message = String.format("%s failed due to an unexpected error.", this.workName);
        CorePlugin.logger().error(message, t);
        if (this.shouldSendUserNotification(t)) {
            CorePlugin.userNotification().errorOccurred(String.format("%s failed", this.workName), message, this.collectErrorMessages(t), 4, t);
        }
        return ToolingApiInvoker.createInfoStatus(message, t);
    }

    private IStatus handleMultiException(AggregateException e) {
        String message = String.format("%s failed due to multiple errors.", this.workName);
        for (Throwable t : e.getCauses()) {
            CorePlugin.logger().error(message, t);
        }
        Optional firstError = FluentIterable.from(e.getCauses()).firstMatch((Predicate)new Predicate<Throwable>(){

            public boolean apply(Throwable t) {
                return ToolingApiInvoker.this.shouldSendUserNotification(t);
            }
        });
        if (firstError.isPresent()) {
            CorePlugin.userNotification().errorOccurred(String.format("%s failed", this.workName), message, this.collectErrorMessages((Throwable)firstError.get()), 4, (Throwable)firstError.get());
        }
        return ToolingApiInvoker.createInfoStatus(message, e);
    }

    private boolean shouldSendUserNotification(Throwable t) {
        if (t instanceof BuildCancelledException) {
            return false;
        }
        if (t instanceof BuildException) {
            return this.notifyUserAboutBuildFailures;
        }
        return true;
    }

    private String collectErrorMessages(Throwable t) {
        ArrayList messages = Lists.newArrayList();
        Throwable cause = t.getCause();
        if (cause != null) {
            this.collectCausesRecursively(cause, messages);
        }
        String messageStack = Joiner.on((char)'\n').join(StringUtils.removeAdjacentDuplicates(messages));
        return t.getMessage() + (messageStack.isEmpty() ? "" : "\n\n" + messageStack);
    }

    private void collectCausesRecursively(Throwable t, List<String> messages) {
        List singleLineMessages = Splitter.on((char)'\n').omitEmptyStrings().splitToList((CharSequence)Strings.nullToEmpty((String)t.getMessage()));
        messages.addAll(singleLineMessages);
        Throwable cause = t.getCause();
        if (cause != null) {
            this.collectCausesRecursively(cause, messages);
        }
    }

    private static Status createInfoStatus(String message, Throwable t) {
        return new Status(1, "org.eclipse.buildship.core", message, t);
    }

    private static Status createCancelStatus(String message, BuildCancelledException e) {
        return new Status(8, "org.eclipse.buildship.core", message, (Throwable)e);
    }
}

