/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.databinding.ObservablesManager;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.tools.emf.ui.common.AbstractElementEditorContribution;
import org.eclipse.e4.tools.emf.ui.common.IContributionClassCreator;
import org.eclipse.e4.tools.emf.ui.common.IEditorDescriptor;
import org.eclipse.e4.tools.emf.ui.common.IEditorFeature;
import org.eclipse.e4.tools.emf.ui.common.IExtensionLookup;
import org.eclipse.e4.tools.emf.ui.common.IModelExtractor;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.tools.emf.ui.common.IScriptingSupport;
import org.eclipse.e4.tools.emf.ui.common.MemoryTransfer;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.PatternFilter;
import org.eclipse.e4.tools.emf.ui.internal.common.ComponentLabelProvider;
import org.eclipse.e4.tools.emf.ui.internal.common.ControlHighlighter;
import org.eclipse.e4.tools.emf.ui.internal.common.TreeViewerEx;
import org.eclipse.e4.tools.emf.ui.internal.common.VirtualEntry;
import org.eclipse.e4.tools.emf.ui.internal.common.component.AddonsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ApplicationEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.AreaEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.BindingContextEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.BindingTableEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.CategoryEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.CommandEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.CommandParameterEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.CompositePartEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.CoreExpressionEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.DefaultEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.DialogEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.DirectMenuItemEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.DirectToolItemEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.DynamicMenuContributionEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.HandledMenuItemEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.HandledToolItemEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.HandlerEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.KeyBindingEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.MenuContributionEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.MenuEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.MenuSeparatorEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ModelFragmentsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ParameterEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PartDescriptorEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PartEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PartSashContainerEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PartStackEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PerspectiveEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PerspectiveStackEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PlaceholderEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PopupMenuEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.StringModelFragment;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ToolBarContributionEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ToolBarEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ToolBarSeparatorEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ToolControlEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.TrimBarEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.TrimContributionEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.TrimmedWindowEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.WindowEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.WizardDialogEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.EmfUtil;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.IGotoObject;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.ListTab;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.XmiTab;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VApplicationAddons;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VApplicationCategoriesEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VApplicationWindowEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VBindingTableEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VCommandEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VHandlerEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VItemParametersEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VMenuContributionsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VModelFragmentsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VModelImportsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VPartDescriptor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VPartDescriptorMenuEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VPartMenuEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VPerspectiveControlEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VPerspectiveWindowsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VRootBindingContexts;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VSnippetsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VToolBarContributionsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VTrimContributionsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VWindowControlEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VWindowSharedElementsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VWindowTrimEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VWindowWindowsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.properties.ExportIdsHandler;
import org.eclipse.e4.tools.emf.ui.internal.common.properties.ExternalizeStringHandler;
import org.eclipse.e4.tools.emf.ui.internal.common.properties.ProjectOSGiTranslationProvider;
import org.eclipse.e4.tools.emf.ui.internal.common.xml.EMFDocumentResourceMediator;
import org.eclipse.e4.tools.services.IClipboardService;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.PersistState;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsPackageImpl;
import org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicPackageImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedPackageImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuPackageImpl;
import org.eclipse.e4.ui.model.fragment.MModelFragments;
import org.eclipse.e4.ui.model.fragment.impl.FragmentPackageImpl;
import org.eclipse.e4.ui.model.internal.ModelUtils;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.swt.internal.copy.FilteredTree;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.IEMFProperty;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeAdapter;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

public class ModelEditor
implements IGotoObject {
    private static final String ORG_ECLIPSE_E4_TOOLS_MODELEDITOR_FILTEREDTREE_ENABLED_XMITAB_DISABLED = "org.eclipse.e4.tools.modeleditor.filteredtree.enabled.xmitab.disabled";
    public static final String CSS_CLASS_KEY = "org.eclipse.e4.ui.css.CssClassName";
    public static final String VIRTUAL_PART_MENU = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_PART_MENU";
    public static final String VIRTUAL_HANDLER = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_HANDLER";
    public static final String VIRTUAL_BINDING_TABLE = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_BINDING_TABLE";
    public static final String VIRTUAL_COMMAND = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_COMMAND";
    public static final String VIRTUAL_APPLICATION_WINDOWS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_APPLICATION_WINDOWS";
    public static final String VIRTUAL_PERSPECTIVE_WINDOWS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_PERSPECTIVE_WINDOWS";
    public static final String VIRTUAL_WINDOW_WINDOWS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_WINDOW_WINDOWS";
    public static final String VIRTUAL_WINDOW_CONTROLS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_WINDOW_CONTROLS";
    public static final String VIRTUAL_PART_DESCRIPTORS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_PART_DESCRIPTORS";
    public static final String VIRTUAL_PARTDESCRIPTOR_MENU = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_PARTDESCRIPTOR_MENU";
    public static final String VIRTUAL_TRIMMED_WINDOW_TRIMS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_TRIMMED_WINDOW_TRIMS";
    public static final String VIRTUAL_ADDONS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_ADDONS";
    public static final String VIRTUAL_MENU_CONTRIBUTIONS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_MENU_CONTRIBUTIONS";
    public static final String VIRTUAL_TOOLBAR_CONTRIBUTIONS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_TOOLBAR_CONTRIBUTIONS";
    public static final String VIRTUAL_TRIM_CONTRIBUTIONS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_TRIM_CONTRIBUTIONS";
    public static final String VIRTUAL_WINDOW_SHARED_ELEMENTS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_WINDOW_SHARED_ELEMENTS";
    public static final String VIRTUAL_MODEL_FRAGEMENTS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_MODEL_FRAGEMENTS";
    public static final String VIRTUAL_MODEL_IMPORTS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_MODEL_IMPORTS";
    public static final String VIRTUAL_CATEGORIES = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_CATEGORIES";
    public static final String VIRTUAL_PARAMETERS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_PARAMETERS";
    public static final String VIRTUAL_MENUELEMENTS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_MENUELEMENTS";
    public static final String VIRTUAL_ROOT_CONTEXTS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_ROOT_CONTEXTS";
    public static final String VIRTUAL_PERSPECTIVE_CONTROLS = String.valueOf(ModelEditor.class.getName()) + "VIRTUAL_PERSPECTIVE_CONTROLS";
    public static final String VIRTUAL_SNIPPETS = String.valueOf(ModelEditor.class.getName()) + "VIRTUAL_SNIPPETS";
    public static final int TAB_FORM = 0;
    public static final int TAB_XMI = 1;
    public static final int TAB_LIST = 2;
    private final Map<EClass, AbstractComponentEditor> editorMap = new HashMap<EClass, AbstractComponentEditor>();
    private final Map<String, AbstractComponentEditor> virtualEditors = new HashMap<String, AbstractComponentEditor>();
    private final Map<Class<?>, List<AbstractElementEditorContribution>> tabContributions = new HashMap();
    private final List<FeaturePath> labelFeaturePaths = new ArrayList<FeaturePath>();
    private final List<IEditorFeature> editorFeatures = new ArrayList<IEditorFeature>();
    private final List<IContributionClassCreator> contributionCreator = new ArrayList<IContributionClassCreator>();
    private TreeViewer viewer;
    private final IModelResource modelProvider;
    private final IProject project;
    private final ImageRegistry componentImages = new ImageRegistry();
    @Inject
    ESelectionService selectionService;
    @Inject
    MApplication app;
    private final IEclipseContext context;
    private boolean fragment;
    private IClipboardService.Handler clipboardHandler;
    @Inject
    @Optional
    private IClipboardService clipboardService;
    @Inject
    @Preference(nodePath="org.eclipse.e4.tools.emf.ui", value="autoCreateElementId")
    private boolean autoCreateElementId;
    @Inject
    @Preference(nodePath="org.eclipse.e4.tools.emf.ui", value="showXMIId")
    private boolean showXMIId;
    @Inject
    @Preference(nodePath="org.eclipse.e4.tools.emf.ui")
    IEclipsePreferences preferences;
    @Inject
    @Optional
    private IExtensionLookup extensionLookup;
    @Inject
    @Translation
    private Messages messages;
    @Inject
    @Optional
    private IModelExtractor modelExtractor;
    private final ObservablesManager obsManager;
    private final IResourcePool resourcePool;
    private EMFDocumentResourceMediator emfDocumentProvider;
    private AbstractComponentEditor currentEditor;
    private Listener keyListener;
    private CTabFolder editorTabFolder;
    private boolean mod1Down = false;
    private boolean saving;
    private ListTab listTab;
    private CTabItem tabItemXmi;
    private CTabItem tabItemList;
    private CTabItem tabItemTree;
    private XmiTab xmiTab;

    public ModelEditor(Composite composite, IEclipseContext context, IModelResource modelProvider, IProject project, IResourcePool resourcePool) {
        this.resourcePool = resourcePool;
        this.modelProvider = modelProvider;
        this.project = project;
        this.context = context;
        this.context.set(ModelEditor.class, (Object)this);
        this.obsManager = new ObservablesManager();
        if (project != null) {
            String localeString = "";
            Object object = this.context.get("org.eclipse.e4.core.locale");
            if (object != null) {
                localeString = object.toString();
            }
            ProjectOSGiTranslationProvider translationProvider = new ProjectOSGiTranslationProvider(project, localeString){

                @Override
                protected void updateResourceBundle() {
                    super.updateResourceBundle();
                    if (ModelEditor.this.viewer != null) {
                        ModelEditor.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ModelEditor.this.viewer.refresh();
                            }
                        });
                    }
                }
            };
            context.set(ProjectOSGiTranslationProvider.class, (Object)translationProvider);
        }
        this.labelFeaturePaths.add(FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{UiPackageImpl.Literals.UI_ELEMENT__TO_BE_RENDERED}));
        this.labelFeaturePaths.add(FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{UiPackageImpl.Literals.UI_ELEMENT__VISIBLE}));
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                ModelEditor.this.persistState();
            }
        });
    }

    @PersistState
    protected void persistState() {
        if (this.listTab != null) {
            this.listTab.saveSettings();
        }
    }

    @PostConstruct
    void postCreate(Composite composite) {
        if (this.project == null) {
            this.keyListener = new Listener(){

                public void handleEvent(Event event) {
                    if ((event.stateMask & 0x10000) == 65536) {
                        ModelEditor.this.findAndHighlight(((Display)ModelEditor.this.context.get(Display.class)).getFocusControl());
                    }
                }
            };
            ((Display)this.context.get(Display.class)).addFilter(4, this.keyListener);
        }
        this.context.set(ModelEditor.class, (Object)this);
        this.context.set(IResourcePool.class, (Object)this.resourcePool);
        this.context.set(EditingDomain.class, (Object)this.modelProvider.getEditingDomain());
        this.context.set(IModelResource.class, (Object)this.modelProvider);
        if (this.project != null) {
            this.context.set(IProject.class, (Object)this.project);
        }
        this.loadEditorFeatures();
        this.registerDefaultEditors();
        this.registerVirtualEditors();
        this.registerContributedEditors();
        this.registerContributedVirtualEditors();
        this.registerContributedEditorTabs();
        this.loadContributionCreators();
        this.fragment = this.modelProvider.getRoot().get(0) instanceof MModelFragments;
        this.emfDocumentProvider = new EMFDocumentResourceMediator(this.modelProvider);
        this.editorTabFolder = new CTabFolder(composite, 1024);
        this.tabItemTree = new CTabItem(this.editorTabFolder, 0);
        this.tabItemTree.setText(this.messages.ModelEditor_Form);
        this.tabItemTree.setControl((Control)this.createFormTab((Composite)this.editorTabFolder));
        this.tabItemTree.setImage(this.resourcePool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.obj16.application_form"));
        this.tab_list_show(true);
        this.tabItemXmi = new CTabItem(this.editorTabFolder, 0);
        this.tabItemXmi.setText(this.messages.ModelEditor_XMI);
        this.xmiTab = this.createXMITab((Composite)this.editorTabFolder);
        this.tabItemXmi.setControl((Control)this.xmiTab);
        this.tabItemXmi.setImage(this.resourcePool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.obj16.chart_organisation"));
        this.editorTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ModelEditor.this.editorTabFolder.getSelectionIndex() == ModelEditor.getTabIndex(ModelEditor.this.tabItemXmi)) {
                    ModelEditor.this.emfDocumentProvider.updateFromEMF();
                }
            }
        });
        this.editorTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ModelEditor.this.listTab != null && ModelEditor.this.editorTabFolder.getSelectionIndex() == ModelEditor.getTabIndex(ModelEditor.this.listTab.getTabItem())) {
                    ModelEditor.this.app.getContext().set("org.eclipse.e4.tools.active-object-viewer", (Object)ModelEditor.this.listTab);
                } else {
                    ModelEditor.this.app.getContext().set("org.eclipse.e4.tools.active-object-viewer", null);
                }
            }
        });
        this.editorTabFolder.setSelection(0);
    }

    public static int getTabIndex(CTabItem tabItem) {
        return Arrays.asList(tabItem.getParent().getItems()).indexOf(tabItem);
    }

    private void findAndHighlight(Control control) {
        if (control != null) {
            MApplicationElement m;
            MApplicationElement o = m = this.findModelElement(control);
            if (m != null) {
                ArrayList<MApplicationElement> l = new ArrayList<MApplicationElement>();
                do {
                    l.add(m);
                } while ((m = (MApplicationElement)((EObject)m).eContainer()) != null);
                if (o instanceof MPart) {
                    System.err.println(String.valueOf(this.getClass().getName()) + ".findAndHighLight: " + o);
                    System.err.println(String.valueOf(this.getClass().getName()) + ".findAndHighLight: " + ((EObject)o).eContainingFeature());
                }
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)o));
            }
        }
    }

    private MApplicationElement findModelElement(Control control) {
        do {
            if (control.getData("modelElement") == null) continue;
            return (MApplicationElement)control.getData("modelElement");
        } while ((control = control.getParent()) != null);
        return null;
    }

    private XmiTab createXMITab(Composite composite) {
        IEclipseContext childContext = this.context.createChild();
        childContext.set(Composite.class, (Object)composite);
        childContext.set(EMFDocumentResourceMediator.class, (Object)this.emfDocumentProvider);
        childContext.set(IEclipsePreferences.class, (Object)this.preferences);
        childContext.set(IResourcePool.class, (Object)this.resourcePool);
        XmiTab ret = (XmiTab)((Object)ContextInjectionFactory.make(XmiTab.class, (IEclipseContext)childContext));
        return ret;
    }

    private Composite createFormTab(Composite composite) {
        SashForm form = new SashForm(composite, 256);
        form.setBackground(form.getDisplay().getSystemColor(1));
        this.viewer = this.createTreeViewerArea((Composite)form);
        Composite parent = new Composite((Composite)form, 0);
        FillLayout l = new FillLayout();
        parent.setLayout((Layout)l);
        Composite editingArea = new Composite(parent, 2048);
        GridLayout gl = new GridLayout();
        editingArea.setLayout((Layout)gl);
        Composite headerContainer = new Composite(editingArea, 0);
        headerContainer.setLayout((Layout)new GridLayout(3, false));
        headerContainer.setLayoutData((Object)new GridData(768));
        final Label iconLabel = new Label(headerContainer, 0);
        iconLabel.setLayoutData((Object)new GridData(20, 20));
        final Label sectionHeaderLabel = new Label(headerContainer, 0);
        sectionHeaderLabel.setLayoutData((Object)new GridData(768));
        Label separatorLabel = new Label(headerContainer, 258);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        separatorLabel.setLayoutData((Object)gridData);
        final StackLayout layout = new StackLayout();
        final Composite contentContainer = new Composite(editingArea, 0);
        contentContainer.setLayoutData((Object)new GridData(1808));
        contentContainer.setLayout((Layout)layout);
        this.viewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    Command cmd;
                    ArrayList<EObject> list = new ArrayList<EObject>();
                    IStructuredSelection selection = (IStructuredSelection)ModelEditor.this.viewer.getSelection();
                    for (Object o : ((StructuredSelection)selection).toList()) {
                        if (!(o instanceof EObject)) continue;
                        list.add((EObject)o);
                    }
                    if (!list.isEmpty() && (cmd = DeleteCommand.create((EditingDomain)ModelEditor.this.modelProvider.getEditingDomain(), list)).canExecute()) {
                        ModelEditor.this.modelProvider.getEditingDomain().getCommandStack().execute(cmd);
                    }
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    final IStructuredSelection s = (IStructuredSelection)event.getSelection();
                    if (s.getFirstElement() instanceof EObject) {
                        EObject obj = (EObject)s.getFirstElement();
                        final AbstractComponentEditor editor = ModelEditor.this.getEditor(obj.eClass());
                        if (editor != null) {
                            ModelEditor.this.currentEditor = editor;
                            sectionHeaderLabel.setText(editor.getLabel(obj));
                            iconLabel.setImage(editor.getImage(obj));
                            ModelEditor.this.obsManager.runAndCollect(new Runnable(){

                                @Override
                                public void run() {
                                    Composite comp = editor.getEditor(contentContainer, s.getFirstElement());
                                    comp.setBackgroundMode(1);
                                    layout.topControl = comp;
                                    contentContainer.layout(true);
                                }
                            });
                        }
                    } else {
                        VirtualEntry entry = (VirtualEntry)s.getFirstElement();
                        final AbstractComponentEditor editor = (AbstractComponentEditor)ModelEditor.this.virtualEditors.get(entry.getId());
                        if (editor != null) {
                            ModelEditor.this.currentEditor = editor;
                            sectionHeaderLabel.setText(editor.getLabel(entry));
                            iconLabel.setImage(editor.getImage(entry));
                            ModelEditor.this.obsManager.runAndCollect(new Runnable(){

                                @Override
                                public void run() {
                                    Composite comp = editor.getEditor(contentContainer, s.getFirstElement());
                                    comp.setBackgroundMode(1);
                                    layout.topControl = comp;
                                    contentContainer.layout(true);
                                }
                            });
                        }
                    }
                    if (ModelEditor.this.selectionService != null) {
                        ModelEditor.this.selectionService.setSelection(s.getFirstElement());
                    }
                }
            }
        });
        form.setWeights(new int[]{3, 4});
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IExtensionRegistry registry;
                IExtensionPoint extPoint;
                IConfigurationElement[] elements;
                final IStructuredSelection s = (IStructuredSelection)ModelEditor.this.viewer.getSelection();
                final List listOfSelections = s.toList();
                int noSelected = listOfSelections.size();
                boolean addSeparator = false;
                if (!s.isEmpty() && noSelected == 1) {
                    List<Action> actions;
                    if (s.getFirstElement() instanceof VirtualEntry) {
                        actions = ((AbstractComponentEditor)ModelEditor.this.virtualEditors.get(((VirtualEntry)s.getFirstElement()).getId())).getActions(s.getFirstElement());
                        if (actions.size() > 0) {
                            MenuManager addMenu = new MenuManager(((ModelEditor)ModelEditor.this).messages.ModelEditor_AddChild);
                            for (Action a : actions) {
                                addSeparator = true;
                                addMenu.add((IAction)a);
                            }
                            manager.add((IContributionItem)addMenu);
                        }
                        if ((actions = ((AbstractComponentEditor)ModelEditor.this.virtualEditors.get(((VirtualEntry)s.getFirstElement()).getId())).getActionsImport(s.getFirstElement())).size() > 0) {
                            MenuManager menu = new MenuManager(((ModelEditor)ModelEditor.this).messages.ModelEditor_Import3x);
                            for (Action a : actions) {
                                addSeparator = true;
                                menu.add((IAction)a);
                            }
                            manager.add((IContributionItem)menu);
                        }
                        if (addSeparator) {
                            manager.add((IContributionItem)new Separator());
                        }
                    } else {
                        final EObject o = (EObject)s.getFirstElement();
                        AbstractComponentEditor editor = ModelEditor.this.getEditor(o.eClass());
                        actions = editor != null ? new ArrayList<Action>(editor.getActions(s.getFirstElement())) : new ArrayList<Action>();
                        if (actions.size() > 0) {
                            MenuManager addMenu = new MenuManager(((ModelEditor)ModelEditor.this).messages.ModelEditor_AddChild);
                            for (Action a : actions) {
                                addSeparator = true;
                                addMenu.add((IAction)a);
                            }
                            manager.add((IContributionItem)addMenu);
                        }
                        if ((actions = editor != null ? new ArrayList<Action>(editor.getActionsImport(s.getFirstElement())) : new ArrayList<Action>()).size() > 0) {
                            MenuManager menu = new MenuManager(((ModelEditor)ModelEditor.this).messages.ModelEditor_Import3x);
                            for (Action a : actions) {
                                addSeparator = true;
                                menu.add((IAction)a);
                            }
                            manager.add((IContributionItem)menu);
                        }
                        if (o.eContainer() != null) {
                            addSeparator = true;
                            manager.add((IAction)new Action(((ModelEditor)ModelEditor.this).messages.ModelEditor_Delete, ImageDescriptor.createFromImage((Image)ModelEditor.this.resourcePool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.obj16.cross"))){

                                public void run() {
                                    Command cmd = DeleteCommand.create((EditingDomain)ModelEditor.this.modelProvider.getEditingDomain(), (Object)o);
                                    if (cmd.canExecute()) {
                                        ModelEditor.this.modelProvider.getEditingDomain().getCommandStack().execute(cmd);
                                    }
                                }
                            });
                        }
                    }
                }
                if (noSelected > 0 && !ModelEditor.this.isModelFragment() && ModelEditor.this.modelExtractor != null) {
                    manager.add((IAction)new Action(((ModelEditor)ModelEditor.this).messages.ModelEditor_ExtractFragment, ImageDescriptor.createFromImage((Image)ModelEditor.this.resourcePool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.modelelements.ModelFragments"))){

                        public void run() {
                            Command cmd;
                            ArrayList<MApplicationElement> maes = new ArrayList<MApplicationElement>();
                            for (Object objSelect : listOfSelections) {
                                EObject container = null;
                                if (objSelect instanceof VirtualEntry) {
                                    VirtualEntry ve = (VirtualEntry)objSelect;
                                    container = (EObject)ve.getOriginalParent();
                                    IObservableList list = ve.getList();
                                    Iterator iterator = list.iterator();
                                    while (iterator.hasNext()) {
                                        maes.add((MApplicationElement)iterator.next());
                                    }
                                } else {
                                    container = ((EObject)objSelect).eContainer();
                                    MApplicationElement objSelect2 = (MApplicationElement)objSelect;
                                    if (!(objSelect2 instanceof MApplication)) {
                                        maes.add(objSelect2);
                                    } else {
                                        return;
                                    }
                                }
                                String containerId = ((MApplicationElement)container).getElementId();
                                if (containerId != null && containerId.length() != 0) continue;
                                MessageDialog.openError((Shell)ModelEditor.this.viewer.getControl().getShell(), null, (String)((ModelEditor)(this).ModelEditor.this).messages.ModelEditor_ExtractFragment_NoParentId);
                                return;
                            }
                            if (ModelEditor.this.modelExtractor.extract(ModelEditor.this.viewer.getControl().getShell(), ModelEditor.this.project, maes) && (cmd = DeleteCommand.create((EditingDomain)ModelEditor.this.modelProvider.getEditingDomain(), maes)).canExecute()) {
                                ModelEditor.this.modelProvider.getEditingDomain().getCommandStack().execute(cmd);
                            }
                        }
                    });
                }
                if ((elements = (extPoint = (registry = RegistryFactory.getRegistry()).getExtensionPoint("org.eclipse.e4.tools.emf.ui.scripting")).getConfigurationElements()).length > 0 && !s.isEmpty() && s.getFirstElement() instanceof MApplicationElement && noSelected == 1) {
                    if (addSeparator) {
                        manager.add((IContributionItem)new Separator());
                    }
                    addSeparator = false;
                    MenuManager scriptExecute = new MenuManager(((ModelEditor)ModelEditor.this).messages.ModelEditor_Script);
                    manager.add((IContributionItem)scriptExecute);
                    IConfigurationElement[] iConfigurationElementArray = elements;
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement e;
                        final IConfigurationElement le = e = iConfigurationElementArray[n2];
                        scriptExecute.add((IAction)new Action(e.getAttribute("label")){

                            public void run() {
                                try {
                                    MApplicationElement o = (MApplicationElement)s.getFirstElement();
                                    IScriptingSupport support = (IScriptingSupport)le.createExecutableExtension("class");
                                    IEclipseContext ctx = null;
                                    if (ModelEditor.this.project == null) {
                                        ctx = o instanceof MContext ? ((MContext)o).getContext() : ModelUtils.getContainingContext((MApplicationElement)o);
                                    }
                                    support.openEditor(ModelEditor.this.viewer.getControl().getShell(), s.getFirstElement(), ctx);
                                }
                                catch (CoreException e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                        ++n2;
                    }
                }
                if (ModelEditor.this.project != null) {
                    if (addSeparator) {
                        manager.add((IContributionItem)new Separator());
                    }
                    Action nlsAction = new Action(((ModelEditor)ModelEditor.this).messages.ModelEditor_ExternalizeStrings){

                        public void run() {
                            ExternalizeStringHandler h = (ExternalizeStringHandler)ContextInjectionFactory.make(ExternalizeStringHandler.class, (IEclipseContext)ModelEditor.this.context);
                            ContextInjectionFactory.invoke((Object)h, Execute.class, (IEclipseContext)ModelEditor.this.context);
                        }
                    };
                    Action extIdAction = new Action(((ModelEditor)ModelEditor.this).messages.ModelEditor_ExportIds){

                        public void run() {
                            ExportIdsHandler h = (ExportIdsHandler)ContextInjectionFactory.make(ExportIdsHandler.class, (IEclipseContext)ModelEditor.this.context);
                            ContextInjectionFactory.invoke((Object)h, Execute.class, (IEclipseContext)ModelEditor.this.context);
                        }
                    };
                    manager.add((IAction)nlsAction);
                    manager.add((IAction)extIdAction);
                } else {
                    MUIElement el;
                    if (addSeparator) {
                        manager.add((IContributionItem)new Separator());
                    }
                    if (s.getFirstElement() instanceof MUIElement && (el = (MUIElement)s.getFirstElement()).getWidget() instanceof Control) {
                        manager.add((IAction)new Action(((ModelEditor)ModelEditor.this).messages.ModelEditor_ShowControl){

                            public void run() {
                                ControlHighlighter.show((Control)el.getWidget());
                            }
                        });
                    }
                }
                if (addSeparator) {
                    manager.add((IContributionItem)new Separator());
                }
                Action expandAction = new Action(((ModelEditor)ModelEditor.this).messages.ModelEditor_ExpandSubtree){

                    public void run() {
                        if (!s.isEmpty()) {
                            if (ModelEditor.this.viewer.getExpandedState(s.getFirstElement())) {
                                ModelEditor.this.viewer.collapseToLevel(s.getFirstElement(), -1);
                            } else {
                                ModelEditor.this.viewer.expandToLevel(s.getFirstElement(), -1);
                            }
                        }
                    }
                };
                manager.add((IAction)expandAction);
                if (s.getFirstElement() instanceof EObject) {
                    manager.add((IContributionItem)new Separator());
                    final EObject el = (EObject)s.getFirstElement();
                    Action gotoXmiAction = new Action(((ModelEditor)ModelEditor.this).messages.ModelEditor_goto_xmi){

                        public void run() {
                            ModelEditor.this.gotoEObject(1, el);
                        }
                    };
                    manager.add((IAction)gotoXmiAction);
                    if (ModelEditor.this.listTab != null && EmfUtil.getAttribute(el, "elementId") != null) {
                        Action gotoListAction = new Action(((ModelEditor)ModelEditor.this).messages.ModelEditor_goto_list){

                            public void run() {
                                ModelEditor.this.gotoEObject(2, el);
                            }
                        };
                        manager.add((IAction)gotoListAction);
                    }
                }
            }
        });
        this.viewer.getTree().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (ModelEditor.this.mod1Down && (e.keyCode & SWT.MOD1) == SWT.MOD1) {
                    ModelEditor.this.mod1Down = false;
                }
            }

            public void keyPressed(KeyEvent e) {
                if (!ModelEditor.this.mod1Down && (e.keyCode & SWT.MOD1) == SWT.MOD1) {
                    ModelEditor.this.mod1Down = true;
                }
            }
        });
        this.viewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(final TreeExpansionEvent event) {
                if (ModelEditor.this.mod1Down) {
                    ModelEditor.this.viewer.getTree().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ModelEditor.this.viewer.expandToLevel(event.getElement(), -1);
                        }
                    });
                }
            }

            public void treeCollapsed(final TreeExpansionEvent event) {
                if (ModelEditor.this.mod1Down) {
                    ModelEditor.this.viewer.getTree().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ModelEditor.this.viewer.collapseToLevel(event.getElement(), -1);
                        }
                    });
                }
            }
        });
        this.viewer.getControl().setMenu(mgr.createContextMenu(this.viewer.getControl()));
        this.viewer.setSelection((ISelection)new StructuredSelection((List)this.modelProvider.getRoot()));
        return form;
    }

    public IExtensionLookup getExtensionLookup() {
        return this.extensionLookup;
    }

    public boolean isAutoCreateElementId() {
        return this.autoCreateElementId && this.project != null;
    }

    public IProject getProject() {
        return this.project;
    }

    public ImageRegistry getComponentImages() {
        return this.componentImages;
    }

    public boolean isShowXMIId() {
        return this.showXMIId;
    }

    private void loadContributionCreators() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.e4.tools.emf.ui.editors");
        IConfigurationElement[] iConfigurationElementArray = extPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if ("contributionClassCreator".equals(el.getName())) {
                try {
                    this.contributionCreator.add((IContributionClassCreator)el.createExecutableExtension("class"));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public IContributionClassCreator getContributionCreator(EClass eClass) {
        for (IContributionClassCreator c : this.contributionCreator) {
            if (!c.isSupported(eClass)) continue;
            return c;
        }
        return null;
    }

    private void loadEditorFeatures() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.e4.tools.emf.ui.editors");
        IConfigurationElement[] iConfigurationElementArray = extPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if ("editorfeature".equals(el.getName())) {
                try {
                    this.editorFeatures.add((IEditorFeature)el.createExecutableExtension("class"));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public boolean isModelFragment() {
        return this.fragment;
    }

    public boolean isLiveModel() {
        return !this.modelProvider.isSaveable();
    }

    public List<IEditorFeature.FeatureClass> getFeatureClasses(EClass eClass, EStructuralFeature feature) {
        ArrayList<IEditorFeature.FeatureClass> list = new ArrayList<IEditorFeature.FeatureClass>();
        for (IEditorFeature f : this.editorFeatures) {
            list.addAll(f.getFeatureClasses(eClass, feature));
        }
        return list;
    }

    private TreeViewer createTreeViewerArea(Composite parent) {
        Composite treeArea = new Composite(parent, 2048);
        treeArea.setLayout((Layout)new FillLayout());
        treeArea.setData(CSS_CLASS_KEY, (Object)"formContainer");
        treeArea.setBackgroundMode(1);
        TreeViewer tempViewer = null;
        String property = System.getProperty(ORG_ECLIPSE_E4_TOOLS_MODELEDITOR_FILTEREDTREE_ENABLED_XMITAB_DISABLED);
        if (property != null || this.preferences.getBoolean("tab-form-search-show", false)) {
            FilteredTree viewParent = new FilteredTree(treeArea, 66306, (org.eclipse.e4.ui.workbench.swt.internal.copy.PatternFilter)new PatternFilter(), false);
            tempViewer = viewParent.getViewer();
        } else {
            tempViewer = new TreeViewerEx(treeArea, 66306, this.emfDocumentProvider, this.modelProvider);
        }
        final TreeViewer viewer = tempViewer;
        viewer.setLabelProvider((IBaseLabelProvider)new ComponentLabelProvider(this, this.messages));
        ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider((IObservableFactory)new ObservableFactoryImpl(), new TreeStructureAdvisor(){});
        viewer.setContentProvider((IContentProvider)contentProvider);
        final WritableSet clearedSet = new WritableSet();
        contentProvider.getKnownElements().addSetChangeListener(new ISetChangeListener(){

            public void handleSetChange(SetChangeEvent event) {
                for (Object o : event.diff.getAdditions()) {
                    if (!(o instanceof EObject)) continue;
                    clearedSet.add(o);
                }
                for (Object o : event.diff.getRemovals()) {
                    if (!(o instanceof EObject)) continue;
                    clearedSet.remove(o);
                }
            }
        });
        for (FeaturePath p : this.labelFeaturePaths) {
            IObservableMap map = EMFProperties.value((FeaturePath)p).observeDetail((IObservableSet)clearedSet);
            map.addMapChangeListener(new IMapChangeListener(){

                public void handleMapChange(MapChangeEvent event) {
                    viewer.update(event.diff.getChangedKeys().toArray(), null);
                }
            });
        }
        viewer.setInput((Object)this.modelProvider.getRoot());
        viewer.setAutoExpandLevel(2);
        viewer.expandToLevel(viewer.getAutoExpandLevel());
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeViewer viewer = (TreeViewer)event.getViewer();
                IStructuredSelection thisSelection = (IStructuredSelection)event.getSelection();
                Object selectedNode = thisSelection.getFirstElement();
                if (ModelEditor.this.mod1Down) {
                    if (viewer.getExpandedState(selectedNode)) {
                        viewer.setExpandedState(selectedNode, false);
                    } else {
                        viewer.expandToLevel(selectedNode, -1);
                    }
                } else {
                    viewer.setExpandedState(selectedNode, !viewer.getExpandedState(selectedNode));
                }
            }
        });
        viewer.getTree().addTreeListener((TreeListener)new TreeAdapter(){

            public void treeCollapsed(TreeEvent e) {
                viewer.expandToLevel(viewer.getAutoExpandLevel());
            }
        });
        viewer.addDragSupport(2, new Transfer[]{MemoryTransfer.getInstance()}, (DragSourceListener)new DragListener(viewer));
        viewer.addDropSupport(2, new Transfer[]{MemoryTransfer.getInstance()}, (DropTargetListener)new DropListener((Viewer)viewer, this.modelProvider.getEditingDomain()));
        return viewer;
    }

    private void registerContributedVirtualEditors() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.e4.tools.emf.ui.editors");
        IConfigurationElement[] iConfigurationElementArray = extPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if ("virtualeditor".equals(el.getName())) {
                IContributionFactory fact = (IContributionFactory)this.context.get(IContributionFactory.class);
                AbstractComponentEditor editor = (AbstractComponentEditor)fact.create("bundleclass://" + el.getContributor().getName() + "/" + el.getAttribute("class"), this.context);
                this.registerVirtualEditor(el.getAttribute("id"), editor);
            }
            ++n2;
        }
    }

    private void registerVirtualEditors() {
        this.registerVirtualEditor(VIRTUAL_PART_MENU, (AbstractComponentEditor)ContextInjectionFactory.make(VPartMenuEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_HANDLER, (AbstractComponentEditor)ContextInjectionFactory.make(VHandlerEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_BINDING_TABLE, (AbstractComponentEditor)ContextInjectionFactory.make(VBindingTableEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_COMMAND, (AbstractComponentEditor)ContextInjectionFactory.make(VCommandEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_APPLICATION_WINDOWS, (AbstractComponentEditor)ContextInjectionFactory.make(VApplicationWindowEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_WINDOW_WINDOWS, (AbstractComponentEditor)ContextInjectionFactory.make(VWindowWindowsEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_PERSPECTIVE_WINDOWS, (AbstractComponentEditor)ContextInjectionFactory.make(VPerspectiveWindowsEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_WINDOW_CONTROLS, (AbstractComponentEditor)ContextInjectionFactory.make(VWindowControlEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_PART_DESCRIPTORS, (AbstractComponentEditor)ContextInjectionFactory.make(VPartDescriptor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_PARTDESCRIPTOR_MENU, (AbstractComponentEditor)ContextInjectionFactory.make(VPartDescriptorMenuEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_TRIMMED_WINDOW_TRIMS, (AbstractComponentEditor)ContextInjectionFactory.make(VWindowTrimEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_ADDONS, (AbstractComponentEditor)ContextInjectionFactory.make(VApplicationAddons.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_MENU_CONTRIBUTIONS, (AbstractComponentEditor)ContextInjectionFactory.make(VMenuContributionsEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_TOOLBAR_CONTRIBUTIONS, (AbstractComponentEditor)ContextInjectionFactory.make(VToolBarContributionsEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_TRIM_CONTRIBUTIONS, (AbstractComponentEditor)ContextInjectionFactory.make(VTrimContributionsEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_WINDOW_SHARED_ELEMENTS, (AbstractComponentEditor)ContextInjectionFactory.make(VWindowSharedElementsEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_MODEL_FRAGEMENTS, (AbstractComponentEditor)ContextInjectionFactory.make(VModelFragmentsEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_MODEL_IMPORTS, (AbstractComponentEditor)ContextInjectionFactory.make(VModelImportsEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_CATEGORIES, (AbstractComponentEditor)ContextInjectionFactory.make(VApplicationCategoriesEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_PARAMETERS, (AbstractComponentEditor)ContextInjectionFactory.make(VItemParametersEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_ROOT_CONTEXTS, (AbstractComponentEditor)ContextInjectionFactory.make(VRootBindingContexts.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_PERSPECTIVE_CONTROLS, (AbstractComponentEditor)ContextInjectionFactory.make(VPerspectiveControlEditor.class, (IEclipseContext)this.context));
        this.registerVirtualEditor(VIRTUAL_SNIPPETS, (AbstractComponentEditor)ContextInjectionFactory.make(VSnippetsEditor.class, (IEclipseContext)this.context));
    }

    private void registerVirtualEditor(String id, AbstractComponentEditor editor) {
        this.virtualEditors.put(id, editor);
    }

    public void setSelection(Object element) {
        this.viewer.setSelection((ISelection)new StructuredSelection(element));
    }

    private void registerContributedEditors() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.e4.tools.emf.ui.editors");
        IConfigurationElement[] iConfigurationElementArray = extPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if ("editor".equals(el.getName())) {
                try {
                    IEditorDescriptor desc = (IEditorDescriptor)el.createExecutableExtension("descriptorClass");
                    EClass eClass = desc.getEClass();
                    IContributionFactory fact = (IContributionFactory)this.context.get(IContributionFactory.class);
                    AbstractComponentEditor editor = (AbstractComponentEditor)fact.create("bundleclass://" + el.getContributor().getName() + "/" + desc.getEditorClass().getName(), this.context);
                    this.registerEditor(eClass, editor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    private void registerContributedEditorTabs() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.e4.tools.emf.ui.editors");
        IConfigurationElement[] iConfigurationElementArray = extPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if ("editorTab".equals(el.getName())) {
                try {
                    Object o = el.createExecutableExtension("contribution");
                    if (o instanceof AbstractElementEditorContribution) {
                        AbstractElementEditorContribution contribution = (AbstractElementEditorContribution)o;
                        ContextInjectionFactory.inject((Object)contribution, (IEclipseContext)this.context);
                        Class<?> contribElem = contribution.getContributableTo();
                        if (contribElem != null) {
                            if (!this.tabContributions.containsKey(contribElem)) {
                                this.tabContributions.put(contribElem, new ArrayList());
                            }
                            List<AbstractElementEditorContribution> res = this.tabContributions.get(contribElem);
                            res.add(contribution);
                        }
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public List<AbstractElementEditorContribution> getTabContributionsForClass(Class<?> clazz) {
        ArrayList<AbstractElementEditorContribution> ret = new ArrayList<AbstractElementEditorContribution>();
        for (Class<?> clasz : this.tabContributions.keySet()) {
            if (!clasz.isAssignableFrom(clazz)) continue;
            ret.addAll((Collection<AbstractElementEditorContribution>)this.tabContributions.get(clasz));
        }
        return ret;
    }

    private void registerDefaultEditors() {
        this.registerEditor(ApplicationPackageImpl.Literals.APPLICATION, (AbstractComponentEditor)ContextInjectionFactory.make(ApplicationEditor.class, (IEclipseContext)this.context));
        this.registerEditor(ApplicationPackageImpl.Literals.ADDON, (AbstractComponentEditor)ContextInjectionFactory.make(AddonsEditor.class, (IEclipseContext)this.context));
        this.registerEditor(CommandsPackageImpl.Literals.KEY_BINDING, (AbstractComponentEditor)ContextInjectionFactory.make(KeyBindingEditor.class, (IEclipseContext)this.context));
        this.registerEditor(CommandsPackageImpl.Literals.HANDLER, (AbstractComponentEditor)ContextInjectionFactory.make(HandlerEditor.class, (IEclipseContext)this.context));
        this.registerEditor(CommandsPackageImpl.Literals.COMMAND, (AbstractComponentEditor)ContextInjectionFactory.make(CommandEditor.class, (IEclipseContext)this.context));
        this.registerEditor(CommandsPackageImpl.Literals.COMMAND_PARAMETER, (AbstractComponentEditor)ContextInjectionFactory.make(CommandParameterEditor.class, (IEclipseContext)this.context));
        this.registerEditor(CommandsPackageImpl.Literals.PARAMETER, (AbstractComponentEditor)ContextInjectionFactory.make(ParameterEditor.class, (IEclipseContext)this.context));
        this.registerEditor(CommandsPackageImpl.Literals.BINDING_TABLE, (AbstractComponentEditor)ContextInjectionFactory.make(BindingTableEditor.class, (IEclipseContext)this.context));
        this.registerEditor(CommandsPackageImpl.Literals.BINDING_CONTEXT, (AbstractComponentEditor)ContextInjectionFactory.make(BindingContextEditor.class, (IEclipseContext)this.context));
        this.registerEditor(CommandsPackageImpl.Literals.CATEGORY, (AbstractComponentEditor)ContextInjectionFactory.make(CategoryEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.TOOL_BAR, (AbstractComponentEditor)ContextInjectionFactory.make(ToolBarEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.DIRECT_TOOL_ITEM, (AbstractComponentEditor)ContextInjectionFactory.make(DirectToolItemEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.HANDLED_TOOL_ITEM, (AbstractComponentEditor)ContextInjectionFactory.make(HandledToolItemEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.TOOL_BAR_SEPARATOR, (AbstractComponentEditor)ContextInjectionFactory.make(ToolBarSeparatorEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.TOOL_CONTROL, (AbstractComponentEditor)ContextInjectionFactory.make(ToolControlEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.MENU, (AbstractComponentEditor)ContextInjectionFactory.make(MenuEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.POPUP_MENU, (AbstractComponentEditor)ContextInjectionFactory.make(PopupMenuEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.MENU_SEPARATOR, (AbstractComponentEditor)ContextInjectionFactory.make(MenuSeparatorEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.HANDLED_MENU_ITEM, (AbstractComponentEditor)ContextInjectionFactory.make(HandledMenuItemEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.DIRECT_MENU_ITEM, (AbstractComponentEditor)ContextInjectionFactory.make(DirectMenuItemEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.MENU_CONTRIBUTION, (AbstractComponentEditor)ContextInjectionFactory.make(MenuContributionEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.TOOL_BAR_CONTRIBUTION, (AbstractComponentEditor)ContextInjectionFactory.make(ToolBarContributionEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.TRIM_CONTRIBUTION, (AbstractComponentEditor)ContextInjectionFactory.make(TrimContributionEditor.class, (IEclipseContext)this.context));
        this.registerEditor(MenuPackageImpl.Literals.DYNAMIC_MENU_CONTRIBUTION, (AbstractComponentEditor)ContextInjectionFactory.make(DynamicMenuContributionEditor.class, (IEclipseContext)this.context));
        this.registerEditor(UiPackageImpl.Literals.CORE_EXPRESSION, (AbstractComponentEditor)ContextInjectionFactory.make(CoreExpressionEditor.class, (IEclipseContext)this.context));
        this.registerEditor(BasicPackageImpl.Literals.COMPOSITE_PART, (AbstractComponentEditor)ContextInjectionFactory.make(CompositePartEditor.class, (IEclipseContext)this.context));
        this.registerEditor(BasicPackageImpl.Literals.PART, (AbstractComponentEditor)ContextInjectionFactory.make(PartEditor.class, (IEclipseContext)this.context));
        this.registerEditor(BasicPackageImpl.Literals.WINDOW, (AbstractComponentEditor)ContextInjectionFactory.make(WindowEditor.class, (IEclipseContext)this.context));
        this.registerEditor(BasicPackageImpl.Literals.TRIMMED_WINDOW, (AbstractComponentEditor)ContextInjectionFactory.make(TrimmedWindowEditor.class, (IEclipseContext)this.context));
        this.registerEditor(BasicPackageImpl.Literals.PART_SASH_CONTAINER, (AbstractComponentEditor)ContextInjectionFactory.make(PartSashContainerEditor.class, (IEclipseContext)this.context));
        this.registerEditor(AdvancedPackageImpl.Literals.AREA, (AbstractComponentEditor)ContextInjectionFactory.make(AreaEditor.class, (IEclipseContext)this.context));
        this.registerEditor(BasicPackageImpl.Literals.PART_STACK, (AbstractComponentEditor)ContextInjectionFactory.make(PartStackEditor.class, (IEclipseContext)this.context));
        this.registerEditor(BasicPackageImpl.Literals.TRIM_BAR, (AbstractComponentEditor)ContextInjectionFactory.make(TrimBarEditor.class, (IEclipseContext)this.context));
        this.registerEditor(BasicPackageImpl.Literals.DIALOG, (AbstractComponentEditor)ContextInjectionFactory.make(DialogEditor.class, (IEclipseContext)this.context));
        this.registerEditor(BasicPackageImpl.Literals.WIZARD_DIALOG, (AbstractComponentEditor)ContextInjectionFactory.make(WizardDialogEditor.class, (IEclipseContext)this.context));
        this.registerEditor(BasicPackageImpl.Literals.PART_DESCRIPTOR, (AbstractComponentEditor)ContextInjectionFactory.make(PartDescriptorEditor.class, (IEclipseContext)this.context));
        this.registerEditor(AdvancedPackageImpl.Literals.PERSPECTIVE_STACK, (AbstractComponentEditor)ContextInjectionFactory.make(PerspectiveStackEditor.class, (IEclipseContext)this.context));
        this.registerEditor(AdvancedPackageImpl.Literals.PERSPECTIVE, (AbstractComponentEditor)ContextInjectionFactory.make(PerspectiveEditor.class, (IEclipseContext)this.context));
        this.registerEditor(AdvancedPackageImpl.Literals.PLACEHOLDER, (AbstractComponentEditor)ContextInjectionFactory.make(PlaceholderEditor.class, (IEclipseContext)this.context));
        this.registerEditor(FragmentPackageImpl.Literals.MODEL_FRAGMENTS, (AbstractComponentEditor)ContextInjectionFactory.make(ModelFragmentsEditor.class, (IEclipseContext)this.context));
        this.registerEditor(FragmentPackageImpl.Literals.STRING_MODEL_FRAGMENT, (AbstractComponentEditor)ContextInjectionFactory.make(StringModelFragment.class, (IEclipseContext)this.context));
    }

    public void tab_list_show(Boolean show) {
        if (this.editorTabFolder == null) {
            return;
        }
        if (!show.booleanValue()) {
            if (this.listTab != null) {
                this.listTab.getTabItem().dispose();
                ContextInjectionFactory.uninject((Object)this.listTab, (IEclipseContext)this.listTab.getContext());
                this.listTab = null;
            }
        } else if (this.listTab == null) {
            IEclipseContext child = this.context.createChild();
            child.set(CTabFolder.class, (Object)this.editorTabFolder);
            child.set(EMFDocumentResourceMediator.class, (Object)this.emfDocumentProvider);
            child.set(IGotoObject.class, (Object)this);
            child.set(Messages.class, (Object)this.messages);
            this.listTab = (ListTab)ContextInjectionFactory.make(ListTab.class, (IEclipseContext)child);
            this.tabItemList = this.listTab.getTabItem();
        }
    }

    @Inject
    public void setNotVisibleColor(@Preference(value="notVisibleColor") String color) {
        RGB current = JFaceResources.getColorRegistry().getRGB("NOT_VISIBLE_KEY");
        if (current == null || !current.equals((Object)color)) {
            JFaceResources.getColorRegistry().put("NOT_VISIBLE_KEY", StringConverter.asRGB((String)color, (RGB)new RGB(200, 200, 200)));
        }
        if (this.viewer != null) {
            this.viewer.refresh();
            this.viewer.getControl().redraw();
        }
    }

    @Inject
    public void setNotRenderedColor(@Preference(value="notRenderedColor") String color) {
        RGB current = JFaceResources.getColorRegistry().getRGB("NOT_RENDERED_STYLER");
        if (current == null || !current.equals((Object)color)) {
            JFaceResources.getColorRegistry().put("NOT_RENDERED_STYLER", StringConverter.asRGB((String)color, (RGB)new RGB(200, 200, 200)));
        }
        if (this.viewer != null) {
            this.viewer.refresh();
            this.viewer.getControl().redraw();
        }
    }

    @Inject
    public void setNotVisibleRenderedColor(@Preference(value="notVisibleAndRenderedColor") String color) {
        RGB current = JFaceResources.getColorRegistry().getRGB("NOT_VISIBLE_AND_RENDERED_KEY");
        if (current == null || !current.equals((Object)color)) {
            JFaceResources.getColorRegistry().put("NOT_VISIBLE_AND_RENDERED_KEY", StringConverter.asRGB((String)color, (RGB)new RGB(200, 200, 200)));
        }
        if (this.viewer != null) {
            this.viewer.refresh();
            this.viewer.getControl().redraw();
        }
    }

    public void registerEditor(EClass eClass, AbstractComponentEditor editor) {
        this.editorMap.put(eClass, editor);
        FeaturePath[] featurePathArray = editor.getLabelProperties();
        int n = featurePathArray.length;
        int n2 = 0;
        while (n2 < n) {
            FeaturePath p = featurePathArray[n2];
            boolean found = false;
            for (FeaturePath tmp : this.labelFeaturePaths) {
                if (!this.equalsPaths(p, tmp)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.labelFeaturePaths.add(p);
            }
            ++n2;
        }
    }

    private boolean equalsPaths(FeaturePath p1, FeaturePath p2) {
        if (p1.getFeaturePath().length == p2.getFeaturePath().length) {
            int i = 0;
            while (i < p1.getFeaturePath().length) {
                if (!p1.getFeaturePath()[i].equals(p2.getFeaturePath()[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public AbstractComponentEditor getEditor(EClass eClass) {
        AbstractComponentEditor editor = this.editorMap.get(eClass);
        if (editor == null) {
            for (EClass cl : eClass.getESuperTypes()) {
                editor = this.getEditor(cl);
                if (editor == null) continue;
                return editor;
            }
            editor = (AbstractComponentEditor)ContextInjectionFactory.make(DefaultEditor.class, (IEclipseContext)this.context);
        }
        return editor;
    }

    @Persist
    public void doSave(@Optional IProgressMonitor monitor) {
        try {
            this.setSaving(true);
            if (this.modelProvider.isSaveable()) {
                this.modelProvider.save();
            }
        }
        finally {
            this.setSaving(false);
        }
    }

    private void setSaving(boolean saving) {
        this.saving = saving;
    }

    protected boolean isSaving() {
        return this.saving;
    }

    @Focus
    public void setFocus() {
        if (this.clipboardHandler == null) {
            this.clipboardHandler = new ClipboardHandler();
        }
        if (this.clipboardService != null) {
            this.clipboardService.setHandler(this.clipboardHandler);
        }
    }

    @PreDestroy
    void dispose() {
        try {
            this.obsManager.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.project == null) {
            ((Display)this.context.get(Display.class)).removeFilter(4, this.keyListener);
        }
        ContextInjectionFactory.uninject((Object)((Object)this.xmiTab), (IEclipseContext)this.xmiTab.getContext());
    }

    public IModelResource getModelProvider() {
        return this.modelProvider;
    }

    @Override
    public void gotoEObject(int targetHint, EObject object) {
        if (object != null) {
            switch (targetHint) {
                case 0: {
                    ObservableListTreeContentProvider provider = (ObservableListTreeContentProvider)this.viewer.getContentProvider();
                    this.getFirstMatchingItem(object, provider, provider.getChildren(this.viewer.getInput()));
                    this.viewer.reveal((Object)object);
                    this.viewer.setSelection((ISelection)new StructuredSelection((Object)object));
                    this.editorTabFolder.setSelection(ModelEditor.getTabIndex(this.tabItemTree));
                    break;
                }
                case 1: {
                    this.editorTabFolder.setSelection(ModelEditor.getTabIndex(this.tabItemXmi));
                    this.emfDocumentProvider.updateFromEMF();
                    try {
                        this.xmiTab.gotoEObject(object);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 2: {
                    if (this.tabItemList == null || this.listTab == null) break;
                    this.editorTabFolder.setSelection(ModelEditor.getTabIndex(this.tabItemList));
                    this.listTab.getViewer().setSelection((ISelection)new StructuredSelection((Object)object), true);
                    break;
                }
            }
        }
    }

    private Object getFirstMatchingItem(EObject target, ObservableListTreeContentProvider provider, Object[] items) {
        int i = 0;
        while (i < items.length) {
            if (items[i] == target) {
                return items[i];
            }
            Object found = this.getFirstMatchingItem(target, provider, provider.getChildren(items[i]));
            if (found != null) {
                return found;
            }
            ++i;
        }
        return null;
    }

    class ClipboardHandler
    implements IClipboardService.Handler {
        ClipboardHandler() {
        }

        public void paste() {
            if (ModelEditor.this.editorTabFolder.getSelectionIndex() == 0) {
                if (ModelEditor.this.viewer.getControl().getDisplay().getFocusControl() == ModelEditor.this.viewer.getControl()) {
                    this.handleStructurePaste();
                } else if (ModelEditor.this.currentEditor != null) {
                    ModelEditor.this.currentEditor.handlePaste();
                }
            } else {
                ModelEditor.this.xmiTab.paste();
            }
        }

        private void handleStructurePaste() {
            Command cmd;
            Clipboard clip = new Clipboard(ModelEditor.this.viewer.getControl().getDisplay());
            Object o = clip.getContents((Transfer)MemoryTransfer.getInstance());
            clip.dispose();
            if (o == null) {
                return;
            }
            o = EcoreUtil.copy((EObject)((EObject)o));
            Object parent = ((IStructuredSelection)ModelEditor.this.viewer.getSelection()).getFirstElement();
            EReference feature = null;
            EObject container = null;
            if (parent instanceof VirtualEntry) {
                VirtualEntry v = (VirtualEntry)parent;
                feature = ((IEMFProperty)v.getProperty()).getStructuralFeature();
                container = (EObject)v.getOriginalParent();
            } else if (parent instanceof MElementContainer) {
                feature = UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN;
                container = (EObject)parent;
            } else if (parent instanceof EObject) {
                container = (EObject)parent;
                EClass eClass = container.eClass();
                for (EStructuralFeature f : eClass.getEAllStructuralFeatures()) {
                    if (!ModelUtils.getTypeArgument((EClass)eClass, (EGenericType)f.getEGenericType()).isInstance(o)) continue;
                    feature = f;
                    break;
                }
            }
            if (feature == FragmentPackageImpl.Literals.MODEL_FRAGMENTS__IMPORTS && container != null) {
                MApplicationElement el = (MApplicationElement)EcoreUtil.create((EClass)((EObject)o).eClass());
                el.setElementId(((MApplicationElement)o).getElementId());
                Command cmd2 = AddCommand.create((EditingDomain)ModelEditor.this.getModelProvider().getEditingDomain(), (Object)container, (Object)feature, (Object)el);
                if (cmd2.canExecute()) {
                    ModelEditor.this.getModelProvider().getEditingDomain().getCommandStack().execute(cmd2);
                }
                return;
            }
            if (feature != null && container != null && (cmd = AddCommand.create((EditingDomain)ModelEditor.this.getModelProvider().getEditingDomain(), (Object)container, (Object)feature, (Object)o)).canExecute()) {
                ModelEditor.this.getModelProvider().getEditingDomain().getCommandStack().execute(cmd);
                if (ModelEditor.this.isLiveModel() && container instanceof MElementContainer && o instanceof MUIElement) {
                    ((MElementContainer)container).setSelectedElement((MUIElement)o);
                }
            }
        }

        public void copy() {
            if (ModelEditor.this.editorTabFolder.getSelectionIndex() == 0) {
                if (ModelEditor.this.viewer.getControl().getDisplay().getFocusControl() == ModelEditor.this.viewer.getControl()) {
                    this.handleStructureCopy();
                } else if (ModelEditor.this.currentEditor != null) {
                    ModelEditor.this.currentEditor.handleCopy();
                }
            } else {
                ModelEditor.this.xmiTab.copy();
            }
        }

        private void handleStructureCopy() {
            Object o = ((IStructuredSelection)ModelEditor.this.viewer.getSelection()).getFirstElement();
            if (o != null && o instanceof EObject) {
                Clipboard clip = new Clipboard(ModelEditor.this.viewer.getControl().getDisplay());
                clip.setContents(new Object[]{EcoreUtil.copy((EObject)((EObject)o))}, new Transfer[]{MemoryTransfer.getInstance()});
                clip.dispose();
            }
        }

        public void cut() {
            if (ModelEditor.this.editorTabFolder.getSelectionIndex() == 0) {
                if (ModelEditor.this.viewer.getControl().getDisplay().getFocusControl() == ModelEditor.this.viewer.getControl()) {
                    this.handleStructureCut();
                } else if (ModelEditor.this.currentEditor != null) {
                    ModelEditor.this.currentEditor.handleCut();
                }
            } else {
                ModelEditor.this.xmiTab.cut();
            }
        }

        private void handleStructureCut() {
            Object o = ((IStructuredSelection)ModelEditor.this.viewer.getSelection()).getFirstElement();
            if (o != null && o instanceof EObject) {
                Clipboard clip = new Clipboard(ModelEditor.this.viewer.getControl().getDisplay());
                clip.setContents(new Object[]{o}, new Transfer[]{MemoryTransfer.getInstance()});
                clip.dispose();
                EObject eObj = (EObject)o;
                Command cmd = RemoveCommand.create((EditingDomain)ModelEditor.this.getModelProvider().getEditingDomain(), (Object)eObj.eContainer(), (Object)eObj.eContainingFeature(), (Object)eObj);
                if (cmd.canExecute()) {
                    ModelEditor.this.getModelProvider().getEditingDomain().getCommandStack().execute(cmd);
                }
            }
        }
    }

    static class DragListener
    extends DragSourceAdapter {
        private final TreeViewer viewer;

        public DragListener(TreeViewer viewer) {
            this.viewer = viewer;
        }

        public void dragStart(DragSourceEvent event) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            event.doit = !selection.isEmpty() && selection.getFirstElement() instanceof MApplicationElement;
        }

        public void dragSetData(DragSourceEvent event) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            event.data = selection.toArray();
        }
    }

    class DropListener
    extends ViewerDropAdapter {
        private final EditingDomain domain;

        protected DropListener(Viewer viewer, EditingDomain domain) {
            super(viewer);
            this.domain = domain;
        }

        public boolean performDrop(Object data) {
            Object[] dropDataArray;
            if (!(data instanceof Object[])) {
                return false;
            }
            Object[] objectArray = dropDataArray = (Object[])data;
            int n = dropDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                boolean result = this.performSingleDrop(object);
                if (!result) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public boolean performSingleDrop(Object data) {
            block28: {
                block24: {
                    Command cmd;
                    EObject parent;
                    EReference feature;
                    block26: {
                        block27: {
                            block25: {
                                if (this.getCurrentLocation() != 3) break block24;
                                feature = null;
                                parent = null;
                                if (!(this.getCurrentTarget() instanceof MElementContainer)) break block25;
                                feature = UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN;
                                parent = (EObject)this.getCurrentTarget();
                                break block26;
                            }
                            if (!(this.getCurrentTarget() instanceof VirtualEntry)) break block27;
                            VirtualEntry entry = (VirtualEntry)this.getCurrentTarget();
                            IListProperty prop = entry.getProperty();
                            if (!(prop instanceof IEMFProperty)) break block26;
                            feature = ((IEMFProperty)prop).getStructuralFeature();
                            parent = (EObject)entry.getOriginalParent();
                            break block26;
                        }
                        if (this.getCurrentTarget() instanceof EObject) {
                            parent = (EObject)this.getCurrentTarget();
                            for (EStructuralFeature f : parent.eClass().getEAllStructuralFeatures()) {
                                EClassifier cl = ModelUtils.getTypeArgument((EClass)parent.eClass(), (EGenericType)f.getEGenericType());
                                if (!cl.isInstance(data)) continue;
                                feature = f;
                                break;
                            }
                        }
                    }
                    if (feature != null && parent != null && (cmd = AddCommand.create((EditingDomain)this.domain, (Object)parent, (Object)feature, (Object)data)).canExecute()) {
                        this.domain.getCommandStack().execute(cmd);
                        if (ModelEditor.this.isLiveModel() && parent instanceof MElementContainer && data instanceof MUIElement) {
                            ((MElementContainer)parent).setSelectedElement((MUIElement)data);
                        }
                        return true;
                    }
                    break block28;
                }
                if (this.getCurrentLocation() == 2 || this.getCurrentLocation() == 1) {
                    TreeItem parentItem;
                    EReference feature = null;
                    EObject parent = null;
                    TreeItem item = (TreeItem)this.getCurrentEvent().item;
                    if (item != null && (parentItem = item.getParentItem()) != null) {
                        if (parentItem.getData() instanceof VirtualEntry) {
                            VirtualEntry vE = (VirtualEntry)parentItem.getData();
                            parent = (EObject)vE.getOriginalParent();
                            feature = ((IEMFProperty)vE.getProperty()).getStructuralFeature();
                        } else if (parentItem.getData() instanceof MElementContainer) {
                            parent = (EObject)parentItem.getData();
                            feature = UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN;
                        } else if (parentItem.getData() instanceof EObject) {
                            parent = (EObject)parentItem.getData();
                            for (EStructuralFeature f : parent.eClass().getEAllStructuralFeatures()) {
                                EClassifier cl = ModelUtils.getTypeArgument((EClass)parent.eClass(), (EGenericType)f.getEGenericType());
                                if (!cl.isInstance(data)) continue;
                                feature = f;
                                break;
                            }
                        }
                    }
                    if (feature == FragmentPackageImpl.Literals.MODEL_FRAGMENTS__IMPORTS && parent != null) {
                        MApplicationElement el = (MApplicationElement)EcoreUtil.create((EClass)((EObject)data).eClass());
                        el.setElementId(((MApplicationElement)data).getElementId());
                        Command cmd = AddCommand.create((EditingDomain)this.domain, (Object)parent, (Object)feature, (Object)el);
                        if (cmd.canExecute()) {
                            this.domain.getCommandStack().execute(cmd);
                        }
                        return true;
                    }
                    if (feature != null && parent != null && parent.eGet(feature) instanceof List) {
                        Command cmd;
                        List list = (List)parent.eGet(feature);
                        int index = list.indexOf(this.getCurrentTarget());
                        if (index >= list.size()) {
                            index = -1;
                        }
                        if (parent == ((EObject)data).eContainer()) {
                            if (parent instanceof MElementContainer && data instanceof MUIElement) {
                                Util.moveElementByIndex(this.domain, (MUIElement)data, ModelEditor.this.isLiveModel(), index);
                            } else {
                                cmd = MoveCommand.create((EditingDomain)this.domain, (Object)parent, (Object)feature, (Object)data, (int)index);
                                if (cmd.canExecute()) {
                                    this.domain.getCommandStack().execute(cmd);
                                    return true;
                                }
                            }
                        } else {
                            if (parent.eResource() != ((EObject)data).eResource()) {
                                data = EcoreUtil.copy((EObject)((EObject)data));
                            }
                            if ((cmd = AddCommand.create((EditingDomain)this.domain, (Object)parent, (Object)feature, (Object)data, (int)index)).canExecute()) {
                                this.domain.getCommandStack().execute(cmd);
                                if (ModelEditor.this.isLiveModel() && parent instanceof MElementContainer && data instanceof MUIElement) {
                                    ((MElementContainer)parent).setSelectedElement((MUIElement)data);
                                }
                                return true;
                            }
                        }
                    }
                }
            }
            return false;
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            boolean rv = false;
            if (this.getSelectedObject() instanceof MApplicationElement) {
                TreeItem item;
                if (this.getCurrentLocation() == 3) {
                    rv = this.isValidDrop(target, (MApplicationElement)this.getSelectedObject(), false);
                } else if ((this.getCurrentLocation() == 2 || this.getCurrentLocation() == 1) && (item = (TreeItem)this.getCurrentEvent().item) != null && (item = item.getParentItem()) != null) {
                    rv = this.isValidDrop(item.getData(), (MApplicationElement)this.getSelectedObject(), true);
                }
            }
            return rv;
        }

        private boolean isValidDrop(Object target, MApplicationElement instance, boolean isIndex) {
            if (target instanceof MElementContainer) {
                MElementContainer container = (MElementContainer)target;
                if (isIndex || !container.getChildren().contains(instance)) {
                    EClassifier classifier = ModelUtils.getTypeArgument((EClass)((EObject)container).eClass(), (EGenericType)UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN.getEGenericType());
                    return classifier.isInstance((Object)instance);
                }
            } else if (target instanceof VirtualEntry) {
                VirtualEntry vTarget = (VirtualEntry)target;
                if ((isIndex || !vTarget.getList().contains((Object)instance)) && vTarget.getProperty() instanceof IEMFProperty) {
                    EStructuralFeature feature = ((IEMFProperty)vTarget.getProperty()).getStructuralFeature();
                    EObject parent = (EObject)vTarget.getOriginalParent();
                    EClassifier classifier = ModelUtils.getTypeArgument((EClass)parent.eClass(), (EGenericType)feature.getEGenericType());
                    return classifier.isInstance((Object)instance);
                }
            } else if (target instanceof EObject) {
                EObject eObj = (EObject)target;
                for (EStructuralFeature f : eObj.eClass().getEAllStructuralFeatures()) {
                    EClassifier cl = ModelUtils.getTypeArgument((EClass)eObj.eClass(), (EGenericType)f.getEGenericType());
                    if (!cl.isInstance((Object)instance)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    class ObservableFactoryImpl
    implements IObservableFactory {
        ObservableFactoryImpl() {
        }

        public IObservable createObservable(Object target) {
            if (target instanceof IObservableList) {
                return (IObservable)target;
            }
            if (target instanceof VirtualEntry) {
                return ((VirtualEntry)target).getList();
            }
            AbstractComponentEditor editor = ModelEditor.this.getEditor(((EObject)target).eClass());
            if (editor != null) {
                return editor.getChildList(target);
            }
            return null;
        }
    }
}

