/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.r_osgi;

import ch.ethz.iks.r_osgi.RemoteOSGiService;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Map;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.provider.IContainerInstantiator;
import org.eclipse.ecf.core.provider.IRemoteServiceContainerInstantiator;
import org.eclipse.ecf.internal.provider.r_osgi.Activator;
import org.eclipse.ecf.internal.provider.r_osgi.R_OSGiRemoteServiceContainer;
import org.eclipse.ecf.internal.provider.r_osgi.R_OSGiWSRemoteServiceContainer;
import org.eclipse.ecf.internal.provider.r_osgi.R_OSGiWSSRemoteServiceContainer;
import org.eclipse.ecf.provider.r_osgi.identity.R_OSGiID;
import org.eclipse.ecf.provider.r_osgi.identity.R_OSGiNamespace;
import org.eclipse.ecf.provider.r_osgi.identity.R_OSGiWSNamespace;
import org.eclipse.ecf.provider.r_osgi.identity.R_OSGiWSSNamespace;

public final class R_OSGiContainerInstantiator
implements IContainerInstantiator,
IRemoteServiceContainerInstantiator {
    public static final String[] r_OSGiIntents = new String[]{"passByValue", "exactlyOnce", "ordered"};
    public static final String ID_PROP = "id";
    private static final String WS_PROTOCOL = "http";
    private static final String WSS_PROTOCOL = "https";
    private static final int WS_DEFAULT_PORT = 80;
    private static final int WSS_DEFAULT_PORT = 443;
    final boolean useHostname = Boolean.valueOf(System.getProperty("org.eclipse.ecf.provider.r_osgi.useHostName", "true"));
    private static final String ROSGI_CONFIG = "ecf.r_osgi.peer";
    private static final String ROSGI_WEBSOCKETS_CONFIG = "ecf.r_osgi.peer.ws";
    private static final String ROSGI_WEBSOCKETSS_CONFIG = "ecf.r_osgi.peer.wss";
    public static final String NAME = "ecf.r_osgi.peer";
    public static final String NAME_HTTP = "ecf.r_osgi.peer.ws";
    public static final String NAME_HTTPS = "ecf.r_osgi.peer.wss";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static R_OSGiID createR_OSGiID(Namespace namespace, String uriStr) {
        return (R_OSGiID)IDFactory.getDefault().createID(namespace, uriStr);
    }

    public IContainer createInstance(ContainerTypeDescription description, Object[] parameters) throws ContainerCreateException {
        try {
            boolean ws;
            RemoteOSGiService remoteOSGiService = Activator.getDefault().getRemoteOSGiService();
            String descriptionName = description.getName();
            boolean wss = descriptionName.equals("ecf.r_osgi.peer.wss");
            boolean bl = ws = descriptionName.equals("ecf.r_osgi.peer.ws") || wss;
            Namespace ns = wss ? R_OSGiWSSNamespace.getDefault() : (ws ? R_OSGiWSNamespace.getDefault() : R_OSGiNamespace.getDefault());
            Object containerID = null;
            if (parameters == null) {
                String localHost = "localhost";
                if (this.useHostname) {
                    try {
                        localHost = InetAddress.getLocalHost().getCanonicalHostName();
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                }
                String nsScheme = ns.getScheme();
                String wsProtocol = wss ? WSS_PROTOCOL : (ws ? WS_PROTOCOL : null);
                int listeningPort = remoteOSGiService.getListeningPort(wsProtocol != null ? wsProtocol : nsScheme);
                int idPort = -1;
                if (WSS_PROTOCOL.equals(wsProtocol) && listeningPort != 443) {
                    idPort = listeningPort;
                } else if (WS_PROTOCOL.equals(wsProtocol) && listeningPort != 80) {
                    idPort = listeningPort;
                }
                String portStr = idPort > 0 ? ":" + idPort : "";
                containerID = R_OSGiContainerInstantiator.createR_OSGiID(ns, new String(String.valueOf(nsScheme) + "://" + localHost + portStr));
            } else if (parameters.length > 0) {
                if (parameters[0] instanceof ID) {
                    containerID = (ID)parameters[0];
                } else if (parameters[0] instanceof String) {
                    containerID = R_OSGiContainerInstantiator.createR_OSGiID(ns, (String)parameters[0]);
                } else if (parameters[0] instanceof Map) {
                    Map params = (Map)parameters[0];
                    String idStr = (String)params.get(ID_PROP);
                    if (idStr == null) {
                        throw new NullPointerException("No ID prop found in parameters map");
                    }
                    containerID = R_OSGiContainerInstantiator.createR_OSGiID(ns, idStr);
                }
            }
            if (containerID == null) {
                throw new ContainerCreateException("Unsupported arguments " + Arrays.asList(parameters));
            }
            if (wss) {
                return new R_OSGiWSSRemoteServiceContainer(remoteOSGiService, (ID)containerID);
            }
            if (ws) {
                return new R_OSGiWSRemoteServiceContainer(remoteOSGiService, (ID)containerID);
            }
            return new R_OSGiRemoteServiceContainer(remoteOSGiService, (ID)containerID);
        }
        catch (Exception e) {
            throw new ContainerCreateException("Could not create R_OSGI ID", (Throwable)e);
        }
    }

    public String[] getSupportedAdapterTypes(ContainerTypeDescription description) {
        String[] stringArray = new String[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ecf.core.IContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz2.getName();
        return stringArray;
    }

    public Class[][] getSupportedParameterTypes(ContainerTypeDescription description) {
        Class[][] classArray = new Class[2][];
        classArray[0] = new Class[0];
        Class[] classArray2 = new Class[1];
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ecf.core.identity.ID");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz;
        classArray[1] = classArray2;
        return classArray;
    }

    public String[] getSupportedIntents(ContainerTypeDescription description) {
        return r_OSGiIntents;
    }

    public String[] getSupportedConfigs(ContainerTypeDescription description) {
        return new String[]{description.getName()};
    }

    public String[] getImportedConfigs(ContainerTypeDescription description, String[] exporterSupportedConfigs) {
        if (exporterSupportedConfigs == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        int i = 0;
        while (i < exporterSupportedConfigs.length) {
            if (exporterSupportedConfigs[i].equals("ecf.r_osgi.peer")) {
                results.add("ecf.r_osgi.peer");
            }
            if (exporterSupportedConfigs[i].equals("ecf.r_osgi.peer.ws")) {
                results.add("ecf.r_osgi.peer.ws");
            }
            if (exporterSupportedConfigs[i].equals("ecf.r_osgi.peer.wss")) {
                results.add("ecf.r_osgi.peer.wss");
            }
            ++i;
        }
        return results.size() == 0 ? null : results.toArray(new String[results.size()]);
    }

    public Dictionary getPropertiesForImportedConfigs(ContainerTypeDescription description, String[] importedConfigs, Dictionary exportedProperties) {
        return null;
    }
}

