/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.delta;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOAddFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOMoveFeatureDeltaImpl;
import org.eclipse.emf.cdo.spi.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOFeatureDelta;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.collection.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOListFeatureDeltaImpl
extends CDOFeatureDeltaImpl
implements CDOListFeatureDelta {
    private final int originSize;
    private final List<CDOFeatureDelta> listChanges = new ArrayList<CDOFeatureDelta>();
    private transient int[] cachedIndices;
    private transient InternalCDOFeatureDelta.ListTargetAdding[] cachedSources;
    private transient List<CDOFeatureDelta> unprocessedFeatureDeltas;

    public CDOListFeatureDeltaImpl(EStructuralFeature feature, int originSize) {
        super(feature);
        this.originSize = originSize;
    }

    public CDOListFeatureDeltaImpl(CDODataInput in, EClass eClass) throws IOException {
        super(in, eClass);
        this.originSize = in.readInt();
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            this.listChanges.add(in.readCDOFeatureDelta(eClass));
            ++i;
        }
    }

    @Override
    public CDOListFeatureDelta copy() {
        CDOListFeatureDeltaImpl result = new CDOListFeatureDeltaImpl(this.getFeature(), this.getOriginSize());
        HashMap<CDOFeatureDelta, CDOFeatureDelta> map = null;
        if (this.cachedSources != null || this.unprocessedFeatureDeltas != null) {
            map = new HashMap<CDOFeatureDelta, CDOFeatureDelta>();
        }
        for (CDOFeatureDelta delta : this.listChanges) {
            CDOFeatureDelta newDelta = delta.copy();
            result.listChanges.add(newDelta);
            if (map == null) continue;
            map.put(delta, newDelta);
        }
        if (this.cachedIndices != null) {
            result.cachedIndices = CDOListFeatureDeltaImpl.copyOf(this.cachedIndices, this.cachedIndices.length);
        }
        if (this.cachedSources != null) {
            int length = this.cachedSources.length;
            result.cachedSources = new InternalCDOFeatureDelta.ListTargetAdding[length];
            int i = 0;
            while (i < length) {
                InternalCDOFeatureDelta.ListTargetAdding oldElement = this.cachedSources[i];
                CDOFeatureDelta newElement = (CDOFeatureDelta)map.get(oldElement);
                if (newElement instanceof InternalCDOFeatureDelta.ListTargetAdding) {
                    result.cachedSources[i] = (InternalCDOFeatureDelta.ListTargetAdding)((Object)newElement);
                }
                ++i;
            }
        }
        if (this.unprocessedFeatureDeltas != null) {
            int size = this.unprocessedFeatureDeltas.size();
            result.unprocessedFeatureDeltas = new ArrayList<CDOFeatureDelta>(size);
            for (CDOFeatureDelta oldDelta : this.unprocessedFeatureDeltas) {
                CDOFeatureDelta newDelta = (CDOFeatureDelta)map.get(oldDelta);
                if (newDelta == null) continue;
                result.unprocessedFeatureDeltas.add(newDelta);
            }
        }
        return result;
    }

    @Override
    public void write(CDODataOutput out, EClass eClass) throws IOException {
        super.write(out, eClass);
        out.writeInt(this.originSize);
        out.writeInt(this.listChanges.size());
        for (CDOFeatureDelta featureDelta : this.listChanges) {
            out.writeCDOFeatureDelta(eClass, featureDelta);
        }
    }

    @Override
    public CDOFeatureDelta.Type getType() {
        return CDOFeatureDelta.Type.LIST;
    }

    @Override
    public int getOriginSize() {
        return this.originSize;
    }

    @Override
    public List<CDOFeatureDelta> getListChanges() {
        return this.listChanges;
    }

    public Pair<InternalCDOFeatureDelta.ListTargetAdding[], int[]> reconstructAddedIndices() {
        this.reconstructAddedIndicesWithNoCopy();
        return Pair.create((Object)((InternalCDOFeatureDelta.ListTargetAdding[])CDOListFeatureDeltaImpl.copyOf(this.cachedSources, this.cachedSources.length, this.cachedSources.getClass())), (Object)CDOListFeatureDeltaImpl.copyOf(this.cachedIndices, this.cachedIndices.length));
    }

    private void reconstructAddedIndicesWithNoCopy() {
        if (this.cachedIndices == null || this.unprocessedFeatureDeltas != null) {
            if (this.cachedIndices == null) {
                int initialCapacity = this.listChanges.size() + 1;
                this.cachedIndices = new int[initialCapacity];
                this.cachedSources = new InternalCDOFeatureDelta.ListTargetAdding[initialCapacity];
            } else {
                int requiredCapacity = 1 + this.cachedIndices[0] + this.unprocessedFeatureDeltas.size();
                if (this.cachedIndices.length < requiredCapacity) {
                    int newCapacity = Math.max(requiredCapacity, this.cachedIndices.length * 2);
                    int[] newIndices = new int[newCapacity];
                    System.arraycopy(this.cachedIndices, 0, newIndices, 0, this.cachedIndices.length);
                    this.cachedIndices = newIndices;
                    InternalCDOFeatureDelta.ListTargetAdding[] newSources = new InternalCDOFeatureDelta.ListTargetAdding[newCapacity];
                    System.arraycopy(this.cachedSources, 0, newSources, 0, this.cachedSources.length);
                    this.cachedSources = newSources;
                }
            }
            List<CDOFeatureDelta> featureDeltasToBeProcessed = this.unprocessedFeatureDeltas == null ? this.listChanges : this.unprocessedFeatureDeltas;
            for (CDOFeatureDelta featureDelta : featureDeltasToBeProcessed) {
                if (featureDelta instanceof InternalCDOFeatureDelta.ListIndexAffecting) {
                    InternalCDOFeatureDelta.ListIndexAffecting affecting = (InternalCDOFeatureDelta.ListIndexAffecting)((Object)featureDelta);
                    affecting.affectIndices(this.cachedSources, this.cachedIndices);
                }
                if (!(featureDelta instanceof InternalCDOFeatureDelta.ListTargetAdding)) continue;
                this.cachedIndices[0] = this.cachedIndices[0] + 1;
                this.cachedIndices[this.cachedIndices[0]] = ((InternalCDOFeatureDelta.ListTargetAdding)((Object)featureDelta)).getIndex();
                this.cachedSources[this.cachedIndices[0]] = (InternalCDOFeatureDelta.ListTargetAdding)((Object)featureDelta);
            }
            this.unprocessedFeatureDeltas = null;
        }
    }

    private boolean cleanupWithNewDelta(CDOFeatureDelta featureDelta) {
        EStructuralFeature feature = this.getFeature();
        switch (featureDelta.getType()) {
            case REMOVE: {
                Boolean result;
                if (!(feature instanceof EReference) && !FeatureMapUtil.isFeatureMap((EStructuralFeature)feature) || (result = this.cleanupWithNewRemoveDelta((CDORemoveFeatureDelta)featureDelta)) == null) break;
                return result;
            }
            case SET: {
                Boolean result = this.cleanupWithNewSetDelta((CDOSetFeatureDelta)featureDelta);
                if (result == null) break;
                return result;
            }
        }
        if (this.cachedIndices != null) {
            if (this.unprocessedFeatureDeltas == null) {
                this.unprocessedFeatureDeltas = new ArrayList<CDOFeatureDelta>();
            }
            this.unprocessedFeatureDeltas.add(featureDelta);
        }
        return true;
    }

    private Boolean cleanupWithNewRemoveDelta(CDORemoveFeatureDelta removeFeatureDelta) {
        int indexToRemove = removeFeatureDelta.getIndex();
        this.reconstructAddedIndicesWithNoCopy();
        int i = 1;
        while (i <= this.cachedIndices[0]) {
            int index = this.cachedIndices[i];
            if (indexToRemove == index) {
                InternalCDOFeatureDelta.ListTargetAdding delta = this.cachedSources[i];
                int floatingIndex = delta.getIndex();
                InternalCDOFeatureDelta.ListIndexAffecting affecting = (InternalCDOFeatureDelta.ListIndexAffecting)((Object)removeFeatureDelta);
                affecting.affectIndices(this.cachedSources, this.cachedIndices);
                boolean skip = true;
                ListIterator<CDOFeatureDelta> iterator = this.listChanges.listIterator();
                while (iterator.hasNext()) {
                    CDOFeatureDelta fd = iterator.next();
                    if (skip) {
                        if (fd != delta) continue;
                        skip = false;
                        iterator.remove();
                        if (!(fd instanceof CDOSetFeatureDelta)) continue;
                        return true;
                    }
                    if (fd instanceof CDOAddFeatureDelta) {
                        if (((CDOAddFeatureDelta)fd).getIndex() <= floatingIndex) {
                            ++floatingIndex;
                        }
                        ((InternalCDOFeatureDelta.WithIndex)((Object)fd)).adjustAfterRemoval(floatingIndex);
                        continue;
                    }
                    if (fd instanceof CDORemoveFeatureDelta) {
                        int idx = floatingIndex;
                        if (((CDORemoveFeatureDelta)fd).getIndex() <= floatingIndex) {
                            --floatingIndex;
                        }
                        ((InternalCDOFeatureDelta.WithIndex)((Object)fd)).adjustAfterRemoval(idx);
                        continue;
                    }
                    if (fd instanceof CDOMoveFeatureDelta) {
                        int patchedTo;
                        int patchedFrom;
                        int from = ((CDOMoveFeatureDelta)fd).getOldPosition();
                        int to = ((CDOMoveFeatureDelta)fd).getNewPosition();
                        if (floatingIndex == from) {
                            floatingIndex = to;
                            iterator.remove();
                            continue;
                        }
                        int n = patchedFrom = floatingIndex <= from ? from - 1 : from;
                        if (from > to) {
                            patchedTo = floatingIndex < to ? to - 1 : to;
                        } else {
                            int n2 = patchedTo = floatingIndex <= to ? to - 1 : to;
                        }
                        if (from < floatingIndex && floatingIndex <= to) {
                            --floatingIndex;
                        } else if (to <= floatingIndex && floatingIndex < from) {
                            ++floatingIndex;
                        }
                        if (patchedFrom == patchedTo) {
                            iterator.remove();
                            continue;
                        }
                        ((CDOMoveFeatureDeltaImpl)fd).setOldPosition(patchedFrom);
                        ((CDOMoveFeatureDeltaImpl)fd).setNewPosition(patchedTo);
                        continue;
                    }
                    if (!(fd instanceof CDOSetFeatureDelta)) continue;
                    ((InternalCDOFeatureDelta.WithIndex)((Object)fd)).adjustAfterRemoval(floatingIndex);
                }
                return false;
            }
            ++i;
        }
        return null;
    }

    private Boolean cleanupWithNewSetDelta(CDOSetFeatureDelta featureDelta) {
        int size = this.listChanges.size();
        final class DeltaProxy
        implements InternalCDOFeatureDelta.WithIndex {
            private final int indexIntoListChanges;
            private int index;

            public DeltaProxy(int indexIntoListChanges, int index) {
                this.indexIntoListChanges = indexIntoListChanges;
                this.index = index;
            }

            public int getIndexIntoListChanges() {
                return this.indexIntoListChanges;
            }

            public int getIndex() {
                return this.index;
            }

            public void adjustAfterAddition(int index) {
                if (index <= this.index) {
                    ++this.index;
                }
            }

            public void adjustAfterRemoval(int index) {
                if (index < this.index && this.index > 0) {
                    --this.index;
                }
            }
        }
        ArrayList<DeltaProxy> proxies = new ArrayList<DeltaProxy>();
        int i = 0;
        while (i < size) {
            CDOFeatureDelta fd = this.listChanges.get(i);
            switch (fd.getType()) {
                case MOVE: {
                    int oldPosition = ((CDOMoveFeatureDelta)fd).getOldPosition();
                    int newPosition = ((CDOMoveFeatureDelta)fd).getNewPosition();
                    for (DeltaProxy deltaProxy : proxies) {
                        deltaProxy.adjustAfterRemoval(oldPosition);
                        deltaProxy.adjustAfterAddition(newPosition);
                    }
                    break;
                }
                case REMOVE: {
                    int index = ((CDORemoveFeatureDelta)fd).getIndex();
                    for (DeltaProxy proxy : proxies) {
                        proxy.adjustAfterRemoval(index);
                    }
                    break;
                }
                case ADD: {
                    int index = ((CDOAddFeatureDelta)fd).getIndex();
                    for (DeltaProxy proxy : proxies) {
                        proxy.adjustAfterAddition(index);
                    }
                    proxies.add(new DeltaProxy(i, index));
                    break;
                }
                case SET: {
                    int index = ((CDOSetFeatureDelta)fd).getIndex();
                    proxies.add(new DeltaProxy(i, index));
                }
            }
            ++i;
        }
        int index = featureDelta.getIndex();
        for (DeltaProxy proxy : proxies) {
            if (proxy.getIndex() != index) continue;
            int indexIntoListChanges = proxy.getIndexIntoListChanges();
            CDOFeatureDelta cDOFeatureDelta = this.listChanges.get(indexIntoListChanges);
            if (cDOFeatureDelta.getType() == CDOFeatureDelta.Type.ADD) {
                ((CDOAddFeatureDeltaImpl)cDOFeatureDelta).setValue(featureDelta.getValue());
                return false;
            }
            this.listChanges.remove(indexIntoListChanges);
            break;
        }
        return null;
    }

    public void add(CDOFeatureDelta featureDelta) {
        if (this.cleanupWithNewDelta(featureDelta)) {
            this.listChanges.add(featureDelta);
        }
    }

    @Override
    public Object applyTo(CDORevision revision) {
        for (CDOFeatureDelta featureDelta : this.listChanges) {
            ((CDOFeatureDeltaImpl)featureDelta).applyTo(revision);
        }
        return null;
    }

    @Override
    public boolean adjustReferences(CDOReferenceAdjuster adjuster) {
        boolean changed = false;
        for (CDOFeatureDelta featureDelta : this.listChanges) {
            changed |= ((CDOFeatureDeltaImpl)featureDelta).adjustReferences(adjuster);
        }
        return changed;
    }

    @Override
    public void accept(CDOFeatureDeltaVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isStructurallyEqual(Object obj) {
        if (!super.isStructurallyEqual(obj)) {
            return false;
        }
        CDOListFeatureDelta that = (CDOListFeatureDelta)obj;
        return ObjectUtil.equals(this.listChanges, that.getListChanges());
    }

    @Override
    protected String toStringAdditional() {
        return "originSize=" + this.originSize + ", list=" + this.listChanges;
    }

    private static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    private static int[] copyOf(int[] original, int newLength) {
        int[] copy = new int[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }
}

