/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.CDOElement;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.util.CDORenameContext;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.explorer.CDOExplorerManager;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.properties.ExplorerUIAdapterFactory;
import org.eclipse.emf.cdo.internal.explorer.checkouts.CDOCheckoutManagerImpl;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.net4j.util.StringUtil;

public class ResourceGroup
extends CDOElement {
    private String name;

    public ResourceGroup(CDOResourceNode delegate) {
        super((EObject)delegate);
        this.reset();
    }

    public CDOResourceNode getDelegate() {
        return (CDOResourceNode)super.getDelegate();
    }

    public void reset() {
        super.reset();
        this.name = this.getDelegate().trimExtension();
    }

    public Object getAdapter(Class adapter) {
        CDOResourceNode delegate;
        CDOCheckout checkout;
        if (adapter == CDORenameContext.class && (checkout = CDOExplorerUtil.getCheckout((Object)(delegate = this.getDelegate()))) != null && checkout.isOpen() && !checkout.isReadOnly()) {
            return new CDORenameContext(){

                public String getType() {
                    return "Resource Group";
                }

                public String getName() {
                    return ResourceGroup.this.name;
                }

                public void setName(final String name) {
                    String type = this.getType();
                    new Job("Rename " + type.toLowerCase()){

                        protected IStatus run(IProgressMonitor monitor) {
                            CDOCommitInfo commitInfo;
                            CDOCheckout checkout;
                            block8: {
                                CDOResourceNode resourceNode = ResourceGroup.this.getDelegate();
                                checkout = CDOExplorerUtil.getCheckout((Object)resourceNode);
                                CDOTransaction transaction = checkout.openTransaction();
                                commitInfo = null;
                                try {
                                    try {
                                        Object[] objectArray = ResourceGroup.this.getChildren();
                                        int n = objectArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            Object child = objectArray[n2];
                                            if (child instanceof CDOResourceNode) {
                                                CDOResourceNode childNode = (CDOResourceNode)child;
                                                CDOResourceNode transactionalChildNode = (CDOResourceNode)transaction.getObject((EObject)childNode);
                                                String extension = transactionalChildNode.getExtension();
                                                transactionalChildNode.setName(String.valueOf(name) + "." + extension);
                                            }
                                            ++n2;
                                        }
                                        commitInfo = transaction.commit();
                                    }
                                    catch (Exception ex) {
                                        OM.LOG.error((Throwable)ex);
                                        transaction.close();
                                        break block8;
                                    }
                                }
                                catch (Throwable throwable) {
                                    transaction.close();
                                    throw throwable;
                                }
                                transaction.close();
                            }
                            if (commitInfo != null) {
                                checkout.getView().waitForUpdate(commitInfo.getTimeStamp());
                                CDOCheckoutManagerImpl checkoutManager = (CDOCheckoutManagerImpl)CDOExplorerUtil.getCheckoutManager();
                                checkoutManager.fireElementChangedEvent(CDOExplorerManager.ElementsChangedEvent.StructuralImpact.PARENT, (Object)ResourceGroup.this);
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }

                public String validateName(String name) {
                    String type = this.getType();
                    if (StringUtil.isEmpty((String)name)) {
                        return String.valueOf(type) + " name is empty.";
                    }
                    if (name.equals(this.getName())) {
                        return null;
                    }
                    Object[] objectArray = ResourceGroup.this.getChildren();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object child = objectArray[n2];
                        if (child instanceof CDOResourceNode) {
                            CDOResourceNode childNode = (CDOResourceNode)child;
                            String extension = childNode.getExtension();
                            String error = ExplorerUIAdapterFactory.checkUniqueName(childNode, String.valueOf(name) + "." + extension, type);
                            if (error != null) {
                                return error;
                            }
                        }
                        ++n2;
                    }
                    return null;
                }
            };
        }
        return super.getAdapter(adapter);
    }

    public String toString(Object child) {
        return ((CDOResourceNode)child).getExtension();
    }

    public String toString() {
        return this.name;
    }
}

