/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts.wizards;

import java.util.Properties;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.CheckoutWizard;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.CheckoutWizardPage;
import org.eclipse.emf.cdo.internal.explorer.checkouts.CDOCheckoutManagerImpl;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CheckoutLabelPage
extends CheckoutWizardPage {
    private String label;
    private Label repositoryLabel;
    private Label typeLabel;
    private Label branchLabel;
    private Label timeLabel;
    private Label rootLabel;
    private Text labelText;

    public CheckoutLabelPage() {
        super("Checkout Label", "Enter the label of the new checkout.");
    }

    public final String getLabel() {
        return this.label;
    }

    public final void setLabel(String label) {
        if (!ObjectUtil.equals((Object)this.label, (Object)label)) {
            CheckoutLabelPage.log("Setting label to " + label);
            this.label = label;
            if (this.labelText != null && !this.labelText.getText().equals(label)) {
                this.labelText.setText(StringUtil.safe((String)label));
            }
        }
    }

    protected Layout createCompositeLayout() {
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        return gridLayout;
    }

    protected void createUI(Composite parent) {
        new Label(parent, 0).setText("Repository:");
        this.repositoryLabel = new Label(parent, 0);
        this.repositoryLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(parent, 0).setText("Type:");
        this.typeLabel = new Label(parent, 0);
        this.typeLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(parent, 0).setText("Branch:");
        this.branchLabel = new Label(parent, 0);
        this.branchLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(parent, 0).setText("Time:");
        this.timeLabel = new Label(parent, 0);
        this.timeLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(parent, 0).setText("Root:");
        this.rootLabel = new Label(parent, 0);
        this.rootLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(parent, 0).setText("Label:");
        this.labelText = new Text(parent, 2048);
        this.labelText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.labelText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CheckoutLabelPage.this.setLabel(CheckoutLabelPage.this.labelText.getText());
                CheckoutLabelPage.this.validate();
            }
        });
    }

    protected void repositoryChanged(CDORepository repository) {
        this.clearLabel();
        super.repositoryChanged(repository);
    }

    protected void typeChanged(String type) {
        this.clearLabel();
        super.typeChanged(type);
    }

    protected void branchPointChanged(int branchID, long timeStamp) {
        this.clearLabel();
        super.branchPointChanged(branchID, timeStamp);
    }

    protected void rootObjectChanged(CDOID rootID) {
        this.clearLabel();
        super.rootObjectChanged(rootID);
    }

    protected void pageActivated() {
        CheckoutWizard wizard = this.getWizard();
        this.repositoryLabel.setText(wizard.getRepositoryPage().getRepository().getLabel());
        String type = wizard.getTypePage().getType();
        this.typeLabel.setText(type);
        CDOBranchPoint branchPoint = wizard.getBranchPointPage().getBranchPoint();
        this.branchLabel.setText(branchPoint.getBranch().getPathName());
        this.timeLabel.setText(CDOCommonUtil.formatTimeStamp((long)branchPoint.getTimeStamp()));
        String rootObjectText = wizard.getRootObjectPage().getRootObjectText();
        this.rootLabel.setText(rootObjectText);
        if (StringUtil.isEmpty((String)this.label)) {
            String label = String.valueOf(StringUtil.capAll((String)type.replace('-', ' '))) + " Checkout";
            this.setLabel(((CDOCheckoutManagerImpl)CDOExplorerUtil.getCheckoutManager()).getUniqueLabel(label));
        }
        this.labelText.setFocus();
        this.labelText.selectAll();
        super.pageActivated();
    }

    protected boolean doValidate() throws CheckoutWizardPage.ValidationProblem {
        if (StringUtil.isEmpty((String)this.label)) {
            return false;
        }
        int i = 0;
        while (i < this.label.length()) {
            char c = this.label.charAt(i);
            int j = 0;
            while (j < "/\\:;,".length()) {
                if (c == "/\\:;,".charAt(j)) {
                    throw new CheckoutWizardPage.ValidationProblem("Invalid character: " + "/\\:;,".substring(j, 1));
                }
                ++j;
            }
            ++i;
        }
        if (CDOExplorerUtil.getCheckoutManager().getCheckoutByLabel(this.label) != null) {
            throw new CheckoutWizardPage.ValidationProblem("Label is not unique.");
        }
        return true;
    }

    protected void fillProperties(Properties properties) {
        properties.setProperty("label", this.label);
    }

    private void clearLabel() {
        this.label = null;
        if (this.labelText != null) {
            this.labelText.setText("");
        }
    }
}

