/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts.wizards;

import java.util.Properties;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.ui.checkouts.wizards.CheckoutWizardPage;
import org.eclipse.emf.cdo.explorer.ui.repositories.CDORepositoriesView;
import org.eclipse.emf.cdo.explorer.ui.repositories.CDORepositoryItemProvider;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class CheckoutRepositoryPage
extends CheckoutWizardPage {
    private CDORepository repository;
    private boolean skip;
    private CDOSession session;
    private TableViewer tableViewer;

    public CheckoutRepositoryPage() {
        super("Repository", "Select the CDO model repository from which to checkout.");
    }

    public final CDORepository getRepository() {
        return this.repository;
    }

    public final void setRepository(CDORepository repository) {
        if (this.repository != repository) {
            this.releaseSession();
            CheckoutRepositoryPage.log("Setting repository to " + repository);
            this.repository = repository;
            this.repositoryChanged(repository);
        }
    }

    public final void skip() {
        this.skip = true;
    }

    public CDOSession getSession() {
        if (this.session == null && this.repository != null) {
            CheckoutRepositoryPage.log("Acquiring session from " + this.repository);
            this.session = this.repository.acquireSession();
        }
        return this.session;
    }

    private void releaseSession() {
        if (this.repository != null && this.session != null) {
            CheckoutRepositoryPage.log("Releasing session of " + this.repository);
            this.repository.releaseSession();
            this.session = null;
        }
    }

    public void dispose() {
        this.releaseSession();
        super.dispose();
    }

    protected void createUI(final Composite parent) {
        TableColumnLayout tableLayout = new TableColumnLayout();
        Composite tableComposite = new Composite(parent, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        tableComposite.setLayout((Layout)tableLayout);
        CDORepositoryItemProvider itemProvider = new CDORepositoryItemProvider();
        this.tableViewer = new TableViewer(tableComposite, 67584);
        this.tableViewer.setContentProvider((IContentProvider)itemProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)itemProvider);
        this.tableViewer.setInput((Object)CDOExplorerUtil.getRepositoryManager());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)CheckoutRepositoryPage.this.tableViewer.getSelection();
                if (selection.size() == 1) {
                    CheckoutRepositoryPage.this.setRepository((CDORepository)selection.getFirstElement());
                }
                CheckoutRepositoryPage.this.validate();
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CheckoutRepositoryPage.this.showNextPage();
            }
        });
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        TableColumn repositoryColumn = new TableColumn(table, 0);
        repositoryColumn.setText("Repository");
        tableLayout.setColumnData((Widget)repositoryColumn, (ColumnLayoutData)new ColumnWeightData(100, 150, true));
        TableColumn modeColumn = new TableColumn(table, 0);
        modeColumn.setText("Versioning Mode");
        tableLayout.setColumnData((Widget)modeColumn, (ColumnLayoutData)new ColumnWeightData(0, 120, true));
        TableColumn idColumn = new TableColumn(table, 0);
        idColumn.setText("ID Generation");
        tableLayout.setColumnData((Widget)idColumn, (ColumnLayoutData)new ColumnWeightData(0, 100, true));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        buttonComposite.setLayout((Layout)gridLayout);
        Button newButton = new Button(buttonComposite, 0);
        newButton.setText("New Repository...");
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = parent.getShell();
                CDORepositoriesView.newRepository(shell);
            }
        });
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                CheckoutRepositoryPage.this.pageActivated();
            }
        });
    }

    protected void pageActivated() {
        if (this.repository != null) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.repository));
        }
        if (this.skip) {
            this.skip = false;
            this.showNextPage();
        }
    }

    protected boolean doValidate() throws CheckoutWizardPage.ValidationProblem {
        return this.repository != null;
    }

    protected void fillProperties(Properties properties) {
        properties.setProperty("repository", this.repository.getID());
    }
}

