/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.handlers;

import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.internal.explorer.checkouts.OfflineCDOCheckout;
import org.eclipse.emf.cdo.internal.ui.Support;
import org.eclipse.emf.cdo.spi.workspace.InternalCDOWorkspace;
import org.eclipse.emf.cdo.transaction.CDOCommitContext;
import org.eclipse.emf.cdo.transaction.CDODefaultTransactionHandler2;
import org.eclipse.emf.cdo.transaction.CDOMerger;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandlerBase;
import org.eclipse.emf.cdo.ui.compare.CDOCompareEditorUtil;
import org.eclipse.emf.cdo.ui.internal.compare.CompareCDOMerger;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.util.ConcurrentAccessException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.workspace.CDOWorkspace;
import org.eclipse.emf.spi.cdo.DefaultCDOMerger;
import org.eclipse.net4j.util.registry.IRegistry;
import org.eclipse.net4j.util.ui.handlers.AbstractBaseHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceUpdateHandler
extends AbstractBaseHandler<OfflineCDOCheckout> {
    public WorkspaceUpdateHandler() {
        super(OfflineCDOCheckout.class, Boolean.valueOf(false));
    }

    protected void doExecute(ExecutionEvent event, IProgressMonitor monitor) throws Exception {
        OfflineCDOCheckout checkout = (OfflineCDOCheckout)this.elements.get(0);
        InternalCDOWorkspace workspace = checkout.getWorkspace();
        if (workspace != null) {
            try {
                this.mergeDefault(checkout, (CDOWorkspace)workspace, monitor);
            }
            catch (CDOMerger.ConflictException ex) {
                if (Support.COMPARE.isAvailable()) {
                    this.mergeCompare(checkout, (CDOWorkspace)workspace);
                }
                throw ex;
            }
        }
    }

    private void mergeCompare(final OfflineCDOCheckout checkout, final CDOWorkspace workspace) {
        CDOCompareEditorUtil.runWithTitle((String)("Update " + checkout.getLabel()), (Runnable)new Runnable(){

            public void run() {
                CDOTransaction transaction = workspace.update((CDOMerger)new CompareCDOMerger(){

                    public void merge(CDOTransaction localTransaction, CDOView remoteView, Set<CDOID> affectedIDs) throws CDOMerger.ConflictException {
                        IRegistry remoteProperties = remoteView.properties();
                        remoteProperties.put((Object)"comparison.image", (Object)OM.getImage("icons/repository.gif"));
                        remoteProperties.put((Object)"comparison.label", (Object)"From remote");
                        IRegistry localProperties = localTransaction.properties();
                        localProperties.put((Object)"comparison.image", (Object)OM.getImage("icons/checkout.gif"));
                        localProperties.put((Object)"comparison.label", (Object)"To local");
                        super.merge(localTransaction, remoteView, affectedIDs);
                    }
                });
                transaction.addTransactionHandler((CDOTransactionHandlerBase)new CDODefaultTransactionHandler2(){

                    public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
                        checkout.refresh();
                    }
                });
            }
        });
    }

    private void mergeDefault(OfflineCDOCheckout checkout, CDOWorkspace workspace, IProgressMonitor monitor) throws ConcurrentAccessException, CommitException {
        CDOTransaction transaction = workspace.update((CDOMerger)new DefaultCDOMerger.PerFeature.ManyValued());
        transaction.commit(monitor);
        transaction.close();
        checkout.refresh();
    }
}

