/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.properties;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.CDOElement;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.util.CDORenameContext;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.explorer.CDOExplorerManager;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.internal.explorer.AbstractElement;
import org.eclipse.emf.cdo.internal.explorer.checkouts.CDOCheckoutManagerImpl;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplorerUIAdapterFactory
implements IAdapterFactory {
    private static final Class<CDORenameContext> CLASS_EXPLORER_RENAME_CONTEXT = CDORenameContext.class;
    private static final Class<CDOElement.StateProvider> CLASS_STATE_PROVIDER = CDOElement.StateProvider.class;
    private static final Class<?>[] CLASSES = new Class[]{CLASS_EXPLORER_RENAME_CONTEXT, CLASS_STATE_PROVIDER};

    public Class<?>[] getAdapterList() {
        return CLASSES;
    }

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        EObject eObject;
        CDOCheckout checkout;
        if (adapterType == CLASS_EXPLORER_RENAME_CONTEXT) {
            CDOResourceNode resourceNode;
            CDOCheckout checkout2;
            if (adaptableObject instanceof AbstractElement) {
                AbstractElement element = (AbstractElement)adaptableObject;
                return (T)this.createRenameContext(element);
            }
            if (adaptableObject instanceof CDOBranch) {
                CDOBranch branch = (CDOBranch)adaptableObject;
                return (T)this.createRenameContext(branch);
            }
            if (adaptableObject instanceof CDOResourceNode && (checkout2 = CDOExplorerUtil.getCheckout((Object)(resourceNode = (CDOResourceNode)adaptableObject))) != null && !checkout2.isReadOnly()) {
                return (T)this.createRenameContext(resourceNode);
            }
        } else if (adapterType == CLASS_STATE_PROVIDER && adaptableObject instanceof EObject && (checkout = CDOExplorerUtil.getCheckout((Object)(eObject = (EObject)adaptableObject))) != null) {
            return (T)checkout;
        }
        return null;
    }

    private Object createRenameContext(final AbstractElement element) {
        return new CDORenameContext(){

            public String getType() {
                String type = StringUtil.capAll((String)element.getType());
                if (element instanceof CDORepository) {
                    type = String.valueOf(type) + " Repository";
                } else if (element instanceof CDOCheckout) {
                    type = String.valueOf(type) + " Checkout";
                }
                return type;
            }

            public String getName() {
                return element.getLabel();
            }

            public void setName(String name) {
                element.setLabel(name);
            }

            public String validateName(String name) {
                return element.validateLabel(name);
            }
        };
    }

    private Object createRenameContext(final CDOBranch branch) {
        return new CDORenameContext(){

            public String getType() {
                return "Branch";
            }

            public String getName() {
                return branch.getName();
            }

            public void setName(String name) {
                branch.setName(name);
            }

            public String validateName(String name) {
                if (StringUtil.isEmpty((String)name)) {
                    return "Branch name is empty.";
                }
                if (name.equals(this.getName())) {
                    return null;
                }
                CDOBranch baseBranch = branch.getBase().getBranch();
                if (baseBranch.getBranch(name) != null) {
                    return "Branch name is not unique within the base branch.";
                }
                return null;
            }
        };
    }

    private Object createRenameContext(final CDOResourceNode resourceNode) {
        return new CDORenameContext(){

            public String getType() {
                return resourceNode instanceof CDOResourceFolder ? "Folder" : "Resource";
            }

            public String getName() {
                return resourceNode.getName();
            }

            public void setName(final String name) {
                new Job("Rename " + this.getType().toLowerCase()){

                    protected IStatus run(IProgressMonitor monitor) {
                        CDOCommitInfo commitInfo;
                        CDOCheckout checkout;
                        block8: {
                            CDOTransaction transaction;
                            checkout = CDOExplorerUtil.getCheckout((Object)resourceNode);
                            if (checkout != null) {
                                transaction = checkout.openTransaction();
                            } else {
                                CDOView view = resourceNode.cdoView();
                                transaction = view.getSession().openTransaction(view.getBranch());
                            }
                            commitInfo = null;
                            try {
                                try {
                                    CDOResourceNode transactionalResourceNode = (CDOResourceNode)transaction.getObject((EObject)resourceNode);
                                    transactionalResourceNode.setName(name);
                                    commitInfo = transaction.commit();
                                }
                                catch (Exception ex) {
                                    OM.LOG.error((Throwable)ex);
                                    transaction.close();
                                    break block8;
                                }
                            }
                            catch (Throwable throwable) {
                                transaction.close();
                                throw throwable;
                            }
                            transaction.close();
                        }
                        if (commitInfo != null && checkout != null) {
                            checkout.getView().waitForUpdate(commitInfo.getTimeStamp());
                            CDOCheckoutManagerImpl checkoutManager = (CDOCheckoutManagerImpl)CDOExplorerUtil.getCheckoutManager();
                            checkoutManager.fireElementChangedEvent(CDOExplorerManager.ElementsChangedEvent.StructuralImpact.PARENT, (Object)resourceNode);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }

            public String validateName(String name) {
                String type = this.getType();
                if (StringUtil.isEmpty((String)name)) {
                    return String.valueOf(type) + " name is empty.";
                }
                if (name.equals(this.getName())) {
                    return null;
                }
                return ExplorerUIAdapterFactory.checkUniqueName(resourceNode, name, type);
            }
        };
    }

    public static String checkUniqueName(CDOResourceNode resourceNode, String name, String type) {
        CDOResourceFolder parentFolder = resourceNode.getFolder();
        if (parentFolder == null) {
            CDOView view = resourceNode.cdoView();
            for (EObject eObject : view.getRootResource().getContents()) {
                CDOResourceNode child;
                if (!(eObject instanceof CDOResourceNode) || !ObjectUtil.equals((Object)(child = (CDOResourceNode)eObject).getName(), (Object)name)) continue;
                return String.valueOf(type) + " name is not unique within the root resource.";
            }
        } else if (parentFolder.getNode(name) != null) {
            return String.valueOf(type) + " name is not unique within the parent folder.";
        }
        return null;
    }
}

