/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.explorer.bundle;

import java.io.File;
import org.eclipse.emf.cdo.internal.explorer.checkouts.CDOCheckoutManagerImpl;
import org.eclipse.emf.cdo.internal.explorer.repositories.CDORepositoryManagerImpl;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMBundle;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.OSGiActivator;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.trace.OMTracer;

public abstract class OM {
    public static final String BUNDLE_ID = "org.eclipse.emf.cdo.explorer";
    public static final OMBundle BUNDLE = OMPlatform.INSTANCE.bundle("org.eclipse.emf.cdo.explorer", OM.class);
    public static final OMTracer DEBUG = BUNDLE.tracer("debug");
    public static final OMLogger LOG = BUNDLE.logger();
    private static final String STATE_LOCATION = System.getProperty("org.eclipse.emf.cdo.explorer.stateLocation");
    private static CDORepositoryManagerImpl repositoryManager;
    private static CDOCheckoutManagerImpl checkoutManager;

    public static void initializeManagers(File stateLocation) {
        OM.disposeManagers();
        repositoryManager = new CDORepositoryManagerImpl(new File(stateLocation, "rp"));
        LifecycleUtil.activate((Object)repositoryManager);
        checkoutManager = new CDOCheckoutManagerImpl(new File(stateLocation, "co"));
        LifecycleUtil.activate((Object)checkoutManager);
    }

    public static void disposeManagers() {
        if (checkoutManager != null) {
            LifecycleUtil.deactivate((Object)checkoutManager);
            checkoutManager = null;
        }
        if (repositoryManager != null) {
            LifecycleUtil.deactivate((Object)repositoryManager);
            repositoryManager = null;
        }
    }

    public static CDORepositoryManagerImpl getRepositoryManager() {
        return repositoryManager;
    }

    public static CDOCheckoutManagerImpl getCheckoutManager() {
        return checkoutManager;
    }

    public static final class Activator
    extends OSGiActivator {
        public Activator() {
            super(BUNDLE);
        }

        protected void doStart() throws Exception {
            super.doStart();
            String stateLocation = STATE_LOCATION != null ? STATE_LOCATION : BUNDLE.getStateLocation();
            OM.initializeManagers(new File(stateLocation));
        }

        protected void doStop() throws Exception {
            OM.disposeManagers();
            super.doStop();
        }
    }
}

