/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security.internal.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.cdo.security.Directory;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.security.SecurityItem;
import org.eclipse.emf.cdo.security.SecurityPackage;
import org.eclipse.emf.cdo.security.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.security.internal.ui.util.ActionBarsHelper;
import org.eclipse.emf.cdo.security.internal.ui.util.INewObjectConfigurator;
import org.eclipse.emf.cdo.security.internal.ui.util.ObjectExistsConverter;
import org.eclipse.emf.cdo.security.internal.ui.util.SecurityUIUtil;
import org.eclipse.emf.cdo.security.internal.ui.util.TableLabelProvider;
import org.eclipse.emf.cdo.security.provider.SecurityEditPlugin;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.celleditor.FeatureEditorDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.ui.actions.SelectionListenerAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class OneToManyBlock {
    private final EditingDomain domain;
    private final AdapterFactory adapterFactory;
    private final DataBindingContext context;
    private final IObservableValue input;
    private final IOneToManyConfiguration configuration;
    private final IFilter supportedContentFilter;
    private IObservableList value;
    private TableViewer viewer;
    private INewObjectConfigurator newObjectConfigurator;
    private IActionBars editorActionBars;

    public OneToManyBlock(IManagedForm managedForm, DataBindingContext context, EditingDomain domain, AdapterFactory adapterFactory, EReference reference) {
        this(context, domain, adapterFactory, new OneToManyConfiguration(managedForm, reference));
    }

    public OneToManyBlock(IManagedForm managedForm, DataBindingContext context, EditingDomain domain, AdapterFactory adapterFactory, EReference reference, EClass itemType) {
        this(context, domain, adapterFactory, new OneToManyConfiguration(managedForm, reference, itemType));
    }

    public OneToManyBlock(DataBindingContext context, EditingDomain domain, AdapterFactory adapterFactory, IOneToManyConfiguration blockConfig) {
        this.context = context;
        this.domain = domain;
        this.adapterFactory = adapterFactory;
        this.configuration = blockConfig;
        this.input = new WritableValue(context.getValidationRealm());
        this.supportedContentFilter = SecurityUIUtil.getSupportedElementFilter(this.configuration.getItemType());
    }

    protected IOneToManyConfiguration getConfiguration() {
        return this.configuration;
    }

    protected boolean isTable() {
        return false;
    }

    public void setEditorActionBars(IActionBars actionBars) {
        this.editorActionBars = actionBars;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        Composite tableParent;
        final EReference reference = this.getConfiguration().getModelReference();
        final EClass itemType = this.getConfiguration().getItemType();
        parent.setLayout((Layout)new GridLayout(2, false));
        TableColumnLayout tableLayout = null;
        if (this.isTable()) {
            tableParent = toolkit.createComposite(parent);
            tableLayout = new TableColumnLayout();
            tableParent.setLayout((Layout)tableLayout);
        } else {
            tableParent = parent;
        }
        Table table = toolkit.createTable(tableParent, 772);
        this.viewer = new TableViewer(table);
        if (this.isTable()) {
            tableParent.setLayoutData((Object)new GridData(4, 4, true, true));
            this.configureColumns(this.viewer, tableLayout);
        } else {
            table.setLayoutData((Object)new GridData(4, 4, true, true));
            TableLabelProvider labels = new TableLabelProvider(this.adapterFactory);
            labels.setFireLabelUpdateNotifications(true);
            this.viewer.setLabelProvider((IBaseLabelProvider)labels);
        }
        this.viewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        SecurityUIUtil.applySupportedElementFilter((StructuredViewer)this.viewer, itemType);
        if (itemType != reference.getEReferenceType()) {
            SecurityUIUtil.applyTypeFilter((StructuredViewer)this.viewer, itemType);
        }
        if (this.getConfiguration().getItemFilter() != null) {
            this.viewer.addFilter(SecurityUIUtil.getViewerFilter(this.getConfiguration().getItemFilter()));
        }
        this.viewer.setInput((Object)this.value);
        this.hookUnsupportedModelContentValidation(this.value);
        if (!reference.isContainment()) {
            this.configureDropSupport(this.viewer);
        }
        this.context.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.viewer.getControl()), this.input, null, ObjectExistsConverter.ObjectWritableConverter.createUpdateValueStrategy());
        Composite buttons = toolkit.createComposite(parent);
        FillLayout fill = new FillLayout(512);
        fill.spacing = 5;
        buttons.setLayout((Layout)fill);
        buttons.setLayoutData((Object)new GridData(16384, 128, false, false));
        Button newButton = null;
        Button addButton = null;
        Button removeButton = null;
        newButton = toolkit.createButton(buttons, Messages.OneToManyBlock_0, 8);
        if (!reference.isContainment()) {
            addButton = toolkit.createButton(buttons, Messages.OneToManyBlock_1, 8);
        }
        removeButton = toolkit.createButton(buttons, Messages.OneToManyBlock_2, 8);
        IViewerObservableValue selection = ViewersObservables.observeSingleSelection((Viewer)this.viewer);
        this.context.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)newButton), this.input, null, ObjectExistsConverter.ObjectWritableConverter.createUpdateValueStrategy());
        if (addButton != null) {
            this.context.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)addButton), this.input, null, ObjectExistsConverter.ObjectWritableConverter.createUpdateValueStrategy());
        }
        this.context.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)removeButton), (IObservableValue)selection, null, ObjectExistsConverter.ObjectWritableConverter.createUpdateValueStrategy());
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Realm realm = ((SecurityItem)OneToManyBlock.this.input.getValue()).getRealm();
                Object owner = reference.isContainment() ? OneToManyBlock.this.input.getValue() : SecurityUIUtil.getDirectory(realm, itemType);
                if (owner != null) {
                    IdentityCommand addToReference;
                    CommandParameter param;
                    EObject child = EcoreUtil.create((EClass)itemType);
                    if (reference.isContainment()) {
                        param = new CommandParameter(owner, (Object)reference, (Object)child);
                        addToReference = IdentityCommand.INSTANCE;
                    } else {
                        param = new CommandParameter(owner, (Object)SecurityPackage.Literals.DIRECTORY__ITEMS, (Object)child);
                        addToReference = AddCommand.create((EditingDomain)OneToManyBlock.this.domain, (Object)OneToManyBlock.this.input.getValue(), (Object)reference, Collections.singleton(child));
                    }
                    Command command = CreateChildCommand.create((EditingDomain)OneToManyBlock.this.domain, (Object)owner, (Object)param, Collections.singleton(owner));
                    command = command.chain((Command)addToReference);
                    if (OneToManyBlock.this.getNewObjectConfigurator() != null) {
                        command = command.chain(OneToManyBlock.this.getNewObjectConfigurator().createConfigureCommand(child));
                    }
                    if (OneToManyBlock.this.execute(command)) {
                        OneToManyBlock.this.viewer.setSelection((ISelection)new StructuredSelection((Object)child));
                        OneToManyBlock.this.viewer.getControl().setFocus();
                        OneToManyBlock.this.viewer.refresh((Object)child);
                    }
                }
            }
        });
        if (addButton != null) {
            addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Realm realm = ((SecurityItem)OneToManyBlock.this.input.getValue()).getRealm();
                    Directory directory = SecurityUIUtil.getDirectory(realm, itemType);
                    if (directory != null) {
                        Command command;
                        ArrayList available = new ArrayList(EcoreUtil.getObjectsByType((Collection)directory.getItems(), (EClassifier)itemType));
                        available.removeAll((Collection<?>)OneToManyBlock.this.value);
                        SecurityUIUtil.applySupportedElementFilter(available, itemType);
                        String label = NLS.bind((String)Messages.OneToManyBlock_3, (Object)SecurityEditPlugin.INSTANCE.getString(String.format("_UI_%s_%s_feature", reference.getEContainingClass().getName(), reference.getName())));
                        FeatureEditorDialog dlg = new FeatureEditorDialog(OneToManyBlock.this.viewer.getControl().getShell(), (ILabelProvider)new TableLabelProvider(OneToManyBlock.this.adapterFactory), OneToManyBlock.this.input.getValue(), (EClassifier)reference.getEContainingClass(), Collections.EMPTY_LIST, label, available, false, true, true);
                        if (dlg.open() == 0 && !dlg.getResult().isEmpty() && OneToManyBlock.this.execute(command = AddCommand.create((EditingDomain)OneToManyBlock.this.domain, (Object)OneToManyBlock.this.input.getValue(), (Object)reference, (Collection)dlg.getResult()))) {
                            OneToManyBlock.this.viewer.setSelection((ISelection)new StructuredSelection((List)dlg.getResult()));
                            OneToManyBlock.this.viewer.getControl().setFocus();
                        }
                    }
                }
            });
        }
        SelectionListenerAction<EObject> removeAction = new SelectionListenerAction<EObject>(Messages.OneToManyBlock_2, SharedIcons.getDescriptor((String)"etool16/delete.gif"), (IObservableValue)selection, reference){
            private final /* synthetic */ IObservableValue val$selection;
            private final /* synthetic */ EReference val$reference;
            {
                this.val$selection = iObservableValue;
                this.val$reference = eReference;
                super($anonymous0, $anonymous1);
            }

            public void run() {
                Object selected = this.val$selection.getValue();
                if (selected != null) {
                    Command command = this.val$reference.isContainment() ? DeleteCommand.create((EditingDomain)OneToManyBlock.this.domain, (Object)this.val$selection.getValue()) : RemoveCommand.create((EditingDomain)OneToManyBlock.this.domain, (Object)OneToManyBlock.this.input.getValue(), (Object)this.val$reference, (Object)this.val$selection.getValue());
                    OneToManyBlock.this.execute(command);
                }
            }

            protected boolean updateSelection(IStructuredSelection selection) {
                return super.updateSelection(selection) && SecurityUIUtil.isEditable(OneToManyBlock.this.input.getValue());
            }

            protected Class<EObject> getType() {
                return EObject.class;
            }
        };
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter((SelectionListenerAction)removeAction){
            private final /* synthetic */ SelectionListenerAction val$removeAction;
            {
                this.val$removeAction = selectionListenerAction;
            }

            public void widgetSelected(SelectionEvent e) {
                if (this.val$removeAction.isEnabled()) {
                    this.val$removeAction.run();
                }
            }
        });
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)removeAction);
        new ActionBarsHelper(this.editorActionBars).addGlobalAction(ActionFactory.DELETE.getId(), (IAction)removeAction).install((Viewer)this.viewer);
    }

    public void setInput(IObservableValue input) {
        if (input != null) {
            Observables.pipe((IObservableValue)input, (IObservableValue)this.input);
        }
        if (this.value != null) {
            if (this.viewer != null) {
                this.viewer.setInput(null);
            }
            this.value.dispose();
        }
        this.value = EMFEditObservables.observeDetailList((org.eclipse.core.databinding.observable.Realm)this.context.getValidationRealm(), (EditingDomain)this.domain, (IObservableValue)input, (EStructuralFeature)this.getConfiguration().getModelReference());
        if (this.viewer != null) {
            this.viewer.setInput((Object)this.value);
            this.hookUnsupportedModelContentValidation(this.value);
        }
    }

    protected boolean execute(Command command) {
        boolean result = command.canExecute();
        if (result) {
            this.domain.getCommandStack().execute(command);
        }
        return result;
    }

    public void setNewObjectConfigurator(INewObjectConfigurator newObjectConfigurator) {
        this.newObjectConfigurator = newObjectConfigurator;
    }

    public INewObjectConfigurator getNewObjectConfigurator() {
        return this.newObjectConfigurator;
    }

    protected void configureColumns(TableViewer viewer, TableColumnLayout layout) {
    }

    private boolean canPresent(Object object) {
        IOneToManyConfiguration config = this.getConfiguration();
        boolean result = config.getItemType().isInstance(object);
        if (result && config.getItemFilter() != null) {
            result = config.getItemFilter().select(object);
        }
        if (result) {
            result = AdapterFactoryEditingDomain.getEditingDomainFor((Object)object) == this.domain;
        }
        return result;
    }

    private boolean canPresentAll(ISelection selection) {
        boolean result;
        boolean bl = result = selection != null && !selection.isEmpty();
        if (result && selection instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)selection).iterator();
            while (result && iter.hasNext()) {
                result = this.canPresent(iter.next());
            }
        }
        return result;
    }

    protected void configureDropSupport(final TableViewer viewer) {
        viewer.addDropSupport(7, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                if (!this.canDrop(event)) {
                    event.detail = 0;
                } else if ((event.operations | 1) != 0) {
                    event.detail = 1;
                }
            }

            private boolean canDrop(DropTargetEvent event) {
                boolean result = false;
                if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
                    result = OneToManyBlock.this.canPresentAll(LocalSelectionTransfer.getTransfer().getSelection());
                }
                return result;
            }

            public void dropAccept(DropTargetEvent event) {
                if (!this.canDrop(event)) {
                    event.detail = 0;
                } else if ((event.operations | 1) != 0) {
                    event.detail = 1;
                }
            }

            public void drop(DropTargetEvent event) {
                if (this.canDrop(event)) {
                    IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
                    Command command = AddCommand.create((EditingDomain)OneToManyBlock.this.domain, (Object)OneToManyBlock.this.input.getValue(), (Object)OneToManyBlock.this.getConfiguration().getModelReference(), (Collection)selection.toList());
                    if (OneToManyBlock.this.execute(command)) {
                        viewer.setSelection((ISelection)selection);
                        viewer.getControl().setFocus();
                    }
                }
            }
        });
    }

    protected void hookUnsupportedModelContentValidation(IObservableList observableList) {
        if (observableList != null && this.supportedContentFilter != null) {
            observableList.addChangeListener(new IChangeListener(){

                public void handleChange(ChangeEvent event) {
                    OneToManyBlock.this.checkUnsupportedModelContent((IObservableList)event.getObservable());
                }
            });
            this.checkUnsupportedModelContent(observableList);
        }
    }

    protected void checkUnsupportedModelContent(IObservableList observableList) {
        for (Object element : observableList) {
            if (this.supportedContentFilter.select(element)) continue;
            this.configuration.getManagedForm().getMessageManager().addMessage((Object)this, Messages.TableSection_3, null, 2, this.viewer.getControl());
            return;
        }
        this.configuration.getManagedForm().getMessageManager().removeMessage((Object)this, this.viewer.getControl());
    }

    public static interface IOneToManyConfiguration {
        public IManagedForm getManagedForm();

        public EReference getModelReference();

        public EClass getItemType();

        public IFilter getItemFilter();
    }

    public static class OneToManyConfiguration
    implements IOneToManyConfiguration {
        private final IManagedForm managedForm;
        private final EReference reference;
        private final EClass itemType;
        private final IFilter filter;

        public OneToManyConfiguration(IManagedForm managedForm, EReference reference) {
            this(managedForm, reference, reference.getEReferenceType(), SecurityUIUtil.getSupportedElementFilter(reference.getEReferenceType()));
        }

        public OneToManyConfiguration(IManagedForm managedForm, EReference reference, EClass itemType) {
            this(managedForm, reference, itemType, SecurityUIUtil.getSupportedElementFilter(itemType));
        }

        public OneToManyConfiguration(IManagedForm managedForm, EReference reference, IFilter filter) {
            this(managedForm, reference, reference.getEReferenceType(), filter);
        }

        public OneToManyConfiguration(IManagedForm managedForm, EReference reference, EClass itemType, IFilter filter) {
            this.managedForm = managedForm;
            this.reference = reference;
            this.itemType = itemType;
            this.filter = filter;
        }

        public IManagedForm getManagedForm() {
            return this.managedForm;
        }

        public EReference getModelReference() {
            return this.reference;
        }

        public EClass getItemType() {
            return this.itemType;
        }

        public IFilter getItemFilter() {
            return this.filter;
        }
    }
}

