/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.admin.protocol;

import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.emf.cdo.common.admin.CDOAdminRepository;
import org.eclipse.emf.cdo.server.internal.admin.CDOAdminServer;
import org.eclipse.emf.cdo.server.internal.admin.protocol.CDOAdminServerProtocol;
import org.eclipse.emf.cdo.spi.server.AuthenticationUtil;
import org.eclipse.emf.cdo.spi.server.IAuthenticationProtocol;
import org.eclipse.net4j.signal.IndicationWithResponse;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.security.NotAuthenticatedException;

public class CreateRepositoryIndication
extends IndicationWithResponse {
    private String name;
    private String type;
    private Map<String, Object> properties;

    public CreateRepositoryIndication(CDOAdminServerProtocol protocol) {
        super((SignalProtocol)protocol, (short)2);
    }

    protected void indicating(ExtendedDataInputStream in) throws Exception {
        this.name = in.readString();
        this.type = in.readString();
        this.properties = (Map)in.readObject();
    }

    protected void responding(ExtendedDataOutputStream out) throws Exception {
        try {
            CDOAdminServerProtocol protocol = (CDOAdminServerProtocol)this.getProtocol();
            out.writeBoolean(this.createRepository(protocol));
        }
        catch (NotAuthenticatedException ex) {
            out.writeBoolean(false);
            return;
        }
    }

    protected boolean createRepository(CDOAdminServerProtocol protocol) throws Exception {
        final CDOAdminServer admin = (CDOAdminServer)((Object)protocol.getInfraStructure());
        return (Boolean)AuthenticationUtil.authenticatingOperation((IAuthenticationProtocol)protocol, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                CDOAdminRepository repository = admin.createRepository(CreateRepositoryIndication.this.name, CreateRepositoryIndication.this.type, CreateRepositoryIndication.this.properties);
                if (repository != null) {
                    return true;
                }
                return false;
            }
        }).call();
    }
}

