/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import java.util.LinkedList;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerWriteIndication;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.net4j.util.concurrent.IRWLockManager;

public class LockObjectsIndication
extends CDOServerWriteIndication {
    private CDOSessionProtocol.LockObjectsResult result;

    public LockObjectsIndication(CDOServerProtocol protocol) {
        super(protocol, (short)24);
    }

    protected LockObjectsIndication(CDOServerProtocol protocol, short signalID) {
        super(protocol, signalID);
    }

    protected IView getView(int viewID) {
        return this.getSession().getView(viewID);
    }

    protected void indicating(CDODataInput in) throws IOException {
        int viewID = in.readInt();
        IRWLockManager.LockType lockType = in.readCDOLockType();
        boolean recursive = in.readBoolean();
        long timeout = in.readLong();
        int nRevisions = in.readInt();
        LinkedList<CDORevisionKey> revisionKeys = new LinkedList<CDORevisionKey>();
        int i = 0;
        while (i < nRevisions) {
            revisionKeys.add(in.readCDORevisionKey());
            ++i;
        }
        InternalRepository repository = this.getRepository();
        IView view = this.getView(viewID);
        this.result = repository.lock((InternalView)view, lockType, revisionKeys, recursive, timeout);
    }

    protected void responding(CDODataOutput out) throws IOException {
        out.writeBoolean(this.result.isSuccessful());
        out.writeBoolean(this.result.isTimedOut());
        out.writeBoolean(this.result.isWaitForUpdate());
        out.writeLong(this.result.getRequiredTimestamp());
        CDORevisionKey[] staleRevisions = this.result.getStaleRevisions();
        out.writeInt(staleRevisions.length);
        CDORevisionKey[] cDORevisionKeyArray = staleRevisions;
        int n = staleRevisions.length;
        int n2 = 0;
        while (n2 < n) {
            CDORevisionKey revKey = cDORevisionKeyArray[n2];
            out.writeCDORevisionKey(revKey);
            ++n2;
        }
        out.writeLong(this.result.getTimestamp());
        CDOLockState[] newLockStates = this.result.getNewLockStates();
        out.writeInt(newLockStates.length);
        CDOLockState[] cDOLockStateArray = newLockStates;
        int n3 = newLockStates.length;
        n = 0;
        while (n < n3) {
            CDOLockState lockState = cDOLockStateArray[n];
            out.writeCDOLockState(lockState);
            ++n;
        }
    }
}

