/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOClassInfo;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.concurrent.RWOLockManager;

public class LockStateIndication
extends CDOServerReadIndication {
    private Collection<CDOLockState> existingLockStates;
    private int prefetchDepth = 0;

    public LockStateIndication(CDOServerProtocol protocol) {
        super(protocol, (short)52);
    }

    protected void indicating(CDODataInput in) throws IOException {
        int viewID = in.readInt();
        InternalView view = this.getSession().getView(viewID);
        if (view == null) {
            throw new IllegalStateException("View not found");
        }
        InternalLockManager lockManager = this.getRepository().getLockingManager();
        this.existingLockStates = new ArrayList<CDOLockState>();
        int n = in.readInt();
        if (n < 0) {
            n = -n;
            this.prefetchDepth = in.readInt();
        }
        if (n == 0) {
            List lockStates = lockManager.getLockStates();
            for (RWOLockManager.LockState lockState : lockStates) {
                this.existingLockStates.add(CDOLockUtil.createLockState((RWOLockManager.LockState)lockState));
            }
        } else {
            int i = 0;
            while (i < n) {
                CDOID id = in.readCDOID();
                this.prefetchLockStates(this.prefetchDepth >= 0 ? this.prefetchDepth : Integer.MAX_VALUE, id, view);
                ++i;
            }
        }
    }

    private void prefetchLockStates(int depth, CDOID id, InternalView view) {
        this.addLockState(id, view);
        if (depth > 0) {
            --depth;
            InternalCDORevision revision = (InternalCDORevision)view.getRevision(id);
            InternalCDOClassInfo classInfo = revision.getClassInfo();
            EStructuralFeature[] eStructuralFeatureArray = classInfo.getAllPersistentFeatures();
            int n = eStructuralFeatureArray.length;
            int n2 = 0;
            while (n2 < n) {
                EReference reference;
                EStructuralFeature feature = eStructuralFeatureArray[n2];
                if (feature instanceof EReference && (reference = (EReference)feature).isContainment()) {
                    Object value = revision.getValue((EStructuralFeature)reference);
                    if (value instanceof CDOID) {
                        this.prefetchLockStates(depth, (CDOID)value, view);
                    } else if (value instanceof Collection) {
                        Collection c = (Collection)value;
                        for (Object e : c) {
                            if (!(e instanceof CDOID)) continue;
                            this.prefetchLockStates(depth, (CDOID)e, view);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private void addLockState(CDOID id, InternalView view) {
        Object key = this.getRepository().isSupportingBranches() ? CDOIDUtil.createIDAndBranch((CDOID)id, (CDOBranch)view.getBranch()) : id;
        RWOLockManager.LockState lockState = this.getRepository().getLockingManager().getLockState(key);
        if (lockState != null) {
            this.existingLockStates.add(CDOLockUtil.createLockState((RWOLockManager.LockState)lockState));
        }
    }

    protected void responding(CDODataOutput out) throws IOException {
        out.writeInt(this.existingLockStates.size());
        for (CDOLockState lockState : this.existingLockStates) {
            out.writeCDOLockState(lockState);
        }
    }
}

