/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.CDOCommonView;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRange;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDGenerator;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lob.CDOLobHandler;
import org.eclipse.emf.cdo.common.lock.CDOLockChangeInfo;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.protocol.CDOProtocol;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionCacheAdder;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.common.util.RepositoryStateChangedEvent;
import org.eclipse.emf.cdo.common.util.RepositoryTypeChangedEvent;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.internal.common.model.CDOPackageRegistryImpl;
import org.eclipse.emf.cdo.internal.server.CommitManager;
import org.eclipse.emf.cdo.internal.server.InstancesQueryHandler;
import org.eclipse.emf.cdo.internal.server.LockingManager;
import org.eclipse.emf.cdo.internal.server.QueryManager;
import org.eclipse.emf.cdo.internal.server.ResourcesQueryHandler;
import org.eclipse.emf.cdo.internal.server.SessionManager;
import org.eclipse.emf.cdo.internal.server.TimeStampAuthority;
import org.eclipse.emf.cdo.internal.server.TransactionCommitContext;
import org.eclipse.emf.cdo.internal.server.XRefsQueryHandler;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.IQueryHandlerProvider;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IStoreChunkReader;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.CDOReplicationContext;
import org.eclipse.emf.cdo.spi.common.CDOReplicationInfo;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeSetSegment;
import org.eclipse.emf.cdo.spi.common.commit.CDOCommitInfoUtil;
import org.eclipse.emf.cdo.spi.common.commit.CDORevisionAvailabilityInfo;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.PointerCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.RevisionInfo;
import org.eclipse.emf.cdo.spi.common.revision.SyntheticCDORevision;
import org.eclipse.emf.cdo.spi.server.ContainerQueryHandlerProvider;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalCommitManager;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalQueryManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.cdo.spi.server.InternalTransaction;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.internal.cdo.object.CDOFactoryImpl;
import org.eclipse.emf.internal.cdo.util.CompletePackageClosure;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.net4j.internal.util.concurrent.IExecutorServiceProvider;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.MoveableList;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.concurrent.RWOLockManager;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.monitor.ProgressDistributor;
import org.eclipse.net4j.util.transaction.TransactionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Repository
extends Container<Object>
implements InternalRepository,
IExecutorServiceProvider {
    private static final int UNCHUNKED = -1;
    private static final int NONE = 0;
    private String name;
    private String uuid;
    private InternalStore store;
    private CDOCommonRepository.Type type = CDOCommonRepository.Type.MASTER;
    private CDOCommonRepository.State state = CDOCommonRepository.State.INITIAL;
    private Map<String, String> properties;
    private boolean supportingAudits;
    private boolean supportingBranches;
    private boolean serializingCommits;
    private boolean ensuringReferentialIntegrity;
    private CDOCommonRepository.IDGenerationLocation idGenerationLocation;
    private long optimisticLockingTimeout = 10000L;
    private Semaphore packageRegistryCommitLock = new Semaphore(1);
    private InternalCDOPackageRegistry packageRegistry;
    private InternalCDOBranchManager branchManager;
    private InternalCDORevisionManager revisionManager;
    private InternalCDOCommitInfoManager commitInfoManager;
    private InternalSessionManager sessionManager;
    private InternalQueryManager queryManager;
    private InternalCommitManager commitManager;
    private InternalLockManager lockingManager;
    private IQueryHandlerProvider queryHandlerProvider;
    private IManagedContainer container;
    private List<IRepository.ReadAccessHandler> readAccessHandlers = new ArrayList<IRepository.ReadAccessHandler>();
    private List<IRepository.WriteAccessHandler> writeAccessHandlers = new ArrayList<IRepository.WriteAccessHandler>();
    private EPackage[] initialPackages;
    private TimeStampAuthority timeStampAuthority = new TimeStampAuthority(this);
    private long lastTreeRestructuringCommit = -1L;
    @ReflectUtil.ExcludeFromDump
    private transient Object commitTransactionLock = new Object();
    @ReflectUtil.ExcludeFromDump
    private transient Object createBranchLock = new Object();
    private boolean skipInitialization;
    private CDOID rootResourceID;

    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getUUID() {
        if (this.uuid == null) {
            this.uuid = this.getProperties().get("overrideUUID");
            if (this.uuid == null) {
                this.uuid = UUID.randomUUID().toString();
            } else if (this.uuid.length() == 0) {
                this.uuid = this.getName();
            }
        }
        return this.uuid;
    }

    @Override
    public InternalStore getStore() {
        return this.store;
    }

    @Override
    public void setStore(InternalStore store) {
        this.store = store;
    }

    public CDOCommonRepository.Type getType() {
        return this.type;
    }

    @Override
    public void setType(CDOCommonRepository.Type type) {
        this.checkArg(type, "type");
        if (this.type != type) {
            this.changingType(this.type, type);
        }
    }

    protected void changingType(CDOCommonRepository.Type oldType, CDOCommonRepository.Type newType) {
        this.type = newType;
        this.fireEvent((IEvent)new RepositoryTypeChangedEvent((INotifier)this, oldType, newType));
        if (this.sessionManager != null) {
            this.sessionManager.sendRepositoryTypeNotification(oldType, newType);
        }
    }

    public CDOCommonRepository.State getState() {
        return this.state;
    }

    @Override
    public void setState(CDOCommonRepository.State state) {
        this.checkArg(state, "state");
        if (this.state != state) {
            this.changingState(this.state, state);
        }
    }

    protected void changingState(CDOCommonRepository.State oldState, CDOCommonRepository.State newState) {
        this.state = newState;
        this.fireEvent((IEvent)new RepositoryStateChangedEvent((INotifier)this, oldState, newState));
        if (this.sessionManager != null) {
            this.sessionManager.sendRepositoryStateNotification(oldState, newState, this.getRootResourceID());
        }
    }

    public boolean waitWhileInitial(IProgressMonitor monitor) {
        return CDOCommonUtil.waitWhileInitial((CDOCommonRepository)this, (INotifier)this, (IProgressMonitor)monitor);
    }

    @Override
    public synchronized Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties;
    }

    @Override
    public synchronized void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean isAuthenticating() {
        if (this.sessionManager != null) {
            return this.sessionManager.getAuthenticator() != null;
        }
        return false;
    }

    public boolean isSupportingAudits() {
        return this.supportingAudits;
    }

    public boolean isSupportingBranches() {
        return this.supportingBranches;
    }

    @Deprecated
    public boolean isSupportingEcore() {
        return true;
    }

    public boolean isSerializingCommits() {
        return this.serializingCommits;
    }

    public boolean isEnsuringReferentialIntegrity() {
        return this.ensuringReferentialIntegrity;
    }

    public CDOCommonRepository.IDGenerationLocation getIDGenerationLocation() {
        return this.idGenerationLocation;
    }

    @Override
    public long getOptimisticLockingTimeout() {
        return this.optimisticLockingTimeout;
    }

    @Override
    public void setOptimisticLockingTimeout(long optimisticLockingTimeout) {
        this.optimisticLockingTimeout = optimisticLockingTimeout;
    }

    public String getStoreType() {
        return this.store.getType();
    }

    public Set<CDOID.ObjectType> getObjectIDTypes() {
        return this.store.getObjectIDTypes();
    }

    public CDOID getRootResourceID() {
        return this.rootResourceID;
    }

    @Override
    public void setRootResourceID(CDOID rootResourceID) {
        this.rootResourceID = rootResourceID;
    }

    public Object processPackage(Object value) {
        CDOFactoryImpl.prepareDynamicEPackage((Object)value);
        return value;
    }

    public EPackage[] loadPackages(CDOPackageUnit packageUnit) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        return accessor.loadPackageUnit((InternalCDOPackageUnit)packageUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Integer, Long> createBranch(int branchID, InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
        if (!this.isSupportingBranches()) {
            throw new IllegalStateException("Branching is not supported by " + this);
        }
        long timeStamp = this.getTimeStamp();
        long baseTimeStamp = branchInfo.getBaseTimeStamp();
        if (baseTimeStamp == 0L || baseTimeStamp > timeStamp) {
            baseTimeStamp = timeStamp;
            branchInfo = new InternalCDOBranchManager.BranchLoader.BranchInfo(branchInfo.getName(), branchInfo.getBaseBranchID(), baseTimeStamp);
        }
        Object object = this.createBranchLock;
        synchronized (object) {
            IStoreAccessor accessor = StoreThreadLocal.getAccessor();
            return accessor.createBranch(branchID, branchInfo);
        }
    }

    public InternalCDOBranchManager.BranchLoader.BranchInfo loadBranch(int branchID) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        return accessor.loadBranch(branchID);
    }

    public InternalCDOBranchManager.BranchLoader.SubBranchInfo[] loadSubBranches(int branchID) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        return accessor.loadSubBranches(branchID);
    }

    public int loadBranches(int startID, int endID, CDOBranchHandler branchHandler) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        return accessor.loadBranches(startID, endID, branchHandler);
    }

    @Deprecated
    public void deleteBranch(int branchID) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void renameBranch(int branchID, String newName) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameBranch(int branchID, String oldName, String newName) {
        if (!this.isSupportingBranches()) {
            throw new IllegalStateException("Branching is not supported by " + this);
        }
        if (branchID == 0) {
            throw new IllegalArgumentException("Renaming of the MAIN branch is not supported");
        }
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        if (!(accessor instanceof InternalCDOBranchManager.BranchLoader3)) {
            throw new UnsupportedOperationException("Branch renaming is not supported by " + this);
        }
        Object object = this.createBranchLock;
        synchronized (object) {
            ((InternalCDOBranchManager.BranchLoader3)accessor).renameBranch(branchID, oldName, newName);
        }
    }

    public void loadCommitInfos(CDOBranch branch, long startTime, long endTime, CDOCommitInfoHandler handler) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        accessor.loadCommitInfos(branch, startTime, endTime, handler);
    }

    public CDOCommitData loadCommitData(long timeStamp) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        return accessor.loadCommitData(timeStamp);
    }

    public List<RevisionInfo> loadRevisions(List<RevisionInfo> infos, CDOBranchPoint branchPoint, int referenceChunk, int prefetchDepth) {
        block6: for (RevisionInfo info : infos) {
            CDOID id = info.getID();
            RevisionInfo.Type type = info.getType();
            switch (type) {
                case AVAILABLE_NORMAL: {
                    RevisionInfo.Available.Normal availableInfo = (RevisionInfo.Available.Normal)info;
                    this.checkArg(!availableInfo.isDirect(), "Load is not needed");
                    break;
                }
                case AVAILABLE_POINTER: {
                    RevisionInfo.Available.Pointer pointerInfo = (RevisionInfo.Available.Pointer)info;
                    boolean needsTarget = !pointerInfo.hasTarget();
                    this.checkArg(!pointerInfo.isDirect() || needsTarget, "Load is not needed");
                    if (!needsTarget) break;
                    CDOBranchVersion targetBranchVersion = pointerInfo.getTargetBranchVersion();
                    InternalCDORevision target = this.loadRevisionByVersion(id, targetBranchVersion, referenceChunk);
                    PointerCDORevision pointer = new PointerCDORevision(target.getEClass(), id, pointerInfo.getAvailableBranchVersion().getBranch(), 0L, (CDOBranchVersion)target);
                    info.setResult(target);
                    info.setSynthetic((SyntheticCDORevision)pointer);
                    continue block6;
                }
                case AVAILABLE_DETACHED: {
                    RevisionInfo.Available.Detached detachedInfo = (RevisionInfo.Available.Detached)info;
                    this.checkArg(!detachedInfo.isDirect(), "Load is not needed");
                    break;
                }
                case MISSING: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid revision info type: " + type);
                }
            }
            IStoreAccessor accessor = StoreThreadLocal.getAccessor();
            InternalCDORevision revision = accessor.readRevision(id, branchPoint, referenceChunk, (CDORevisionCacheAdder)this.revisionManager);
            if (revision == null) {
                if (this.isSupportingAudits()) {
                    InternalCDORevision target = this.loadRevisionTarget(id, branchPoint, referenceChunk, accessor);
                    if (target != null) {
                        if (referenceChunk == -1) {
                            target.setUnchunked();
                        }
                        CDOBranch branch = branchPoint.getBranch();
                        long revised = this.loadRevisionRevised(id, branch);
                        PointerCDORevision pointer = new PointerCDORevision(target.getEClass(), id, branch, revised, (CDOBranchVersion)target);
                        info.setSynthetic((SyntheticCDORevision)pointer);
                    }
                    info.setResult(target);
                    continue;
                }
                DetachedCDORevision detachedRevision = new DetachedCDORevision(EcorePackage.Literals.ECLASS, id, branchPoint.getBranch(), 0, 0L);
                info.setSynthetic((SyntheticCDORevision)detachedRevision);
                continue;
            }
            if (revision instanceof DetachedCDORevision) {
                DetachedCDORevision detached = (DetachedCDORevision)revision;
                info.setSynthetic((SyntheticCDORevision)detached);
                continue;
            }
            if (referenceChunk == -1) {
                revision.setUnchunked();
            }
            revision.freeze();
            info.setResult(revision);
        }
        return null;
    }

    private InternalCDORevision loadRevisionTarget(CDOID id, CDOBranchPoint branchPoint, int referenceChunk, IStoreAccessor accessor) {
        CDOBranch branch = branchPoint.getBranch();
        while (!branch.isMainBranch()) {
            branchPoint = branch.getBase();
            branch = branchPoint.getBranch();
            InternalCDORevision revision = accessor.readRevision(id, branchPoint, referenceChunk, (CDORevisionCacheAdder)this.revisionManager);
            if (revision == null) continue;
            revision.freeze();
            return revision;
        }
        return null;
    }

    private long loadRevisionRevised(CDOID id, CDOBranch branch) {
        InternalCDORevision revision = this.loadRevisionByVersion(id, branch.getVersion(1), -1);
        if (revision != null) {
            return revision.getTimeStamp() - 1L;
        }
        return 0L;
    }

    public InternalCDORevision loadRevisionByVersion(CDOID id, CDOBranchVersion branchVersion, int referenceChunk) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        return accessor.readRevisionByVersion(id, branchVersion, referenceChunk, (CDORevisionCacheAdder)this.revisionManager);
    }

    public CDOBranchPointRange loadObjectLifetime(CDOID id, CDOBranchPoint branchPoint) {
        InternalCDORevision revision = this.revisionManager.getRevision(id, branchPoint, -1, 0, true);
        if (revision == null) {
            return null;
        }
        CDORevision firstRevision = this.getFirstRevision(id, (CDORevision)revision);
        if (firstRevision == null) {
            return null;
        }
        CDOBranchPoint lastPoint = this.getLastBranchPoint((CDORevision)revision, branchPoint);
        return CDOBranchUtil.createRange((CDOBranchPoint)firstRevision, (CDOBranchPoint)lastPoint);
    }

    private CDORevision getFirstRevision(CDOID id, CDORevision revision) {
        CDOBranchPoint base;
        InternalCDORevision baseRevision;
        CDOBranch branch = revision.getBranch();
        int version = revision.getVersion() - 1;
        while (version >= 1) {
            InternalCDORevision rev = this.revisionManager.getRevisionByVersion(id, branch.getVersion(version), -1, true);
            if (rev == null) {
                return revision;
            }
            revision = rev;
            --version;
        }
        if (!branch.isMainBranch() && (baseRevision = this.revisionManager.getRevision(id, base = branch.getBase(), -1, 0, true)) != null) {
            return this.getFirstRevision(id, (CDORevision)baseRevision);
        }
        return revision;
    }

    private CDOBranchPoint getLastBranchPoint(CDORevision revision, CDOBranchPoint branchPoint) {
        CDOBranch branch = branchPoint.getBranch();
        if (revision.getBranch() != branch) {
            return branch.getHead();
        }
        CDOID id = revision.getID();
        int version = revision.getVersion() + 1;
        while (version <= Integer.MAX_VALUE) {
            InternalCDORevision rev;
            if (revision.getRevised() == 0L || (rev = this.revisionManager.getRevisionByVersion(id, branch.getVersion(version), -1, true)) == null) break;
            revision = rev;
            ++version;
        }
        return branch.getPoint(revision.getRevised());
    }

    @Deprecated
    protected void ensureChunks(InternalCDORevision revision, int referenceChunk, IStoreAccessor accessor) {
        EStructuralFeature[] eStructuralFeatureArray = revision.getClassInfo().getAllPersistentFeatures();
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (feature.isMany()) {
                CDOList list = revision.getList(feature);
                int chunkEnd = Math.min(referenceChunk, list.size());
                accessor = this.ensureChunk(revision, feature, accessor, (MoveableList<Object>)list, 0, chunkEnd);
            }
            ++n2;
        }
    }

    @Override
    public void ensureChunks(InternalCDORevision revision) {
        this.ensureChunks(revision, -1);
    }

    public void ensureChunks(InternalCDORevision revision, int chunkSize) {
        if (revision.isUnchunked()) {
            return;
        }
        IStoreAccessor accessor = null;
        boolean unchunked = true;
        EStructuralFeature[] eStructuralFeatureArray = revision.getClassInfo().getAllPersistentFeatures();
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOList list;
            int size;
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (feature.isMany() && (size = (list = revision.getList(feature)).size()) != 0) {
                int chunkSizeToUse = chunkSize;
                if (chunkSizeToUse == -1) {
                    chunkSizeToUse = size;
                }
                int chunkEnd = Math.min(chunkSizeToUse, size);
                accessor = this.ensureChunk(revision, feature, accessor, (MoveableList<Object>)list, 0, chunkEnd);
                if (unchunked) {
                    int i = chunkEnd + 1;
                    while (i < size) {
                        if (list.get(i) == InternalCDOList.UNINITIALIZED) {
                            unchunked = false;
                            break;
                        }
                        ++i;
                    }
                }
            }
            ++n2;
        }
        if (unchunked) {
            revision.setUnchunked();
        }
    }

    @Override
    public IStoreAccessor ensureChunk(InternalCDORevision revision, EStructuralFeature feature, int chunkStart, int chunkEnd) {
        if (!revision.isUnchunked()) {
            CDOList list = revision.getList(feature);
            chunkEnd = Math.min(chunkEnd, list.size());
            IStoreAccessor accessor = StoreThreadLocal.getAccessor();
            this.ensureChunk(revision, feature, accessor, (MoveableList<Object>)list, chunkStart, chunkEnd);
            if (this.isUnchunked(revision)) {
                revision.setUnchunked();
            }
            return accessor;
        }
        return null;
    }

    private boolean isUnchunked(InternalCDORevision revision) {
        EStructuralFeature[] eStructuralFeatureArray = revision.getClassInfo().getAllPersistentFeatures();
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (feature.isMany()) {
                CDOList list = revision.getList(feature);
                int size = list.size();
                int i = 0;
                while (i < size) {
                    if (list.get(i) == InternalCDOList.UNINITIALIZED) {
                        return false;
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return true;
    }

    protected IStoreAccessor ensureChunk(InternalCDORevision revision, EStructuralFeature feature, IStoreAccessor accessor, MoveableList<Object> list, int chunkStart, int chunkEnd) {
        IStoreChunkReader chunkReader = null;
        int fromIndex = -1;
        int j = chunkStart;
        while (j < chunkEnd) {
            if (list.get(j) == InternalCDOList.UNINITIALIZED) {
                if (fromIndex == -1) {
                    fromIndex = j;
                }
            } else if (fromIndex != -1) {
                int toIndex;
                if (chunkReader == null) {
                    if (accessor == null) {
                        accessor = StoreThreadLocal.getAccessor();
                    }
                    chunkReader = accessor.createChunkReader(revision, feature);
                }
                if (fromIndex == (toIndex = j) - 1) {
                    chunkReader.addSimpleChunk(fromIndex);
                } else {
                    chunkReader.addRangedChunk(fromIndex, toIndex);
                }
                fromIndex = -1;
            }
            ++j;
        }
        if (fromIndex != -1) {
            int toIndex;
            if (chunkReader == null) {
                if (accessor == null) {
                    accessor = StoreThreadLocal.getAccessor();
                }
                chunkReader = accessor.createChunkReader(revision, feature);
            }
            if (fromIndex == (toIndex = chunkEnd) - 1) {
                chunkReader.addSimpleChunk(fromIndex);
            } else {
                chunkReader.addRangedChunk(fromIndex, toIndex);
            }
        }
        if (chunkReader != null) {
            InternalCDOList cdoList = list instanceof InternalCDOList ? (InternalCDOList)list : null;
            List<IStoreChunkReader.Chunk> chunks = chunkReader.executeRead();
            for (IStoreChunkReader.Chunk chunk : chunks) {
                int startIndex = chunk.getStartIndex();
                int indexInChunk = 0;
                while (indexInChunk < chunk.size()) {
                    Object id = chunk.get(indexInChunk);
                    if (cdoList != null) {
                        cdoList.setWithoutFrozenCheck(startIndex + indexInChunk, id);
                    } else {
                        list.set(startIndex + indexInChunk, id);
                    }
                    ++indexInChunk;
                }
            }
        }
        return accessor;
    }

    @Override
    public InternalCDOPackageRegistry getPackageRegistry(boolean considerCommitContext) {
        InternalCDOPackageRegistry contextualPackageRegistry;
        IStoreAccessor.CommitContext commitContext;
        if (considerCommitContext && (commitContext = StoreThreadLocal.getCommitContext()) != null && (contextualPackageRegistry = commitContext.getPackageRegistry()) != null) {
            return contextualPackageRegistry;
        }
        return this.packageRegistry;
    }

    @Override
    public Semaphore getPackageRegistryCommitLock() {
        return this.packageRegistryCommitLock;
    }

    @Override
    public InternalCDOPackageRegistry getPackageRegistry() {
        return this.getPackageRegistry(true);
    }

    public void setPackageRegistry(InternalCDOPackageRegistry packageRegistry) {
        this.checkInactive();
        this.packageRegistry = packageRegistry;
    }

    @Override
    public InternalSessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public void setSessionManager(InternalSessionManager sessionManager) {
        this.checkInactive();
        this.sessionManager = sessionManager;
    }

    @Override
    public InternalCDOBranchManager getBranchManager() {
        return this.branchManager;
    }

    @Override
    public void setBranchManager(InternalCDOBranchManager branchManager) {
        this.checkInactive();
        this.branchManager = branchManager;
    }

    @Override
    public InternalCDOCommitInfoManager getCommitInfoManager() {
        return this.commitInfoManager;
    }

    public void setCommitInfoManager(InternalCDOCommitInfoManager commitInfoManager) {
        this.checkInactive();
        this.commitInfoManager = commitInfoManager;
    }

    @Override
    public InternalCDORevisionManager getRevisionManager() {
        return this.revisionManager;
    }

    @Override
    public void setRevisionManager(InternalCDORevisionManager revisionManager) {
        this.checkInactive();
        this.revisionManager = revisionManager;
    }

    @Override
    public InternalQueryManager getQueryManager() {
        return this.queryManager;
    }

    public void setQueryManager(InternalQueryManager queryManager) {
        this.checkInactive();
        this.queryManager = queryManager;
    }

    @Override
    public InternalCommitManager getCommitManager() {
        return this.commitManager;
    }

    public void setCommitManager(InternalCommitManager commitManager) {
        this.checkInactive();
        this.commitManager = commitManager;
    }

    @Override
    @Deprecated
    public InternalLockManager getLockManager() {
        return this.getLockingManager();
    }

    @Override
    public InternalLockManager getLockingManager() {
        return this.lockingManager;
    }

    public void setLockingManager(InternalLockManager lockingManager) {
        this.checkInactive();
        this.lockingManager = lockingManager;
    }

    @Override
    public InternalCommitContext createCommitContext(InternalTransaction transaction) {
        return new TransactionCommitContext(transaction);
    }

    @Override
    public long getLastCommitTimeStamp() {
        return this.timeStampAuthority.getLastFinishedTimeStamp();
    }

    @Override
    public void setLastCommitTimeStamp(long lastCommitTimeStamp) {
        this.timeStampAuthority.setLastFinishedTimeStamp(lastCommitTimeStamp);
    }

    @Override
    public long waitForCommit(long timeout) {
        return this.timeStampAuthority.waitForCommit(timeout);
    }

    @Override
    public long[] createCommitTimeStamp(OMMonitor monitor) {
        return this.timeStampAuthority.startCommit(0L, monitor);
    }

    @Override
    public long[] forceCommitTimeStamp(long override, OMMonitor monitor) {
        return this.timeStampAuthority.startCommit(override, monitor);
    }

    @Override
    public void endCommit(long timestamp) {
        this.timeStampAuthority.endCommit(timestamp);
    }

    @Override
    public void failCommit(long timestamp) {
        this.timeStampAuthority.failCommit(timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeOutsideStartCommit(Runnable runnable) {
        TimeStampAuthority timeStampAuthority = this.timeStampAuthority;
        synchronized (timeStampAuthority) {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(InternalCommitContext commitContext, OMMonitor monitor) {
        if (this.isTreeRestructuring(commitContext)) {
            Object object = this.commitTransactionLock;
            synchronized (object) {
                commitContext.setLastTreeRestructuringCommit(this.lastTreeRestructuringCommit);
                this.commitUnsynced(commitContext, monitor);
                this.lastTreeRestructuringCommit = commitContext.getTimeStamp();
            }
        } else if (this.serializingCommits) {
            Object object = this.commitTransactionLock;
            synchronized (object) {
                this.commitUnsynced(commitContext, monitor);
            }
        } else {
            this.commitUnsynced(commitContext, monitor);
        }
    }

    protected void commitUnsynced(InternalCommitContext commitContext, OMMonitor monitor) {
        ProgressDistributor distributor = this.store.getIndicatingCommitDistributor();
        distributor.run(InternalCommitContext.OPS, (Object)commitContext, monitor);
    }

    private boolean isTreeRestructuring(InternalCommitContext commitContext) {
        InternalCDORevisionDelta[] internalCDORevisionDeltaArray = commitContext.getDirtyObjectDeltas();
        int n = internalCDORevisionDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDORevisionDelta delta = internalCDORevisionDeltaArray[n2];
            for (CDOFeatureDelta featureDelta : delta.getFeatureDeltas()) {
                EStructuralFeature feature = featureDelta.getFeature();
                if (feature != CDOContainerFeatureDelta.CONTAINER_FEATURE) continue;
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    @Deprecated
    public void sendCommitNotification(InternalSession sender, CDOCommitInfo commitInfo) {
        this.sendCommitNotification(sender, commitInfo, true);
    }

    @Override
    @Deprecated
    public CDOCommitInfoHandler[] getCommitInfoHandlers() {
        return this.commitInfoManager.getCommitInfoHandlers();
    }

    @Override
    @Deprecated
    public void addCommitInfoHandler(CDOCommitInfoHandler handler) {
        this.commitInfoManager.addCommitInfoHandler(handler);
    }

    @Override
    @Deprecated
    public void removeCommitInfoHandler(CDOCommitInfoHandler handler) {
        this.commitInfoManager.removeCommitInfoHandler(handler);
    }

    @Override
    @Deprecated
    public void sendCommitNotification(InternalSession sender, CDOCommitInfo commitInfo, boolean clearResourcePathCache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sendCommitNotification(CDOProtocol.CommitNotificationInfo info) {
        boolean isFailureCommitInfo;
        CDOCommitInfo commitInfo = info.getCommitInfo();
        boolean bl = isFailureCommitInfo = commitInfo.getBranch() == null;
        if (isFailureCommitInfo || !commitInfo.isEmpty()) {
            this.sessionManager.sendCommitNotification(info);
            this.commitInfoManager.notifyCommitInfoHandlers(commitInfo);
        }
    }

    @Override
    public IQueryHandlerProvider getQueryHandlerProvider() {
        return this.queryHandlerProvider;
    }

    @Override
    public void setQueryHandlerProvider(IQueryHandlerProvider queryHandlerProvider) {
        this.queryHandlerProvider = queryHandlerProvider;
    }

    @Override
    public synchronized IQueryHandler getQueryHandler(CDOQueryInfo info) {
        IQueryHandler handler;
        String language = info.getQueryLanguage();
        if ("resources".equals(language)) {
            return new ResourcesQueryHandler();
        }
        if ("instances".equals(language)) {
            return new InstancesQueryHandler();
        }
        if ("xrefs".equals(language)) {
            return new XRefsQueryHandler();
        }
        IStoreAccessor storeAccessor = StoreThreadLocal.getAccessor();
        if (storeAccessor != null && (handler = storeAccessor.getQueryHandler(info)) != null) {
            return handler;
        }
        if (this.queryHandlerProvider == null) {
            IManagedContainer container = this.getContainer();
            this.queryHandlerProvider = new ContainerQueryHandlerProvider(container);
        }
        if ((handler = this.queryHandlerProvider.getQueryHandler(info)) != null) {
            return handler;
        }
        return null;
    }

    @Override
    public IManagedContainer getContainer() {
        if (this.container == null) {
            return IPluginContainer.INSTANCE;
        }
        return this.container;
    }

    @Override
    public void setContainer(IManagedContainer container) {
        this.container = container;
    }

    public ExecutorService getExecutorService() {
        IManagedContainer container = this.getContainer();
        return ConcurrencyUtil.getExecutorService((IManagedContainer)container);
    }

    public Object[] getElements() {
        Object[] elements = new Object[]{this.packageRegistry, this.branchManager, this.revisionManager, this.sessionManager, this.queryManager, this.commitManager, this.commitInfoManager, this.getLockingManager(), this.store};
        return elements;
    }

    public boolean isEmpty() {
        return false;
    }

    public long getCreationTime() {
        return this.store.getCreationTime();
    }

    @Override
    public void validateTimeStamp(long timeStamp) throws IllegalArgumentException {
        long creationTimeStamp = this.getCreationTime();
        if (timeStamp < creationTimeStamp) {
            throw new IllegalArgumentException(MessageFormat.format("timeStamp ({0}) < repository creation time ({1})", CDOCommonUtil.formatTimeStamp((long)timeStamp), CDOCommonUtil.formatTimeStamp((long)creationTimeStamp)));
        }
        long currentTimeStamp = this.getTimeStamp();
        if (timeStamp > currentTimeStamp) {
            throw new IllegalArgumentException(MessageFormat.format("timeStamp ({0}) > current time ({1})", CDOCommonUtil.formatTimeStamp((long)timeStamp), CDOCommonUtil.formatTimeStamp((long)currentTimeStamp)));
        }
    }

    public long getTimeStamp() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IRepository.Handler> getHandlers() {
        HashSet<IRepository.Handler> handlers = new HashSet<IRepository.Handler>();
        List<IRepository.Handler> list = this.readAccessHandlers;
        synchronized (list) {
            handlers.addAll(this.readAccessHandlers);
        }
        list = this.writeAccessHandlers;
        synchronized (list) {
            handlers.addAll(this.writeAccessHandlers);
        }
        return handlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHandler(IRepository.Handler handler) {
        List<IRepository.Handler> list;
        if (handler instanceof IRepository.ReadAccessHandler) {
            list = this.readAccessHandlers;
            synchronized (list) {
                if (!this.readAccessHandlers.contains(handler)) {
                    this.readAccessHandlers.add((IRepository.ReadAccessHandler)handler);
                }
            }
        }
        if (handler instanceof IRepository.WriteAccessHandler) {
            list = this.writeAccessHandlers;
            synchronized (list) {
                if (!this.writeAccessHandlers.contains(handler)) {
                    this.writeAccessHandlers.add((IRepository.WriteAccessHandler)handler);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHandler(IRepository.Handler handler) {
        List<IRepository.Handler> list;
        if (handler instanceof IRepository.ReadAccessHandler) {
            list = this.readAccessHandlers;
            synchronized (list) {
                this.readAccessHandlers.remove(handler);
            }
        }
        if (handler instanceof IRepository.WriteAccessHandler) {
            list = this.writeAccessHandlers;
            synchronized (list) {
                this.writeAccessHandlers.remove(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyReadAccessHandlers(InternalSession session, CDORevision[] revisions, List<CDORevision> additionalRevisions) {
        IRepository.ReadAccessHandler[] handlers;
        List<IRepository.ReadAccessHandler> list = this.readAccessHandlers;
        synchronized (list) {
            int size = this.readAccessHandlers.size();
            if (size == 0) {
                return;
            }
            handlers = this.readAccessHandlers.toArray(new IRepository.ReadAccessHandler[size]);
        }
        IRepository.ReadAccessHandler[] readAccessHandlerArray = handlers;
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            IRepository.ReadAccessHandler handler = readAccessHandlerArray[n2];
            handler.handleRevisionsBeforeSending(session, revisions, additionalRevisions);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyWriteAccessHandlers(ITransaction transaction, IStoreAccessor.CommitContext commitContext, boolean beforeCommit, OMMonitor monitor) {
        IRepository.WriteAccessHandler[] handlers;
        List<IRepository.WriteAccessHandler> list = this.writeAccessHandlers;
        synchronized (list) {
            int size = this.writeAccessHandlers.size();
            if (size == 0) {
                return;
            }
            handlers = this.writeAccessHandlers.toArray(new IRepository.WriteAccessHandler[size]);
        }
        try {
            monitor.begin((double)handlers.length);
            IRepository.WriteAccessHandler[] writeAccessHandlerArray = handlers;
            int n = handlers.length;
            int n2 = 0;
            while (n2 < n) {
                IRepository.WriteAccessHandler handler = writeAccessHandlerArray[n2];
                try {
                    if (beforeCommit) {
                        handler.handleTransactionBeforeCommitting(transaction, commitContext, monitor.fork());
                    } else {
                        handler.handleTransactionAfterCommitted(transaction, commitContext, monitor.fork());
                    }
                }
                catch (RuntimeException ex) {
                    if (!beforeCommit) {
                        OM.LOG.error((Throwable)ex);
                    }
                    throw ex;
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void setInitialPackages(EPackage ... initialPackages) {
        this.checkInactive();
        this.initialPackages = initialPackages;
    }

    @Override
    public CDOReplicationInfo replicateRaw(CDODataOutput out, int lastReplicatedBranchID, long lastReplicatedCommitTime) throws IOException {
        int fromBranchID = lastReplicatedBranchID + 1;
        final int toBranchID = this.store.getLastBranchID();
        long fromCommitTime = lastReplicatedCommitTime + 1L;
        final long toCommitTime = this.store.getLastCommitTime();
        out.writeInt(toBranchID);
        out.writeLong(toCommitTime);
        IStoreAccessor.Raw accessor = (IStoreAccessor.Raw)StoreThreadLocal.getAccessor();
        accessor.rawExport(out, fromBranchID, toBranchID, fromCommitTime, toCommitTime);
        return new CDOReplicationInfo(){

            public int getLastReplicatedBranchID() {
                return toBranchID;
            }

            public long getLastReplicatedCommitTime() {
                return toCommitTime;
            }

            public String[] getLockAreaIDs() {
                return null;
            }
        };
    }

    @Override
    public void replicate(CDOReplicationContext context) {
        int startID = context.getLastReplicatedBranchID() + 1;
        this.branchManager.getBranches(startID, 0, (CDOBranchHandler)context);
        long startTime = context.getLastReplicatedCommitTime();
        this.commitInfoManager.getCommitInfos(null, startTime + 1L, 0L, (CDOCommitInfoHandler)context);
        this.getLockingManager().getLockAreas(null, (IDurableLockingManager.LockArea.Handler)context);
    }

    @Override
    public CDOChangeSetData getChangeSet(CDOBranchPoint startPoint, CDOBranchPoint endPoint) {
        CDOChangeSetSegment[] segments = CDOChangeSetSegment.createFrom((CDOBranchPoint)startPoint, (CDOBranchPoint)endPoint);
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        Set<CDOID> ids = accessor.readChangeSet((OMMonitor)new Monitor(), segments);
        return CDORevisionUtil.createChangeSetData(ids, (CDOBranchPoint)startPoint, (CDOBranchPoint)endPoint, (CDORevisionManager)this.revisionManager);
    }

    @Override
    public Set<CDOID> getMergeData(CDORevisionAvailabilityInfo targetInfo, CDORevisionAvailabilityInfo sourceInfo, CDORevisionAvailabilityInfo targetBaseInfo, CDORevisionAvailabilityInfo sourceBaseInfo, OMMonitor monitor) {
        CDOBranchPoint target = targetInfo.getBranchPoint();
        CDOBranchPoint source = sourceInfo.getBranchPoint();
        monitor.begin(5.0);
        try {
            IStoreAccessor accessor = StoreThreadLocal.getAccessor();
            HashSet<CDOID> ids = new HashSet<CDOID>();
            if (targetBaseInfo == null && sourceBaseInfo == null) {
                if (CDOBranchUtil.isContainedBy((CDOBranchPoint)source, (CDOBranchPoint)target)) {
                    ids.addAll(accessor.readChangeSet(monitor.fork(), CDOChangeSetSegment.createFrom((CDOBranchPoint)source, (CDOBranchPoint)target)));
                } else if (CDOBranchUtil.isContainedBy((CDOBranchPoint)target, (CDOBranchPoint)source)) {
                    ids.addAll(accessor.readChangeSet(monitor.fork(), CDOChangeSetSegment.createFrom((CDOBranchPoint)target, (CDOBranchPoint)source)));
                } else {
                    CDOBranchPoint ancestor = CDOBranchUtil.getAncestor((CDOBranchPoint)target, (CDOBranchPoint)source);
                    ids.addAll(accessor.readChangeSet(monitor.fork(), CDOChangeSetSegment.createFrom((CDOBranchPoint)ancestor, (CDOBranchPoint)target)));
                    ids.addAll(accessor.readChangeSet(monitor.fork(), CDOChangeSetSegment.createFrom((CDOBranchPoint)ancestor, (CDOBranchPoint)source)));
                }
            } else {
                CDORevisionAvailabilityInfo sourceBaseInfoToUse = sourceBaseInfo == null ? targetBaseInfo : sourceBaseInfo;
                ids.addAll(accessor.readChangeSet(monitor.fork(), CDOChangeSetSegment.createFrom((CDOBranchPoint)targetBaseInfo.getBranchPoint(), (CDOBranchPoint)target)));
                ids.addAll(accessor.readChangeSet(monitor.fork(), CDOChangeSetSegment.createFrom((CDOBranchPoint)sourceBaseInfoToUse.getBranchPoint(), (CDOBranchPoint)source)));
            }
            this.loadMergeData(ids, targetInfo, monitor.fork());
            this.loadMergeData(ids, sourceInfo, monitor.fork());
            if (targetBaseInfo != null) {
                this.loadMergeData(ids, targetBaseInfo, monitor.fork());
            }
            if (sourceBaseInfo != null) {
                this.loadMergeData(ids, sourceBaseInfo, monitor.fork());
            }
            HashSet<CDOID> hashSet = ids;
            return hashSet;
        }
        finally {
            monitor.done();
        }
    }

    private void loadMergeData(Set<CDOID> ids, CDORevisionAvailabilityInfo info, OMMonitor monitor) {
        int size = ids.size();
        monitor.begin((double)size);
        try {
            CDOBranchPoint branchPoint = info.getBranchPoint();
            for (CDOID id : ids) {
                if (info.containsRevision(id)) {
                    info.removeRevision(id);
                } else {
                    InternalCDORevision revision = this.getRevisionFromBranch(id, branchPoint);
                    if (revision != null) {
                        info.addRevision((CDORevisionKey)revision);
                    } else {
                        info.removeRevision(id);
                    }
                }
                monitor.worked();
            }
        }
        finally {
            monitor.done();
        }
    }

    private InternalCDORevision getRevisionFromBranch(CDOID id, CDOBranchPoint branchPoint) {
        return this.revisionManager.getRevision(id, branchPoint, -1, 0, true);
    }

    @Override
    public void queryLobs(List<byte[]> ids) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        accessor.queryLobs(ids);
    }

    @Override
    public void handleLobs(long fromTime, long toTime, CDOLobHandler handler) throws IOException {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        accessor.handleLobs(fromTime, toTime, handler);
    }

    @Override
    public void loadLob(byte[] id, OutputStream out) throws IOException {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        accessor.loadLob(id, out);
    }

    @Override
    public void handleRevisions(EClass eClass, CDOBranch branch, boolean exactBranch, long timeStamp, boolean exactTime, final CDORevisionHandler handler) {
        CDORevisionHandler wrapper = handler;
        if (!exactBranch && !branch.isMainBranch()) {
            if (exactTime && timeStamp == 0L) {
                throw new IllegalArgumentException("Time stamp must be specified if exactBranch==false and exactTime==true");
            }
            wrapper = new CDORevisionHandler(){
                private Set<CDOID> handled = new HashSet<CDOID>();

                public boolean handleRevision(CDORevision revision) {
                    CDOID id = revision.getID();
                    if (this.handled.add(id)) {
                        return handler.handleRevision(revision);
                    }
                    return true;
                }
            };
        }
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        while (branch != null) {
            accessor.handleRevisions(eClass, branch, timeStamp, exactTime, wrapper);
            if (exactBranch) break;
            CDOBranchPoint base = branch.getBase();
            branch = base.getBranch();
            timeStamp = base.getTimeStamp();
        }
    }

    public static List<Object> revisionKeysToObjects(List<CDORevisionKey> revisionKeys, CDOBranch viewedBranch, boolean isSupportingBranches) {
        ArrayList<Object> lockables = new ArrayList<Object>();
        for (CDORevisionKey revKey : revisionKeys) {
            CDOID id = revKey.getID();
            if (isSupportingBranches) {
                lockables.add(CDOIDUtil.createIDAndBranch((CDOID)id, (CDOBranch)viewedBranch));
                continue;
            }
            lockables.add(id);
        }
        return lockables;
    }

    @Override
    public CDOSessionProtocol.LockObjectsResult lock(InternalView view, IRWLockManager.LockType lockType, List<CDORevisionKey> revKeys, boolean recursive, long timeout) {
        List<Object> lockables = Repository.revisionKeysToObjects(revKeys, view.getBranch(), this.isSupportingBranches());
        return this.lock(view, lockType, lockables, revKeys, recursive, timeout);
    }

    protected CDOSessionProtocol.LockObjectsResult lock(InternalView view, IRWLockManager.LockType type, List<Object> lockables, List<CDORevisionKey> loadedRevs, boolean recursive, long timeout) {
        boolean staleNoUpdate;
        List<RWOLockManager.LockState<Object, IView>> newLockStates = null;
        try {
            newLockStates = this.getLockingManager().lock2(true, type, view, lockables, recursive, timeout);
        }
        catch (TimeoutRuntimeException ex) {
            return new CDOSessionProtocol.LockObjectsResult(false, true, false, 0L, new CDORevisionKey[0], new CDOLockState[0], this.getTimeStamp());
        }
        catch (InterruptedException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
        long[] requiredTimestamp = new long[1];
        CDORevisionKey[] staleRevisionsArray = null;
        try {
            staleRevisionsArray = this.checkStaleRevisions(view, loadedRevs, lockables, type, requiredTimestamp);
        }
        catch (IllegalArgumentException e) {
            this.getLockingManager().unlock2(true, type, view, lockables, recursive);
            throw e;
        }
        InternalSession session = view.getSession();
        boolean bl = staleNoUpdate = staleRevisionsArray.length > 0 && !session.isPassiveUpdateEnabled();
        if (staleNoUpdate) {
            this.getLockingManager().unlock2(true, type, view, lockables, recursive);
            return new CDOSessionProtocol.LockObjectsResult(false, false, false, requiredTimestamp[0], staleRevisionsArray, new CDOLockState[0], this.getTimeStamp());
        }
        CDOLockState[] cdoLockStates = Repository.toCDOLockStates(newLockStates);
        this.sendLockNotifications(view, CDOLockChangeInfo.Operation.LOCK, type, cdoLockStates);
        boolean waitForUpdate = staleRevisionsArray.length > 0;
        return new CDOSessionProtocol.LockObjectsResult(true, false, waitForUpdate, requiredTimestamp[0], staleRevisionsArray, cdoLockStates, this.getTimeStamp());
    }

    private CDORevisionKey[] checkStaleRevisions(InternalView view, List<CDORevisionKey> revisionKeys, List<Object> objectsToLock, IRWLockManager.LockType lockType, long[] requiredTimestamp) {
        LinkedList<CDORevisionKey> staleRevisions = new LinkedList<CDORevisionKey>();
        if (revisionKeys != null) {
            InternalCDORevisionManager revManager = this.getRevisionManager();
            CDOBranch viewedBranch = view.getBranch();
            for (CDORevisionKey revKey : revisionKeys) {
                CDOID id = revKey.getID();
                InternalCDORevision rev = revManager.getRevision(id, viewedBranch.getHead(), -1, 0, true);
                if (rev == null) {
                    throw new IllegalArgumentException(String.format("Object %s not found in branch %s (possibly detached)", id, viewedBranch));
                }
                if (revKey.equals(rev)) continue;
                staleRevisions.add(CDORevisionUtil.copyRevisionKey((CDORevisionKey)rev));
                requiredTimestamp[0] = Math.max(requiredTimestamp[0], rev.getTimeStamp());
            }
        }
        CDORevisionKey[] staleRevisionsArray = new CDORevisionKey[staleRevisions.size()];
        staleRevisions.toArray(staleRevisionsArray);
        return staleRevisionsArray;
    }

    private void sendLockNotifications(IView view, CDOLockChangeInfo.Operation operation, IRWLockManager.LockType lockType, CDOLockState[] cdoLockStates) {
        long timestamp = this.getTimeStamp();
        CDOLockChangeInfo lockChangeInfo = CDOLockUtil.createLockChangeInfo((long)timestamp, (CDOCommonView)view, (CDOBranch)view.getBranch(), (CDOLockChangeInfo.Operation)operation, (IRWLockManager.LockType)lockType, (CDOLockState[])cdoLockStates);
        this.getSessionManager().sendLockNotification((InternalSession)view.getSession(), lockChangeInfo);
    }

    public static CDOLockState[] toCDOLockStates(List<RWOLockManager.LockState<Object, IView>> lockStates) {
        CDOLockState[] cdoLockStates = new CDOLockState[lockStates.size()];
        int i = 0;
        for (RWOLockManager.LockState<Object, IView> lockState : lockStates) {
            CDOLockState cdoLockState = CDOLockUtil.createLockState(lockState);
            cdoLockStates[i++] = cdoLockState;
        }
        return cdoLockStates;
    }

    @Override
    public CDOSessionProtocol.UnlockObjectsResult unlock(InternalView view, IRWLockManager.LockType lockType, List<CDOID> objectIDs, boolean recursive) {
        ArrayList<Object> unlockables = null;
        if (objectIDs != null) {
            unlockables = new ArrayList<Object>(objectIDs.size());
            CDOBranch branch = view.getBranch();
            for (CDOID id : objectIDs) {
                CDOID key = this.supportingBranches ? CDOIDUtil.createIDAndBranch((CDOID)id, (CDOBranch)branch) : id;
                unlockables.add(key);
            }
        }
        return this.doUnlock(view, lockType, unlockables, recursive);
    }

    protected CDOSessionProtocol.UnlockObjectsResult doUnlock(InternalView view, IRWLockManager.LockType lockType, List<Object> unlockables, boolean recursive) {
        List<RWOLockManager.LockState<Object, IView>> newLockStates = null;
        newLockStates = lockType == null ? this.getLockingManager().unlock2(true, view) : this.getLockingManager().unlock2(true, lockType, view, unlockables, recursive);
        long timestamp = this.getTimeStamp();
        CDOLockState[] cdoLockStates = Repository.toCDOLockStates(newLockStates);
        this.sendLockNotifications(view, CDOLockChangeInfo.Operation.UNLOCK, lockType, cdoLockStates);
        return new CDOSessionProtocol.UnlockObjectsResult(cdoLockStates, timestamp);
    }

    public Object getAdapter(Class adapter) {
        return AdapterUtil.adapt((Object)this, (Class)adapter, (boolean)false);
    }

    public String toString() {
        return MessageFormat.format("Repository[{0}]", this.name);
    }

    @Override
    public boolean isSkipInitialization() {
        return this.skipInitialization;
    }

    @Override
    public void setSkipInitialization(boolean skipInitialization) {
        this.skipInitialization = skipInitialization;
    }

    protected void initProperties() {
        String valueTimeout;
        String valueIDLocation;
        String valueIntegrity;
        String valueAudits = this.properties.get("supportingAudits");
        this.supportingAudits = valueAudits != null ? Boolean.valueOf(valueAudits) : this.store.getRevisionTemporality() == IStore.RevisionTemporality.AUDITING;
        String valueBranches = this.properties.get("supportingBranches");
        this.supportingBranches = valueBranches != null ? Boolean.valueOf(valueBranches) : this.store.getRevisionParallelism() == IStore.RevisionParallelism.BRANCHING;
        String valueCommits = this.properties.get("serializeCommits");
        if (valueCommits != null) {
            this.serializingCommits = Boolean.valueOf(valueCommits);
        }
        if ((valueIntegrity = this.properties.get("ensureReferentialIntegrity")) != null) {
            this.ensuringReferentialIntegrity = Boolean.valueOf(valueIntegrity);
        }
        if ((valueIDLocation = this.properties.get("idGenerationLocation")) != null) {
            this.idGenerationLocation = CDOCommonRepository.IDGenerationLocation.valueOf((String)valueIDLocation);
        }
        if (this.idGenerationLocation == null) {
            this.idGenerationLocation = CDOCommonRepository.IDGenerationLocation.STORE;
        }
        if ((valueTimeout = this.properties.get("optimisticLockingTimeout")) != null) {
            this.optimisticLockingTimeout = Long.valueOf(valueTimeout);
        }
    }

    @Override
    @Deprecated
    public void initSystemPackages() {
        this.initSystemPackages(true);
    }

    @Override
    public void initSystemPackages(boolean firstStart) {
        IStoreAccessor writer = this.store.getWriter(null);
        StoreThreadLocal.setAccessor(writer);
        try {
            ArrayList<InternalCDOPackageUnit> list = new ArrayList<InternalCDOPackageUnit>();
            boolean nonSystemPackages = false;
            if (this.initialPackages != null) {
                EPackage[] ePackageArray = this.initialPackages;
                int n = this.initialPackages.length;
                int n2 = 0;
                while (n2 < n) {
                    EPackage initialPackage = ePackageArray[n2];
                    if (!this.packageRegistry.containsKey((Object)initialPackage.getNsURI())) {
                        list.add(this.initPackage(initialPackage));
                        nonSystemPackages = true;
                    }
                    ++n2;
                }
            }
            if (nonSystemPackages && !firstStart) {
                OM.LOG.info("Initial packages are about to be pre-registered. They may not become part of replications.");
            }
            if (!list.isEmpty()) {
                InternalCDOPackageUnit[] initialUnits = list.toArray(new InternalCDOPackageUnit[list.size()]);
                writer.writePackageUnits(initialUnits, (OMMonitor)new Monitor());
                writer.commit((OMMonitor)new Monitor());
            }
        }
        finally {
            StoreThreadLocal.release();
        }
    }

    protected InternalCDOPackageUnit initPackage(EPackage ePackage) {
        EMFUtil.registerPackage((EPackage)ePackage, (EPackage.Registry[])new EPackage.Registry[]{this.packageRegistry});
        InternalCDOPackageInfo packageInfo = this.packageRegistry.getPackageInfo(ePackage);
        InternalCDOPackageUnit packageUnit = packageInfo.getPackageUnit();
        packageUnit.setTimeStamp(this.store.getCreationTime());
        packageUnit.setState(CDOPackageUnit.State.LOADED);
        return packageUnit;
    }

    @Override
    public void initMainBranch(InternalCDOBranchManager branchManager, long timeStamp) {
        branchManager.initMainBranch(false, timeStamp);
    }

    protected void initRootResource() {
        CDOBranchPoint head = this.branchManager.getMainBranch().getHead();
        CDORevisionFactory factory = this.getRevisionManager().getFactory();
        InternalCDORevision rootResource = (InternalCDORevision)factory.createRevision(EresourcePackage.Literals.CDO_RESOURCE);
        rootResource.setBranchPoint(head);
        rootResource.setContainerID((Object)CDOID.NULL);
        rootResource.setContainingFeatureID(0);
        CDOID id = this.createRootResourceID();
        rootResource.setID(id);
        rootResource.setResourceID(id);
        InternalSession session = this.getSessionManager().openSession(null);
        InternalTransaction transaction = session.openTransaction(1, head);
        TransactionCommitContext commitContext = new TransactionCommitContext(transaction){

            protected long[] createTimeStamp(OMMonitor monitor) {
                InternalRepository repository = this.getTransaction().getSession().getManager().getRepository();
                return repository.forceCommitTimeStamp(Repository.this.store.getCreationTime(), monitor);
            }

            public String getUserID() {
                return "CDO_SYSTEM";
            }

            public String getCommitComment() {
                return "<initialize>";
            }
        };
        commitContext.setNewObjects(new InternalCDORevision[]{rootResource});
        commitContext.setNewPackageUnits(this.getNewPackageUnitsForRootResource(commitContext.getPackageRegistry()));
        commitContext.preWrite();
        commitContext.write((OMMonitor)new Monitor());
        commitContext.commit((OMMonitor)new Monitor());
        String rollbackMessage = commitContext.getRollbackMessage();
        if (rollbackMessage != null) {
            throw new TransactionException(rollbackMessage);
        }
        this.rootResourceID = id instanceof CDOIDTemp ? commitContext.getIDMappings().get(id) : id;
        commitContext.postCommit(true);
        session.close();
    }

    private InternalCDOPackageUnit[] getNewPackageUnitsForRootResource(InternalCDOPackageRegistry commitContextPackageRegistry) {
        ArrayList<InternalCDOPackageUnit> newPackageUnitsForRootResource = new ArrayList<InternalCDOPackageUnit>();
        CompletePackageClosure closure = new CompletePackageClosure();
        Set ePackages = closure.calculate(Collections.singletonList(EresourcePackage.eINSTANCE));
        for (EPackage ePackage : ePackages) {
            InternalCDOPackageUnit packageUnit = commitContextPackageRegistry.getPackageUnit(ePackage);
            if (packageUnit == null) continue;
            newPackageUnitsForRootResource.add(packageUnit);
        }
        return newPackageUnitsForRootResource.toArray(new InternalCDOPackageUnit[0]);
    }

    protected CDOID createRootResourceID() {
        if (this.getIDGenerationLocation() == CDOCommonRepository.IDGenerationLocation.STORE) {
            return CDOIDUtil.createTempObject((int)1);
        }
        return CDOIDGenerator.UUID.generateCDOID(null);
    }

    protected void readRootResource() {
        IStoreAccessor reader = this.store.getReader(null);
        StoreThreadLocal.setAccessor(reader);
        try {
            CDOBranchPoint head = this.branchManager.getMainBranch().getHead();
            this.rootResourceID = reader.readResourceID(CDOID.NULL, null, head);
        }
        finally {
            StoreThreadLocal.release();
        }
    }

    protected void readPackageUnits() {
        IStoreAccessor reader = this.store.getReader(null);
        StoreThreadLocal.setAccessor(reader);
        try {
            Collection<InternalCDOPackageUnit> packageUnits = reader.readPackageUnits();
            for (InternalCDOPackageUnit packageUnit : packageUnits) {
                this.packageRegistry.putPackageUnit(packageUnit);
            }
        }
        finally {
            StoreThreadLocal.release();
        }
    }

    protected void setPostActivateState() {
        this.setState(CDOCommonRepository.State.ONLINE);
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.store, "store");
        this.checkState(!StringUtil.isEmpty((String)this.name), "name is empty");
        this.checkState(this.packageRegistry, "packageRegistry");
        this.checkState(this.sessionManager, "sessionManager");
        this.checkState(this.branchManager, "branchManager");
        this.checkState(this.revisionManager, "revisionManager");
        this.checkState(this.queryManager, "queryManager");
        this.checkState(this.commitInfoManager, "commitInfoManager");
        this.checkState(this.commitManager, "commitManager");
        this.checkState(this.getLockingManager(), "lockingManager");
        this.packageRegistry.setReplacingDescriptors(true);
        this.packageRegistry.setPackageProcessor((InternalCDOPackageRegistry.PackageProcessor)this);
        this.packageRegistry.setPackageLoader((InternalCDOPackageRegistry.PackageLoader)this);
        this.branchManager.setRepository((CDOCommonRepository)this);
        this.branchManager.setBranchLoader((InternalCDOBranchManager.BranchLoader)this);
        this.revisionManager.setRevisionLoader((InternalCDORevisionManager.RevisionLoader)this);
        this.sessionManager.setRepository(this);
        this.queryManager.setRepository(this);
        this.commitInfoManager.setRepository((CDOCommonRepository)this);
        this.commitInfoManager.setCommitInfoLoader((InternalCDOCommitInfoManager.CommitInfoLoader)this);
        this.commitManager.setRepository(this);
        this.getLockingManager().setRepository(this);
        this.store.setRepository(this);
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.initProperties();
        if (this.idGenerationLocation == CDOCommonRepository.IDGenerationLocation.CLIENT && !(this.store instanceof IStore.CanHandleClientAssignedIDs)) {
            throw new IllegalStateException("Store can not handle client assigned IDs: " + this.store);
        }
        this.store.setRevisionTemporality(this.supportingAudits ? IStore.RevisionTemporality.AUDITING : IStore.RevisionTemporality.NONE);
        this.store.setRevisionParallelism(this.supportingBranches ? IStore.RevisionParallelism.BRANCHING : IStore.RevisionParallelism.NONE);
        this.revisionManager.setSupportingAudits(this.supportingAudits);
        this.revisionManager.setSupportingBranches(this.supportingBranches);
        LifecycleUtil.activate((Object)this.store);
        LifecycleUtil.activate((Object)this.packageRegistry);
        LifecycleUtil.activate((Object)this.sessionManager);
        LifecycleUtil.activate((Object)this.revisionManager);
        LifecycleUtil.activate((Object)this.branchManager);
        LifecycleUtil.activate((Object)this.queryManager);
        LifecycleUtil.activate((Object)this.commitInfoManager);
        LifecycleUtil.activate((Object)this.commitManager);
        LifecycleUtil.activate((Object)this.queryHandlerProvider);
        if (!this.skipInitialization) {
            long creationTime = this.store.getCreationTime();
            this.initMainBranch(this.branchManager, creationTime);
            long lastCommitTime = Math.max(creationTime, this.store.getLastCommitTime());
            this.timeStampAuthority.setLastFinishedTimeStamp(lastCommitTime);
            if (this.store.isFirstStart()) {
                this.initSystemPackages(true);
                this.initRootResource();
            } else {
                this.initSystemPackages(false);
                this.readPackageUnits();
                this.readRootResource();
            }
        }
        LifecycleUtil.activate((Object)this.lockingManager);
        this.setPostActivateState();
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)this.getLockingManager());
        LifecycleUtil.deactivate((Object)this.queryHandlerProvider);
        LifecycleUtil.deactivate((Object)this.commitManager);
        LifecycleUtil.deactivate((Object)this.commitInfoManager);
        LifecycleUtil.deactivate((Object)this.queryManager);
        LifecycleUtil.deactivate((Object)this.revisionManager);
        LifecycleUtil.deactivate((Object)this.sessionManager);
        LifecycleUtil.deactivate((Object)this.store);
        LifecycleUtil.deactivate((Object)this.branchManager);
        LifecycleUtil.deactivate((Object)this.packageRegistry);
        super.doDeactivate();
    }

    public static class Default
    extends Repository {
        protected void doBeforeActivate() throws Exception {
            if (this.getPackageRegistry(false) == null) {
                this.setPackageRegistry(this.createPackageRegistry());
            }
            if (this.getSessionManager() == null) {
                this.setSessionManager(this.createSessionManager());
            }
            if (this.getBranchManager() == null) {
                this.setBranchManager(this.createBranchManager());
            }
            if (this.getRevisionManager() == null) {
                this.setRevisionManager(this.createRevisionManager());
            }
            if (this.getQueryManager() == null) {
                this.setQueryManager(this.createQueryManager());
            }
            if (this.getCommitInfoManager() == null) {
                this.setCommitInfoManager(this.createCommitInfoManager());
            }
            if (this.getCommitManager() == null) {
                this.setCommitManager(this.createCommitManager());
            }
            if (this.getLockManager() == null) {
                this.setLockingManager(this.createLockManager());
            }
            super.doBeforeActivate();
        }

        protected InternalCDOPackageRegistry createPackageRegistry() {
            return new CDOPackageRegistryImpl();
        }

        protected InternalSessionManager createSessionManager() {
            return new SessionManager();
        }

        protected InternalCDOBranchManager createBranchManager() {
            return CDOBranchUtil.createBranchManager();
        }

        protected InternalCDORevisionManager createRevisionManager() {
            return (InternalCDORevisionManager)CDORevisionUtil.createRevisionManager();
        }

        protected InternalQueryManager createQueryManager() {
            return new QueryManager();
        }

        protected InternalCDOCommitInfoManager createCommitInfoManager() {
            return CDOCommitInfoUtil.createCommitInfoManager();
        }

        protected InternalCommitManager createCommitManager() {
            return new CommitManager();
        }

        @Deprecated
        protected InternalLockManager createLockManager() {
            return this.createLockingManager();
        }

        public LockingManager createLockingManager() {
            return new LockingManager();
        }
    }
}

