/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.internal.compare;

import java.util.Set;
import org.eclipse.compare.internal.CompareEditor;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOChangeSet;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.transaction.CDOCommitContext;
import org.eclipse.emf.cdo.transaction.CDODefaultTransactionHandler2;
import org.eclipse.emf.cdo.transaction.CDOMerger;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandlerBase;
import org.eclipse.emf.cdo.transaction.CDOTransactionOpener;
import org.eclipse.emf.cdo.ui.compare.CDOCompareEditorUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.internal.cdo.transaction.CDOMerger2;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareCDOMerger
implements CDOMerger2 {
    public static final String PROP_COMPARISON_LABEL = "comparison.label";
    public static final String PROP_COMPARISON_IMAGE = "comparison.image";

    @Deprecated
    public CDOChangeSetData merge(CDOChangeSet target, CDOChangeSet source) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void merge(CDOTransaction localTransaction, CDOView remoteView, Set<CDOID> affectedIDs) throws CDOMerger.ConflictException {
        CompareCDOMerger.closeTransactionAfterCommit(localTransaction);
        CompareCDOMerger.closeEditorWithTransaction(localTransaction);
        CDOCompareEditorUtil.openEditor(remoteView, (CDOView)localTransaction, affectedIDs, true);
    }

    public static void closeTransactionAfterCommit(CDOTransaction transaction) {
        transaction.addTransactionHandler((CDOTransactionHandlerBase)new CDODefaultTransactionHandler2(){

            public void rolledBackTransaction(CDOTransaction transaction) {
                this.closeTransaction(transaction);
            }

            public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
                this.closeTransaction(transaction);
            }

            private void closeTransaction(final CDOTransaction transaction) {
                UIUtil.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        transaction.close();
                    }
                });
            }
        });
    }

    public static void closeEditorWithTransaction(final CDOTransaction transaction) {
        final IEditorPart[] result = new IEditorPart[1];
        final IWorkbenchPage page = UIUtil.getActiveWorkbenchPage();
        IPartListener listener = new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
                if (part instanceof CompareEditor) {
                    result[0] = (IEditorPart)part;
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                if (part == result[0]) {
                    transaction.close();
                    page.removePartListener((IPartListener)this);
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
            }
        };
        page.addPartListener(listener);
        transaction.addListener((IListener)new LifecycleEventAdapter(){

            protected void onDeactivated(ILifecycle lifecycle) {
                if (result[0] != null) {
                    UIUtil.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            page.closeEditor(result[0], false);
                        }
                    });
                }
            }
        });
    }

    public static final class TransactionOpenerAndEditorCloser
    implements CDOTransactionOpener {
        private final CDOTransactionOpener delegate;
        private final boolean closeTransactionAfterCommit;

        public TransactionOpenerAndEditorCloser(CDOTransactionOpener delegate, boolean closeTransactionAfterCommit) {
            this.delegate = delegate;
            this.closeTransactionAfterCommit = closeTransactionAfterCommit;
        }

        public boolean isCloseTransactionAfterCommit() {
            return this.closeTransactionAfterCommit;
        }

        public CDOTransaction openTransaction(String durableLockingID, ResourceSet resourceSet) {
            return this.wrap(this.delegate.openTransaction(durableLockingID, resourceSet));
        }

        public CDOTransaction openTransaction(CDOBranchPoint target, ResourceSet resourceSet) {
            return this.wrap(this.delegate.openTransaction(target, resourceSet));
        }

        private CDOTransaction wrap(CDOTransaction transaction) {
            if (this.closeTransactionAfterCommit) {
                CompareCDOMerger.closeTransactionAfterCommit(transaction);
            }
            CompareCDOMerger.closeEditorWithTransaction(transaction);
            return transaction;
        }
    }
}

