/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.session;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewContainer;
import org.eclipse.emf.cdo.view.CDOViewProvider;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.internal.cdo.session.SessionUtil;
import org.eclipse.emf.internal.cdo.view.CDOViewImpl;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.emf.spi.cdo.InternalCDOViewSet;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDOViewContainerImpl
extends Container<CDOView>
implements CDOViewContainer {
    public static final ThreadLocal<CDOViewProvider> VIEW_PROVIDER = new ThreadLocal();
    private Set<InternalCDOView> views = new HashSet<InternalCDOView>();
    @ReflectUtil.ExcludeFromDump
    private int lastViewID;

    @Override
    public CDOView getView(int viewID) {
        this.checkActive();
        InternalCDOView[] internalCDOViewArray = this.getViews();
        int n = internalCDOViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOView view = internalCDOViewArray[n2];
            if (view.getViewID() == viewID) {
                return view;
            }
            ++n2;
        }
        return null;
    }

    public InternalCDOView[] getViews() {
        return this.getViews(null);
    }

    public InternalCDOView[] getViews(CDOBranch branch) {
        List<InternalCDOView> views = this.getViews(branch, false);
        return views.toArray(new InternalCDOView[views.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<InternalCDOView> getViews(CDOBranch branch, boolean writeable) {
        this.checkActive();
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            ArrayList<InternalCDOView> result = new ArrayList<InternalCDOView>();
            for (InternalCDOView view : this.views) {
                if (branch != null && branch != view.getBranch() || writeable && view.isReadOnly()) continue;
                result.add(view);
            }
            return result;
        }
    }

    public CDOView[] getElements() {
        return this.getViews();
    }

    public boolean isEmpty() {
        this.checkActive();
        return this.views.isEmpty();
    }

    @Override
    public CDOView openView(CDOBranchPoint target, ResourceSet resourceSet) {
        return this.openView(target.getBranch(), target.getTimeStamp(), resourceSet);
    }

    @Override
    public CDOView openView(CDOBranchPoint target) {
        return this.openView(target, this.createResourceSet());
    }

    @Override
    public InternalCDOView openView(CDOBranch branch, long timeStamp, ResourceSet resourceSet) {
        this.checkActive();
        InternalCDOView view = this.createView(branch, timeStamp);
        this.initView(view, resourceSet);
        return view;
    }

    @Override
    public InternalCDOView openView(CDOBranch branch, long timeStamp) {
        return this.openView(branch, timeStamp, this.createResourceSet());
    }

    @Override
    public InternalCDOView openView(CDOBranch branch) {
        return this.openView(branch, 0L);
    }

    @Override
    public InternalCDOView openView(long timeStamp) {
        return this.openView(this.getMainBranch(), timeStamp);
    }

    @Override
    public InternalCDOView openView(ResourceSet resourceSet) {
        return this.openView(this.getMainBranch(), 0L, resourceSet);
    }

    @Override
    public InternalCDOView openView() {
        return this.openView(0L);
    }

    @Override
    public CDOView openView(String durableLockingID) {
        return this.openView(durableLockingID, this.createResourceSet());
    }

    @Override
    public CDOView openView(String durableLockingID, ResourceSet resourceSet) {
        this.checkActive();
        InternalCDOView view = this.createView(durableLockingID);
        this.initView(view, resourceSet);
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewDetached(InternalCDOView view) {
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            if (!this.views.remove(view)) {
                return;
            }
        }
        if (this.isActive()) {
            try {
                LifecycleUtil.deactivate((Object)view);
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
        this.fireElementRemovedEvent(view);
    }

    protected InternalCDOView createView(CDOBranch branch, long timeStamp) {
        return new CDOViewImpl(branch, timeStamp);
    }

    protected InternalCDOView createView(String durableLockingID) {
        return new CDOViewImpl(durableLockingID);
    }

    protected ResourceSet createResourceSet() {
        return new ResourceSetImpl();
    }

    protected void doDeactivate() throws Exception {
        InternalCDOView[] internalCDOViewArray = this.views.toArray(new InternalCDOView[this.views.size()]);
        int n = internalCDOViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOView view = internalCDOViewArray[n2];
            try {
                view.close();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            ++n2;
        }
        this.views.clear();
        super.doDeactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initView(InternalCDOView view, ResourceSet resourceSet) {
        CDOViewProvider viewProvider = VIEW_PROVIDER.get();
        if (viewProvider != null) {
            view.setProvider(viewProvider);
        }
        InternalCDOViewSet viewSet = SessionUtil.prepareResourceSet(resourceSet);
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            view.setViewID(++this.lastViewID);
            this.initViewSynced(view);
            this.views.add(view);
        }
        view.setViewSet(viewSet);
        viewSet.add(view);
        try {
            view.activate();
            this.fireElementAddedEvent(view);
        }
        catch (RuntimeException ex) {
            Set<InternalCDOView> set2 = this.views;
            synchronized (set2) {
                this.views.remove(view);
            }
            viewSet.remove(view);
            view.deactivate();
            throw ex;
        }
    }

    protected void initViewSynced(InternalCDOView view) {
    }

    protected abstract CDOBranch getMainBranch();
}

