/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.session;

import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.properties.DefaultPropertyTester;
import org.eclipse.net4j.util.properties.IProperties;
import org.eclipse.net4j.util.properties.Properties;
import org.eclipse.net4j.util.properties.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionProperties
extends Properties<CDOSession>
implements CDOCommonRepository {
    public static final IProperties<CDOSession> INSTANCE = new SessionProperties();
    private static final String CATEGORY_SESSION = "Session";
    private static final String CATEGORY_REPOSITORY = "Repository";

    private SessionProperties() {
        super(CDOSession.class);
        this.add((Property)new Property<CDOSession>("open", Messages.getString("SessionPropertyTester_34"), Messages.getString("SessionPropertyTester_35"), CATEGORY_SESSION){

            protected Object eval(CDOSession session) {
                return !session.isClosed();
            }
        });
        this.add((Property)new Property<CDOSession>("sessionID", Messages.getString("SessionPropertyTester_0"), Messages.getString("SessionPropertyTester_3"), CATEGORY_SESSION){

            protected Object eval(CDOSession session) {
                return session.getSessionID();
            }
        });
        this.add((Property)new Property<CDOSession>("userID", Messages.getString("SessionPropertyTester_4"), Messages.getString("SessionPropertyTester_5"), CATEGORY_SESSION){

            protected Object eval(CDOSession session) {
                return session.getUserID();
            }
        });
        this.add((Property)new Property<CDOSession>("passiveUpdateEnabled", Messages.getString("SessionPropertyTester_6"), Messages.getString("SessionPropertyTester_7"), CATEGORY_SESSION){

            protected Object eval(CDOSession session) {
                return session.options().isPassiveUpdateEnabled();
            }
        });
        this.add((Property)new Property<CDOSession>("lastUpdateTime", Messages.getString("SessionPropertyTester_36"), Messages.getString("SessionPropertyTester_37"), CATEGORY_SESSION){

            protected Object eval(CDOSession session) {
                return CDOCommonUtil.formatTimeStamp((long)session.getLastUpdateTime());
            }
        });
        this.add((Property)new Property<CDOSession>("passiveUpdateMode", Messages.getString("SessionPropertyTester_8"), Messages.getString("SessionPropertyTester_9"), CATEGORY_SESSION){

            protected Object eval(CDOSession session) {
                return session.options().getPassiveUpdateMode();
            }
        });
        this.add((Property)new Property<CDOSession>("repositoryName", Messages.getString("SessionPropertyTester_10"), Messages.getString("SessionPropertyTester_11"), CATEGORY_REPOSITORY){

            protected Object eval(CDOSession session) {
                return session.getRepositoryInfo().getName();
            }
        });
        this.add((Property)new Property<CDOSession>("repositoryUUID", Messages.getString("SessionPropertyTester_12"), Messages.getString("SessionPropertyTester_13"), CATEGORY_REPOSITORY){

            protected Object eval(CDOSession session) {
                return session.getRepositoryInfo().getUUID();
            }
        });
        this.add((Property)new Property<CDOSession>("repositoryType", Messages.getString("SessionPropertyTester_14"), Messages.getString("SessionPropertyTester_15"), CATEGORY_REPOSITORY){

            protected Object eval(CDOSession session) {
                return session.getRepositoryInfo().getType();
            }
        });
        this.add((Property)new Property<CDOSession>("repositoryState", Messages.getString("SessionPropertyTester_16"), Messages.getString("SessionPropertyTester_17"), CATEGORY_REPOSITORY){

            protected Object eval(CDOSession session) {
                return session.getRepositoryInfo().getState();
            }
        });
        this.add((Property)new Property<CDOSession>("repositoryCreationTime", Messages.getString("SessionPropertyTester_18"), Messages.getString("SessionPropertyTester_19"), CATEGORY_REPOSITORY){

            protected Object eval(CDOSession session) {
                return CDOCommonUtil.formatTimeStamp((long)session.getRepositoryInfo().getCreationTime());
            }
        });
        this.add((Property)new Property<CDOSession>("authenticating", Messages.getString("SessionPropertyTester_40"), Messages.getString("SessionPropertyTester_41"), CATEGORY_REPOSITORY){

            protected Object eval(CDOSession session) {
                return session.getRepositoryInfo().isAuthenticating();
            }
        });
        this.add((Property)new Property<CDOSession>("supportingAudits", Messages.getString("SessionPropertyTester_20"), Messages.getString("SessionPropertyTester_21"), CATEGORY_REPOSITORY){

            protected Object eval(CDOSession session) {
                return session.getRepositoryInfo().isSupportingAudits();
            }
        });
        this.add((Property)new Property<CDOSession>("supportingBranches", Messages.getString("SessionPropertyTester_22"), Messages.getString("SessionPropertyTester_23"), CATEGORY_REPOSITORY){

            protected Object eval(CDOSession session) {
                return session.getRepositoryInfo().isSupportingBranches();
            }
        });
        this.add((Property)new Property<CDOSession>("serializeCommits", Messages.getString("SessionPropertyTester_38"), Messages.getString("SessionPropertyTester_39"), CATEGORY_REPOSITORY){

            protected Object eval(CDOSession session) {
                return session.getRepositoryInfo().isSerializingCommits();
            }
        });
        this.add((Property)new Property<CDOSession>("ensureReferentialIntegrity", Messages.getString("SessionPropertyTester_30"), Messages.getString("SessionPropertyTester_31"), CATEGORY_REPOSITORY){

            protected Object eval(CDOSession session) {
                return session.getRepositoryInfo().isEnsuringReferentialIntegrity();
            }
        });
        this.add((Property)new Property<CDOSession>("idGenerationLocation", Messages.getString("SessionPropertyTester_32"), Messages.getString("SessionPropertyTester_33"), CATEGORY_REPOSITORY){

            protected Object eval(CDOSession session) {
                return session.getRepositoryInfo().getIDGenerationLocation();
            }
        });
        this.add((Property)new Property<CDOSession>("storeType", Messages.getString("SessionPropertyTester_24"), Messages.getString("SessionPropertyTester_25"), CATEGORY_REPOSITORY){

            protected Object eval(CDOSession session) {
                return session.getRepositoryInfo().getStoreType();
            }
        });
        this.add((Property)new Property<CDOSession>("objectIDTypes", Messages.getString("SessionPropertyTester_26"), Messages.getString("SessionPropertyTester_27"), CATEGORY_REPOSITORY){

            protected Object eval(CDOSession session) {
                StringBuilder builder = new StringBuilder();
                for (CDOID.ObjectType objectIDType : session.getRepositoryInfo().getObjectIDTypes()) {
                    if (builder.length() != 0) {
                        builder.append(", ");
                    }
                    builder.append(objectIDType);
                }
                return builder;
            }
        });
        this.add((Property)new Property<CDOSession>("userAuthenticated"){

            protected Object eval(CDOSession session) {
                return !StringUtil.isEmpty((String)session.getUserID());
            }
        });
    }

    public Object getAdapter(Class adapter) {
        return AdapterUtil.adapt((Object)((Object)this), (Class)adapter, (boolean)false);
    }

    public long getTimeStamp() {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        throw new UnsupportedOperationException();
    }

    public String getUUID() {
        throw new UnsupportedOperationException();
    }

    public CDOCommonRepository.Type getType() {
        throw new UnsupportedOperationException();
    }

    public CDOCommonRepository.State getState() {
        throw new UnsupportedOperationException();
    }

    public long getCreationTime() {
        throw new UnsupportedOperationException();
    }

    public String getStoreType() {
        throw new UnsupportedOperationException();
    }

    public Set<CDOID.ObjectType> getObjectIDTypes() {
        throw new UnsupportedOperationException();
    }

    public CDOCommonRepository.IDGenerationLocation getIDGenerationLocation() {
        throw new UnsupportedOperationException();
    }

    public CDOID getRootResourceID() {
        throw new UnsupportedOperationException();
    }

    public boolean isAuthenticating() {
        throw new UnsupportedOperationException();
    }

    public boolean isSupportingAudits() {
        throw new UnsupportedOperationException();
    }

    public boolean isSupportingBranches() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public boolean isSupportingEcore() {
        throw new UnsupportedOperationException();
    }

    public boolean isSerializingCommits() {
        throw new UnsupportedOperationException();
    }

    public boolean isEnsuringReferentialIntegrity() {
        throw new UnsupportedOperationException();
    }

    public boolean waitWhileInitial(IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) {
        new Tester().dumpContributionMarkup();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Tester
    extends DefaultPropertyTester<CDOSession> {
        public static final String NAMESPACE = "org.eclipse.emf.cdo.session";

        public Tester() {
            super(NAMESPACE, INSTANCE);
        }
    }
}

