/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.view;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.CDOCommonView;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lock.CDOLockChangeInfo;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.common.revision.CDOIDAndBranch;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionsLoadedEvent;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.internal.common.lock.CDOLockStateImpl;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.lock.InternalCDOLockState;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.transaction.CDOCommitContext;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.LockTimeoutException;
import org.eclipse.emf.cdo.util.ReadOnlyException;
import org.eclipse.emf.cdo.util.StaleRevisionLockException;
import org.eclipse.emf.cdo.view.CDOAdapterPolicy;
import org.eclipse.emf.cdo.view.CDOFeatureAnalyzer;
import org.eclipse.emf.cdo.view.CDOInvalidationPolicy;
import org.eclipse.emf.cdo.view.CDORevisionPrefetchingPolicy;
import org.eclipse.emf.cdo.view.CDOStaleReferencePolicy;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewDurabilityChangedEvent;
import org.eclipse.emf.cdo.view.CDOViewInvalidationEvent;
import org.eclipse.emf.cdo.view.CDOViewLocksChangedEvent;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.object.CDODeltaNotificationImpl;
import org.eclipse.emf.internal.cdo.object.CDOInvalidationNotificationImpl;
import org.eclipse.emf.internal.cdo.object.CDONotificationBuilder;
import org.eclipse.emf.internal.cdo.session.SessionUtil;
import org.eclipse.emf.internal.cdo.util.DefaultLocksChangedEvent;
import org.eclipse.emf.internal.cdo.view.AbstractCDOView;
import org.eclipse.emf.internal.cdo.view.CDODefaultLockStateLoadingPolicy;
import org.eclipse.emf.internal.cdo.view.CDOLockStateLoadingPolicy;
import org.eclipse.emf.internal.cdo.view.CDOStateMachine;
import org.eclipse.emf.internal.cdo.view.CDOViewRegistryImpl;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.emf.spi.cdo.InternalCDOViewSet;
import org.eclipse.net4j.internal.util.concurrent.ExecutorWorkSerializer;
import org.eclipse.net4j.internal.util.concurrent.IExecutorServiceProvider;
import org.eclipse.net4j.internal.util.concurrent.InternalConcurrencyUtil;
import org.eclipse.net4j.internal.util.concurrent.RunnableWithName;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.HashBag;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.event.Notifier;
import org.eclipse.net4j.util.event.ThrowableEvent;
import org.eclipse.net4j.util.lifecycle.LifecycleException;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.monitor.EclipseMonitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.options.IOptions;
import org.eclipse.net4j.util.options.OptionsEvent;
import org.eclipse.net4j.util.ref.ReferenceType;
import org.eclipse.net4j.util.ref.ReferenceValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOViewImpl
extends AbstractCDOView
implements IExecutorServiceProvider {
    public static final String PROP_TIME_MACHINE_DISABLED = "timeMachineDisabled";
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_VIEW, CDOViewImpl.class);
    private int viewID;
    private InternalCDOSession session;
    private String durableLockingID;
    private ChangeSubscriptionManager changeSubscriptionManager = new ChangeSubscriptionManager();
    private AdapterManager adapterManager = new AdapterManager();
    private OptionsImpl options;
    private long lastUpdateTime;
    private CDOLockOwner lockOwner;
    private Map<CDOObject, CDOLockState> lockStates = new WeakHashMap<CDOObject, CDOLockState>();
    private ExecutorWorkSerializer invalidationRunner = this.createInvalidationRunner();
    private volatile boolean invalidationRunnerActive;

    public CDOViewImpl(CDOBranch branch, long timeStamp) {
        super(branch.getPoint(timeStamp));
        this.options = this.createOptions();
    }

    public CDOViewImpl(String durableLockingID) {
        this.durableLockingID = durableLockingID;
        this.options = this.createOptions();
    }

    @Override
    public OptionsImpl options() {
        return this.options;
    }

    public int getViewID() {
        return this.viewID;
    }

    @Override
    public void setViewID(int viewId) {
        this.viewID = viewId;
    }

    public ExecutorService getExecutorService() {
        return InternalConcurrencyUtil.getExecutorService((Object)this.session);
    }

    @Override
    public InternalCDOSession getSession() {
        return this.session;
    }

    @Override
    public void setSession(InternalCDOSession session) {
        super.setSession(session);
        this.session = session;
    }

    public int getSessionID() {
        return this.session.getSessionID();
    }

    @Override
    public synchronized boolean setBranchPoint(CDOBranchPoint branchPoint, IProgressMonitor progressMonitor) {
        this.checkActive();
        branchPoint = this.adjustBranchPoint(branchPoint);
        long timeStamp = branchPoint.getTimeStamp();
        long creationTimeStamp = this.session.getRepositoryInfo().getCreationTime();
        if (timeStamp != 0L && timeStamp < creationTimeStamp) {
            throw new IllegalArgumentException(MessageFormat.format("timeStamp ({0}) < repository creation time ({1})", CDOCommonUtil.formatTimeStamp((long)timeStamp), CDOCommonUtil.formatTimeStamp((long)creationTimeStamp)));
        }
        CDOBranchPoint oldBranchPoint = CDOBranchUtil.copyBranchPoint((CDOBranchPoint)this.getBranchPoint());
        if (branchPoint.equals(oldBranchPoint)) {
            return false;
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Changing view target to {0}", new Object[]{branchPoint});
        }
        Map oldRevisions = CDOIDUtil.createMap();
        ArrayList<CDORevisionKey> allChangedObjects = new ArrayList<CDORevisionKey>();
        ArrayList<CDOIDAndVersion> allDetachedObjects = new ArrayList<CDOIDAndVersion>();
        List<InternalCDOObject> invalidObjects = this.getInvalidObjects(branchPoint);
        for (InternalCDOObject object : invalidObjects) {
            InternalCDORevision revision = object.cdoRevision();
            if (revision == null) continue;
            oldRevisions.put(object.cdoID(), revision);
        }
        CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
        EclipseMonitor monitor = progressMonitor != null ? new EclipseMonitor(progressMonitor) : null;
        sessionProtocol.switchTarget(this.viewID, branchPoint, invalidObjects, allChangedObjects, allDetachedObjects, (OMMonitor)monitor);
        this.basicSetBranchPoint(branchPoint);
        CDOBranch branch = branchPoint.getBranch();
        try {
            CDOStateMachine.SWITCHING_TARGET.set(Boolean.TRUE);
            this.doInvalidate(branch, 0L, allChangedObjects, allDetachedObjects, oldRevisions, true);
        }
        finally {
            CDOStateMachine.SWITCHING_TARGET.remove();
        }
        IListener[] listeners = this.getListeners();
        if (listeners != null) {
            this.fireViewTargetChangedEvent(oldBranchPoint, listeners);
        }
        return true;
    }

    private List<InternalCDOObject> getInvalidObjects(CDOBranchPoint branchPoint) {
        ArrayList<InternalCDOObject> result = new ArrayList<InternalCDOObject>();
        for (InternalCDOObject object : this.getModifiableObjects().values()) {
            InternalCDORevision revision = object.cdoRevision(false);
            if (revision != null && revision.isValid(branchPoint)) continue;
            result.add(object);
        }
        return result;
    }

    private Set<? extends CDOObject> getSet(Collection<? extends CDOObject> objects) {
        if (objects instanceof Set) {
            return (Set)objects;
        }
        return new HashSet<CDOObject>(objects);
    }

    @Override
    public synchronized void lockObjects(Collection<? extends CDOObject> objects, IRWLockManager.LockType lockType, long timeout) throws InterruptedException {
        this.lockObjects(objects, lockType, timeout, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void lockObjects(Collection<? extends CDOObject> objects, IRWLockManager.LockType lockType, long timeout, boolean recursive) throws InterruptedException {
        void var10_13;
        this.checkActive();
        this.checkState(this.getTimeStamp() == 0L, "Locking not supported for historial views");
        Set<? extends CDOObject> uniqueObjects = this.getSet(objects);
        int size = uniqueObjects.size();
        ArrayList<CDORevisionKey> revisionKeys = new ArrayList<CDORevisionKey>(size);
        ArrayList<InternalCDOLockState> locksOnNewObjects = new ArrayList<InternalCDOLockState>(size);
        for (CDOObject cDOObject : uniqueObjects) {
            if (FSMUtil.isNew(cDOObject)) {
                InternalCDOLockState lockState = this.createUpdatedLockStateForNewObject(cDOObject, lockType, true);
                locksOnNewObjects.add(lockState);
                continue;
            }
            InternalCDORevision revision = this.getRevision(cDOObject);
            if (revision == null) continue;
            revisionKeys.add((CDORevisionKey)revision);
        }
        Object var10_11 = null;
        if (!revisionKeys.isEmpty()) {
            CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
            CDOSessionProtocol.LockObjectsResult lockObjectsResult = sessionProtocol.lockObjects2(revisionKeys, this.viewID, this.getBranch(), lockType, recursive, timeout);
            if (!lockObjectsResult.isSuccessful()) {
                if (lockObjectsResult.isTimedOut()) {
                    throw new LockTimeoutException();
                }
                CDORevisionKey[] staleRevisions = lockObjectsResult.getStaleRevisions();
                if (staleRevisions != null) {
                    throw new StaleRevisionLockException(staleRevisions);
                }
                throw new AssertionError((Object)"Unexpected lock result state");
            }
            if (lockObjectsResult.isWaitForUpdate()) {
                if (!this.session.options().isPassiveUpdateEnabled()) {
                    throw new AssertionError((Object)"Lock result requires client to wait, but client does not have passiveUpdates enabled");
                }
                long requiredTimestamp = lockObjectsResult.getRequiredTimestamp();
                if (!this.waitForUpdate(requiredTimestamp, 10000L)) {
                    throw new AssertionError((Object)("Lock result requires client to wait for commit " + requiredTimestamp + ", but client did not receive invalidations after " + this.lastUpdateTime));
                }
                InternalCDOSession session = this.session;
                InternalCDORevisionManager revisionManager = session.getRevisionManager();
                CDORevisionKey[] cDORevisionKeyArray = lockObjectsResult.getStaleRevisions();
                int n = cDORevisionKeyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CDORevisionKey requiredKey = cDORevisionKeyArray[n2];
                    CDOID id = requiredKey.getID();
                    InternalCDOObject object = this.getObject(id);
                    InternalCDORevision revision = object.cdoRevision(true);
                    if (!requiredKey.equals(revision)) {
                        InternalCDORevision requiredRevision = revisionManager.getRevisionByVersion(id, (CDOBranchVersion)requiredKey, -1, true);
                        InternalCDORevisionDelta revisionDelta = requiredRevision.compare((CDORevision)revision);
                        CDOStateMachine.INSTANCE.invalidate(object, (CDORevisionKey)revisionDelta);
                    }
                    ++n2;
                }
            }
        }
        CDOLockState[] locksOnNewObjectsArray = locksOnNewObjects.toArray(new CDOLockState[locksOnNewObjects.size()]);
        this.updateLockStates(locksOnNewObjectsArray);
        if (var10_13 != null) {
            this.updateAndNotifyLockStates(CDOLockChangeInfo.Operation.LOCK, lockType, var10_13.getTimestamp(), var10_13.getNewLockStates());
        }
    }

    protected void updateAndNotifyLockStates(CDOLockChangeInfo.Operation op, IRWLockManager.LockType type, long timestamp, CDOLockState[] newLockStates) {
        this.updateLockStates(newLockStates);
        this.notifyOtherViewsAboutLockChanges(op, type, timestamp, newLockStates);
    }

    protected void updateLockStates(CDOLockState[] newLockStates) {
        CDOLockState[] cDOLockStateArray = newLockStates;
        int n = newLockStates.length;
        int n2 = 0;
        while (n2 < n) {
            CDOID id;
            CDOLockState lockState = cDOLockStateArray[n2];
            Object lockedObject = lockState.getLockedObject();
            if (lockedObject instanceof CDOID) {
                id = (CDOID)lockedObject;
            } else if (lockedObject instanceof CDOIDAndBranch) {
                id = ((CDOIDAndBranch)lockedObject).getID();
            } else if (lockedObject instanceof EObject) {
                CDOObject newObj = CDOUtil.getCDOObject((EObject)lockedObject);
                id = newObj.cdoID();
            } else {
                throw new IllegalStateException("Unexpected: " + lockedObject.getClass().getSimpleName());
            }
            InternalCDOObject object = this.getObject(id, false);
            if (object != null) {
                InternalCDOLockState existingLockState = (InternalCDOLockState)this.lockStates.get(object);
                if (existingLockState != null) {
                    ((CDOLockStateImpl)existingLockState).updateFrom(lockState);
                } else {
                    this.lockStates.put(object, lockState);
                }
            }
            ++n2;
        }
    }

    private void notifyOtherViewsAboutLockChanges(CDOLockChangeInfo.Operation op, IRWLockManager.LockType type, long timestamp, CDOLockState[] lockStates) {
        if (lockStates.length > 0) {
            CDOLockChangeInfo lockChangeInfo = this.makeLockChangeInfo(op, type, timestamp, lockStates);
            this.session.handleLockNotification(lockChangeInfo, this);
            if (this.isActive()) {
                this.fireLocksChangedEvent(this, lockChangeInfo);
            }
        }
    }

    private CDOLockChangeInfo makeLockChangeInfo(CDOLockChangeInfo.Operation op, IRWLockManager.LockType type, long timestamp, CDOLockState[] newLockStates) {
        return CDOLockUtil.createLockChangeInfo((long)timestamp, (CDOCommonView)this, (CDOBranch)this.getBranch(), (CDOLockChangeInfo.Operation)op, (IRWLockManager.LockType)type, (CDOLockState[])newLockStates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void handleLockNotification(InternalCDOView sender, CDOLockChangeInfo lockChangeInfo) {
        CDOLockChangeInfo event = null;
        try {
            block13: {
                block12: {
                    Map<CDOObject, CDOLockState> map = this.lockStates;
                    // MONITORENTER : map
                    if (!this.options().isLockNotificationEnabled()) {
                        // MONITOREXIT : map
                        if (event == null) return;
                        this.fireLocksChangedEvent(sender, event);
                        return;
                    }
                    if (lockChangeInfo.isInvalidateAll()) {
                        this.lockStates.clear();
                        event = lockChangeInfo;
                        // MONITOREXIT : map
                        if (event == null) return;
                        this.fireLocksChangedEvent(sender, event);
                        return;
                    }
                    CDOBranch lockChangeBranch = lockChangeInfo.getBranch();
                    CDOBranch viewBranch = this.getBranch();
                    if (lockChangeBranch == viewBranch) break block12;
                    // MONITOREXIT : map
                    if (event == null) return;
                    this.fireLocksChangedEvent(sender, event);
                    return;
                    {
                        catch (Throwable throwable) {
                            // MONITOREXIT : map
                            throw throwable;
                        }
                    }
                }
                if (!lockChangeInfo.getLockOwner().equals(this.lockOwner)) break block13;
                // MONITOREXIT : map
                if (event == null) return;
                this.fireLocksChangedEvent(sender, event);
                return;
            }
            this.updateLockStates(lockChangeInfo.getLockStates());
            event = lockChangeInfo;
            // MONITOREXIT : map
        }
        catch (Throwable throwable) {
            if (event == null) throw throwable;
            this.fireLocksChangedEvent(sender, event);
            throw throwable;
        }
        if (event == null) return;
        this.fireLocksChangedEvent(sender, event);
    }

    private void fireLocksChangedEvent(InternalCDOView sender, CDOLockChangeInfo lockChangeInfo) {
        IListener[] listeners = this.getListeners();
        if (listeners != null) {
            this.fireEvent(new LocksChangedEvent(sender, lockChangeInfo), listeners);
        }
    }

    protected InternalCDORevision getRevision(CDOObject object) {
        if (object.cdoState() == CDOState.NEW) {
            return null;
        }
        InternalCDORevision revision = (InternalCDORevision)object.cdoRevision();
        if (revision == null) {
            revision = CDOStateMachine.INSTANCE.read((InternalCDOObject)object);
        }
        return revision;
    }

    @Override
    public synchronized void unlockObjects(Collection<? extends CDOObject> objects, IRWLockManager.LockType lockType) {
        this.unlockObjects(objects, lockType, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void unlockObjects(Collection<? extends CDOObject> objects, IRWLockManager.LockType lockType, boolean recursive) {
        void var6_10;
        this.checkActive();
        ArrayList<CDOID> objectIDs = null;
        LinkedList<Object> locksOnNewObjects = new LinkedList<Object>();
        if (objects != null) {
            objectIDs = new ArrayList<CDOID>();
            for (CDOObject cDOObject : this.getSet(objects)) {
                if (FSMUtil.isNew(cDOObject)) {
                    InternalCDOLockState lockState = this.createUpdatedLockStateForNewObject(cDOObject, lockType, false);
                    locksOnNewObjects.add(lockState);
                    continue;
                }
                objectIDs.add(cDOObject.cdoID());
            }
        } else {
            locksOnNewObjects.addAll(this.createUnlockedLockStatesForAllNewObjects());
        }
        Object var6_8 = null;
        if (objectIDs == null || !objectIDs.isEmpty()) {
            CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
            CDOSessionProtocol.UnlockObjectsResult unlockObjectsResult = sessionProtocol.unlockObjects2(this, objectIDs, lockType, recursive);
        }
        CDOLockState[] locksOnNewObjectsArray = locksOnNewObjects.toArray(new CDOLockState[locksOnNewObjects.size()]);
        this.updateLockStates(locksOnNewObjectsArray);
        if (var6_10 != null) {
            this.updateAndNotifyLockStates(CDOLockChangeInfo.Operation.UNLOCK, lockType, var6_10.getTimestamp(), var6_10.getNewLockStates());
        }
    }

    protected InternalCDOLockState createUpdatedLockStateForNewObject(CDOObject object, IRWLockManager.LockType lockType, boolean on) {
        throw new ReadOnlyException();
    }

    protected Collection<CDOLockState> createUnlockedLockStatesForAllNewObjects() {
        return Collections.emptyList();
    }

    @Override
    public synchronized void unlockObjects() {
        this.unlockObjects(null, null);
    }

    @Override
    public synchronized boolean isObjectLocked(CDOObject object, IRWLockManager.LockType lockType, boolean byOthers) {
        this.checkActive();
        CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
        return sessionProtocol.isObjectLocked(this, object, lockType, byOthers);
    }

    public boolean isDurableView() {
        return this.durableLockingID != null;
    }

    public synchronized String getDurableLockingID() {
        return this.durableLockingID;
    }

    @Override
    @Deprecated
    public String enableDurableLocking(boolean enable) {
        if (enable) {
            return this.enableDurableLocking();
        }
        this.disableDurableLocking(false);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String enableDurableLocking() {
        String oldID = this.durableLockingID;
        try {
            CDOViewImpl cDOViewImpl = this;
            synchronized (cDOViewImpl) {
                CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
                if (this.durableLockingID == null) {
                    this.durableLockingID = sessionProtocol.changeLockArea(this, true);
                }
                String string = this.durableLockingID;
                return string;
            }
        }
        finally {
            this.fireDurabilityChangedEvent(oldID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableDurableLocking(boolean releaseLocks) {
        String oldID = this.durableLockingID;
        try {
            CDOViewImpl cDOViewImpl = this;
            synchronized (cDOViewImpl) {
                CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
                if (this.durableLockingID != null) {
                    sessionProtocol.changeLockArea(this, false);
                    this.durableLockingID = null;
                    if (releaseLocks) {
                        this.unlockObjects();
                    }
                }
            }
        }
        finally {
            this.fireDurabilityChangedEvent(oldID);
        }
    }

    private void fireDurabilityChangedEvent(final String oldID) {
        if (!ObjectUtil.equals((Object)oldID, (Object)this.durableLockingID)) {
            this.fireEvent(new CDOViewDurabilityChangedEvent(){

                public CDOView getSource() {
                    return CDOViewImpl.this;
                }

                public String getOldDurableLockingID() {
                    return oldID;
                }

                public String getNewDurableLockingID() {
                    return CDOViewImpl.this.durableLockingID;
                }
            });
        }
    }

    @Override
    @Deprecated
    public synchronized CDOFeatureAnalyzer getFeatureAnalyzer() {
        return this.options().getFeatureAnalyzer();
    }

    @Override
    @Deprecated
    public synchronized void setFeatureAnalyzer(CDOFeatureAnalyzer featureAnalyzer) {
        this.options.setFeatureAnalyzer(featureAnalyzer);
    }

    @Override
    public InternalCDOTransaction toTransaction() {
        this.checkActive();
        if (this instanceof InternalCDOTransaction) {
            return (InternalCDOTransaction)((Object)this);
        }
        throw new ReadOnlyException(MessageFormat.format(Messages.getString("CDOViewImpl.0"), this));
    }

    @Override
    public synchronized InternalCDORevision getRevision(CDOID id, boolean loadOnDemand) {
        InternalCDORevisionManager revisionManager = this.session.getRevisionManager();
        int initialChunkSize = this.session.options().getCollectionLoadingPolicy().getInitialChunkSize();
        CDOBranchPoint branchPoint = this.getBranchPointForID(id);
        return revisionManager.getRevision(id, branchPoint, initialChunkSize, 0, loadOnDemand);
    }

    @Override
    public synchronized void remapObject(CDOID oldID) {
        InternalCDOObject object = this.getObject(oldID, false);
        InternalCDOLockState oldLockState = (InternalCDOLockState)this.lockStates.remove(object);
        if (oldLockState != null) {
            Object lockedObject = CDOViewImpl.getLockTarget(object);
            InternalCDOLockState newLockState = (InternalCDOLockState)CDOLockUtil.createLockState((Object)lockedObject);
            ((CDOLockStateImpl)newLockState).updateFrom((CDOLockState)oldLockState);
            this.lockStates.put(object, (CDOLockState)newLockState);
        }
        super.remapObject(oldID);
    }

    @Override
    public synchronized InternalCDOObject removeObject(CDOID id) {
        InternalCDOObject removedObject = super.removeObject(id);
        this.removeLockState(removedObject);
        return removedObject;
    }

    @Override
    public synchronized CDOLockState[] getLockStates(Collection<CDOID> ids) {
        return this.getLockStates(ids, true);
    }

    protected synchronized CDOLockState[] getLockStates(Collection<CDOID> ids, boolean loadOnDemand) {
        LinkedList<CDOID> missing = new LinkedList<CDOID>();
        LinkedList<CDOLockState> lockStates = new LinkedList<CDOLockState>();
        ArrayList<CDOLockState> locksOnNewObjects = new ArrayList<CDOLockState>(ids.size());
        for (CDOID id : ids) {
            CDOLockState lockState = null;
            InternalCDOObject object = this.getObject(id, false);
            if (object != null) {
                lockState = this.lockStates.get(object);
            }
            if (lockState != null) {
                lockStates.add(lockState);
                continue;
            }
            if (loadOnDemand && object != null && FSMUtil.isNew(object)) {
                Object lockedObject = CDOViewImpl.getLockTarget(object);
                CDOLockState defaultLockState = CDOLockUtil.createLockState((Object)lockedObject);
                locksOnNewObjects.add(defaultLockState);
                lockStates.add(defaultLockState);
                continue;
            }
            missing.add(id);
        }
        if (loadOnDemand && (missing.size() > 0 || ids.isEmpty())) {
            CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
            CDOLockState[] loadedLockStates = sessionProtocol.getLockStates(this.viewID, missing, 0);
            ArrayList<CDOLockState> newLockStateForCache = new ArrayList<CDOLockState>(loadedLockStates.length + missing.size());
            CDOLockState[] cDOLockStateArray = loadedLockStates;
            int defaultLockState = loadedLockStates.length;
            int n = 0;
            while (n < defaultLockState) {
                CDOLockState loadedLockState = cDOLockStateArray[n];
                lockStates.add(loadedLockState);
                newLockStateForCache.add(loadedLockState);
                CDOID cdoID = CDOIDUtil.getCDOID((Object)loadedLockState.getLockedObject());
                if (cdoID != null) {
                    missing.remove(cdoID);
                }
                ++n;
            }
            for (CDOID missingLockStateForCDOID : missing) {
                InternalCDOObject object = this.getObject(missingLockStateForCDOID, false);
                Object target = object != null ? CDOViewImpl.getLockTarget(object) : missingLockStateForCDOID;
                CDOLockState defaultLockState2 = CDOLockUtil.createLockState((Object)target);
                lockStates.add(defaultLockState2);
                newLockStateForCache.add(defaultLockState2);
            }
            if (this.options().isLockNotificationEnabled()) {
                this.updateLockStates(newLockStateForCache.toArray(new CDOLockState[newLockStateForCache.size()]));
            }
        }
        CDOLockState[] locksOnNewObjectsArray = locksOnNewObjects.toArray(new CDOLockState[locksOnNewObjects.size()]);
        this.updateLockStates(locksOnNewObjectsArray);
        return lockStates.toArray(new CDOLockState[lockStates.size()]);
    }

    protected CDOLockState removeLockState(CDOObject object) {
        return this.lockStates.remove(object);
    }

    protected CDOLockState getLockState(CDOObject object) {
        return this.lockStates.get(object);
    }

    private CDOBranchPoint getBranchPointForID(CDOID id) {
        CDOBranchPoint branchPoint = this.getNormalizedBranchPoint();
        if (branchPoint.getTimeStamp() != 0L) {
            return branchPoint;
        }
        if (this.session.isSticky()) {
            branchPoint = this.session.getCommittedSinceLastRefresh(id);
            if (branchPoint == null) {
                branchPoint = this.getBranch().getPoint(this.session.getLastUpdateTime());
            }
            return branchPoint;
        }
        return this;
    }

    @Override
    public synchronized void prefetchRevisions(CDOID id, int depth) {
        this.checkArg(depth != 0, "Prefetch depth must not be zero");
        int initialChunkSize = this.session.options().getCollectionLoadingPolicy().getInitialChunkSize();
        this.prefetchRevisions(id, depth, initialChunkSize);
    }

    protected void prefetchRevisions(CDOID id, int depth, int initialChunkSize) {
        InternalCDORevisionManager revisionManager = this.session.getRevisionManager();
        revisionManager.getRevision(id, (CDOBranchPoint)this, initialChunkSize, depth, true);
    }

    @Override
    @Deprecated
    public void invalidate(CDOBranch branch, long lastUpdateTime, List<CDORevisionKey> allChangedObjects, List<CDOIDAndVersion> allDetachedObjects, Map<CDOID, InternalCDORevision> oldRevisions, boolean async) {
        this.invalidate(branch, lastUpdateTime, allChangedObjects, allDetachedObjects, oldRevisions, async, true);
    }

    @Override
    public void invalidate(CDOBranch branch, long lastUpdateTime, List<CDORevisionKey> allChangedObjects, List<CDOIDAndVersion> allDetachedObjects, Map<CDOID, InternalCDORevision> oldRevisions, boolean async, boolean clearResourcePathCache) {
        if (async) {
            ExecutorWorkSerializer serializer = this.getInvalidationRunner();
            serializer.addWork((Runnable)((Object)new InvalidationRunnable(branch, lastUpdateTime, allChangedObjects, allDetachedObjects, oldRevisions, clearResourcePathCache)));
        } else {
            this.doInvalidate(branch, lastUpdateTime, allChangedObjects, allDetachedObjects, oldRevisions, clearResourcePathCache);
        }
    }

    protected synchronized void doInvalidate(CDOBranch branch, long lastUpdateTime, List<CDORevisionKey> allChangedObjects, List<CDOIDAndVersion> allDetachedObjects, Map<CDOID, InternalCDORevision> oldRevisions, boolean clearResourcePathCache) {
        if (this.getTimeStamp() != 0L && CDOStateMachine.SWITCHING_TARGET.get() != Boolean.TRUE) {
            return;
        }
        try {
            try {
                if (branch == this.getBranch()) {
                    if (clearResourcePathCache) {
                        this.clearResourcePathCacheIfNecessary(null);
                    }
                    ArrayList<CDORevisionDelta> deltas = new ArrayList<CDORevisionDelta>();
                    HashMap<CDOObject, CDORevisionDelta> revisionDeltas = new HashMap<CDOObject, CDORevisionDelta>();
                    HashSet<CDOObject> detachedObjects = new HashSet<CDOObject>();
                    Map<CDOObject, Pair<CDORevision, CDORevisionDelta>> conflicts = this.invalidate(allChangedObjects, allDetachedObjects, deltas, revisionDeltas, detachedObjects);
                    this.handleConflicts(lastUpdateTime, conflicts, deltas);
                    this.sendInvalidationNotifications(revisionDeltas.keySet(), detachedObjects);
                    this.fireInvalidationEvent(lastUpdateTime, Collections.unmodifiableMap(revisionDeltas), Collections.unmodifiableSet(detachedObjects));
                    if (!deltas.isEmpty() || !detachedObjects.isEmpty()) {
                        this.sendDeltaNotifications(deltas, detachedObjects, oldRevisions);
                    }
                    this.fireAdaptersNotifiedEvent(lastUpdateTime);
                }
            }
            catch (RuntimeException ex) {
                if (this.isActive()) {
                    this.fireEvent((IEvent)new ThrowableEvent((INotifier)this, (Throwable)ex));
                    throw ex;
                }
                this.setLastUpdateTime(lastUpdateTime);
            }
        }
        finally {
            this.setLastUpdateTime(lastUpdateTime);
        }
    }

    public ExecutorWorkSerializer getInvalidationRunner() {
        return this.invalidationRunner;
    }

    private ExecutorWorkSerializer createInvalidationRunner() {
        return new ExecutorWorkSerializer(){

            protected void noWork() {
                if (CDOViewImpl.this.isClosed()) {
                    this.dispose();
                }
            }
        };
    }

    @Override
    public boolean isInvalidationRunnerActive() {
        return this.invalidationRunnerActive;
    }

    private void sendInvalidationNotifications(Set<CDOObject> dirtyObjects, Set<CDOObject> detachedObjects) {
        if (this.options().isInvalidationNotificationEnabled()) {
            CDOInvalidationNotificationImpl notification;
            for (CDOObject dirtyObject : dirtyObjects) {
                if (!((InternalCDOObject)dirtyObject).eNotificationRequired()) continue;
                notification = new CDOInvalidationNotificationImpl(dirtyObject);
                dirtyObject.eNotify(notification);
            }
            for (CDOObject detachedObject : detachedObjects) {
                if (!((InternalCDOObject)detachedObject).eNotificationRequired()) continue;
                notification = new CDOInvalidationNotificationImpl(detachedObject);
                detachedObject.eNotify(notification);
            }
        }
    }

    private void fireInvalidationEvent(long timeStamp, Map<CDOObject, CDORevisionDelta> revisionDeltas, Set<CDOObject> detachedObjects) {
        IListener[] listeners;
        if (!(revisionDeltas.isEmpty() && detachedObjects.isEmpty() || (listeners = this.getListeners()) == null)) {
            this.fireEvent(new InvalidationEvent(timeStamp, revisionDeltas, detachedObjects), listeners);
        }
    }

    public synchronized void sendDeltaNotifications(Collection<CDORevisionDelta> deltas, Set<CDOObject> detachedObjects, Map<CDOID, InternalCDORevision> oldRevisions) {
        if (deltas != null) {
            CDONotificationBuilder builder = new CDONotificationBuilder(this);
            Map<CDOID, InternalCDOObject> objects = this.getModifiableObjects();
            for (CDORevisionDelta delta : deltas) {
                NotificationChain notification;
                CDOID id = delta.getID();
                InternalCDOObject object = objects.get(id);
                if (object == null || !object.eNotificationRequired()) continue;
                InternalCDORevision oldRevision = null;
                if (oldRevisions != null) {
                    oldRevision = oldRevisions.get(id);
                }
                if ((notification = builder.buildNotification(object, oldRevision, delta, detachedObjects)) == null) continue;
                notification.dispatch();
            }
        }
        if (detachedObjects != null && !detachedObjects.isEmpty()) {
            if (this.options().isDetachmentNotificationEnabled()) {
                for (CDOObject detachedObject : detachedObjects) {
                    InternalCDOObject object = (InternalCDOObject)detachedObject;
                    if (!object.eNotificationRequired()) continue;
                    new CDODeltaNotificationImpl((InternalEObject)object, 111, null, null, null).dispatch();
                }
            }
            this.getChangeSubscriptionManager().handleDetachedObjects(detachedObjects);
        }
    }

    private boolean isLocked(InternalCDOObject object) {
        if (object.cdoWriteLock().isLocked()) {
            return true;
        }
        return object.cdoReadLock().isLocked();
    }

    protected final AdapterManager getAdapterManager() {
        return this.adapterManager;
    }

    @Override
    public synchronized void handleAddAdapter(InternalCDOObject eObject, Adapter adapter) {
        if (!FSMUtil.isNew(eObject)) {
            this.subscribe(eObject, adapter);
        }
        this.adapterManager.attachAdapter(eObject, adapter);
    }

    @Override
    public synchronized void handleRemoveAdapter(InternalCDOObject eObject, Adapter adapter) {
        if (!FSMUtil.isNew(eObject)) {
            this.unsubscribe(eObject, adapter);
        }
        this.adapterManager.detachAdapter(eObject, adapter);
    }

    @Override
    public synchronized void subscribe(EObject eObject, Adapter adapter) {
        if (this.changeSubscriptionManager != null) {
            this.changeSubscriptionManager.subscribe(eObject, adapter);
        }
    }

    @Override
    public synchronized void unsubscribe(EObject eObject, Adapter adapter) {
        if (this.changeSubscriptionManager != null) {
            this.changeSubscriptionManager.unsubscribe(eObject, adapter);
        }
    }

    @Override
    public synchronized boolean hasSubscription(CDOID id) {
        if (this.changeSubscriptionManager != null) {
            return this.changeSubscriptionManager.getSubcribeObject(id) != null;
        }
        return false;
    }

    protected final ChangeSubscriptionManager getChangeSubscriptionManager() {
        return this.changeSubscriptionManager;
    }

    protected OptionsImpl createOptions() {
        return new OptionsImpl();
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.session, "session");
        this.checkState(this.viewID > 0, "viewID");
    }

    @Override
    protected void doActivate() throws Exception {
        super.doActivate();
        CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
        if (this.durableLockingID != null) {
            CDOBranchPoint branchPoint = sessionProtocol.openView(this.viewID, this.isReadOnly(), this.durableLockingID);
            this.basicSetBranchPoint(branchPoint);
        } else {
            sessionProtocol.openView(this.viewID, this.isReadOnly(), (CDOBranchPoint)this);
        }
        CDOViewRegistryImpl.INSTANCE.register(this);
        Runnable runnable = SessionUtil.getTestDelayInViewActivation();
        if (runnable != null) {
            runnable.run();
        }
        this.lockOwner = CDOLockUtil.createLockOwner((CDOCommonView)this);
    }

    protected void doAfterActivate() throws Exception {
        block2: {
            super.doAfterActivate();
            ExecutorService executorService = InternalConcurrencyUtil.getExecutorService((Object)this.session);
            this.invalidationRunner.setExecutor((Executor)executorService);
            try {
                LifecycleUtil.activate((Object)this.invalidationRunner);
            }
            catch (LifecycleException ex) {
                if (ex.getCause() instanceof InterruptedException) break block2;
                throw ex;
            }
        }
    }

    protected void doBeforeDeactivate() throws Exception {
        InternalCDOViewSet viewSet = this.getViewSet();
        viewSet.remove(this);
        super.doBeforeDeactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDeactivate() throws Exception {
        block29: {
            block28: {
                CDOViewRegistryImpl.INSTANCE.deregister(this);
                LifecycleUtil.deactivate((Object)this.invalidationRunner, (OMLogger.Level)OMLogger.Level.WARN);
                try {
                    try {
                        CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
                        if (LifecycleUtil.isActive((Object)sessionProtocol)) {
                            sessionProtocol.closeView(this.viewID);
                        }
                        break block28;
                    }
                    catch (Exception ex) {
                        OM.LOG.error((Throwable)ex);
                        Map<CDOObject, CDOLockState> map = this.lockStates;
                        synchronized (map) {
                            if (this.options.lockStatePrefetcher != null) {
                                this.options.lockStatePrefetcher.dispose();
                                this.options.lockStatePrefetcher = null;
                            }
                            if (this.session.isActive() && !this.lockStates.isEmpty()) {
                                ArrayList<CDOLockState> result = new ArrayList<CDOLockState>();
                                for (CDOLockState lockState : this.lockStates.values()) {
                                    if (!((InternalCDOLockState)lockState).removeOwner(this.lockOwner)) continue;
                                    result.add(lockState);
                                }
                                if (!result.isEmpty()) {
                                    CDOLockState[] deactivateLockStates = result.toArray(new CDOLockState[result.size()]);
                                    long timeStamp = this.session.getLastUpdateTime();
                                    this.notifyOtherViewsAboutLockChanges(CDOLockChangeInfo.Operation.UNLOCK, null, timeStamp, deactivateLockStates);
                                }
                                this.lockStates.clear();
                                this.lockOwner = null;
                            }
                            break block29;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Map<CDOObject, CDOLockState> map = this.lockStates;
                    synchronized (map) {
                        if (this.options.lockStatePrefetcher != null) {
                            this.options.lockStatePrefetcher.dispose();
                            this.options.lockStatePrefetcher = null;
                        }
                        if (this.session.isActive() && !this.lockStates.isEmpty()) {
                            ArrayList<CDOLockState> result = new ArrayList<CDOLockState>();
                            for (CDOLockState lockState : this.lockStates.values()) {
                                if (!((InternalCDOLockState)lockState).removeOwner(this.lockOwner)) continue;
                                result.add(lockState);
                            }
                            if (!result.isEmpty()) {
                                CDOLockState[] deactivateLockStates = result.toArray(new CDOLockState[result.size()]);
                                long timeStamp = this.session.getLastUpdateTime();
                                this.notifyOtherViewsAboutLockChanges(CDOLockChangeInfo.Operation.UNLOCK, null, timeStamp, deactivateLockStates);
                            }
                            this.lockStates.clear();
                            this.lockOwner = null;
                        }
                    }
                }
                throw throwable;
            }
            Map<CDOObject, CDOLockState> map = this.lockStates;
            synchronized (map) {
                if (this.options.lockStatePrefetcher != null) {
                    this.options.lockStatePrefetcher.dispose();
                    this.options.lockStatePrefetcher = null;
                }
                if (this.session.isActive() && !this.lockStates.isEmpty()) {
                    ArrayList<CDOLockState> result = new ArrayList<CDOLockState>();
                    for (CDOLockState lockState : this.lockStates.values()) {
                        if (!((InternalCDOLockState)lockState).removeOwner(this.lockOwner)) continue;
                        result.add(lockState);
                    }
                    if (!result.isEmpty()) {
                        CDOLockState[] deactivateLockStates = result.toArray(new CDOLockState[result.size()]);
                        long timeStamp = this.session.getLastUpdateTime();
                        this.notifyOtherViewsAboutLockChanges(CDOLockChangeInfo.Operation.UNLOCK, null, timeStamp, deactivateLockStates);
                    }
                    this.lockStates.clear();
                    this.lockOwner = null;
                }
            }
        }
        try {
            this.session.viewDetached(this);
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
        this.changeSubscriptionManager = null;
        super.doDeactivate();
    }

    @Override
    public synchronized long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public synchronized void setLastUpdateTime(long lastUpdateTime) {
        if (this.lastUpdateTime < lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }
        this.notifyAll();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean waitForUpdate(long updateTime, long timeoutMillis) {
        end = timeoutMillis == -1L ? 0x7FFFFFFFFFFFFFFFL : System.currentTimeMillis() + timeoutMillis;
        var7_4 = this;
        synchronized (var7_4) {
            while (true) lbl-1000:
            // 2 sources

            {
                if (this.lastUpdateTime < updateTime) ** break block8
                return true;
                break;
            }
            catch (Throwable v0) {
                throw v0;
            }
            {
                block9: {
                    now = System.currentTimeMillis();
                    if (now < end) break block9;
                    return false;
                }
                try {
                    waitMillis = end - now;
                    this.wait(waitMillis);
                    continue;
                }
                catch (InterruptedException ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
                ** while (true)
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean runAfterUpdate(final long updateTime, final Runnable runnable) {
        CDOViewImpl cDOViewImpl = this;
        synchronized (cDOViewImpl) {
            long lastUpdateTime = this.getLastUpdateTime();
            if (lastUpdateTime < updateTime) {
                this.addListener(new IListener(){

                    public void notifyEvent(IEvent event) {
                        CDOViewInvalidationEvent e;
                        if (event instanceof CDOViewInvalidationEvent && (e = (CDOViewInvalidationEvent)event).getTimeStamp() >= updateTime) {
                            CDOViewImpl.this.removeListener(this);
                            runnable.run();
                        }
                    }
                });
                return false;
            }
        }
        runnable.run();
        return true;
    }

    protected static Object getLockTarget(CDOObject object) {
        CDOView view = object.cdoView();
        if (view == null) {
            return null;
        }
        CDOID id = object.cdoID();
        boolean branching = view.getSession().getRepositoryInfo().isSupportingBranches();
        if (branching) {
            return CDOIDUtil.createIDAndBranch((CDOID)id, (CDOBranch)view.getBranch());
        }
        return id;
    }

    protected final class AdapterManager {
        private Set<CDOObject> objects = new HashBag();

        public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
            if (CDOViewImpl.this.options().getStrongReferencePolicy() != CDOAdapterPolicy.NONE) {
                for (CDOObject object : commitContext.getNewObjects().values()) {
                    this.attachObject(object);
                }
                for (CDOObject object : commitContext.getDetachedObjects().values()) {
                    this.detachObject(object);
                }
            }
        }

        private void attachObject(CDOObject object) {
            if (((InternalEObject)object).eNotificationRequired()) {
                CDOAdapterPolicy strongReferencePolicy = CDOViewImpl.this.options().getStrongReferencePolicy();
                int count = 0;
                for (Adapter adapter : object.eAdapters()) {
                    if (!strongReferencePolicy.isValid(object, adapter)) continue;
                    ++count;
                }
                int i = 0;
                while (i < count) {
                    this.objects.add(object);
                    ++i;
                }
            }
        }

        private void detachObject(CDOObject object) {
            while (this.objects.remove(object)) {
            }
        }

        private void attachAdapter(CDOObject object, Adapter adapter) {
            if (CDOViewImpl.this.options().getStrongReferencePolicy().isValid(object, adapter)) {
                this.objects.add(object);
            }
        }

        private void detachAdapter(CDOObject object, Adapter adapter) {
            if (CDOViewImpl.this.options().getStrongReferencePolicy().isValid(object, adapter)) {
                this.objects.remove(object);
            }
        }

        private void reset() {
            Set<CDOObject> oldObjects = this.objects;
            this.objects = new HashBag();
            if (CDOViewImpl.this.options().getStrongReferencePolicy() != CDOAdapterPolicy.NONE) {
                for (InternalCDOObject object : CDOViewImpl.this.getObjectsList()) {
                    this.attachObject(object);
                }
            }
            oldObjects.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class ChangeSubscriptionManager {
        private Map<CDOID, SubscribeEntry> subscriptions = CDOIDUtil.createMap();

        public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
            this.handleNewObjects(commitContext.getNewObjects().values());
            this.handleDetachedObjects(commitContext.getDetachedObjects().values());
        }

        private void subscribe(EObject eObject, Adapter adapter) {
            this.subscribe(eObject, adapter, 1);
        }

        private void unsubscribe(EObject eObject, Adapter adapter) {
            this.subscribe(eObject, adapter, -1);
        }

        private void notifyChangeSubcriptionPolicy() {
            boolean policiesPresent = CDOViewImpl.this.options().hasChangeSubscriptionPolicies();
            this.subscriptions.clear();
            ArrayList<CDOID> ids = new ArrayList<CDOID>();
            if (policiesPresent) {
                for (InternalCDOObject object : CDOViewImpl.this.getObjectsList()) {
                    int count = this.getNumberOfValidAdapters(object);
                    if (count <= 0) continue;
                    ids.add(object.cdoID());
                    this.addEntry(object.cdoID(), object, count);
                }
            }
            this.request(ids, true, true);
        }

        private void handleDetachedObjects(Collection<CDOObject> detachedObjects) {
            for (CDOObject detachedObject : detachedObjects) {
                CDOID id = detachedObject.cdoID();
                SubscribeEntry entry = this.subscriptions.get(id);
                if (entry == null) continue;
                this.detachObject(id);
            }
        }

        private void handleNewObjects(Collection<? extends CDOObject> newObjects) {
            for (CDOObject cDOObject : newObjects) {
                int count;
                InternalCDOObject cdoDetachedObject = (InternalCDOObject)cDOObject;
                if (cdoDetachedObject == null || (count = this.getNumberOfValidAdapters(cdoDetachedObject)) <= 0) continue;
                this.subscribe(cdoDetachedObject.cdoID(), cdoDetachedObject, count);
            }
        }

        private InternalCDOObject getSubcribeObject(CDOID id) {
            SubscribeEntry entry = this.subscriptions.get(id);
            if (entry != null) {
                return entry.getObject();
            }
            return null;
        }

        private void request(List<CDOID> ids, boolean clear, boolean subscribeMode) {
            CDOSessionProtocol sessionProtocol = CDOViewImpl.this.session.getSessionProtocol();
            sessionProtocol.changeSubscription(CDOViewImpl.this.getViewID(), ids, subscribeMode, clear);
        }

        private int getNumberOfValidAdapters(InternalCDOObject object) {
            int count = 0;
            if (!FSMUtil.isTransient(object) && !FSMUtil.isNew(object) && object.eNotificationRequired()) {
                EObject instance = CDOUtil.getEObject(object);
                for (Adapter adapter : instance.eAdapters()) {
                    if (!this.shouldSubscribe(object, adapter)) continue;
                    ++count;
                }
            }
            return count;
        }

        private void subscribe(EObject eObject, Adapter adapter, int adjust) {
            if (this.shouldSubscribe(eObject, adapter)) {
                CDOViewImpl view = CDOViewImpl.this;
                InternalCDOObject internalCDOObject = FSMUtil.adapt(eObject, view);
                if (internalCDOObject.cdoView() != view) {
                    throw new CDOException(MessageFormat.format(Messages.getString("CDOViewImpl.27"), internalCDOObject));
                }
                this.subscribe(internalCDOObject.cdoID(), internalCDOObject, adjust);
            }
        }

        private boolean shouldSubscribe(EObject eObject, Adapter adapter) {
            CDOAdapterPolicy[] cDOAdapterPolicyArray = CDOViewImpl.this.options().getChangeSubscriptionPolicies();
            int n = cDOAdapterPolicyArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOAdapterPolicy policy = cDOAdapterPolicyArray[n2];
                if (policy.isValid(eObject, adapter)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private void subscribe(CDOID id, InternalCDOObject cdoObject, int adjust) {
            boolean policiesPresent = CDOViewImpl.this.options().hasChangeSubscriptionPolicies();
            int count = 0;
            SubscribeEntry entry = this.subscriptions.get(id);
            if (entry == null) {
                if (adjust < 0) {
                    return;
                }
                if (policiesPresent) {
                    this.request(Collections.singletonList(id), false, true);
                }
            } else {
                count = entry.getCount();
            }
            if ((count += adjust) <= 0) {
                this.subscriptions.remove(id);
                if (policiesPresent) {
                    this.request(Collections.singletonList(id), false, false);
                }
            } else if (entry == null) {
                this.addEntry(id, cdoObject, count);
            } else {
                entry.setCount(count);
            }
        }

        private void detachObject(CDOID id) {
            this.subscribe(id, null, Integer.MIN_VALUE);
        }

        private void addEntry(CDOID key, InternalCDOObject object, int count) {
            this.subscriptions.put(key, new SubscribeEntry(object, count));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class InvalidationEvent
    extends AbstractCDOView.Event
    implements CDOViewInvalidationEvent {
        private static final long serialVersionUID = 1L;
        private long timeStamp;
        private Map<CDOObject, CDORevisionDelta> revisionDeltas;
        private Set<CDOObject> detachedObjects;

        public InvalidationEvent(long timeStamp, Map<CDOObject, CDORevisionDelta> revisionDeltas, Set<CDOObject> detachedObjects) {
            this.timeStamp = timeStamp;
            this.revisionDeltas = revisionDeltas;
            this.detachedObjects = detachedObjects;
        }

        @Override
        public long getTimeStamp() {
            return this.timeStamp;
        }

        @Override
        public Set<CDOObject> getDirtyObjects() {
            return this.revisionDeltas.keySet();
        }

        @Override
        public Map<CDOObject, CDORevisionDelta> getRevisionDeltas() {
            return this.revisionDeltas;
        }

        @Override
        public Set<CDOObject> getDetachedObjects() {
            return this.detachedObjects;
        }

        public String toString() {
            return "CDOViewInvalidationEvent: " + this.revisionDeltas;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class InvalidationRunnable
    extends RunnableWithName {
        private final CDOBranch branch;
        private final long lastUpdateTime;
        private final List<CDORevisionKey> allChangedObjects;
        private final List<CDOIDAndVersion> allDetachedObjects;
        private final Map<CDOID, InternalCDORevision> oldRevisions;
        private boolean clearResourcePathCache;

        private InvalidationRunnable(CDOBranch branch, long lastUpdateTime, List<CDORevisionKey> allChangedObjects, List<CDOIDAndVersion> allDetachedObjects, Map<CDOID, InternalCDORevision> oldRevisions, boolean clearResourcePathCache) {
            this.branch = branch;
            this.lastUpdateTime = lastUpdateTime;
            this.allChangedObjects = allChangedObjects;
            this.allDetachedObjects = allDetachedObjects;
            this.oldRevisions = oldRevisions;
            this.clearResourcePathCache = clearResourcePathCache;
        }

        public String getName() {
            return "CDOViewInvalidationRunner-" + CDOViewImpl.this;
        }

        protected void doRun() {
            try {
                try {
                    CDOViewImpl.this.invalidationRunnerActive = true;
                    CDOViewImpl.this.doInvalidate(this.branch, this.lastUpdateTime, this.allChangedObjects, this.allDetachedObjects, this.oldRevisions, this.clearResourcePathCache);
                }
                catch (Exception ex) {
                    if (CDOViewImpl.this.isActive()) {
                        OM.LOG.error((Throwable)ex);
                    }
                    CDOViewImpl.this.invalidationRunnerActive = false;
                }
            }
            finally {
                CDOViewImpl.this.invalidationRunnerActive = false;
            }
        }
    }

    private final class LockStatePrefetcher
    implements IListener {
        public LockStatePrefetcher() {
            CDOViewImpl.this.session.getRevisionManager().addListener((IListener)this);
        }

        public void notifyEvent(IEvent event) {
            if (event instanceof CDORevisionsLoadedEvent) {
                CDORevisionsLoadedEvent revisionsLoadedEvent = (CDORevisionsLoadedEvent)event;
                this.updateCDOViewObjectsCache(revisionsLoadedEvent);
            }
        }

        private void updateCDOViewObjectsCache(CDORevisionsLoadedEvent revisionsLoadedEvent) {
            HashSet<CDOID> ids = new HashSet<CDOID>();
            CDOLockStateLoadingPolicy lockStateLoadingPolicy = CDOViewImpl.this.options().getLockStateLoadingPolicy();
            for (CDORevision revision : revisionsLoadedEvent.getPrimaryLoadedRevisions()) {
                boolean isResourceNode;
                InternalCDOObject object;
                CDOID id;
                if (revision == null || (id = revision.getID()) == null || !lockStateLoadingPolicy.loadLockState(id) || (object = CDOViewImpl.this.getObject(id, !(isResourceNode = revision.isResourceNode()))) == null) continue;
                ids.add(id);
            }
            if (!ids.isEmpty()) {
                CDOSessionProtocol sessionProtocol = CDOViewImpl.this.session.getSessionProtocol();
                CDOLockState[] lockStates = sessionProtocol.getLockStates(CDOViewImpl.this.viewID, ids, revisionsLoadedEvent.getPrefetchDepth());
                this.updateLockStatesForAllViews(lockStates);
                ArrayList<CDOLockState> missingLockStates = new ArrayList<CDOLockState>();
                for (CDOID id : ids) {
                    InternalCDOObject object = CDOViewImpl.this.getObject(id, false);
                    if (object == null || CDOViewImpl.this.lockStates.get(object) != null) continue;
                    Object lockedObject = CDOViewImpl.getLockTarget(object);
                    missingLockStates.add(CDOLockUtil.createLockState((Object)lockedObject));
                }
                for (CDORevision revision : revisionsLoadedEvent.getAdditionalLoadedRevisions()) {
                    boolean isResourceNode;
                    InternalCDOObject object;
                    CDOID id = revision.getID();
                    if (id == null || !lockStateLoadingPolicy.loadLockState(id) || (object = CDOViewImpl.this.getObject(id, !(isResourceNode = revision.isResourceNode()))) == null || CDOViewImpl.this.lockStates.get(object) != null) continue;
                    Object lockedObject = CDOViewImpl.getLockTarget(object);
                    missingLockStates.add(CDOLockUtil.createLockState((Object)lockedObject));
                }
                this.updateLockStatesForAllViews(missingLockStates.toArray(new CDOLockState[missingLockStates.size()]));
            }
        }

        private void updateLockStatesForAllViews(CDOLockState[] lockStates) {
            CDOViewImpl.this.updateLockStates(lockStates);
            CDOView[] cDOViewArray = CDOViewImpl.this.getSession().getViews();
            int n = cDOViewArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOView view = cDOViewArray[n2];
                if (view != CDOViewImpl.this && view.getBranch() == CDOViewImpl.this.getBranch()) {
                    CDOViewImpl.this.updateLockStates(lockStates);
                }
                ++n2;
            }
        }

        public void dispose() {
            CDOViewImpl.this.session.getRevisionManager().removeListener((IListener)this);
        }
    }

    private final class LocksChangedEvent
    extends DefaultLocksChangedEvent
    implements CDOViewLocksChangedEvent {
        private static final long serialVersionUID = 1L;

        public LocksChangedEvent(InternalCDOView sender, CDOLockChangeInfo lockChangeInfo) {
            super((INotifier)CDOViewImpl.this, sender, lockChangeInfo);
        }

        public InternalCDOView getSource() {
            return (InternalCDOView)super.getSource();
        }

        public EObject[] getAffectedObjects() {
            ArrayList<EObject> objects = new ArrayList<EObject>();
            InternalCDOView view = this.getSource();
            CDOLockState[] lockStates = this.getLockStates();
            int i = 0;
            while (i < lockStates.length) {
                CDOObject object;
                CDOLockState lockState = lockStates[i];
                Object lockedObject = lockState.getLockedObject();
                CDOID id = null;
                if (lockedObject instanceof CDOIDAndBranch) {
                    CDOIDAndBranch idAndBranch = (CDOIDAndBranch)lockedObject;
                    if (idAndBranch.getBranch().getID() == view.getBranch().getID()) {
                        id = idAndBranch.getID();
                    }
                } else if (lockedObject instanceof CDOID) {
                    id = (CDOID)lockedObject;
                }
                if (id != null && (object = view.getObject(id, false)) != null) {
                    objects.add(CDOUtil.getEObject(object));
                }
                ++i;
            }
            return objects.toArray(new EObject[objects.size()]);
        }
    }

    public class OptionsImpl
    extends Notifier
    implements CDOView.Options {
        private boolean loadNotificationEnabled;
        private boolean detachmentNotificationEnabled;
        private boolean invalidationNotificationEnabled;
        private CDOInvalidationPolicy invalidationPolicy = CDOInvalidationPolicy.DEFAULT;
        private boolean lockNotificationsEnabled;
        private boolean lockStatePrefetchEnabled;
        private CDOLockStateLoadingPolicy lockStateLoadingPolicy = new CDODefaultLockStateLoadingPolicy();
        private LockStatePrefetcher lockStatePrefetcher;
        private CDORevisionPrefetchingPolicy revisionPrefetchingPolicy = CDOUtil.createRevisionPrefetchingPolicy(1);
        private CDOFeatureAnalyzer featureAnalyzer = CDOFeatureAnalyzer.NOOP;
        private CDOStaleReferencePolicy staleReferencePolicy = CDOStaleReferencePolicy.DEFAULT;
        private HashBag<CDOAdapterPolicy> changeSubscriptionPolicies = new HashBag();
        private CDOAdapterPolicy strongReferencePolicy = CDOAdapterPolicy.ALL;

        public CDOViewImpl getContainer() {
            return CDOViewImpl.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isLoadNotificationEnabled() {
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                return this.loadNotificationEnabled;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLoadNotificationEnabled(boolean enabled) {
            CDOViewImpl.this.checkActive();
            LoadNotificationEventImpl event = null;
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                if (this.loadNotificationEnabled != enabled) {
                    this.loadNotificationEnabled = enabled;
                    event = new LoadNotificationEventImpl();
                }
            }
            this.fireEvent((IEvent)event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDetachmentNotificationEnabled() {
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                return this.detachmentNotificationEnabled;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDetachmentNotificationEnabled(boolean enabled) {
            CDOViewImpl.this.checkActive();
            DetachmentNotificationEventImpl event = null;
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                if (this.detachmentNotificationEnabled != enabled) {
                    this.detachmentNotificationEnabled = enabled;
                    event = new DetachmentNotificationEventImpl();
                }
            }
            this.fireEvent((IEvent)event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isInvalidationNotificationEnabled() {
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                return this.invalidationNotificationEnabled;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setInvalidationNotificationEnabled(boolean enabled) {
            CDOViewImpl.this.checkActive();
            InvalidationNotificationEventImpl event = null;
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                if (this.invalidationNotificationEnabled != enabled) {
                    this.invalidationNotificationEnabled = enabled;
                    event = new InvalidationNotificationEventImpl();
                }
            }
            this.fireEvent((IEvent)event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CDOInvalidationPolicy getInvalidationPolicy() {
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                return this.invalidationPolicy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setInvalidationPolicy(CDOInvalidationPolicy policy) {
            CDOViewImpl.this.checkActive();
            InvalidationPolicyEventImpl event = null;
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                if (this.invalidationPolicy != policy) {
                    this.invalidationPolicy = policy;
                    event = new InvalidationPolicyEventImpl();
                }
            }
            this.fireEvent((IEvent)event);
        }

        public boolean isLockNotificationEnabled() {
            return this.lockNotificationsEnabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLockNotificationEnabled(boolean enabled) {
            CDOViewImpl.this.checkActive();
            LockNotificationEventImpl event = null;
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                if (enabled != this.lockNotificationsEnabled) {
                    CDOSessionProtocol protocol = CDOViewImpl.this.session.getSessionProtocol();
                    protocol.enableLockNotifications(CDOViewImpl.this.viewID, enabled);
                    this.lockNotificationsEnabled = enabled;
                    event = new LockNotificationEventImpl(enabled);
                }
            }
            this.fireEvent((IEvent)event);
        }

        public boolean isLockStatePrefetchEnabled() {
            return this.lockStatePrefetchEnabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLockStatePrefetchEnabled(boolean enabled) {
            CDOViewImpl.this.checkActive();
            LockStatePrefetchEventImpl event = null;
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                if (enabled != this.lockStatePrefetchEnabled) {
                    this.lockStatePrefetchEnabled = enabled;
                    if (enabled) {
                        this.lockStatePrefetcher = new LockStatePrefetcher();
                    } else {
                        this.lockStatePrefetcher.dispose();
                        this.lockStatePrefetcher = null;
                    }
                    event = new LockStatePrefetchEventImpl();
                }
            }
            this.fireEvent((IEvent)event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CDOLockStateLoadingPolicy getLockStateLoadingPolicy() {
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                return this.lockStateLoadingPolicy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLockStateLoadingPolicy(CDOLockStateLoadingPolicy lockStateLoadingPolicy) {
            CDOViewImpl.this.checkActive();
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                this.lockStateLoadingPolicy = lockStateLoadingPolicy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasChangeSubscriptionPolicies() {
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                return !this.changeSubscriptionPolicies.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CDOAdapterPolicy[] getChangeSubscriptionPolicies() {
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                return (CDOAdapterPolicy[])this.changeSubscriptionPolicies.toArray((Object[])new CDOAdapterPolicy[this.changeSubscriptionPolicies.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeSubscriptionPolicy(CDOAdapterPolicy policy) {
            CDOViewImpl.this.checkActive();
            ChangeSubscriptionPoliciesEventImpl event = null;
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                if (this.changeSubscriptionPolicies.add((Object)policy)) {
                    CDOViewImpl.this.changeSubscriptionManager.notifyChangeSubcriptionPolicy();
                    event = new ChangeSubscriptionPoliciesEventImpl();
                }
            }
            this.fireEvent((IEvent)event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeSubscriptionPolicy(CDOAdapterPolicy policy) {
            CDOViewImpl.this.checkActive();
            ChangeSubscriptionPoliciesEventImpl event = null;
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                if (this.changeSubscriptionPolicies.remove((Object)policy) && !this.changeSubscriptionPolicies.contains((Object)policy)) {
                    CDOViewImpl.this.changeSubscriptionManager.notifyChangeSubcriptionPolicy();
                    event = new ChangeSubscriptionPoliciesEventImpl();
                }
            }
            this.fireEvent((IEvent)event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CDOAdapterPolicy getStrongReferencePolicy() {
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                return this.strongReferencePolicy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setStrongReferencePolicy(CDOAdapterPolicy adapterPolicy) {
            CDOViewImpl.this.checkActive();
            if (adapterPolicy == null) {
                adapterPolicy = CDOAdapterPolicy.ALL;
            }
            ReferencePolicyEventImpl event = null;
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                if (this.strongReferencePolicy != adapterPolicy) {
                    this.strongReferencePolicy = adapterPolicy;
                    CDOViewImpl.this.adapterManager.reset();
                    event = new ReferencePolicyEventImpl();
                }
            }
            this.fireEvent((IEvent)event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CDORevisionPrefetchingPolicy getRevisionPrefetchingPolicy() {
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                return this.revisionPrefetchingPolicy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRevisionPrefetchingPolicy(CDORevisionPrefetchingPolicy prefetchingPolicy) {
            CDOViewImpl.this.checkActive();
            if (prefetchingPolicy == null) {
                prefetchingPolicy = CDORevisionPrefetchingPolicy.NO_PREFETCHING;
            }
            RevisionPrefetchingPolicyEventImpl event = null;
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                if (this.revisionPrefetchingPolicy != prefetchingPolicy) {
                    this.revisionPrefetchingPolicy = prefetchingPolicy;
                    event = new RevisionPrefetchingPolicyEventImpl();
                }
            }
            this.fireEvent((IEvent)event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CDOFeatureAnalyzer getFeatureAnalyzer() {
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                return this.featureAnalyzer;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setFeatureAnalyzer(CDOFeatureAnalyzer featureAnalyzer) {
            CDOViewImpl.this.checkActive();
            if (featureAnalyzer == null) {
                featureAnalyzer = CDOFeatureAnalyzer.NOOP;
            }
            FeatureAnalyzerEventImpl event = null;
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                if (this.featureAnalyzer != featureAnalyzer) {
                    this.featureAnalyzer = featureAnalyzer;
                    event = new FeatureAnalyzerEventImpl();
                }
            }
            this.fireEvent((IEvent)event);
        }

        @Deprecated
        public CDOStaleReferencePolicy getStaleReferenceBehaviour() {
            return this.getStaleReferencePolicy();
        }

        @Deprecated
        public void setStaleReferenceBehaviour(CDOStaleReferencePolicy policy) {
            this.setStaleReferencePolicy(policy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CDOStaleReferencePolicy getStaleReferencePolicy() {
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                return this.staleReferencePolicy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setStaleReferencePolicy(CDOStaleReferencePolicy policy) {
            CDOViewImpl.this.checkActive();
            if (policy == null) {
                policy = CDOStaleReferencePolicy.DEFAULT;
            }
            StaleReferencePolicyEventImpl event = null;
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                if (this.staleReferencePolicy != policy) {
                    this.staleReferencePolicy = policy;
                    event = new StaleReferencePolicyEventImpl();
                }
            }
            this.fireEvent((IEvent)event);
        }

        public ReferenceType getCacheReferenceType() {
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                Map<CDOID, InternalCDOObject> objects = CDOViewImpl.this.getModifiableObjects();
                if (objects instanceof ReferenceValueMap.Strong) {
                    return ReferenceType.STRONG;
                }
                if (objects instanceof ReferenceValueMap.Soft) {
                    return ReferenceType.SOFT;
                }
                if (objects instanceof ReferenceValueMap.Weak) {
                    return ReferenceType.WEAK;
                }
                throw new IllegalStateException(Messages.getString("CDOViewImpl.29"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean setCacheReferenceType(ReferenceType referenceType) {
            CDOViewImpl.this.checkActive();
            if (referenceType == null) {
                referenceType = ReferenceType.SOFT;
            }
            CDOViewImpl cDOViewImpl = CDOViewImpl.this;
            synchronized (cDOViewImpl) {
                if (!CDOViewImpl.this.initObjectsMap(referenceType)) {
                    return false;
                }
            }
            IListener[] listeners = this.getListeners();
            if (listeners != null) {
                this.fireEvent((IEvent)new CacheReferenceTypeEventImpl(), listeners);
            }
            return true;
        }

        private final class CacheReferenceTypeEventImpl
        extends OptionsEvent
        implements CDOView.Options.CacheReferenceTypeEvent {
            private static final long serialVersionUID = 1L;

            public CacheReferenceTypeEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class ChangeSubscriptionPoliciesEventImpl
        extends OptionsEvent
        implements CDOView.Options.ChangeSubscriptionPoliciesEvent {
            private static final long serialVersionUID = 1L;

            public ChangeSubscriptionPoliciesEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class DetachmentNotificationEventImpl
        extends OptionsEvent
        implements CDOView.Options.DetachmentNotificationEvent {
            private static final long serialVersionUID = 1L;

            public DetachmentNotificationEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class FeatureAnalyzerEventImpl
        extends OptionsEvent
        implements CDOView.Options.FeatureAnalyzerEvent {
            private static final long serialVersionUID = 1L;

            public FeatureAnalyzerEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class InvalidationNotificationEventImpl
        extends OptionsEvent
        implements CDOView.Options.InvalidationNotificationEvent {
            private static final long serialVersionUID = 1L;

            public InvalidationNotificationEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class InvalidationPolicyEventImpl
        extends OptionsEvent
        implements CDOView.Options.InvalidationPolicyEvent {
            private static final long serialVersionUID = 1L;

            public InvalidationPolicyEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class LoadNotificationEventImpl
        extends OptionsEvent
        implements CDOView.Options.LoadNotificationEvent {
            private static final long serialVersionUID = 1L;

            public LoadNotificationEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class LockNotificationEventImpl
        extends OptionsEvent
        implements CDOCommonView.Options.LockNotificationEvent {
            private static final long serialVersionUID = 1L;
            private boolean enabled;

            public LockNotificationEventImpl(boolean enabled) {
                super((IOptions)OptionsImpl.this);
                this.enabled = enabled;
            }

            public boolean getEnabled() {
                return this.enabled;
            }
        }

        private final class LockStatePrefetchEventImpl
        extends OptionsEvent {
            private static final long serialVersionUID = 1L;

            public LockStatePrefetchEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class ReferencePolicyEventImpl
        extends OptionsEvent
        implements CDOView.Options.ReferencePolicyEvent {
            private static final long serialVersionUID = 1L;

            public ReferencePolicyEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class RevisionPrefetchingPolicyEventImpl
        extends OptionsEvent
        implements CDOView.Options.RevisionPrefetchingPolicyEvent {
            private static final long serialVersionUID = 1L;

            public RevisionPrefetchingPolicyEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class StaleReferencePolicyEventImpl
        extends OptionsEvent
        implements CDOView.Options.StaleReferencePolicyEvent {
            private static final long serialVersionUID = 1L;

            public StaleReferencePolicyEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }
    }

    private static final class SubscribeEntry {
        private InternalCDOObject object;
        private int count;

        public SubscribeEntry(InternalCDOObject object, int count) {
            this.object = object;
            this.count = count;
        }

        public InternalCDOObject getObject() {
            return this.object;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }
}

