/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.findrefs;

import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.findReferences.ReferenceFinder;
import org.eclipse.xtext.findReferences.TargetURIs;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

public class XcoreReferenceFinder
extends ReferenceFinder {
    protected void findLocalReferencesFromElement(TargetURIs targetURIs, EObject sourceCandidate, Resource localResource, IReferenceFinder.Acceptor acceptor) {
        super.findLocalReferencesFromElement(targetURIs, sourceCandidate, localResource, (IReferenceFinder.Acceptor)new DuplicateFilter(acceptor));
    }

    protected void findReferencesInDescription(TargetURIs targetURIs, IResourceDescription resourceDescription, IReferenceFinder.IResourceAccess resourceAccess, IReferenceFinder.Acceptor acceptor, IProgressMonitor monitor) {
        super.findReferencesInDescription(targetURIs, resourceDescription, resourceAccess, (IReferenceFinder.Acceptor)new DuplicateFilter(acceptor), monitor);
    }

    private static class DuplicateFilter
    implements IReferenceFinder.Acceptor {
        private IReferenceFinder.Acceptor delegate;
        final Set<Pair<URI, EReference>> sourceURIEReferencePairs = Sets.newHashSet();

        public DuplicateFilter(IReferenceFinder.Acceptor delegate) {
            this.delegate = delegate;
        }

        public void accept(EObject source, URI sourceURI, EReference eReference, int index, EObject targetOrProxy, URI targetURI) {
            if (this.sourceURIEReferencePairs.add((Pair<URI, EReference>)Tuples.pair((Object)sourceURI, (Object)eReference))) {
                this.delegate.accept(source, sourceURI, eReference, index, targetOrProxy, targetURI);
            }
        }

        public void accept(IReferenceDescription description) {
            if (this.sourceURIEReferencePairs.add((Pair<URI, EReference>)Tuples.pair((Object)description.getSourceEObjectUri(), (Object)description.getEReference()))) {
                this.delegate.accept(description);
            }
        }
    }
}

