/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.properties;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.eef.runtime.api.component.IPropertiesEditionComponent;
import org.eclipse.emf.eef.runtime.context.ExtendedPropertiesEditingContext;
import org.eclipse.emf.eef.runtime.ui.parts.ViewHelper;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BindingViewHelper
implements ViewHelper {
    private static final String EMPTY_STRING = "";
    public static final String DLG_IMG_HELP = "dialog_help_image";
    private ExtendedPropertiesEditingContext context;
    private FormToolkit toolkit;

    public BindingViewHelper(ExtendedPropertiesEditingContext context) {
        this.context = context;
        this.toolkit = null;
    }

    public BindingViewHelper(ExtendedPropertiesEditingContext context, FormToolkit toolkit) {
        this.context = context;
        this.toolkit = toolkit;
    }

    public Label createLabel(Composite parent, Object editor, String alternate) {
        Label label;
        IPropertiesEditionComponent propertiesEditingComponent = this.context.getPropertiesEditingComponent();
        String text = this.getDescription(editor, alternate);
        if (!text.endsWith(": ") && !text.endsWith(":")) {
            text = String.valueOf(text) + ": ";
        }
        if (this.toolkit != null) {
            label = this.toolkit.createLabel(parent, text);
        } else {
            label = new Label(parent, 0);
            label.setText(text);
        }
        if (propertiesEditingComponent != null && propertiesEditingComponent.isRequired(editor, this.toolkit == null ? 0 : 1)) {
            label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        }
        return label;
    }

    public String getDescription(Object editor, String alternate) {
        IItemPropertyDescriptor propertyDescriptor;
        IItemPropertySource labelProvider;
        IPropertiesEditionComponent propertiesEditingComponent = this.context.getPropertiesEditingComponent();
        String text = alternate;
        EStructuralFeature associatedFeature = propertiesEditingComponent.associatedFeature(editor);
        if (associatedFeature != null && (labelProvider = (IItemPropertySource)this.context.getAdapterFactory().adapt((Notifier)this.context.getEObject(), IItemPropertySource.class)) != null && (propertyDescriptor = labelProvider.getPropertyDescriptor((Object)this.context.getEObject(), (Object)associatedFeature)) != null) {
            text = propertyDescriptor.getDisplayName(editor);
        }
        return text;
    }

    public Control createHelpButton(Composite parent, Object feature) {
        Object helpID = null;
        String alternate = this.context.getPropertiesEditingComponent().getHelpContent(feature, this.toolkit == null ? 0 : 1);
        Image image = JFaceResources.getImage((String)DLG_IMG_HELP);
        if (helpID != null && !EMPTY_STRING.equals(helpID)) {
            ToolBar result = new ToolBar(parent, 0x880000);
            ++((GridLayout)parent.getLayout()).numColumns;
            result.setLayoutData((Object)new GridData(64));
            ToolItem item = new ToolItem(result, 0);
            item.setImage(image);
            if (alternate != null && !EMPTY_STRING.equals(alternate)) {
                item.setToolTipText(alternate);
            }
            return result;
        }
        Label result = null;
        result = this.toolkit != null ? this.toolkit.createLabel(parent, EMPTY_STRING) : new Label(parent, 0);
        if (alternate != null && !EMPTY_STRING.equals(alternate)) {
            result.setImage(image);
            result.setToolTipText(alternate);
        }
        return result;
    }
}

