/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EOppositeSetUnset
implements ModelChangeTrigger {
    private Session session;
    public static final NotificationFilter SHOULD_UPDATE = new NotificationFilter.Custom(){

        public boolean matches(Notification notification) {
            if (!notification.isTouch() && notification.getFeature() == EcorePackage.eINSTANCE.getEReference_EOpposite() && notification.getNotifier() instanceof EReference) {
                return ((EReference)notification.getNotifier()).getEOpposite() != null;
            }
            return false;
        }
    };

    public EOppositeSetUnset(Session set) {
        this.session = set;
    }

    public Option<Command> localChangesAboutToCommit(Collection<Notification> notifications) {
        final ArrayList toBeCleared = Lists.newArrayList();
        final ArrayList toBeSet = Lists.newArrayList();
        for (Notification notif : notifications) {
            if (!SHOULD_UPDATE.matches(notif)) continue;
            EReference updatedRef = (EReference)notif.getNotifier();
            if (notif.getEventType() == 1) {
                toBeSet.add(updatedRef);
            }
            if (notif.getEventType() != 2) continue;
            toBeCleared.add(updatedRef);
        }
        if (toBeCleared.size() > 0 || toBeSet.size() > 0) {
            RecordingCommand result = new RecordingCommand(this.session.getTransactionalEditingDomain()){

                protected void doExecute() {
                    for (EReference toClear : toBeCleared) {
                        if (toClear.getEOpposite() == null) continue;
                        toClear.getEOpposite().setEOpposite(null);
                    }
                    for (EReference toSet : toBeSet) {
                        if (toSet.getEOpposite() == null) continue;
                        toSet.getEOpposite().setEOpposite(toSet);
                    }
                }
            };
            return Options.newSome((Object)result);
        }
        return Options.newNone();
    }

    public int priority() {
        return 1;
    }
}

