/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.controls;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EEnumImpl;
import org.eclipse.emf.ecp.view.internal.editor.controls.Activator;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.provider.ECPTooltipModifierHelper;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public abstract class ExpectedValueControlRenderer
extends SimpleControlSWTControlSWTRenderer {
    private static final EMFFormsDatabinding EMFFORMS_DATABINDING;
    private static final EMFFormsLabelProvider EMFFORMS_LABELPROVIDER;
    private static final VTViewTemplateProvider VIEW_TEMPLATE_PROVIDER;
    private Label text;

    static {
        BundleContext bundleContext = FrameworkUtil.getBundle(ExpectedValueControlRenderer.class).getBundleContext();
        ServiceReference emfFormsDatabindingServiceReference = bundleContext.getServiceReference(EMFFormsDatabinding.class);
        EMFFORMS_DATABINDING = (EMFFormsDatabinding)bundleContext.getService(emfFormsDatabindingServiceReference);
        ServiceReference emfFormsLabelProviderServiceReference = bundleContext.getServiceReference(EMFFormsLabelProvider.class);
        EMFFORMS_LABELPROVIDER = (EMFFormsLabelProvider)bundleContext.getService(emfFormsLabelProviderServiceReference);
        ServiceReference vtViewTemplateProviderServiceReference = bundleContext.getServiceReference(VTViewTemplateProvider.class);
        VIEW_TEMPLATE_PROVIDER = (VTViewTemplateProvider)bundleContext.getService(vtViewTemplateProviderServiceReference);
    }

    public ExpectedValueControlRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService) {
        super(vElement, viewContext, reportService, EMFFORMS_DATABINDING, EMFFORMS_LABELPROVIDER, VIEW_TEMPLATE_PROVIDER);
    }

    private String getTextVariantID() {
        return "org_eclipse_emf_ecp_view_editor_controls_ruleattribute";
    }

    protected Control createSWTControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)composite);
        Button bSelectObject = new Button(composite, 8);
        bSelectObject.setText("Select Object");
        this.text = new Label(composite, 2052);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        this.text.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getTextVariantID());
        bSelectObject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ExpectedValueControlRenderer.this.onSelectButton(ExpectedValueControlRenderer.this.text);
            }
        });
        return this.text;
    }

    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        Label text = (Label)control;
        TargetToModelUpdateStrategy targetToModelUpdateStrategy = new TargetToModelUpdateStrategy();
        ModelToTargetUpdateStrategy modelToTargetUpdateStrategy = new ModelToTargetUpdateStrategy();
        ISWTObservableValue value = SWTObservables.observeText((Control)text);
        Binding binding = this.getDataBindingContext().bindValue((IObservableValue)value, this.getModelValue(), (UpdateValueStrategy)targetToModelUpdateStrategy, (UpdateValueStrategy)modelToTargetUpdateStrategy);
        return new Binding[]{binding};
    }

    protected Binding createTooltipBinding(Control text, IObservableValue modelValue, DataBindingContext dataBindingContext, UpdateValueStrategy targetToModel, UpdateValueStrategy modelToTarget) {
        ISWTObservableValue toolTip = SWTObservables.observeTooltipText((Control)text);
        return dataBindingContext.bindValue((IObservableValue)toolTip, modelValue, targetToModel, modelToTarget);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object getSelectedObject(EAttribute attribute) {
        String object = null;
        Class attribuetClazz = attribute.getEAttributeType().getInstanceClass();
        if (attribuetClazz == null) {
            if (!EcorePackage.eINSTANCE.getEEnum().isInstance((Object)attribute.getEType())) return null;
            attribuetClazz = Enum.class;
            EList eLiterals = ((EEnumImpl)EEnumImpl.class.cast(attribute.getEType())).getELiterals();
            Object[] enumValues = eLiterals.toArray();
            ListDialog ld = new ListDialog(this.text.getShell());
            ld.setLabelProvider((ILabelProvider)new LabelProvider());
            ld.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
            ld.setInput((Object)enumValues);
            ld.setInitialSelections(new Object[]{enumValues[0]});
            ld.setMessage("Please select the enum value to set.");
            ld.setTitle("Select a value");
            int enumSelectionResult = ld.open();
            if (enumSelectionResult != 0) return object;
            return ((EEnumLiteral)EEnumLiteral.class.cast(ld.getResult()[0])).getLiteral();
        }
        if (attribuetClazz.isPrimitive()) {
            if (Integer.TYPE.isAssignableFrom(attribuetClazz)) {
                attribuetClazz = Integer.class;
            } else if (Long.TYPE.isAssignableFrom(attribuetClazz)) {
                attribuetClazz = Long.class;
            } else if (Float.TYPE.isAssignableFrom(attribuetClazz)) {
                attribuetClazz = Float.class;
            } else if (Double.TYPE.isAssignableFrom(attribuetClazz)) {
                attribuetClazz = Double.class;
            } else if (Boolean.TYPE.isAssignableFrom(attribuetClazz)) {
                attribuetClazz = Boolean.class;
            } else if (Character.TYPE.isAssignableFrom(attribuetClazz)) {
                attribuetClazz = Character.class;
            }
        }
        if (Enum.class.isAssignableFrom(attribuetClazz)) {
            T[] enumValues = attribuetClazz.getEnumConstants();
            ListDialog ld = new ListDialog(this.text.getShell());
            ld.setLabelProvider((ILabelProvider)new LabelProvider());
            ld.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
            ld.setInput(enumValues);
            ld.setInitialSelections(new Object[]{enumValues[0]});
            ld.setMessage("Please select the enum value to set.");
            ld.setTitle("Select a value");
            int enumSelectionResult = ld.open();
            if (enumSelectionResult != 0) return object;
            return ((Enumerator)Enumerator.class.cast(ld.getResult()[0])).getLiteral();
        }
        if (String.class.isAssignableFrom(attribuetClazz) || Number.class.isAssignableFrom(attribuetClazz) || Boolean.class.isAssignableFrom(attribuetClazz)) {
            try {
                Constructor constructor = attribuetClazz.getConstructor(String.class);
                InputDialog id = new InputDialog(this.text.getShell(), "Insert the value", "The value must be parseable by the " + attribuetClazz.getSimpleName() + " class. For a double value please use the #.# format. For boolean values 'true' or 'false'.", null, null);
                int inputResult = id.open();
                if (inputResult == 0) {
                    object = (String)constructor.newInstance(id.getValue());
                }
                if (!Boolean.class.isAssignableFrom(attribuetClazz)) return object;
                if ((Boolean)Boolean.class.cast(object) != false) return object;
                if ("false".equalsIgnoreCase(id.getValue())) return object;
                MessageDialog.openError((Shell)this.text.getShell(), (String)"Invalid boolean value", (String)"You have entered an invalid value. False has been chosen instead.");
                return object;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.openInvalidValueMessage();
                return object;
            }
            catch (SecurityException securityException) {
                this.openInvalidValueMessage();
                return object;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.openInvalidValueMessage();
                return object;
            }
            catch (InstantiationException instantiationException) {
                this.openInvalidValueMessage();
                return object;
            }
            catch (IllegalAccessException illegalAccessException) {
                this.openInvalidValueMessage();
                return object;
            }
            catch (InvocationTargetException invocationTargetException) {
                this.openInvalidValueMessage();
            }
            return object;
        } else {
            MessageDialog.openError((Shell)this.text.getShell(), (String)"Not primitive Attribute selected", (String)"The selected attribute has a not primitive type. We can't provide you support for it!");
        }
        return object;
    }

    private void openInvalidValueMessage() {
        MessageDialog.openError((Shell)this.text.getShell(), (String)"Invalid value", (String)"You have entered an invalid value. The previsous value will be kept.");
    }

    protected abstract void onSelectButton(Label var1);

    protected EObject getObservedEObject() throws DatabindingFailedException {
        IObservableValue observableValue = Activator.getDefault().getEMFFormsDatabinding().getObservableValue(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
        EObject result = (EObject)((IObserving)observableValue).getObserved();
        observableValue.dispose();
        return result;
    }

    protected String getUnsetText() {
        return null;
    }

    protected class ModelToTargetUpdateStrategy
    extends EMFUpdateValueStrategy {
        protected ModelToTargetUpdateStrategy() {
        }

        public Object convert(Object value) {
            String converted = value.toString();
            if (String.class.isInstance(converted)) {
                IObservableValue observableValue;
                try {
                    observableValue = EMFFORMS_DATABINDING.getObservableValue(((VControl)ExpectedValueControlRenderer.this.getVElement()).getDomainModelReference(), ExpectedValueControlRenderer.this.getViewModelContext().getDomainModel());
                }
                catch (DatabindingFailedException ex) {
                    ExpectedValueControlRenderer.this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                    return converted;
                }
                InternalEObject internalEObject = (InternalEObject)((IObserving)observableValue).getObserved();
                EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
                observableValue.dispose();
                return ECPTooltipModifierHelper.modifyString((String)((String)String.class.cast(converted)), (EStructuralFeature.Setting)internalEObject.eSetting(structuralFeature));
            }
            return converted;
        }
    }

    protected class TargetToModelUpdateStrategy
    extends EMFUpdateValueStrategy {
        public Object convert(Object value) {
            return value;
        }
    }
}

