/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.table.internal.validation;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.spi.UniqueSetting;
import org.eclipse.emf.ecp.view.spi.context.GlobalViewModelService;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.model.util.ViewModelPropertiesHelper;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emf.ecp.view.spi.table.model.DetailEditing;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emf.ecp.view.table.internal.validation.Activator;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;

public class TableValidationInitiator
implements GlobalViewModelService {
    private final Map<UniqueSetting, TableContextMapping> mapping = new LinkedHashMap<UniqueSetting, TableContextMapping>();
    private ViewModelContext context;

    public void instantiate(ViewModelContext context) {
        this.context = context;
        context.registerDomainChangeListener(new ModelChangeListener(){

            public void notifyChange(ModelChangeNotification notification) {
                if (notification.getRawNotification().isTouch() || TableValidationInitiator.this.mapping.isEmpty()) {
                    return;
                }
                TableContextMapping tableContextMapping = (TableContextMapping)TableValidationInitiator.this.mapping.get(UniqueSetting.createSetting((EObject)notification.getNotifier(), (EStructuralFeature)notification.getStructuralFeature()));
                if (tableContextMapping == null) {
                    return;
                }
                for (EObject newValue : notification.getNewEObjects()) {
                    try {
                        tableContextMapping.context.getChildContext(newValue, (VElement)tableContextMapping.control, TableValidationInitiator.this.getView(tableContextMapping.control), new ViewModelService[0]);
                    }
                    catch (DatabindingFailedException ex) {
                        Activator.getDefault().getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                    }
                }
            }
        });
        this.checkForTables(context);
    }

    private void checkForTables(ViewModelContext context) {
        VElement viewRoot = context.getViewModel();
        TreeIterator eAllContents = viewRoot.eAllContents();
        while (eAllContents.hasNext()) {
            IObservableValue observableValue;
            VTableControl tableControl;
            EObject eObject = (EObject)eAllContents.next();
            if (!VTableControl.class.isInstance(eObject) || !this.isCorrectContainer(tableControl = (VTableControl)VTableControl.class.cast(eObject), (EObject)viewRoot) || tableControl.getDetailEditing() != DetailEditing.WITH_PANEL) continue;
            VTableDomainModelReference tableDomainModelReference = (VTableDomainModelReference)tableControl.getDomainModelReference();
            try {
                observableValue = tableDomainModelReference.getDomainModelReference() != null ? Activator.getDefault().getEMFFormsDatabinding().getObservableValue(tableDomainModelReference.getDomainModelReference(), context.getDomainModel()) : Activator.getDefault().getEMFFormsDatabinding().getObservableValue((VDomainModelReference)tableDomainModelReference, context.getDomainModel());
            }
            catch (DatabindingFailedException ex) {
                Activator.getDefault().getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                continue;
            }
            IObserving observing = (IObserving)observableValue;
            EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
            EObject observed = (EObject)observing.getObserved();
            observableValue.dispose();
            this.mapping.put(UniqueSetting.createSetting((EObject)observed, (EStructuralFeature)structuralFeature), new TableContextMapping(tableControl, context));
            EList tableContents = (EList)observed.eGet(structuralFeature, true);
            for (EObject tableEObject : tableContents) {
                try {
                    VView detailView = this.getView(tableControl);
                    ViewModelContext childContext = context.getChildContext(tableEObject, (VElement)tableControl, detailView, new ViewModelService[0]);
                    childContext.addContextUser((Object)this);
                }
                catch (DatabindingFailedException ex) {
                    Activator.getDefault().getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                }
            }
        }
    }

    private boolean isCorrectContainer(VTableControl tableControl, EObject root) {
        EObject current = tableControl.eContainer();
        while (!VView.class.isInstance(current) && current != root) {
            current = current.eContainer();
        }
        return current == root;
    }

    private VView getView(VTableControl tableControl) throws DatabindingFailedException {
        VView detailView = tableControl.getDetailView();
        if (detailView == null) {
            VTableDomainModelReference tableDomainModelReference = (VTableDomainModelReference)tableControl.getDomainModelReference();
            IValueProperty valueProperty = tableDomainModelReference.getDomainModelReference() != null ? Activator.getDefault().getEMFFormsDatabinding().getValueProperty(tableDomainModelReference.getDomainModelReference(), this.context.getDomainModel()) : Activator.getDefault().getEMFFormsDatabinding().getValueProperty((VDomainModelReference)tableDomainModelReference, this.context.getDomainModel());
            EReference reference = (EReference)valueProperty.getValueType();
            VElement viewModel = this.context.getViewModel();
            VViewModelProperties properties = ViewModelPropertiesHelper.getInhertitedPropertiesOrEmpty((VElement)viewModel);
            detailView = ViewProviderHelper.getView((EObject)EcoreUtil.create((EClass)reference.getEReferenceType()), (VViewModelProperties)properties);
        }
        return detailView;
    }

    public void dispose() {
    }

    public int getPriority() {
        return 2;
    }

    public void childViewModelContextAdded(ViewModelContext childContext) {
        this.checkForTables(childContext);
    }

    private static class TableContextMapping {
        private final VTableControl control;
        private final ViewModelContext context;

        public TableContextMapping(VTableControl control, ViewModelContext context) {
            this.control = control;
            this.context = context;
        }
    }
}

