/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ui.model.ModelPackage;
import org.eclipse.epp.internal.logging.aeri.ui.model.Settings;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Browsers;
import org.eclipse.epp.internal.logging.aeri.ui.v2.ServerConfiguration;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ConfigurationDialog
extends TitleAreaDialog {
    public static final int ESC_CANCEL = 84;
    public static final ImageDescriptor TITLE_IMAGE_DESC = ImageDescriptor.createFromFile(ConfigurationDialog.class, (String)"/icons/wizban/stacktraces_wiz.png");
    private static final Point TOOLTIP_DISPLACEMENT = new Point(5, 20);
    private static int TOOLTIP_MS_HIDE_DELAY = 20000;
    private Text emailText;
    private Text nameText;
    private Button anonymizeStacktracesButton;
    private Button clearMessagesButton;
    private Settings settings;
    private ServerConfiguration configuration;

    public ConfigurationDialog(Shell parentShell, Settings settings, ServerConfiguration configuration) {
        super(parentShell);
        this.settings = settings;
        this.configuration = configuration;
        this.setHelpAvailable(false);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Automated Error Reporting Configuration");
        shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail == 2) {
                    e.doit = false;
                    ConfigurationDialog.this.setReturnCode(84);
                    ConfigurationDialog.this.close();
                }
            }
        });
    }

    public void create() {
        super.create();
        this.setTitle("Thank you for using the Automated Error Reporter");
        this.setMessage("Please take a moment for the initial configuration. All values can be changed in the preferences at any time.");
        this.anonymizeStacktracesButton.setFocus();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.CONFIGURATIONDIALOG_ENABLE, true);
        this.createButton(parent, 1, Messages.CONFIGURATIONDIALOG_DISABLE, false);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(TITLE_IMAGE_DESC.createImage());
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        Composite personalGroup = this.createPersonalGroup(container);
        GridDataFactory.fillDefaults().indent(10, 10).grab(true, false).applyTo((Control)personalGroup);
        Group makeAnonymousGroup = this.makeAnonymousGroup(container);
        GridDataFactory.fillDefaults().applyTo((Control)makeAnonymousGroup);
        Composite linksComposite = this.createLinksComposite(container);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)linksComposite);
        this.createDataBindingContext();
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    private Composite createPersonalGroup(Composite container) {
        Composite personalGroup = new Composite(container, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(personalGroup);
        this.nameText = this.createLabelledText(personalGroup, Messages.FIELD_LABEL_NAME, Messages.FIELD_MESSAGE_NAME, Messages.FIELD_MESSAGE_NAME);
        String emailTooltip = String.valueOf(Messages.FIELD_MESSAGE_EMAIL) + '\n' + Messages.FIELD_DESC_EMAIL;
        this.emailText = this.createLabelledText(personalGroup, Messages.FIELD_LABEL_EMAIL, Messages.FIELD_MESSAGE_EMAIL, emailTooltip);
        return personalGroup;
    }

    private Text createLabelledText(Composite parent, String labelString, String messageString, String tooltipString) {
        Label label = new Label(parent, 0);
        label.setText(labelString);
        this.calibrateTooltip(new DefaultToolTip((Control)label), tooltipString);
        Text text = new Text(parent, 2048);
        text.setMessage(messageString);
        this.calibrateTooltip(new DefaultToolTip((Control)text), tooltipString);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)text);
        return text;
    }

    private Group makeAnonymousGroup(Composite container) {
        Group makeAnonymousGroup = new Group(container, 92);
        makeAnonymousGroup.setLayout((Layout)new RowLayout(512));
        makeAnonymousGroup.setText(Messages.CONFIGURATIONDIALOG_ANONYMIZATION);
        this.anonymizeStacktracesButton = this.createGroupCheckButton(makeAnonymousGroup, Messages.FIELD_LABEL_ANONYMIZE_STACKTRACES, Messages.TOOLTIP_MAKE_STACKTRACE_ANONYMOUS);
        this.clearMessagesButton = this.createGroupCheckButton(makeAnonymousGroup, Messages.FIELD_LABEL_ANONYMIZE_MESSAGES, Messages.TOOLTIP_MAKE_MESSAGES_ANONYMOUS);
        return makeAnonymousGroup;
    }

    private Button createGroupCheckButton(Group group, String buttonText, String toolTipText) {
        Button button = new Button((Composite)group, 32);
        button.setText(buttonText);
        this.calibrateTooltip(new DefaultToolTip((Control)button), toolTipText);
        return button;
    }

    private Composite createLinksComposite(Composite container) {
        Composite linksComposite = new Composite(container, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(linksComposite);
        Link learnMoreLink = new Link(linksComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).align(1, 0x1000008).applyTo((Control)learnMoreLink);
        learnMoreLink.setText(Messages.LINK_LEARN_MORE);
        learnMoreLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Browsers.openInExternalBrowser(ConfigurationDialog.this.configuration.getHelpUrl());
            }
        });
        Link feedbackLink = new Link(linksComposite, 0);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000008).applyTo((Control)feedbackLink);
        feedbackLink.setText(Messages.LINK_PROVIDE_FEEDBACK);
        feedbackLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Browsers.openInExternalBrowser(ConfigurationDialog.this.configuration.getFeedbackUrl());
            }
        });
        return linksComposite;
    }

    private void createDataBindingContext() {
        DataBindingContext context = new DataBindingContext();
        ModelPackage pkg = ModelPackage.eINSTANCE;
        ISWTObservableValue ovTxtName = WidgetProperties.text((int)24).observe((Widget)this.nameText);
        IObservableValue ovSetName = EMFProperties.value((EStructuralFeature)pkg.getSettings_Name()).observe((Object)this.settings);
        context.bindValue((IObservableValue)ovTxtName, ovSetName, null, null);
        ISWTObservableValue ovTxtEmail = WidgetProperties.text((int)24).observe((Widget)this.emailText);
        IObservableValue ovSetEmail = EMFProperties.value((EStructuralFeature)pkg.getSettings_Email()).observe((Object)this.settings);
        context.bindValue((IObservableValue)ovTxtEmail, ovSetEmail, null, null);
        ISWTObservableValue ovBtnAnonSt = WidgetProperties.selection().observe((Widget)this.anonymizeStacktracesButton);
        IObservableValue ovSetAnonSt = EMFProperties.value((EStructuralFeature)pkg.getSettings_AnonymizeStrackTraceElements()).observe((Object)this.settings);
        context.bindValue((IObservableValue)ovBtnAnonSt, ovSetAnonSt, null, null);
        ISWTObservableValue ovBtnAnonMsg = WidgetProperties.selection().observe((Widget)this.clearMessagesButton);
        IObservableValue ovSetAnonMsg = EMFProperties.value((EStructuralFeature)pkg.getSettings_AnonymizeMessages()).observe((Object)this.settings);
        context.bindValue((IObservableValue)ovBtnAnonMsg, ovSetAnonMsg, null, null);
    }

    private void calibrateTooltip(DefaultToolTip toolTip, String toolTipText) {
        toolTip.setText(toolTipText);
        toolTip.setFont(JFaceResources.getDialogFont());
        toolTip.setShift(TOOLTIP_DISPLACEMENT);
        toolTip.setHideDelay(TOOLTIP_MS_HIDE_DELAY);
    }
}

