/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui;

import com.google.common.eventbus.EventBus;
import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ui.model.ErrorReport;
import org.eclipse.epp.internal.logging.aeri.ui.model.ModelPackage;
import org.eclipse.epp.internal.logging.aeri.ui.model.RememberSendAction;
import org.eclipse.epp.internal.logging.aeri.ui.model.Reports;
import org.eclipse.epp.internal.logging.aeri.ui.model.SendAction;
import org.eclipse.epp.internal.logging.aeri.ui.model.Settings;
import org.eclipse.epp.internal.logging.aeri.ui.v2.ServerConfiguration;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class ReportDialog
extends MessageDialog {
    private static final Image ERROR_ICON = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
    private Settings settings;
    private ServerConfiguration configuration;
    private TableViewer tableViewer;
    private StyledText messageText;
    private IObservableList errors;
    private WritableValue selectedErrorReport;
    private Text commentText;
    private Button rememberDecisionButton;
    private ComboViewer rememberSettingCombo;
    private Button logMessageButton;
    private Button ignoreSimilarButton;

    public ReportDialog(Shell parentShell, Settings settings, ServerConfiguration configuration, IObservableList errors, EventBus bus) {
        super(parentShell, "An Error Was Logged", null, "We noticed a new error event was logged. Such error events may reveal issues in the Eclipse codebase, and thus we kindly ask you to report them to eclipse.org.", 4, new String[]{"Send", "Don't Send"}, 0);
        this.setShellStyle(3184);
        this.setBlockOnOpen(false);
        this.settings = settings;
        this.configuration = configuration;
        this.errors = errors;
    }

    protected boolean customShouldTakeFocus() {
        return false;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setLayout((Layout)new GridLayout(1, false));
    }

    public Composite createCustomArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().applyTo(container);
        this.createCommentContainer(parent, container);
        this.createDetailsContainer(parent, container);
        Composite settingsComposite = this.createSettingsComposite(parent);
        GridDataFactory.fillDefaults().grab(true, false).indent(0, 5).align(1, 0x1000000).applyTo((Control)settingsComposite);
        this.configureDataBinding();
        return container;
    }

    private void createCommentContainer(Composite parent, Composite container) {
        ExpandableComposite commentContainer = new ExpandableComposite(container, 0);
        commentContainer.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        commentContainer.setText("Comments");
        commentContainer.setExpanded(true);
        Composite commentContent = new Composite((Composite)commentContainer, 0);
        GridLayoutFactory.fillDefaults().applyTo(commentContent);
        this.commentText = new Text(commentContent, 2114);
        this.commentText.setToolTipText("If possible, please provide additional information such as steps that allow committers to reproduce this error.");
        GridDataFactory.fillDefaults().hint(-1, 50).grab(true, false).applyTo((Control)this.commentText);
        commentContainer.setClient((Control)commentContent);
        commentContainer.addExpansionListener((IExpansionListener)new PackShellExpansionListener(parent.getShell()));
    }

    private void createDetailsContainer(Composite parent, Composite container) {
        ExpandableComposite detailsContainer = new ExpandableComposite(container, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)detailsContainer);
        detailsContainer.setText("Details");
        Composite detailsContent = this.createDetailsContent((Composite)detailsContainer);
        detailsContainer.setClient((Control)detailsContent);
        detailsContainer.addExpansionListener((IExpansionListener)new PackShellExpansionListener(parent.getShell()));
        detailsContainer.setExpanded(true);
    }

    private Composite createDetailsContent(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(container);
        SashForm sash = new SashForm(container, 256);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)sash);
        this.createTableComposite((Composite)sash);
        this.createDetailsArea((Composite)sash);
        sash.setWeights(new int[]{20, 80});
        return container;
    }

    private void configureDataBinding() {
        DataBindingContext context = new DataBindingContext();
        this.selectedErrorReport = new WritableValue();
        this.selectedErrorReport.addValueChangeListener((IValueChangeListener)new ErrorReportSelectionChangeListener());
        ISWTObservableValue ovCommentText = WidgetProperties.text((int)24).observe((Widget)this.commentText);
        IObservableValue ovReportComment = EMFProperties.value((EStructuralFeature)ModelPackage.Literals.ERROR_REPORT__COMMENT).observeDetail((IObservableValue)this.selectedErrorReport);
        context.bindValue((IObservableValue)ovCommentText, ovReportComment);
        ISWTObservableValue ovLogMessage = WidgetProperties.selection().observe((Widget)this.logMessageButton);
        IObservableValue ovReportLogMessage = EMFProperties.value((EStructuralFeature)ModelPackage.Literals.ERROR_REPORT__LOG_MESSAGE).observeDetail((IObservableValue)this.selectedErrorReport);
        context.bindValue((IObservableValue)ovLogMessage, ovReportLogMessage);
        ISWTObservableValue ovIgnoreSimilar = WidgetProperties.selection().observe((Widget)this.ignoreSimilarButton);
        IObservableValue ovReportIgnoreSimilar = EMFProperties.value((EStructuralFeature)ModelPackage.Literals.ERROR_REPORT__IGNORE_SIMILAR).observeDetail((IObservableValue)this.selectedErrorReport);
        context.bindValue((IObservableValue)ovIgnoreSimilar, ovReportIgnoreSimilar);
        this.addChangeListenerToBindings(context);
    }

    private void addChangeListenerToBindings(DataBindingContext context) {
        for (Object o : context.getBindings()) {
            Binding b = (Binding)o;
            b.getModel().addChangeListener(new IChangeListener(){

                public void handleChange(ChangeEvent event) {
                    Object report = ReportDialog.this.selectedErrorReport.getValue();
                    if (report != null && !ReportDialog.this.messageText.isDisposed()) {
                        ErrorReport copy = Reports.createAnonymizedSendCopy((ErrorReport)report, ReportDialog.this.settings, ReportDialog.this.configuration);
                        ReportDialog.this.messageText.setText(MessageFormat.format("\nThe following data will be sent:\n\n{0}", Reports.prettyPrint(copy)));
                    }
                }
            });
        }
    }

    private Composite createTableComposite(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        this.tableViewer = new TableViewer(tableComposite, 68354);
        TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ErrorReport event = (ErrorReport)element;
                return event.getStatus().getMessage();
            }

            public Image getImage(Object element) {
                return ERROR_ICON;
            }
        });
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.tableViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.tableViewer.setInput((Object)this.errors);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ReportDialog.this.tableViewer.getSelection();
                if (!selection.isEmpty() && selection.size() == 1) {
                    ReportDialog.this.selectedErrorReport.setValue(selection.getFirstElement());
                } else {
                    ReportDialog.this.selectedErrorReport.setValue(null);
                }
            }
        });
        this.tableViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127 || e.keyCode == 8) {
                    this.deleteSelection();
                }
            }

            private void deleteSelection() {
                IStructuredSelection selection = (IStructuredSelection)ReportDialog.this.tableViewer.getSelection();
                ReportDialog.this.errors.removeAll((Collection)selection.toList());
                ReportDialog.this.selectedErrorReport.setValue(null);
            }
        });
        return tableComposite;
    }

    private Composite createDetailsArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(container);
        this.createMessageComposite(container);
        this.createButtons(container);
        return container;
    }

    private void createButtons(Composite container) {
        this.logMessageButton = this.createAndConfigureCheckbox(container, Messages.FIELD_LABEL_NOT_AN_ERROR, Messages.TOOLTIP_NOT_AN_ERROR);
        this.ignoreSimilarButton = this.createAndConfigureCheckbox(container, Messages.FIELD_LABEL_IGNORE_SIMILAR_ERRORS_IN_FUTURE, Messages.TOOLTIP_IGNORE_SIMILAR_ERRORS_IN_FUTURE);
    }

    private void createMessageComposite(Composite container) {
        Composite messageComposite = new Composite(container, 0);
        GridLayoutFactory.fillDefaults().applyTo(messageComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)messageComposite);
        this.messageText = new StyledText(messageComposite, 2816);
        this.messageText.setEditable(false);
        this.messageText.setMargins(5, this.messageText.getTopMargin(), this.messageText.getRightMargin(), this.messageText.getBottomMargin());
        this.messageText.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.messageText.setForeground(new Color((Device)container.getDisplay(), 80, 80, 80));
        GridDataFactory.fillDefaults().minSize(100, 1).hint(100, 300).grab(true, true).applyTo((Control)this.messageText);
    }

    private Button createAndConfigureCheckbox(Composite parent, String text, String toolTip) {
        Button checkbox = new Button(parent, 32);
        checkbox.setText(text);
        checkbox.setToolTipText(toolTip);
        return checkbox;
    }

    protected Composite createSettingsComposite(Composite parent) {
        Composite settingsComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(settingsComposite);
        this.rememberDecisionButton = new Button(settingsComposite, 32);
        this.rememberDecisionButton.setText("Remember my decision");
        this.rememberSettingCombo = new ComboViewer(settingsComposite);
        this.rememberSettingCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.rememberSettingCombo.getCombo().setEnabled(false);
        this.rememberSettingCombo.setInput((Object)new RememberSendAction[]{RememberSendAction.PERMANENT, RememberSendAction.RESTART, RememberSendAction.HOURS_24});
        this.rememberSettingCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                RememberSendAction mode = (RememberSendAction)((Object)element);
                switch (mode) {
                    case PERMANENT: {
                        return "permanently";
                    }
                    case RESTART: {
                        return "until restart";
                    }
                    case HOURS_24: {
                        return "for 24 hours";
                    }
                }
                return super.getText(element);
            }
        });
        this.rememberSettingCombo.setSelection((ISelection)new StructuredSelection((Object)RememberSendAction.PERMANENT));
        this.rememberDecisionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportDialog.this.rememberSettingCombo.getCombo().setEnabled(ReportDialog.this.rememberDecisionButton.getSelection());
            }
        });
        return settingsComposite;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.okPressed();
        } else if (buttonId == 1) {
            this.cancelPressed();
        }
    }

    protected void okPressed() {
        this.rememberSendAction(SendAction.SILENT);
        super.okPressed();
    }

    protected void cancelPressed() {
        this.rememberSendAction(SendAction.IGNORE);
        super.cancelPressed();
    }

    public boolean close() {
        return super.close();
    }

    private void rememberSendAction(SendAction action) {
        RememberSendAction rememberSendAction = this.selectRememberAction();
        this.settings.setRememberSendAction(rememberSendAction);
        if (rememberSendAction != RememberSendAction.NONE) {
            this.settings.setAction(action);
            if (rememberSendAction == RememberSendAction.HOURS_24) {
                this.settings.setRememberSendActionPeriodStart(System.currentTimeMillis());
            }
        }
    }

    private RememberSendAction selectRememberAction() {
        ISelection selection;
        if (this.rememberDecisionButton.getSelection() && !(selection = this.rememberSettingCombo.getSelection()).isEmpty()) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return (RememberSendAction)((Object)structuredSelection.getFirstElement());
        }
        return RememberSendAction.NONE;
    }

    public void create() {
        super.create();
        if (!this.errors.isEmpty()) {
            StructuredSelection selection = new StructuredSelection(this.tableViewer.getElementAt(0));
            this.tableViewer.setSelection((ISelection)selection, true);
        }
    }

    private final class ErrorReportSelectionChangeListener
    implements IValueChangeListener {
        private ErrorReportSelectionChangeListener() {
        }

        public void handleValueChange(ValueChangeEvent event) {
            boolean isAnyReportSelected;
            boolean bl = isAnyReportSelected = event.getObservableValue().getValue() != null;
            if (!isAnyReportSelected) {
                ReportDialog.this.messageText.setText("Please select a single report for more information");
                ReportDialog.this.logMessageButton.setSelection(false);
                ReportDialog.this.ignoreSimilarButton.setSelection(false);
            }
            ReportDialog.this.logMessageButton.setEnabled(isAnyReportSelected);
            ReportDialog.this.ignoreSimilarButton.setEnabled(isAnyReportSelected);
            ReportDialog.this.commentText.setEnabled(isAnyReportSelected);
        }
    }

    private static final class PackShellExpansionListener
    extends ExpansionAdapter {
        private final Shell shell;

        private PackShellExpansionListener(Shell shell) {
            this.shell = shell;
        }

        public void expansionStateChanged(ExpansionEvent e) {
            this.shell.pack();
        }
    }
}

